
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/utils/dynamic-atlas/manager.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var Atlas = require('./atlas');

var _atlases = [];

var _atlasIndex = -1;

var _maxAtlasCount = 5;
var _textureSize = 2048;
var _maxFrameSize = 512;
var _textureBleeding = true;
var _debugNode = null;

function newAtlas() {
  var atlas = _atlases[++_atlasIndex];

  if (!atlas) {
    atlas = new Atlas(_textureSize, _textureSize);

    _atlases.push(atlas);
  }

  return atlas;
}

function beforeSceneLoad() {
  dynamicAtlasManager.reset();
}

var _enabled = false;
/**
 * !#en Manage Dynamic Atlas Manager. Dynamic Atlas Manager is used for merging textures at runtime, see [Dynamic Atlas](https://docs.cocos.com/creator/manual/en/advanced-topics/dynamic-atlas.html) for details.
 * !#zh 管理动态图集。动态图集用于在运行时对贴图进行合并，详见 [动态合图](https://docs.cocos.com/creator/manual/zh/advanced-topics/dynamic-atlas.html)。
 * @class DynamicAtlasManager
 */

var dynamicAtlasManager = {
  Atlas: Atlas,

  /**
   * !#en Enable or disable the dynamic atlas, see [Dynamic Atlas](https://docs.cocos.com/creator/manual/en/advanced-topics/dynamic-atlas.html) for details.
   * !#zh 开启或者关闭动态图集，详见 [动态合图](https://docs.cocos.com/creator/manual/zh/advanced-topics/dynamic-atlas.html)。
   * @property enabled
   * @type {Boolean}
   */
  get enabled() {
    return _enabled;
  },

  set enabled(value) {
    if (_enabled === value) return;

    if (value) {
      this.reset();
      cc.director.on(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, beforeSceneLoad);
    } else {
      cc.director.off(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, beforeSceneLoad);
    }

    _enabled = value;
  },

  /**
   * !#en The maximum number of atlas that can be created.
   * !#zh 可以创建的最大图集数量。
   * @property maxAtlasCount
   * @type {Number}
   */
  get maxAtlasCount() {
    return _maxAtlasCount;
  },

  set maxAtlasCount(value) {
    _maxAtlasCount = value;
  },

  /**
   * !#en Is enable textureBleeding.
   * !#zh 是否开启 textureBleeding
   * @property textureBleeding
   * @type {Boolean}
   */
  get textureBleeding() {
    return _textureBleeding;
  },

  set textureBleeding(enable) {
    _textureBleeding = enable;
  },

  /**
   * !#en The size of the atlas that was created
   * !#zh 创建的图集的宽高
   * @property textureSize
   * @type {Number}
   */
  get textureSize() {
    return _textureSize;
  },

  set textureSize(value) {
    _textureSize = value;
  },

  /**
   * !#en The maximum size of the picture that can be added to the atlas.
   * !#zh 可以添加进图集的图片的最大尺寸。
   * @property maxFrameSize
   * @type {Number}
   */
  get maxFrameSize() {
    return _maxFrameSize;
  },

  set maxFrameSize(value) {
    _maxFrameSize = value;
  },

  /**
   * !#en The minimum size of the picture that can be added to the atlas.
   * !#zh 可以添加进图集的图片的最小尺寸。
   * @property minFrameSize
   * @type {Number}
   * @deprecated
   */

  /**
   * !#en Append a sprite frame into the dynamic atlas.
   * !#zh 添加碎图进入动态图集。
   * @method insertSpriteFrame
   * @param {SpriteFrame} spriteFrame 
   */
  insertSpriteFrame: function insertSpriteFrame(spriteFrame) {
    if (CC_EDITOR) return null;
    if (!_enabled || _atlasIndex === _maxAtlasCount || !spriteFrame || spriteFrame._original) return null;
    if (!spriteFrame._texture.packable) return null;
    var atlas = _atlases[_atlasIndex];

    if (!atlas) {
      atlas = newAtlas();
    }

    var frame = atlas.insertSpriteFrame(spriteFrame);

    if (!frame && _atlasIndex !== _maxAtlasCount) {
      atlas = newAtlas();
      return atlas.insertSpriteFrame(spriteFrame);
    }

    return frame;
  },

  /** 
   * !#en Resets all dynamic atlas, and the existing ones will be destroyed.
   * !#zh 重置所有动态图集，已有的动态图集会被销毁。
   * @method reset
  */
  reset: function reset() {
    for (var i = 0, l = _atlases.length; i < l; i++) {
      _atlases[i].destroy();
    }

    _atlases.length = 0;
    _atlasIndex = -1;
  },
  deleteAtlasSpriteFrame: function deleteAtlasSpriteFrame(spriteFrame) {
    if (!spriteFrame._original) return;
    var texture = spriteFrame._original._texture;
    this.deleteAtlasTexture(texture);
  },
  deleteAtlasTexture: function deleteAtlasTexture(texture) {
    if (texture) {
      for (var i = _atlases.length - 1; i >= 0; i--) {
        _atlases[i].deleteInnerTexture(texture);

        if (_atlases[i].isEmpty()) {
          _atlases[i].destroy();

          _atlases.splice(i, 1);

          _atlasIndex--;
        }
      }
    }
  },

  /**
   * !#en Displays all the dynamic atlas in the current scene, which you can use to view the current atlas state.
   * !#zh 在当前场景中显示所有动态图集，可以用来查看当前的合图状态。
   * @method showDebug
   * @param {Boolean} show
   */
  showDebug: CC_DEV && function (show) {
    if (show) {
      if (!_debugNode || !_debugNode.isValid) {
        var width = cc.visibleRect.width;
        var height = cc.visibleRect.height;
        _debugNode = new cc.Node('DYNAMIC_ATLAS_DEBUG_NODE');
        _debugNode.width = width;
        _debugNode.height = height;
        _debugNode.x = width / 2;
        _debugNode.y = height / 2;
        _debugNode.zIndex = cc.macro.MAX_ZINDEX;
        _debugNode.parent = cc.director.getScene();
        _debugNode.groupIndex = cc.Node.BuiltinGroupIndex.DEBUG;

        cc.Camera._setupDebugCamera();

        var scroll = _debugNode.addComponent(cc.ScrollView);

        var content = new cc.Node('CONTENT');
        var layout = content.addComponent(cc.Layout);
        layout.type = cc.Layout.Type.VERTICAL;
        layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
        content.parent = _debugNode;
        content.width = _textureSize;
        content.anchorY = 1;
        content.x = _textureSize;
        scroll.content = content;

        for (var i = 0; i <= _atlasIndex; i++) {
          var node = new cc.Node('ATLAS');
          var texture = _atlases[i]._texture;
          var spriteFrame = new cc.SpriteFrame();
          spriteFrame.setTexture(_atlases[i]._texture);
          var sprite = node.addComponent(cc.Sprite);
          sprite.spriteFrame = spriteFrame;
          node.parent = content;
        }
      }
    } else {
      if (_debugNode) {
        _debugNode.parent = null;
        _debugNode = null;
      }
    }
  },
  update: function update() {
    if (!this.enabled) return;

    for (var i = 0; i <= _atlasIndex; i++) {
      _atlases[i].update();
    }
  }
};
/**
 * @module cc
 */

/**
 * @property dynamicAtlasManager
 * @type DynamicAtlasManager
 */

module.exports = cc.dynamicAtlasManager = dynamicAtlasManager;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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