
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/render-flow.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var FlagOfset = 0;
var DONOTHING = 1 << FlagOfset++;
var BREAK_FLOW = 1 << FlagOfset++;
var LOCAL_TRANSFORM = 1 << FlagOfset++;
var WORLD_TRANSFORM = 1 << FlagOfset++;
var TRANSFORM = LOCAL_TRANSFORM | WORLD_TRANSFORM;
var UPDATE_RENDER_DATA = 1 << FlagOfset++;
var OPACITY = 1 << FlagOfset++;
var COLOR = 1 << FlagOfset++;
var OPACITY_COLOR = OPACITY | COLOR;
var RENDER = 1 << FlagOfset++;
var CHILDREN = 1 << FlagOfset++;
var POST_RENDER = 1 << FlagOfset++;
var FINAL = 1 << FlagOfset++;

var _batcher, _forward;

var _cullingMask = 0;

function RenderFlow() {
  this._func = init;
  this._next = null;
}

var _proto = RenderFlow.prototype;

_proto._doNothing = function () {};

_proto._localTransform = function (node) {
  node._updateLocalMatrix();

  node._renderFlag &= ~LOCAL_TRANSFORM;

  this._next._func(node);
};

_proto._worldTransform = function (node) {
  _batcher.worldMatDirty++;
  var t = node._matrix;
  var trs = node._trs;
  var tm = t.m;
  tm[12] = trs[0];
  tm[13] = trs[1];
  tm[14] = trs[2];

  node._mulMat(node._worldMatrix, node._parent._worldMatrix, t);

  node._renderFlag &= ~WORLD_TRANSFORM;

  this._next._func(node);

  _batcher.worldMatDirty--;
};

_proto._opacity = function (node) {
  _batcher.parentOpacityDirty++;
  node._renderFlag &= ~OPACITY;

  this._next._func(node);

  _batcher.parentOpacityDirty--;
};

_proto._color = function (node) {
  var comp = node._renderComponent;

  if (comp) {
    comp._updateColor();
  }

  node._renderFlag &= ~COLOR;

  this._next._func(node);
};

_proto._updateRenderData = function (node) {
  var comp = node._renderComponent;

  comp._assembler.updateRenderData(comp);

  node._renderFlag &= ~UPDATE_RENDER_DATA;

  this._next._func(node);
};

_proto._render = function (node) {
  var comp = node._renderComponent;

  comp._checkBacth(_batcher, node._cullingMask);

  comp._assembler.fillBuffers(comp, _batcher);

  this._next._func(node);
};

_proto._children = function (node) {
  var cullingMask = _cullingMask;
  var batcher = _batcher;
  var parentOpacity = batcher.parentOpacity;
  var opacity = batcher.parentOpacity *= node._opacity / 255;
  var worldTransformFlag = batcher.worldMatDirty ? WORLD_TRANSFORM : 0;
  var worldOpacityFlag = batcher.parentOpacityDirty ? OPACITY_COLOR : 0;
  var worldDirtyFlag = worldTransformFlag | worldOpacityFlag;
  var children = node._children;

  for (var i = 0, l = children.length; i < l; i++) {
    var c = children[i]; // Advance the modification of the flag to avoid node attribute modification is invalid when opacity === 0.

    c._renderFlag |= worldDirtyFlag;
    if (!c._activeInHierarchy || c._opacity === 0) continue;
    _cullingMask = c._cullingMask = c.groupIndex === 0 ? cullingMask : 1 << c.groupIndex; // TODO: Maybe has better way to implement cascade opacity

    var colorVal = c._color._val;

    c._color._fastSetA(c._opacity * opacity);

    flows[c._renderFlag]._func(c);

    c._color._val = colorVal;
  }

  batcher.parentOpacity = parentOpacity;

  this._next._func(node);
};

_proto._postRender = function (node) {
  var comp = node._renderComponent;

  comp._checkBacth(_batcher, node._cullingMask);

  comp._assembler.postFillBuffers(comp, _batcher);

  this._next._func(node);
};

var EMPTY_FLOW = new RenderFlow();
EMPTY_FLOW._func = EMPTY_FLOW._doNothing;
EMPTY_FLOW._next = EMPTY_FLOW;
var flows = {};

function createFlow(flag, next) {
  var flow = new RenderFlow();
  flow._next = next || EMPTY_FLOW;

  switch (flag) {
    case DONOTHING:
      flow._func = flow._doNothing;
      break;

    case BREAK_FLOW:
      flow._func = flow._doNothing;
      break;

    case LOCAL_TRANSFORM:
      flow._func = flow._localTransform;
      break;

    case WORLD_TRANSFORM:
      flow._func = flow._worldTransform;
      break;

    case OPACITY:
      flow._func = flow._opacity;
      break;

    case COLOR:
      flow._func = flow._color;
      break;

    case UPDATE_RENDER_DATA:
      flow._func = flow._updateRenderData;
      break;

    case RENDER:
      flow._func = flow._render;
      break;

    case CHILDREN:
      flow._func = flow._children;
      break;

    case POST_RENDER:
      flow._func = flow._postRender;
      break;
  }

  return flow;
}

function getFlow(flag) {
  var flow = null;
  var tFlag = FINAL;

  while (tFlag > 0) {
    if (tFlag & flag) flow = createFlow(tFlag, flow);
    tFlag = tFlag >> 1;
  }

  return flow;
} // 


function init(node) {
  var flag = node._renderFlag;
  var r = flows[flag] = getFlow(flag);

  r._func(node);
}

RenderFlow.flows = flows;
RenderFlow.createFlow = createFlow; // validate whether render component is ready to be rendered.

var _validateList = [];

RenderFlow.registerValidate = function (renderComp) {
  if (renderComp._inValidateList) return;

  _validateList.push(renderComp);

  renderComp._inValidateList = true;
};

RenderFlow.validateRenderers = function () {
  for (var i = 0, l = _validateList.length; i < l; i++) {
    var renderComp = _validateList[i];
    if (!renderComp.isValid) continue;

    if (!renderComp.enabledInHierarchy) {
      renderComp.disableRender();
    } else {
      renderComp._validateRender();
    }

    renderComp._inValidateList = false;
  }

  _validateList.length = 0;
};

RenderFlow.visitRootNode = function (rootNode) {
  RenderFlow.validateRenderers();
  _cullingMask = 1 << rootNode.groupIndex;

  if (rootNode._renderFlag & WORLD_TRANSFORM) {
    _batcher.worldMatDirty++;

    rootNode._calculWorldMatrix();

    rootNode._renderFlag &= ~WORLD_TRANSFORM;

    flows[rootNode._renderFlag]._func(rootNode);

    _batcher.worldMatDirty--;
  } else {
    flows[rootNode._renderFlag]._func(rootNode);
  }
};

RenderFlow.render = function (scene, dt) {
  _batcher.reset();

  _batcher.walking = true;
  RenderFlow.visitRootNode(scene);

  _batcher.terminate();

  _batcher.walking = false;

  _forward.render(_batcher._renderScene, dt);
};

RenderFlow.init = function (batcher, forwardRenderer) {
  _batcher = batcher;
  _forward = forwardRenderer;
  flows[0] = EMPTY_FLOW;

  for (var i = 1; i < FINAL; i++) {
    flows[i] = new RenderFlow();
  }
};

RenderFlow.getBachther = function () {
  return _batcher;
};

RenderFlow.FLAG_DONOTHING = DONOTHING;
RenderFlow.FLAG_BREAK_FLOW = BREAK_FLOW;
RenderFlow.FLAG_LOCAL_TRANSFORM = LOCAL_TRANSFORM;
RenderFlow.FLAG_WORLD_TRANSFORM = WORLD_TRANSFORM;
RenderFlow.FLAG_TRANSFORM = TRANSFORM;
RenderFlow.FLAG_OPACITY = OPACITY;
RenderFlow.FLAG_COLOR = COLOR;
RenderFlow.FLAG_OPACITY_COLOR = OPACITY_COLOR;
RenderFlow.FLAG_UPDATE_RENDER_DATA = UPDATE_RENDER_DATA;
RenderFlow.FLAG_RENDER = RENDER;
RenderFlow.FLAG_CHILDREN = CHILDREN;
RenderFlow.FLAG_POST_RENDER = POST_RENDER;
RenderFlow.FLAG_FINAL = FINAL;
module.exports = cc.RenderFlow = RenderFlow;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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