
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/canvas/renderers/utils.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var WHITE = (255 << 16) + (255 << 8) + 255;
var MAX_CANVAS_COUNT = 32;

function colorizedFrame(canvas, texture, color, sx, sy, sw, sh) {
  var image = texture._image;
  var ctx = canvas.getContext("2d");
  canvas.width = sw;
  canvas.height = sh; // Draw color

  ctx.globalCompositeOperation = 'source-over';
  ctx.fillStyle = 'rgb(' + color.r + ',' + color.g + ',' + color.b + ')';
  ctx.fillRect(0, 0, sw, sh); // Multiply color with texture

  ctx.globalCompositeOperation = 'multiply';
  ctx.drawImage(image, sx, sy, sw, sh, 0, 0, sw, sh); // Clip out transparent pixels

  ctx.globalCompositeOperation = "destination-atop";
  ctx.drawImage(image, sx, sy, sw, sh, 0, 0, sw, sh);
  return canvas;
}

var canvasMgr = {
  canvasMap: {},
  canvasUsed: {},
  canvasPool: [],
  checking: false,
  check: function check() {
    var exist = false;

    for (var key in this.canvasUsed) {
      exist = true;

      if (!this.canvasUsed[key]) {
        var canvas = this.canvasMap[key];
        canvas.width = 0;
        canvas.height = 0;

        if (this.canvasPool.length < 32) {
          this.canvasPool.push(canvas);
        }

        delete this.canvasMap[key];
        delete this.canvasUsed[key];
      } else {
        this.canvasUsed[key] = false;
      }
    }

    if (!exist) {
      cc.director.off(cc.Director.EVENT_AFTER_DRAW, this.check, this);
      this.checking = false;
    }
  },
  startCheck: function startCheck() {
    cc.director.on(cc.Director.EVENT_AFTER_DRAW, this.check, this);
    this.checking = true;
  },
  getCanvas: function getCanvas(key) {
    this.canvasUsed[key] = true;
    return this.canvasMap[key];
  },
  cacheCanvas: function cacheCanvas(canvas, key) {
    this.canvasMap[key] = canvas;
    this.canvasUsed[key] = true;

    if (!this.checking) {
      this.startCheck();
    }
  },
  dropImage: function dropImage(key) {
    if (this.canvasMap[key]) {
      delete this.canvasMap[key];
    }
  }
};
module.exports = {
  getColorizedImage: function getColorizedImage(texture, color) {
    if (!texture) return null;
    if (texture.width === 0 || texture.height === 0) return texture._image; // original image

    var cval = color._val & 0x00ffffff;

    if (cval === WHITE) {
      return texture._image;
    } // get from cache


    var key = texture.url + cval;
    var cache = canvasMgr.getCanvas(key);

    if (!cache) {
      cache = canvasMgr.canvasPool.pop() || document.createElement("canvas");
      colorizedFrame(cache, texture, color, 0, 0, texture.width, texture.height);
      canvasMgr.cacheCanvas(cache, key);
    }

    return cache;
  },
  getFrameCache: function getFrameCache(texture, color, sx, sy, sw, sh) {
    if (!texture || !texture.url || sx < 0 || sy < 0 || sw <= 0 || sh <= 0) {
      return null;
    }

    var key = texture.url;
    var generate = false;
    var cval = color._val & 0x00ffffff;

    if (cval !== WHITE) {
      key += cval;
      generate = true;
    }

    if (sx !== 0 || sy !== 0 && sw !== texture.width && sh !== texture.height) {
      key += '_' + sx + '_' + sy + '_' + sw + '_' + sh;
      generate = true;
    }

    if (!generate) {
      return texture._image;
    } // get from cache


    var cache = canvasMgr.getCanvas(key);

    if (!cache) {
      cache = canvasMgr.canvasPool.pop() || document.createElement("canvas");
      colorizedFrame(cache, texture, color, sx, sy, sw, sh);
      canvasMgr.cacheCanvas(cache, key);
    }

    return cache;
  },
  dropColorizedImage: function dropColorizedImage(texture, color) {
    var key = texture.url + (color._val & 0x00ffffff);
    canvasMgr.dropImage(key);
  }
}; // cache context data of device.

var _globalAlpha = -1;

var context = {
  setGlobalAlpha: function setGlobalAlpha(ctx, alpha) {
    if (_globalAlpha === alpha) {
      return;
    }

    _globalAlpha = alpha;
    ctx.globalAlpha = _globalAlpha;
  },
  reset: function reset() {
    _globalAlpha = -1;
  }
};
module.exports.context = context;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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