
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/canvas/renderers/sprite/simple.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler = _interopRequireDefault(require("../../../assembler"));

var _renderData = _interopRequireDefault(require("../render-data"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var utils = require('../utils');

var CanvasSimpleSprite =
/*#__PURE__*/
function (_Assembler) {
  _inheritsLoose(CanvasSimpleSprite, _Assembler);

  function CanvasSimpleSprite() {
    return _Assembler.apply(this, arguments) || this;
  }

  var _proto = CanvasSimpleSprite.prototype;

  _proto.init = function init() {
    this._renderData = new _renderData["default"]();
    this._renderData.dataLength = 2;
  };

  _proto.updateRenderData = function updateRenderData(sprite) {
    if (sprite._vertsDirty) {
      this.updateUVs(sprite);
      this.updateVerts(sprite);
      sprite._vertsDirty = false;
    }
  };

  _proto.updateUVs = function updateUVs(sprite) {
    var frame = sprite.spriteFrame;
    var renderData = this._renderData;
    var verts = renderData.vertices;
    var rect = frame._rect;

    if (frame._rotated) {
      var l = rect.x;
      var r = rect.width;
      var b = rect.y;
      var t = rect.height;
      verts[0].u = l;
      verts[0].v = b;
      verts[1].u = t;
      verts[1].v = r;
    } else {
      var _l = rect.x;
      var _r = rect.width;
      var _b = rect.y;
      var _t = rect.height;
      verts[0].u = _l;
      verts[0].v = _b;
      verts[1].u = _r;
      verts[1].v = _t;
    }
  };

  _proto.updateVerts = function updateVerts(sprite) {
    var renderData = this._renderData,
        node = sprite.node,
        verts = renderData.vertices,
        frame = sprite.spriteFrame,
        cw = node.width,
        ch = node.height,
        appx = node.anchorX * cw,
        appy = node.anchorY * ch,
        l,
        b,
        r,
        t;

    if (sprite.trim) {
      l = -appx;
      b = -appy;
      r = cw;
      t = ch;
    } else {
      var ow = frame._originalSize.width,
          oh = frame._originalSize.height,
          rw = frame._rect.width,
          rh = frame._rect.height,
          offset = frame._offset,
          scaleX = cw / ow,
          scaleY = ch / oh;
      var trimLeft = offset.x + (ow - rw) / 2;
      var trimBottom = offset.y + (oh - rh) / 2;
      l = trimLeft * scaleX - appx;
      b = trimBottom * scaleY - appy;
      r = cw;
      t = ch;
    }

    if (frame._rotated) {
      verts[0].y = l;
      verts[0].x = b;
      verts[1].y = r;
      verts[1].x = t;
    } else {
      verts[0].x = l;
      verts[0].y = b;
      verts[1].x = r;
      verts[1].y = t;
    }

    renderData.vertDirty = false;
  };

  _proto.draw = function draw(ctx, comp) {
    var node = comp.node;
    var frame = comp._spriteFrame; // Transform

    var matrix = node._worldMatrix;
    var matrixm = matrix.m;
    var a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    ctx.transform(a, b, c, d, tx, ty);
    ctx.scale(1, -1);

    if (frame._rotated) {
      ctx.rotate(-Math.PI / 2);
    } // TODO: handle blend function
    // opacity


    utils.context.setGlobalAlpha(ctx, node.opacity / 255);
    var tex = frame._texture,
        verts = this._renderData.vertices;
    var image = utils.getColorizedImage(tex, node._color);
    var x = verts[0].x;
    var y = verts[0].y;
    var w = verts[1].x;
    var h = verts[1].y;
    y = -y - h;
    var sx = verts[0].u;
    var sy = verts[0].v;
    var sw = verts[1].u;
    var sh = verts[1].v;
    ctx.drawImage(image, sx, sy, sw, sh, x, y, w, h);
    return 1;
  };

  return CanvasSimpleSprite;
}(_assembler["default"]);

exports["default"] = CanvasSimpleSprite;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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