
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/canvas/renderers/graphics/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler = _interopRequireDefault(require("../../../assembler"));

var _impl = _interopRequireDefault(require("./impl"));

var _graphics = _interopRequireDefault(require("../../../../graphics/graphics"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var CanvasGraphicsAssembler =
/*#__PURE__*/
function () {
  function CanvasGraphicsAssembler() {}

  var _proto = CanvasGraphicsAssembler.prototype;

  _proto.init = function init() {};

  _proto.updateRenderData = function updateRenderData() {};

  _proto.draw = function draw(ctx, comp) {
    var node = comp.node; // Transform

    var matrix = node._worldMatrix;
    var matrixm = matrix.m;
    var a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    ctx.transform(a, b, c, d, tx, ty);
    ctx.save(); // TODO: handle blend function
    // opacity

    ctx.globalAlpha = node.opacity / 255;
    var style = comp._impl.style;
    ctx.strokeStyle = style.strokeStyle;
    ctx.fillStyle = style.fillStyle;
    ctx.lineWidth = style.lineWidth;
    ctx.lineJoin = style.lineJoin;
    ctx.miterLimit = style.miterLimit;
    var endPath = true;
    var cmds = comp._impl.cmds;

    for (var i = 0, l = cmds.length; i < l; i++) {
      var cmd = cmds[i];
      var ctxCmd = cmd[0],
          args = cmd[1];

      if (ctxCmd === 'moveTo' && endPath) {
        ctx.beginPath();
        endPath = false;
      } else if (ctxCmd === 'fill' || ctxCmd === 'stroke' || ctxCmd === 'fillRect') {
        endPath = true;
      }

      if (typeof ctx[ctxCmd] === 'function') {
        ctx[ctxCmd].apply(ctx, args);
      } else {
        ctx[ctxCmd] = args;
      }
    }

    ctx.restore();
    return 1;
  };

  _proto.stroke = function stroke(comp) {
    comp._impl.stroke();
  };

  _proto.fill = function fill(comp) {
    comp._impl.fill();
  };

  _proto.clear = function clear() {};

  return CanvasGraphicsAssembler;
}();

exports["default"] = CanvasGraphicsAssembler;

_assembler["default"].register(_graphics["default"], CanvasGraphicsAssembler);

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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