
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/canvas/renderers/graphics/impl.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Helper = require('../../../../graphics/helper');

var Types = require('../../../../graphics/types');

var js = require('../../../../platform/js');

var LineJoin = Types.LineJoin;
var LineCap = Types.LineCap;

function Impl() {
  this.cmds = [];
  this.style = {
    strokeStyle: 'black',
    fillStyle: 'white',
    lineCap: 'butt',
    lineJoin: 'miter',
    miterLimit: 10
  };
}

var _proto = Impl.prototype;
js.mixin(_proto, {
  moveTo: function moveTo(x, y) {
    this.cmds.push(['moveTo', [x, y]]);
  },
  lineTo: function lineTo(x, y) {
    this.cmds.push(['lineTo', [x, y]]);
  },
  bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
    this.cmds.push(['bezierCurveTo', [c1x, c1y, c2x, c2y, x, y]]);
  },
  quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
    this.cmds.push(['quadraticCurveTo', [cx, cy, x, y]]);
  },
  arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
    Helper.arc(this, cx, cy, r, startAngle, endAngle, counterclockwise);
  },
  ellipse: function ellipse(cx, cy, rx, ry) {
    Helper.ellipse(this, cx, cy, rx, ry);
  },
  circle: function circle(cx, cy, r) {
    Helper.ellipse(this, cx, cy, r, r);
  },
  rect: function rect(x, y, w, h) {
    this.moveTo(x, y);
    this.lineTo(x, y + h);
    this.lineTo(x + w, y + h);
    this.lineTo(x + w, y);
    this.close();
  },
  roundRect: function roundRect(x, y, w, h, r) {
    Helper.roundRect(this, x, y, w, h, r);
  },
  clear: function clear(comp, clean) {
    this.cmds.length = 0;
  },
  close: function close() {
    this.cmds.push(['closePath', []]);
  },
  stroke: function stroke() {
    this.cmds.push(['stroke', []]);
  },
  fill: function fill() {
    this.cmds.push(['fill', []]);
  }
});
js.set(_proto, 'strokeColor', function (v) {
  var strokeStyle = 'rgba(' + (0 | v.r) + ',' + (0 | v.g) + ',' + (0 | v.b) + ',' + v.a / 255 + ')';
  this.cmds.push(['strokeStyle', strokeStyle]);
  this.style.strokeStyle = strokeStyle;
});
js.set(_proto, 'fillColor', function (v) {
  var fillStyle = 'rgba(' + (0 | v.r) + ',' + (0 | v.g) + ',' + (0 | v.b) + ',' + v.a / 255 + ')';
  this.cmds.push(['fillStyle', fillStyle]);
  this.style.fillStyle = fillStyle;
});
js.set(_proto, 'lineWidth', function (v) {
  this.cmds.push(['lineWidth', v]);
  this.style.lineWidth = v;
});
js.set(_proto, 'lineCap', function (v) {
  var lineCap = 'butt';

  if (v === LineCap.BUTT) {
    lineCap = 'butt';
  } else if (v === LineCap.ROUND) {
    lineCap = 'round';
  } else if (v === LineCap.SQUARE) {
    lineCap = 'square';
  }

  this.cmds.push(['lineCap', lineCap]);
  this.style.lineCap = lineCap;
});
js.set(_proto, 'lineJoin', function (v) {
  var lineJoin = 'bevel';

  if (v === LineJoin.BEVEL) {
    lineJoin = 'bevel';
  } else if (v === LineJoin.ROUND) {
    lineJoin = 'round';
  } else if (v === LineJoin.MITER) {
    lineJoin = 'miter';
  }

  this.cmds.push(['lineJoin', lineJoin]);
  this.style.lineJoin = lineJoin;
});
js.set(_proto, 'miterLimit', function (v) {
  this.cmds.push(['miterLimit', v]);
  this.style.miterLimit = v;
});
cc.Graphics._Impl = Impl;
module.exports = Impl;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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