
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/preprocess-class.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = require('./js');

var Attrs = require('./attribute'); // 增加预处理属性这个步骤的目的是降低 CCClass 的实现难度，将比较稳定的通用逻辑和一些需求比较灵活的属性需求分隔开。


var SerializableAttrs = {
  url: {
    canUsedInGet: true
  },
  "default": {},
  serializable: {},
  editorOnly: {},
  formerlySerializedAs: {}
};
var TYPO_TO_CORRECT_DEV = CC_DEV && {
  extend: 'extends',
  property: 'properties',
  "static": 'statics',
  constructor: 'ctor'
}; // 预处理 notify 等扩展属性

function parseNotify(val, propName, notify, properties) {
  if (val.get || val.set) {
    if (CC_DEV) {
      cc.warnID(5500);
    }

    return;
  }

  if (val.hasOwnProperty('default')) {
    // 添加新的内部属性，将原来的属性修改为 getter/setter 形式
    // （以 _ 开头将自动设置property 为 visible: false）
    var newKey = "_N$" + propName;

    val.get = function () {
      return this[newKey];
    };

    val.set = function (value) {
      var oldValue = this[newKey];
      this[newKey] = value;
      notify.call(this, oldValue);
    };

    if (CC_EDITOR) {
      val.notifyFor = newKey;
    }

    var newValue = {};
    properties[newKey] = newValue; // 将不能用于get方法中的属性移动到newValue中

    for (var attr in SerializableAttrs) {
      var v = SerializableAttrs[attr];

      if (val.hasOwnProperty(attr)) {
        newValue[attr] = val[attr];

        if (!v.canUsedInGet) {
          delete val[attr];
        }
      }
    }
  } else if (CC_DEV) {
    cc.warnID(5501);
  }
}

function checkUrl(val, className, propName, url) {
  if (Array.isArray(url)) {
    if (url.length > 0) {
      url = url[0];
    } else if (CC_EDITOR) {
      return cc.errorID(5502, className, propName);
    }
  }

  if (CC_EDITOR) {
    if (url == null) {
      return cc.warnID(5503, className, propName);
    }

    if (typeof url !== 'function' || !js.isChildClassOf(url, cc.RawAsset)) {
      return cc.errorID(5504, className, propName);
    }

    if (url === cc.RawAsset) {
      cc.error('Please change the definition of the property \'%s\' in class \'%s\'. Since v1.10,\n' + 'declaring a property in CCClass as a URL is obsolete.\n' + 'For example, if you have a property of cc.RawAsset, the old definition is:\n' + '    %s: cc.RawAsset,\n' + '    // or:\n' + '    %s: {\n' + '      url: cc.RawAsset,\n' + '      default: ""\n' + '    },\n' + '    // and you can simply get the url by:\n' + '    `this.%s`\n' + 'Now you should use:\n' + '    %s: {\n' + '      type: cc.Asset,     // use \'type:\' to declare an object reference\n' + '      default: null,      // object\'s default value is null\n' + '    },\n' + '    // then you should get the url by:\n' + '    `this.%s.nativeUrl`', propName, className, propName, propName, propName, propName, propName);
    } else if (js.isChildClassOf(url, cc.Asset)) {
      if (cc.RawAsset.wasRawAssetType(url)) {
        if (!val._short) {
          cc.error('Please change the definition of the property \'%s\' in class \'%s\'. Since v1.10,\n' + 'declaring a property in CCClass as a URL is obsolete.\n' + 'For example, if you have a property of Texture2D, the old definition is:\n' + '    %s: cc.Texture2D,\n' + '    // or:\n' + '    %s: {\n' + '      url: cc.Texture2D,\n' + '      default: ""\n' + '    },\n' + 'Now you should use:\n' + '    %s: {\n' + '      type: cc.Texture2D, // use \'type:\' to declare a Texture2D object\n' + '      default: null,      // object\'s default value is null\n' + '    },', propName, className, propName, propName, propName);
        }
      } else {
        return cc.errorID(5505, className, propName, cc.js.getClassName(url));
      }
    }

    if (val.type) {
      return cc.errorID(5506, className, propName);
    }
  }

  val.type = url;
}

function parseType(val, type, className, propName) {
  var STATIC_CHECK = CC_EDITOR && CC_DEV || CC_TEST;

  if (Array.isArray(type)) {
    if (STATIC_CHECK && 'default' in val) {
      var isArray = require('./CCClass').isArray; // require lazily to avoid circular require() calls


      if (!isArray(val["default"])) {
        cc.warnID(5507, className, propName);
      }
    }

    if (type.length > 0) {
      if (cc.RawAsset.isRawAssetType(type[0])) {
        val.url = type[0];
        delete val.type;
        return;
      } else {
        val.type = type = type[0];
      }
    } else {
      return cc.errorID(5508, className, propName);
    }
  }

  if (typeof type === 'function') {
    if (type === String) {
      val.type = cc.String;

      if (STATIC_CHECK) {
        cc.warnID(3608, "\"" + className + "." + propName + "\"");
      }
    } else if (type === Boolean) {
      val.type = cc.Boolean;

      if (STATIC_CHECK) {
        cc.warnID(3609, "\"" + className + "." + propName + "\"");
      }
    } else if (type === Number) {
      val.type = cc.Float;

      if (STATIC_CHECK) {
        cc.warnID(3610, "\"" + className + "." + propName + "\"");
      }
    } else if (STATIC_CHECK && cc.RawAsset.isRawAssetType(type)) {
      cc.warnID(5509, className, propName, js.getClassName(type));
    }
  } else if (STATIC_CHECK) {
    switch (type) {
      case 'Number':
        cc.warnID(5510, className, propName);
        break;

      case 'String':
        cc.warn("The type of \"" + className + "." + propName + "\" must be cc.String, not \"String\".");
        break;

      case 'Boolean':
        cc.warn("The type of \"" + className + "." + propName + "\" must be cc.Boolean, not \"Boolean\".");
        break;

      case 'Float':
        cc.warn("The type of \"" + className + "." + propName + "\" must be cc.Float, not \"Float\".");
        break;

      case 'Integer':
        cc.warn("The type of \"" + className + "." + propName + "\" must be cc.Integer, not \"Integer\".");
        break;

      case null:
        cc.warnID(5511, className, propName);
        break;
    }
  }
}

function postCheckType(val, type, className, propName) {
  if (CC_EDITOR && typeof type === 'function') {
    if (cc.Class._isCCClass(type) && val.serializable !== false && !js._getClassId(type, false)) {
      cc.warnID(5512, className, propName, className, propName);
    }
  }
}

function getBaseClassWherePropertyDefined_DEV(propName, cls) {
  if (CC_DEV) {
    var res;

    for (; cls && cls.__props__ && cls.__props__.indexOf(propName) !== -1; cls = cls.$super) {
      res = cls;
    }

    if (!res) {
      cc.error('unknown error');
    }

    return res;
  }
}

function _wrapOptions(isES6Getset, _default, type, isUrlType) {
  var res = isES6Getset ? {
    _short: true
  } : {
    _short: true,
    "default": _default
  };

  if (type) {
    if (isUrlType) {
      res.url = type;
    } else {
      res.type = type;
    }
  }

  return res;
}

exports.getFullFormOfProperty = function (options, isES6Getset, propname_dev, classname_dev) {
  var isLiteral = options && options.constructor === Object;

  if (isLiteral) {
    return null;
  }

  if (Array.isArray(options) && options.length > 0) {
    var type = options[0];

    if (CC_DEV && cc.RawAsset.wasRawAssetType(type)) {
      // deprecate `myProp: [cc.Texture2D]` since 1.10
      cc.error('Please change the definition of the property \'%s\' in class \'%s\'. Since v1.10,\n' + 'properties in CCClass can not be abbreviated if they are RawAsset.\n' + 'Please declare in the complete form.\n' + 'For example, if you have an array of Texture2D urls, the old definition is:\n' + '    %s: [cc.Texture2D],\n' + 'If you are using JS, you should use:\n' + '    %s: {\n' + '      type: cc.Texture2D, // use \'type:\' to declare an array of Texture2D objects\n' + '      default: []\n' + '    },\n' + 'If you are using TS, you should use:\n' + '    @property({\n' + '      type: cc.Texture2D, // use \'type:\' to declare an array of Texture2D objects\n' + '    })\n' + '    %s: cc.Texture2D[] = [];', propname_dev, classname_dev, propname_dev, propname_dev);
      return _wrapOptions(isES6Getset, [], options, true);
    }

    return _wrapOptions(isES6Getset, [], options);
  } else if (typeof options === 'function') {
    var _type = options;

    if (!cc.RawAsset.isRawAssetType(_type)) {
      if (cc.RawAsset.wasRawAssetType(_type)) {
        // deprecate `myProp: cc.Texture2D` since 1.10
        if (CC_DEV) {
          cc.error('Please change the definition of property \'%s\' in class \'%s\'. Since v1.10,\n' + 'properties in CCClass can not be abbreviated if they are RawAsset.\n' + 'Please declare in the complete form.\n' + 'For example, if you have a property of Texture2D, the old definition is:\n' + '    %s: cc.Texture2D,\n' + 'If you are using JS, you should use:\n' + '    %s: {\n' + '      type: cc.Texture2D,// use \'type:\' to declare Texture2D object directly\n' + '      default: null,     // object\'s default value is null\n' + '    },\n' + 'If you are using TS, you should use:\n' + '    @property({\n' + '      type: cc.Texture2D,// use \'type:\' to declare Texture2D object directly\n' + '    })\n' + '    %s: cc.Texture2D = null;', propname_dev, classname_dev, propname_dev, propname_dev);
        }
      } else {
        return _wrapOptions(isES6Getset, js.isChildClassOf(_type, cc.ValueType) ? new _type() : null, _type);
      }
    }

    return _wrapOptions(isES6Getset, '', _type, true);
  } else if (options instanceof Attrs.PrimitiveType) {
    return _wrapOptions(isES6Getset, options["default"]);
  } else {
    return _wrapOptions(isES6Getset, options);
  }
};

exports.preprocessAttrs = function (properties, className, cls, es6) {
  for (var propName in properties) {
    var val = properties[propName];
    var fullForm = exports.getFullFormOfProperty(val, false, propName, className);

    if (fullForm) {
      val = properties[propName] = fullForm;
    }

    if (val) {
      if (CC_EDITOR) {
        if ('default' in val) {
          if (val.get) {
            cc.errorID(5513, className, propName);
          } else if (val.set) {
            cc.errorID(5514, className, propName);
          } else if (cc.Class._isCCClass(val["default"])) {
            val["default"] = null;
            cc.errorID(5515, className, propName);
          }
        } else if (!val.get && !val.set) {
          var maybeTypeScript = es6;

          if (!maybeTypeScript) {
            cc.errorID(5516, className, propName);
          }
        }
      }

      if (CC_DEV && !val.override && cls.__props__.indexOf(propName) !== -1) {
        // check override
        var baseClass = js.getClassName(getBaseClassWherePropertyDefined_DEV(propName, cls));
        cc.warnID(5517, className, propName, baseClass, propName);
      }

      var notify = val.notify;

      if (notify) {
        if (CC_DEV && es6) {
          cc.error('not yet support notify attribute for ES6 Classes');
        } else {
          parseNotify(val, propName, notify, properties);
        }
      }

      if ('type' in val) {
        parseType(val, val.type, className, propName);
      }

      if ('url' in val) {
        checkUrl(val, className, propName, val.url);
      }

      if ('type' in val) {
        postCheckType(val, val.type, className, propName);
      }
    }
  }
};

if (CC_DEV) {
  var CALL_SUPER_DESTROY_REG_DEV = /\b\._super\b|destroy\s*\.\s*call\s*\(\s*\w+\s*[,|)]/;

  exports.doValidateMethodWithProps_DEV = function (func, funcName, className, cls, base) {
    if (cls.__props__ && cls.__props__.indexOf(funcName) >= 0) {
      // find class that defines this method as a property
      var baseClassName = js.getClassName(getBaseClassWherePropertyDefined_DEV(funcName, cls));
      cc.errorID(3648, className, funcName, baseClassName);
      return false;
    }

    if (funcName === 'destroy' && js.isChildClassOf(base, cc.Component) && !CALL_SUPER_DESTROY_REG_DEV.test(func)) {
      cc.error("Overwriting '" + funcName + "' function in '" + className + "' class without calling super is not allowed. Call the super function in '" + funcName + "' please.");
    }
  };
}

exports.validateMethodWithProps = function (func, funcName, className, cls, base) {
  if (CC_DEV && funcName === 'constructor') {
    cc.errorID(3643, className);
    return false;
  }

  if (typeof func === 'function' || func === null) {
    if (CC_DEV) {
      this.doValidateMethodWithProps_DEV(func, funcName, className, cls, base);
    }
  } else {
    if (CC_DEV) {
      if (func === false && base && base.prototype) {
        // check override
        var overrided = base.prototype[funcName];

        if (typeof overrided === 'function') {
          var baseFuc = js.getClassName(base) + '.' + funcName;
          var subFuc = className + '.' + funcName;
          cc.warnID(3624, subFuc, baseFuc, subFuc, subFuc);
        }
      }

      var correct = TYPO_TO_CORRECT_DEV[funcName];

      if (correct) {
        cc.warnID(3621, className, funcName, correct);
      } else if (func) {
        cc.errorID(3622, className, funcName);
      }
    }

    return false;
  }

  return true;
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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