
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCView.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var EventTarget = require('../event/event-target');

var js = require('../platform/js');

var renderer = require('../renderer');

require('../platform/CCClass');

var __BrowserGetter = {
  init: function init() {
    this.html = document.getElementsByTagName("html")[0];
  },
  availWidth: function availWidth(frame) {
    if (!frame || frame === this.html) return window.innerWidth;else return frame.clientWidth;
  },
  availHeight: function availHeight(frame) {
    if (!frame || frame === this.html) return window.innerHeight;else return frame.clientHeight;
  },
  meta: {
    "width": "device-width"
  },
  adaptationType: cc.sys.browserType
};
if (cc.sys.os === cc.sys.OS_IOS) // All browsers are WebView
  __BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_SAFARI;

switch (__BrowserGetter.adaptationType) {
  case cc.sys.BROWSER_TYPE_SAFARI:
    __BrowserGetter.meta["minimal-ui"] = "true";
    __BrowserGetter.availWidth = cc.sys.isMobile ? function (frame) {
      // bug fix for navigation bar on Safari
      return window.innerWidth;
    } : function (frame) {
      return frame.clientWidth;
    };
    __BrowserGetter.availHeight = cc.sys.isMobile ? function (frame) {
      // bug fix for navigation bar on Safari
      return window.innerHeight;
    } : function (frame) {
      return frame.clientHeight;
    };
    break;

  case cc.sys.BROWSER_TYPE_SOUGOU:
  case cc.sys.BROWSER_TYPE_UC:
    __BrowserGetter.meta["minimal-ui"] = "true";

    __BrowserGetter.availWidth = function (frame) {
      return frame.clientWidth;
    };

    __BrowserGetter.availHeight = function (frame) {
      return frame.clientHeight;
    };

    break;
}

var _scissorRect = null;
/**
 * cc.view is the singleton object which represents the game window.<br/>
 * It's main task include: <br/>
 *  - Apply the design resolution policy<br/>
 *  - Provide interaction with the window, like resize event on web, retina display support, etc...<br/>
 *  - Manage the game view port which can be different with the window<br/>
 *  - Manage the content scale and translation<br/>
 * <br/>
 * Since the cc.view is a singleton, you don't need to call any constructor or create functions,<br/>
 * the standard way to use it is by calling:<br/>
 *  - cc.view.methodName(); <br/>
 *
 * @class View
 * @extends EventTarget
 */

var View = function View() {
  EventTarget.call(this);

  var _t = this,
      _strategyer = cc.ContainerStrategy,
      _strategy = cc.ContentStrategy;

  __BrowserGetter.init(this); // Size of parent node that contains cc.game.container and cc.game.canvas


  _t._frameSize = cc.size(0, 0); // resolution size, it is the size appropriate for the app resources.

  _t._designResolutionSize = cc.size(0, 0);
  _t._originalDesignResolutionSize = cc.size(0, 0);
  _t._scaleX = 1;
  _t._scaleY = 1; // Viewport is the container's rect related to content's coordinates in pixel

  _t._viewportRect = cc.rect(0, 0, 0, 0); // The visible rect in content's coordinate in point

  _t._visibleRect = cc.rect(0, 0, 0, 0); // Auto full screen disabled by default

  _t._autoFullScreen = false; // The device's pixel ratio (for retina displays)

  _t._devicePixelRatio = 1;

  if (CC_JSB) {
    _t._maxPixelRatio = 4;
  } else {
    _t._maxPixelRatio = 2;
  } // Retina disabled by default


  _t._retinaEnabled = false; // Custom callback for resize event

  _t._resizeCallback = null;
  _t._resizing = false;
  _t._resizeWithBrowserSize = false;
  _t._orientationChanging = true;
  _t._isRotated = false;
  _t._orientation = cc.macro.ORIENTATION_AUTO;
  _t._isAdjustViewport = true;
  _t._antiAliasEnabled = false; // Setup system default resolution policies

  _t._resolutionPolicy = null;
  _t._rpExactFit = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.EXACT_FIT);
  _t._rpShowAll = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.SHOW_ALL);
  _t._rpNoBorder = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.NO_BORDER);
  _t._rpFixedHeight = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_HEIGHT);
  _t._rpFixedWidth = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_WIDTH);
  cc.game.once(cc.game.EVENT_ENGINE_INITED, this.init, this);
};

cc.js.extend(View, EventTarget);
cc.js.mixin(View.prototype, {
  init: function init() {
    this._initFrameSize();

    var w = cc.game.canvas.width,
        h = cc.game.canvas.height;
    this._designResolutionSize.width = w;
    this._designResolutionSize.height = h;
    this._originalDesignResolutionSize.width = w;
    this._originalDesignResolutionSize.height = h;
    this._viewportRect.width = w;
    this._viewportRect.height = h;
    this._visibleRect.width = w;
    this._visibleRect.height = h;
    cc.winSize.width = this._visibleRect.width;
    cc.winSize.height = this._visibleRect.height;
    cc.visibleRect && cc.visibleRect.init(this._visibleRect);
  },
  // Resize helper functions
  _resizeEvent: function _resizeEvent(forceOrEvent) {
    var view;

    if (this.setDesignResolutionSize) {
      view = this;
    } else {
      view = cc.view;
    } // HACK: some browsers can't update window size immediately
    // need to handle resize event callback on the next tick


    var sys = cc.sys;

    if (sys.browserType === sys.BROWSER_TYPE_UC && sys.os === sys.OS_IOS) {
      setTimeout(function () {
        view._resizeEvent(forceOrEvent);
      }, 0);
      return;
    } // Check frame size changed or not


    var prevFrameW = view._frameSize.width,
        prevFrameH = view._frameSize.height,
        prevRotated = view._isRotated;

    if (cc.sys.isMobile) {
      var containerStyle = cc.game.container.style,
          margin = containerStyle.margin;
      containerStyle.margin = '0';
      containerStyle.display = 'none';

      view._initFrameSize();

      containerStyle.margin = margin;
      containerStyle.display = 'block';
    } else {
      view._initFrameSize();
    }

    if (forceOrEvent !== true && view._isRotated === prevRotated && view._frameSize.width === prevFrameW && view._frameSize.height === prevFrameH) return; // Frame size changed, do resize works

    var width = view._originalDesignResolutionSize.width;
    var height = view._originalDesignResolutionSize.height;
    view._resizing = true;
    if (width > 0) view.setDesignResolutionSize(width, height, view._resolutionPolicy);
    view._resizing = false;
    view.emit('canvas-resize');

    if (view._resizeCallback) {
      view._resizeCallback.call();
    }
  },
  _orientationChange: function _orientationChange() {
    cc.view._orientationChanging = true;

    cc.view._resizeEvent(); // HACK: show nav bar on iOS safari
    // safari will enter fullscreen when rotate to landscape
    // need to exit fullscreen when rotate back to portrait, scrollTo(0, 1) works.


    if (cc.sys.browserType === cc.sys.BROWSER_TYPE_SAFARI && cc.sys.isMobile) {
      setTimeout(function () {
        if (window.innerHeight > window.innerWidth) {
          window.scrollTo(0, 1);
        }
      }, 500);
    }
  },

  /**
   * !#en
   * Sets view's target-densitydpi for android mobile browser. it can be set to:           <br/>
   *   1. cc.macro.DENSITYDPI_DEVICE, value is "device-dpi"                                      <br/>
   *   2. cc.macro.DENSITYDPI_HIGH, value is "high-dpi"  (default value)                         <br/>
   *   3. cc.macro.DENSITYDPI_MEDIUM, value is "medium-dpi" (browser's default value)            <br/>
   *   4. cc.macro.DENSITYDPI_LOW, value is "low-dpi"                                            <br/>
   *   5. Custom value, e.g: "480"                                                         <br/>
   * !#zh 设置目标内容的每英寸像素点密度。
   *
   * @method setTargetDensityDPI
   * @param {String} densityDPI
   * @deprecated since v2.0
   */

  /**
   * !#en
   * Returns the current target-densitydpi value of cc.view.
   * !#zh 获取目标内容的每英寸像素点密度。
   * @method getTargetDensityDPI
   * @returns {String}
   * @deprecated since v2.0
   */

  /**
   * !#en
   * Sets whether resize canvas automatically when browser's size changed.<br/>
   * Useful only on web.
   * !#zh 设置当发现浏览器的尺寸改变时，是否自动调整 canvas 尺寸大小。
   * 仅在 Web 模式下有效。
   * @method resizeWithBrowserSize
   * @param {Boolean} enabled - Whether enable automatic resize with browser's resize event
   */
  resizeWithBrowserSize: function resizeWithBrowserSize(enabled) {
    if (enabled) {
      //enable
      if (!this._resizeWithBrowserSize) {
        this._resizeWithBrowserSize = true;
        window.addEventListener('resize', this._resizeEvent);
        window.addEventListener('orientationchange', this._orientationChange);
      }
    } else {
      //disable
      if (this._resizeWithBrowserSize) {
        this._resizeWithBrowserSize = false;
        window.removeEventListener('resize', this._resizeEvent);
        window.removeEventListener('orientationchange', this._orientationChange);
      }
    }
  },

  /**
   * !#en
   * Sets the callback function for cc.view's resize action,<br/>
   * this callback will be invoked before applying resolution policy, <br/>
   * so you can do any additional modifications within the callback.<br/>
   * Useful only on web.
   * !#zh 设置 cc.view 调整视窗尺寸行为的回调函数，
   * 这个回调函数会在应用适配模式之前被调用，
   * 因此你可以在这个回调函数内添加任意附加改变，
   * 仅在 Web 平台下有效。
   * @method setResizeCallback
   * @param {Function|Null} callback - The callback function
   */
  setResizeCallback: function setResizeCallback(callback) {
    if (CC_EDITOR) return;

    if (typeof callback === 'function' || callback == null) {
      this._resizeCallback = callback;
    }
  },

  /**
   * !#en
   * Sets the orientation of the game, it can be landscape, portrait or auto.
   * When set it to landscape or portrait, and screen w/h ratio doesn't fit, 
   * cc.view will automatically rotate the game canvas using CSS.
   * Note that this function doesn't have any effect in native, 
   * in native, you need to set the application orientation in native project settings
   * !#zh 设置游戏屏幕朝向，它能够是横版，竖版或自动。
   * 当设置为横版或竖版，并且屏幕的宽高比例不匹配时，
   * cc.view 会自动用 CSS 旋转游戏场景的 canvas，
   * 这个方法不会对 native 部分产生任何影响，对于 native 而言，你需要在应用设置中的设置排版。
   * @method setOrientation
   * @param {Number} orientation - Possible values: cc.macro.ORIENTATION_LANDSCAPE | cc.macro.ORIENTATION_PORTRAIT | cc.macro.ORIENTATION_AUTO
   */
  setOrientation: function setOrientation(orientation) {
    orientation = orientation & cc.macro.ORIENTATION_AUTO;

    if (orientation && this._orientation !== orientation) {
      this._orientation = orientation;
      var designWidth = this._originalDesignResolutionSize.width;
      var designHeight = this._originalDesignResolutionSize.height;
      this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
    }
  },
  _initFrameSize: function _initFrameSize() {
    var locFrameSize = this._frameSize;

    var w = __BrowserGetter.availWidth(cc.game.frame);

    var h = __BrowserGetter.availHeight(cc.game.frame);

    var isLandscape = w >= h;

    if (CC_EDITOR || !cc.sys.isMobile || isLandscape && this._orientation & cc.macro.ORIENTATION_LANDSCAPE || !isLandscape && this._orientation & cc.macro.ORIENTATION_PORTRAIT) {
      locFrameSize.width = w;
      locFrameSize.height = h;
      cc.game.container.style['-webkit-transform'] = 'rotate(0deg)';
      cc.game.container.style.transform = 'rotate(0deg)';
      this._isRotated = false;
    } else {
      locFrameSize.width = h;
      locFrameSize.height = w;
      cc.game.container.style['-webkit-transform'] = 'rotate(90deg)';
      cc.game.container.style.transform = 'rotate(90deg)';
      cc.game.container.style['-webkit-transform-origin'] = '0px 0px 0px';
      cc.game.container.style.transformOrigin = '0px 0px 0px';
      this._isRotated = true;
    }

    if (this._orientationChanging) {
      setTimeout(function () {
        cc.view._orientationChanging = false;
      }, 1000);
    }
  },
  _setViewportMeta: function _setViewportMeta(metas, overwrite) {
    var vp = document.getElementById("cocosMetaElement");

    if (vp && overwrite) {
      document.head.removeChild(vp);
    }

    var elems = document.getElementsByName("viewport"),
        currentVP = elems ? elems[0] : null,
        content,
        key,
        pattern;
    content = currentVP ? currentVP.content : "";
    vp = vp || document.createElement("meta");
    vp.id = "cocosMetaElement";
    vp.name = "viewport";
    vp.content = "";

    for (key in metas) {
      if (content.indexOf(key) == -1) {
        content += "," + key + "=" + metas[key];
      } else if (overwrite) {
        pattern = new RegExp(key + "\s*=\s*[^,]+");
        content.replace(pattern, key + "=" + metas[key]);
      }
    }

    if (/^,/.test(content)) content = content.substr(1);
    vp.content = content; // For adopting certain android devices which don't support second viewport

    if (currentVP) currentVP.content = content;
    document.head.appendChild(vp);
  },
  _adjustViewportMeta: function _adjustViewportMeta() {
    if (this._isAdjustViewport && !CC_JSB && !CC_RUNTIME) {
      this._setViewportMeta(__BrowserGetter.meta, false);

      this._isAdjustViewport = false;
    }
  },

  /**
   * !#en
   * Sets whether the engine modify the "viewport" meta in your web page.<br/>
   * It's enabled by default, we strongly suggest you not to disable it.<br/>
   * And even when it's enabled, you can still set your own "viewport" meta, it won't be overridden<br/>
   * Only useful on web
   * !#zh 设置引擎是否调整 viewport meta 来配合屏幕适配。
   * 默认设置为启动，我们强烈建议你不要将它设置为关闭。
   * 即使当它启动时，你仍然能够设置你的 viewport meta，它不会被覆盖。
   * 仅在 Web 模式下有效
   * @method adjustViewportMeta
   * @param {Boolean} enabled - Enable automatic modification to "viewport" meta
   */
  adjustViewportMeta: function adjustViewportMeta(enabled) {
    this._isAdjustViewport = enabled;
  },

  /**
   * !#en
   * Retina support is enabled by default for Apple device but disabled for other devices,<br/>
   * it takes effect only when you called setDesignResolutionPolicy<br/>
   * Only useful on web
   * !#zh 对于 Apple 这种支持 Retina 显示的设备上默认进行优化而其他类型设备默认不进行优化，
   * 它仅会在你调用 setDesignResolutionPolicy 方法时有影响。
   * 仅在 Web 模式下有效。
   * @method enableRetina
   * @param {Boolean} enabled - Enable or disable retina display
   */
  enableRetina: function enableRetina(enabled) {
    if (CC_EDITOR && enabled) {
      cc.warn('Can not enable retina in Editor.');
      return;
    }

    this._retinaEnabled = !!enabled;
  },

  /**
   * !#en
   * Check whether retina display is enabled.<br/>
   * Only useful on web
   * !#zh 检查是否对 Retina 显示设备进行优化。
   * 仅在 Web 模式下有效。
   * @method isRetinaEnabled
   * @return {Boolean}
   */
  isRetinaEnabled: function isRetinaEnabled() {
    if (CC_EDITOR) {
      return false;
    }

    return this._retinaEnabled;
  },

  /**
   * !#en Whether to Enable on anti-alias
   * !#zh 控制抗锯齿是否开启
   * @method enableAntiAlias
   * @param {Boolean} enabled - Enable or not anti-alias
   * @deprecated cc.view.enableAntiAlias is deprecated now, please use cc.Texture2D.setFilters instead
   * @since v2.3.0
   */
  enableAntiAlias: function enableAntiAlias(enabled) {
    cc.warnID(9200);

    if (this._antiAliasEnabled === enabled) {
      return;
    }

    this._antiAliasEnabled = enabled;

    if (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL) {
      var cache = cc.loader._cache;

      for (var key in cache) {
        var item = cache[key];
        var tex = item && item.content instanceof cc.Texture2D ? item.content : null;

        if (tex) {
          var Filter = cc.Texture2D.Filter;

          if (enabled) {
            tex.setFilters(Filter.LINEAR, Filter.LINEAR);
          } else {
            tex.setFilters(Filter.NEAREST, Filter.NEAREST);
          }
        }
      }
    } else if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
      var ctx = cc.game.canvas.getContext('2d');
      ctx.imageSmoothingEnabled = enabled;
      ctx.mozImageSmoothingEnabled = enabled;
    }
  },

  /**
   * !#en Returns whether the current enable on anti-alias
   * !#zh 返回当前是否抗锯齿
   * @method isAntiAliasEnabled
   * @return {Boolean}
   */
  isAntiAliasEnabled: function isAntiAliasEnabled() {
    return this._antiAliasEnabled;
  },

  /**
   * !#en
   * If enabled, the application will try automatically to enter full screen mode on mobile devices<br/>
   * You can pass true as parameter to enable it and disable it by passing false.<br/>
   * Only useful on web
   * !#zh 启动时，移动端游戏会在移动端自动尝试进入全屏模式。
   * 你能够传入 true 为参数去启动它，用 false 参数来关闭它。
   * @method enableAutoFullScreen
   * @param {Boolean} enabled - Enable or disable auto full screen on mobile devices
   */
  enableAutoFullScreen: function enableAutoFullScreen(enabled) {
    if (enabled && enabled !== this._autoFullScreen && cc.sys.isMobile) {
      // Automatically full screen when user touches on mobile version
      this._autoFullScreen = true;
      cc.screen.autoFullScreen(cc.game.frame);
    } else {
      this._autoFullScreen = false;
      cc.screen.disableAutoFullScreen(cc.game.frame);
    }
  },

  /**
   * !#en
   * Check whether auto full screen is enabled.<br/>
   * Only useful on web
   * !#zh 检查自动进入全屏模式是否启动。
   * 仅在 Web 模式下有效。
   * @method isAutoFullScreenEnabled
   * @return {Boolean} Auto full screen enabled or not
   */
  isAutoFullScreenEnabled: function isAutoFullScreenEnabled() {
    return this._autoFullScreen;
  },

  /*
   * Not support on native.<br/>
   * On web, it sets the size of the canvas.
   * !#zh 这个方法并不支持 native 平台，在 Web 平台下，可以用来设置 canvas 尺寸。
   * @method setCanvasSize
   * @param {Number} width
   * @param {Number} height
   */
  setCanvasSize: function setCanvasSize(width, height) {
    var canvas = cc.game.canvas;
    var container = cc.game.container;
    canvas.width = width * this._devicePixelRatio;
    canvas.height = height * this._devicePixelRatio;
    canvas.style.width = width + 'px';
    canvas.style.height = height + 'px';
    container.style.width = width + 'px';
    container.style.height = height + 'px';

    this._resizeEvent();
  },

  /**
   * !#en
   * Returns the canvas size of the view.<br/>
   * On native platforms, it returns the screen size since the view is a fullscreen view.<br/>
   * On web, it returns the size of the canvas element.
   * !#zh 返回视图中 canvas 的尺寸。
   * 在 native 平台下，它返回全屏视图下屏幕的尺寸。
   * 在 Web 平台下，它返回 canvas 元素尺寸。
   * @method getCanvasSize
   * @return {Size}
   */
  getCanvasSize: function getCanvasSize() {
    return cc.size(cc.game.canvas.width, cc.game.canvas.height);
  },

  /**
   * !#en
   * Returns the frame size of the view.<br/>
   * On native platforms, it returns the screen size since the view is a fullscreen view.<br/>
   * On web, it returns the size of the canvas's outer DOM element.
   * !#zh 返回视图中边框尺寸。
   * 在 native 平台下，它返回全屏视图下屏幕的尺寸。
   * 在 web 平台下，它返回 canvas 元素的外层 DOM 元素尺寸。
   * @method getFrameSize
   * @return {Size}
   */
  getFrameSize: function getFrameSize() {
    return cc.size(this._frameSize.width, this._frameSize.height);
  },

  /**
   * !#en
   * On native, it sets the frame size of view.<br/>
   * On web, it sets the size of the canvas's outer DOM element.
   * !#zh 在 native 平台下，设置视图框架尺寸。
   * 在 web 平台下，设置 canvas 外层 DOM 元素尺寸。
   * @method setFrameSize
   * @param {Number} width
   * @param {Number} height
   */
  setFrameSize: function setFrameSize(width, height) {
    this._frameSize.width = width;
    this._frameSize.height = height;
    cc.game.frame.style.width = width + "px";
    cc.game.frame.style.height = height + "px";

    this._resizeEvent(true);
  },

  /**
   * !#en
   * Returns the visible area size of the view port.
   * !#zh 返回视图窗口可见区域尺寸。
   * @method getVisibleSize
   * @return {Size}
   */
  getVisibleSize: function getVisibleSize() {
    return cc.size(this._visibleRect.width, this._visibleRect.height);
  },

  /**
   * !#en
   * Returns the visible area size of the view port.
   * !#zh 返回视图窗口可见区域像素尺寸。
   * @method getVisibleSizeInPixel
   * @return {Size}
   */
  getVisibleSizeInPixel: function getVisibleSizeInPixel() {
    return cc.size(this._visibleRect.width * this._scaleX, this._visibleRect.height * this._scaleY);
  },

  /**
   * !#en
   * Returns the visible origin of the view port.
   * !#zh 返回视图窗口可见区域原点。
   * @method getVisibleOrigin
   * @return {Vec2}
   */
  getVisibleOrigin: function getVisibleOrigin() {
    return cc.v2(this._visibleRect.x, this._visibleRect.y);
  },

  /**
   * !#en
   * Returns the visible origin of the view port.
   * !#zh 返回视图窗口可见区域像素原点。
   * @method getVisibleOriginInPixel
   * @return {Vec2}
   */
  getVisibleOriginInPixel: function getVisibleOriginInPixel() {
    return cc.v2(this._visibleRect.x * this._scaleX, this._visibleRect.y * this._scaleY);
  },

  /**
   * !#en
   * Returns the current resolution policy
   * !#zh 返回当前分辨率方案
   * @see cc.ResolutionPolicy
   * @method getResolutionPolicy
   * @return {ResolutionPolicy}
   */
  getResolutionPolicy: function getResolutionPolicy() {
    return this._resolutionPolicy;
  },

  /**
   * !#en
   * Sets the current resolution policy
   * !#zh 设置当前分辨率模式
   * @see cc.ResolutionPolicy
   * @method setResolutionPolicy
   * @param {ResolutionPolicy|Number} resolutionPolicy
   */
  setResolutionPolicy: function setResolutionPolicy(resolutionPolicy) {
    var _t = this;

    if (resolutionPolicy instanceof cc.ResolutionPolicy) {
      _t._resolutionPolicy = resolutionPolicy;
    } // Ensure compatibility with JSB
    else {
        var _locPolicy = cc.ResolutionPolicy;
        if (resolutionPolicy === _locPolicy.EXACT_FIT) _t._resolutionPolicy = _t._rpExactFit;
        if (resolutionPolicy === _locPolicy.SHOW_ALL) _t._resolutionPolicy = _t._rpShowAll;
        if (resolutionPolicy === _locPolicy.NO_BORDER) _t._resolutionPolicy = _t._rpNoBorder;
        if (resolutionPolicy === _locPolicy.FIXED_HEIGHT) _t._resolutionPolicy = _t._rpFixedHeight;
        if (resolutionPolicy === _locPolicy.FIXED_WIDTH) _t._resolutionPolicy = _t._rpFixedWidth;
      }
  },

  /**
   * !#en
   * Sets the resolution policy with designed view size in points.<br/>
   * The resolution policy include: <br/>
   * [1] ResolutionExactFit       Fill screen by stretch-to-fit: if the design resolution ratio of width to height is different from the screen resolution ratio, your game view will be stretched.<br/>
   * [2] ResolutionNoBorder       Full screen without black border: if the design resolution ratio of width to height is different from the screen resolution ratio, two areas of your game view will be cut.<br/>
   * [3] ResolutionShowAll        Full screen with black border: if the design resolution ratio of width to height is different from the screen resolution ratio, two black borders will be shown.<br/>
   * [4] ResolutionFixedHeight    Scale the content's height to screen's height and proportionally scale its width<br/>
   * [5] ResolutionFixedWidth     Scale the content's width to screen's width and proportionally scale its height<br/>
   * [cc.ResolutionPolicy]        [Web only feature] Custom resolution policy, constructed by cc.ResolutionPolicy<br/>
   * !#zh 通过设置设计分辨率和匹配模式来进行游戏画面的屏幕适配。
   * @method setDesignResolutionSize
   * @param {Number} width Design resolution width.
   * @param {Number} height Design resolution height.
   * @param {ResolutionPolicy|Number} resolutionPolicy The resolution policy desired
   */
  setDesignResolutionSize: function setDesignResolutionSize(width, height, resolutionPolicy) {
    // Defensive code
    if (!(width > 0 || height > 0)) {
      cc.logID(2200);
      return;
    }

    this.setResolutionPolicy(resolutionPolicy);
    var policy = this._resolutionPolicy;

    if (policy) {
      policy.preApply(this);
    } // Reinit frame size


    if (cc.sys.isMobile) this._adjustViewportMeta(); // Permit to re-detect the orientation of device.

    this._orientationChanging = true; // If resizing, then frame size is already initialized, this logic should be improved

    if (!this._resizing) this._initFrameSize();

    if (!policy) {
      cc.logID(2201);
      return;
    }

    this._originalDesignResolutionSize.width = this._designResolutionSize.width = width;
    this._originalDesignResolutionSize.height = this._designResolutionSize.height = height;
    var result = policy.apply(this, this._designResolutionSize);

    if (result.scale && result.scale.length === 2) {
      this._scaleX = result.scale[0];
      this._scaleY = result.scale[1];
    }

    if (result.viewport) {
      var vp = this._viewportRect,
          vb = this._visibleRect,
          rv = result.viewport;
      vp.x = rv.x;
      vp.y = rv.y;
      vp.width = rv.width;
      vp.height = rv.height;
      vb.x = 0;
      vb.y = 0;
      vb.width = rv.width / this._scaleX;
      vb.height = rv.height / this._scaleY;
    }

    policy.postApply(this);
    cc.winSize.width = this._visibleRect.width;
    cc.winSize.height = this._visibleRect.height;
    cc.visibleRect && cc.visibleRect.init(this._visibleRect);
    renderer.updateCameraViewport();

    cc.internal.inputManager._updateCanvasBoundingRect();

    this.emit('design-resolution-changed');
  },

  /**
   * !#en
   * Returns the designed size for the view.
   * Default resolution size is the same as 'getFrameSize'.
   * !#zh 返回视图的设计分辨率。
   * 默认下分辨率尺寸同 `getFrameSize` 方法相同
   * @method getDesignResolutionSize
   * @return {Size}
   */
  getDesignResolutionSize: function getDesignResolutionSize() {
    return cc.size(this._designResolutionSize.width, this._designResolutionSize.height);
  },

  /**
   * !#en
   * Sets the container to desired pixel resolution and fit the game content to it.
   * This function is very useful for adaptation in mobile browsers.
   * In some HD android devices, the resolution is very high, but its browser performance may not be very good.
   * In this case, enabling retina display is very costy and not suggested, and if retina is disabled, the image may be blurry.
   * But this API can be helpful to set a desired pixel resolution which is in between.
   * This API will do the following:
   *     1. Set viewport's width to the desired width in pixel
   *     2. Set body width to the exact pixel resolution
   *     3. The resolution policy will be reset with designed view size in points.
   * !#zh 设置容器（container）需要的像素分辨率并且适配相应分辨率的游戏内容。
   * @method setRealPixelResolution
   * @param {Number} width Design resolution width.
   * @param {Number} height Design resolution height.
   * @param {ResolutionPolicy|Number} resolutionPolicy The resolution policy desired
   */
  setRealPixelResolution: function setRealPixelResolution(width, height, resolutionPolicy) {
    if (!CC_JSB && !CC_RUNTIME) {
      // Set viewport's width
      this._setViewportMeta({
        "width": width
      }, true); // Set body width to the exact pixel resolution


      document.documentElement.style.width = width + "px";
      document.body.style.width = width + "px";
      document.body.style.left = "0px";
      document.body.style.top = "0px";
    } // Reset the resolution size and policy


    this.setDesignResolutionSize(width, height, resolutionPolicy);
  },

  /**
   * !#en
   * Sets view port rectangle with points.
   * !#zh 用设计分辨率下的点尺寸来设置视窗。
   * @method setViewportInPoints
   * @deprecated since v2.0
   * @param {Number} x
   * @param {Number} y
   * @param {Number} w width
   * @param {Number} h height
   */
  setViewportInPoints: function setViewportInPoints(x, y, w, h) {
    var locScaleX = this._scaleX,
        locScaleY = this._scaleY;

    cc.game._renderContext.viewport(x * locScaleX + this._viewportRect.x, y * locScaleY + this._viewportRect.y, w * locScaleX, h * locScaleY);
  },

  /**
   * !#en
   * Sets Scissor rectangle with points.
   * !#zh 用设计分辨率下的点的尺寸来设置 scissor 剪裁区域。
   * @method setScissorInPoints
   * @deprecated since v2.0
   * @param {Number} x
   * @param {Number} y
   * @param {Number} w
   * @param {Number} h
   */
  setScissorInPoints: function setScissorInPoints(x, y, w, h) {
    var scaleX = this._scaleX,
        scaleY = this._scaleY;
    var sx = Math.ceil(x * scaleX + this._viewportRect.x);
    var sy = Math.ceil(y * scaleY + this._viewportRect.y);
    var sw = Math.ceil(w * scaleX);
    var sh = Math.ceil(h * scaleY);
    var gl = cc.game._renderContext;

    if (!_scissorRect) {
      var boxArr = gl.getParameter(gl.SCISSOR_BOX);
      _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
    }

    if (_scissorRect.x !== sx || _scissorRect.y !== sy || _scissorRect.width !== sw || _scissorRect.height !== sh) {
      _scissorRect.x = sx;
      _scissorRect.y = sy;
      _scissorRect.width = sw;
      _scissorRect.height = sh;
      gl.scissor(sx, sy, sw, sh);
    }
  },

  /**
   * !#en
   * Returns whether GL_SCISSOR_TEST is enable
   * !#zh 检查 scissor 是否生效。
   * @method isScissorEnabled
   * @deprecated since v2.0
   * @return {Boolean}
   */
  isScissorEnabled: function isScissorEnabled() {
    return cc.game._renderContext.isEnabled(gl.SCISSOR_TEST);
  },

  /**
   * !#en
   * Returns the current scissor rectangle
   * !#zh 返回当前的 scissor 剪裁区域。
   * @method getScissorRect
   * @deprecated since v2.0
   * @return {Rect}
   */
  getScissorRect: function getScissorRect() {
    if (!_scissorRect) {
      var boxArr = gl.getParameter(gl.SCISSOR_BOX);
      _scissorRect = cc.rect(boxArr[0], boxArr[1], boxArr[2], boxArr[3]);
    }

    var scaleXFactor = 1 / this._scaleX;
    var scaleYFactor = 1 / this._scaleY;
    return cc.rect((_scissorRect.x - this._viewportRect.x) * scaleXFactor, (_scissorRect.y - this._viewportRect.y) * scaleYFactor, _scissorRect.width * scaleXFactor, _scissorRect.height * scaleYFactor);
  },

  /**
   * !#en
   * Returns the view port rectangle.
   * !#zh 返回视窗剪裁区域。
   * @method getViewportRect
   * @return {Rect}
   */
  getViewportRect: function getViewportRect() {
    return this._viewportRect;
  },

  /**
   * !#en
   * Returns scale factor of the horizontal direction (X axis).
   * !#zh 返回横轴的缩放比，这个缩放比是将画布像素分辨率放到设计分辨率的比例。
   * @method getScaleX
   * @return {Number}
   */
  getScaleX: function getScaleX() {
    return this._scaleX;
  },

  /**
   * !#en
   * Returns scale factor of the vertical direction (Y axis).
   * !#zh 返回纵轴的缩放比，这个缩放比是将画布像素分辨率缩放到设计分辨率的比例。
   * @method getScaleY
   * @return {Number}
   */
  getScaleY: function getScaleY() {
    return this._scaleY;
  },

  /**
   * !#en
   * Returns device pixel ratio for retina display.
   * !#zh 返回设备或浏览器像素比例。
   * @method getDevicePixelRatio
   * @return {Number}
   */
  getDevicePixelRatio: function getDevicePixelRatio() {
    return this._devicePixelRatio;
  },

  /**
   * !#en
   * Returns the real location in view for a translation based on a related position
   * !#zh 将屏幕坐标转换为游戏视图下的坐标。
   * @method convertToLocationInView
   * @param {Number} tx - The X axis translation
   * @param {Number} ty - The Y axis translation
   * @param {Object} relatedPos - The related position object including "left", "top", "width", "height" informations
   * @return {Vec2}
   */
  convertToLocationInView: function convertToLocationInView(tx, ty, relatedPos, out) {
    var result = out || cc.v2();
    var posLeft = relatedPos.adjustedLeft ? relatedPos.adjustedLeft : relatedPos.left;
    var posTop = relatedPos.adjustedTop ? relatedPos.adjustedTop : relatedPos.top;
    var x = this._devicePixelRatio * (tx - posLeft);
    var y = this._devicePixelRatio * (posTop + relatedPos.height - ty);

    if (this._isRotated) {
      result.x = cc.game.canvas.width - y;
      result.y = x;
    } else {
      result.x = x;
      result.y = y;
    }

    return result;
  },
  _convertMouseToLocationInView: function _convertMouseToLocationInView(in_out_point, relatedPos) {
    var viewport = this._viewportRect,
        _t = this;

    in_out_point.x = (_t._devicePixelRatio * (in_out_point.x - relatedPos.left) - viewport.x) / _t._scaleX;
    in_out_point.y = (_t._devicePixelRatio * (relatedPos.top + relatedPos.height - in_out_point.y) - viewport.y) / _t._scaleY;
  },
  _convertPointWithScale: function _convertPointWithScale(point) {
    var viewport = this._viewportRect;
    point.x = (point.x - viewport.x) / this._scaleX;
    point.y = (point.y - viewport.y) / this._scaleY;
  },
  _convertTouchesWithScale: function _convertTouchesWithScale(touches) {
    var viewport = this._viewportRect,
        scaleX = this._scaleX,
        scaleY = this._scaleY,
        selTouch,
        selPoint,
        selPrePoint;

    for (var i = 0; i < touches.length; i++) {
      selTouch = touches[i];
      selPoint = selTouch._point;
      selPrePoint = selTouch._prevPoint;
      selPoint.x = (selPoint.x - viewport.x) / scaleX;
      selPoint.y = (selPoint.y - viewport.y) / scaleY;
      selPrePoint.x = (selPrePoint.x - viewport.x) / scaleX;
      selPrePoint.y = (selPrePoint.y - viewport.y) / scaleY;
    }
  }
});
/**
 * !#en
 * Emit when design resolution changed.
 * !#zh
 * 当设计分辨率改变时发送。
 * @event design-resolution-changed
 */

/**
* !#en
* Emit when canvas resize.
* !#zh
* 当画布大小改变时发送。
* @event canvas-resize
*/

/**
 * <p>cc.game.containerStrategy class is the root strategy class of container's scale strategy,
 * it controls the behavior of how to scale the cc.game.container and cc.game.canvas object</p>
 *
 * @class ContainerStrategy
 */

cc.ContainerStrategy = cc.Class({
  name: "ContainerStrategy",

  /**
   * !#en
   * Manipulation before appling the strategy
   * !#zh 在应用策略之前的操作
   * @method preApply
   * @param {View} view - The target view
   */
  preApply: function preApply(view) {},

  /**
   * !#en
   * Function to apply this strategy
   * !#zh 策略应用方法
   * @method apply
   * @param {View} view
   * @param {Size} designedResolution
   */
  apply: function apply(view, designedResolution) {},

  /**
   * !#en
   * Manipulation after applying the strategy
   * !#zh 策略调用之后的操作
   * @method postApply
   * @param {View} view  The target view
   */
  postApply: function postApply(view) {},
  _setupContainer: function _setupContainer(view, w, h) {
    var locCanvas = cc.game.canvas;

    this._setupStyle(view, w, h); // Setup pixel ratio for retina display


    var devicePixelRatio = view._devicePixelRatio = 1;

    if (CC_JSB) {
      // view.isRetinaEnabled only work on web. 
      devicePixelRatio = view._devicePixelRatio = window.devicePixelRatio;
    } else if (view.isRetinaEnabled()) {
      devicePixelRatio = view._devicePixelRatio = Math.min(view._maxPixelRatio, window.devicePixelRatio || 1);
    } // Setup canvas


    locCanvas.width = w * devicePixelRatio;
    locCanvas.height = h * devicePixelRatio;
  },
  _setupStyle: function _setupStyle(view, w, h) {
    var locCanvas = cc.game.canvas;
    var locContainer = cc.game.container;

    if (cc.sys.os === cc.sys.OS_ANDROID) {
      document.body.style.width = (view._isRotated ? h : w) + 'px';
      document.body.style.height = (view._isRotated ? w : h) + 'px';
    } // Setup style


    locContainer.style.width = locCanvas.style.width = w + 'px';
    locContainer.style.height = locCanvas.style.height = h + 'px';
  },
  _fixContainer: function _fixContainer() {
    // Add container to document body
    document.body.insertBefore(cc.game.container, document.body.firstChild); // Set body's width height to window's size, and forbid overflow, so that game will be centered

    var bs = document.body.style;
    bs.width = window.innerWidth + "px";
    bs.height = window.innerHeight + "px";
    bs.overflow = "hidden"; // Body size solution doesn't work on all mobile browser so this is the aleternative: fixed container

    var contStyle = cc.game.container.style;
    contStyle.position = "fixed";
    contStyle.left = contStyle.top = "0px"; // Reposition body

    document.body.scrollTop = 0;
  }
});
/**
 * <p>cc.ContentStrategy class is the root strategy class of content's scale strategy,
 * it controls the behavior of how to scale the scene and setup the viewport for the game</p>
 *
 * @class ContentStrategy
 */

cc.ContentStrategy = cc.Class({
  name: "ContentStrategy",
  ctor: function ctor() {
    this._result = {
      scale: [1, 1],
      viewport: null
    };
  },
  _buildResult: function _buildResult(containerW, containerH, contentW, contentH, scaleX, scaleY) {
    // Makes content fit better the canvas
    Math.abs(containerW - contentW) < 2 && (contentW = containerW);
    Math.abs(containerH - contentH) < 2 && (contentH = containerH);
    var viewport = cc.rect((containerW - contentW) / 2, (containerH - contentH) / 2, contentW, contentH); // Translate the content

    if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {//TODO: modify something for setTransform
      //cc.game._renderContext.translate(viewport.x, viewport.y + contentH);
    }

    this._result.scale = [scaleX, scaleY];
    this._result.viewport = viewport;
    return this._result;
  },

  /**
   * !#en
   * Manipulation before applying the strategy
   * !#zh 策略应用前的操作
   * @method preApply
   * @param {View} view - The target view
   */
  preApply: function preApply(view) {},

  /**
   * !#en Function to apply this strategy
   * The return value is {scale: [scaleX, scaleY], viewport: {cc.Rect}},
   * The target view can then apply these value to itself, it's preferred not to modify directly its private variables
   * !#zh 调用策略方法
   * @method apply
   * @param {View} view
   * @param {Size} designedResolution
   * @return {Object} scaleAndViewportRect
   */
  apply: function apply(view, designedResolution) {
    return {
      "scale": [1, 1]
    };
  },

  /**
   * !#en
   * Manipulation after applying the strategy
   * !#zh 策略调用之后的操作
   * @method postApply
   * @param {View} view - The target view
   */
  postApply: function postApply(view) {}
});

(function () {
  // Container scale strategys

  /**
   * @class EqualToFrame
   * @extends ContainerStrategy
   */
  var EqualToFrame = cc.Class({
    name: "EqualToFrame",
    "extends": cc.ContainerStrategy,
    apply: function apply(view) {
      var frameH = view._frameSize.height,
          containerStyle = cc.game.container.style;

      this._setupContainer(view, view._frameSize.width, view._frameSize.height); // Setup container's margin and padding


      if (view._isRotated) {
        containerStyle.margin = '0 0 0 ' + frameH + 'px';
      } else {
        containerStyle.margin = '0px';
      }

      containerStyle.padding = "0px";
    }
  });
  /**
   * @class ProportionalToFrame
   * @extends ContainerStrategy
   */

  var ProportionalToFrame = cc.Class({
    name: "ProportionalToFrame",
    "extends": cc.ContainerStrategy,
    apply: function apply(view, designedResolution) {
      var frameW = view._frameSize.width,
          frameH = view._frameSize.height,
          containerStyle = cc.game.container.style,
          designW = designedResolution.width,
          designH = designedResolution.height,
          scaleX = frameW / designW,
          scaleY = frameH / designH,
          containerW,
          containerH;
      scaleX < scaleY ? (containerW = frameW, containerH = designH * scaleX) : (containerW = designW * scaleY, containerH = frameH); // Adjust container size with integer value

      var offx = Math.round((frameW - containerW) / 2);
      var offy = Math.round((frameH - containerH) / 2);
      containerW = frameW - 2 * offx;
      containerH = frameH - 2 * offy;

      this._setupContainer(view, containerW, containerH);

      if (!CC_EDITOR) {
        // Setup container's margin and padding
        if (view._isRotated) {
          containerStyle.margin = '0 0 0 ' + frameH + 'px';
        } else {
          containerStyle.margin = '0px';
        }

        containerStyle.paddingLeft = offx + "px";
        containerStyle.paddingRight = offx + "px";
        containerStyle.paddingTop = offy + "px";
        containerStyle.paddingBottom = offy + "px";
      }
    }
  });
  /**
   * @class EqualToWindow
   * @extends EqualToFrame
   */

  var EqualToWindow = cc.Class({
    name: "EqualToWindow",
    "extends": EqualToFrame,
    preApply: function preApply(view) {
      this._super(view);

      cc.game.frame = document.documentElement;
    },
    apply: function apply(view) {
      this._super(view);

      this._fixContainer();
    }
  });
  /**
   * @class ProportionalToWindow
   * @extends ProportionalToFrame
   */

  var ProportionalToWindow = cc.Class({
    name: "ProportionalToWindow",
    "extends": ProportionalToFrame,
    preApply: function preApply(view) {
      this._super(view);

      cc.game.frame = document.documentElement;
    },
    apply: function apply(view, designedResolution) {
      this._super(view, designedResolution);

      this._fixContainer();
    }
  });
  /**
   * @class OriginalContainer
   * @extends ContainerStrategy
   */

  var OriginalContainer = cc.Class({
    name: "OriginalContainer",
    "extends": cc.ContainerStrategy,
    apply: function apply(view) {
      this._setupContainer(view, cc.game.canvas.width, cc.game.canvas.height);
    }
  }); // need to adapt prototype before instantiating

  var _global = typeof window === 'undefined' ? global : window;

  var globalAdapter = _global.__globalAdapter;

  if (globalAdapter) {
    if (globalAdapter.adaptContainerStrategy) {
      globalAdapter.adaptContainerStrategy(cc.ContainerStrategy.prototype);
    }

    if (globalAdapter.adaptView) {
      globalAdapter.adaptView(View.prototype);
    }
  } // #NOT STABLE on Android# Alias: Strategy that makes the container's size equals to the window's size
  //    cc.ContainerStrategy.EQUAL_TO_WINDOW = new EqualToWindow();
  // #NOT STABLE on Android# Alias: Strategy that scale proportionally the container's size to window's size
  //    cc.ContainerStrategy.PROPORTION_TO_WINDOW = new ProportionalToWindow();
  // Alias: Strategy that makes the container's size equals to the frame's size


  cc.ContainerStrategy.EQUAL_TO_FRAME = new EqualToFrame(); // Alias: Strategy that scale proportionally the container's size to frame's size

  cc.ContainerStrategy.PROPORTION_TO_FRAME = new ProportionalToFrame(); // Alias: Strategy that keeps the original container's size

  cc.ContainerStrategy.ORIGINAL_CONTAINER = new OriginalContainer(); // Content scale strategys

  var ExactFit = cc.Class({
    name: "ExactFit",
    "extends": cc.ContentStrategy,
    apply: function apply(view, designedResolution) {
      var containerW = cc.game.canvas.width,
          containerH = cc.game.canvas.height,
          scaleX = containerW / designedResolution.width,
          scaleY = containerH / designedResolution.height;
      return this._buildResult(containerW, containerH, containerW, containerH, scaleX, scaleY);
    }
  });
  var ShowAll = cc.Class({
    name: "ShowAll",
    "extends": cc.ContentStrategy,
    apply: function apply(view, designedResolution) {
      var containerW = cc.game.canvas.width,
          containerH = cc.game.canvas.height,
          designW = designedResolution.width,
          designH = designedResolution.height,
          scaleX = containerW / designW,
          scaleY = containerH / designH,
          scale = 0,
          contentW,
          contentH;
      scaleX < scaleY ? (scale = scaleX, contentW = containerW, contentH = designH * scale) : (scale = scaleY, contentW = designW * scale, contentH = containerH);
      return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
    }
  });
  var NoBorder = cc.Class({
    name: "NoBorder",
    "extends": cc.ContentStrategy,
    apply: function apply(view, designedResolution) {
      var containerW = cc.game.canvas.width,
          containerH = cc.game.canvas.height,
          designW = designedResolution.width,
          designH = designedResolution.height,
          scaleX = containerW / designW,
          scaleY = containerH / designH,
          scale,
          contentW,
          contentH;
      scaleX < scaleY ? (scale = scaleY, contentW = designW * scale, contentH = containerH) : (scale = scaleX, contentW = containerW, contentH = designH * scale);
      return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
    }
  });
  var FixedHeight = cc.Class({
    name: "FixedHeight",
    "extends": cc.ContentStrategy,
    apply: function apply(view, designedResolution) {
      var containerW = cc.game.canvas.width,
          containerH = cc.game.canvas.height,
          designH = designedResolution.height,
          scale = containerH / designH,
          contentW = containerW,
          contentH = containerH;
      return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
    }
  });
  var FixedWidth = cc.Class({
    name: "FixedWidth",
    "extends": cc.ContentStrategy,
    apply: function apply(view, designedResolution) {
      var containerW = cc.game.canvas.width,
          containerH = cc.game.canvas.height,
          designW = designedResolution.width,
          scale = containerW / designW,
          contentW = containerW,
          contentH = containerH;
      return this._buildResult(containerW, containerH, contentW, contentH, scale, scale);
    }
  }); // Alias: Strategy to scale the content's size to container's size, non proportional

  cc.ContentStrategy.EXACT_FIT = new ExactFit(); // Alias: Strategy to scale the content's size proportionally to maximum size and keeps the whole content area to be visible

  cc.ContentStrategy.SHOW_ALL = new ShowAll(); // Alias: Strategy to scale the content's size proportionally to fill the whole container area

  cc.ContentStrategy.NO_BORDER = new NoBorder(); // Alias: Strategy to scale the content's height to container's height and proportionally scale its width

  cc.ContentStrategy.FIXED_HEIGHT = new FixedHeight(); // Alias: Strategy to scale the content's width to container's width and proportionally scale its height

  cc.ContentStrategy.FIXED_WIDTH = new FixedWidth();
})();
/**
 * <p>cc.ResolutionPolicy class is the root strategy class of scale strategy,
 * its main task is to maintain the compatibility with Cocos2d-x</p>
 *
 * @class ResolutionPolicy
 */

/**
 * @method constructor
 * @param {ContainerStrategy} containerStg The container strategy
 * @param {ContentStrategy} contentStg The content strategy
 */


cc.ResolutionPolicy = cc.Class({
  name: "cc.ResolutionPolicy",

  /**
   * Constructor of cc.ResolutionPolicy
   * @param {ContainerStrategy} containerStg
   * @param {ContentStrategy} contentStg
   */
  ctor: function ctor(containerStg, contentStg) {
    this._containerStrategy = null;
    this._contentStrategy = null;
    this.setContainerStrategy(containerStg);
    this.setContentStrategy(contentStg);
  },

  /**
   * !#en Manipulation before applying the resolution policy
   * !#zh 策略应用前的操作
   * @method preApply
   * @param {View} view The target view
   */
  preApply: function preApply(view) {
    this._containerStrategy.preApply(view);

    this._contentStrategy.preApply(view);
  },

  /**
   * !#en Function to apply this resolution policy
   * The return value is {scale: [scaleX, scaleY], viewport: {cc.Rect}},
   * The target view can then apply these value to itself, it's preferred not to modify directly its private variables
   * !#zh 调用策略方法
   * @method apply
   * @param {View} view - The target view
   * @param {Size} designedResolution - The user defined design resolution
   * @return {Object} An object contains the scale X/Y values and the viewport rect
   */
  apply: function apply(view, designedResolution) {
    this._containerStrategy.apply(view, designedResolution);

    return this._contentStrategy.apply(view, designedResolution);
  },

  /**
   * !#en Manipulation after appyling the strategy
   * !#zh 策略应用之后的操作
   * @method postApply
   * @param {View} view - The target view
   */
  postApply: function postApply(view) {
    this._containerStrategy.postApply(view);

    this._contentStrategy.postApply(view);
  },

  /**
   * !#en
   * Setup the container's scale strategy
   * !#zh 设置容器的适配策略
   * @method setContainerStrategy
   * @param {ContainerStrategy} containerStg
   */
  setContainerStrategy: function setContainerStrategy(containerStg) {
    if (containerStg instanceof cc.ContainerStrategy) this._containerStrategy = containerStg;
  },

  /**
   * !#en
   * Setup the content's scale strategy
   * !#zh 设置内容的适配策略
   * @method setContentStrategy
   * @param {ContentStrategy} contentStg
   */
  setContentStrategy: function setContentStrategy(contentStg) {
    if (contentStg instanceof cc.ContentStrategy) this._contentStrategy = contentStg;
  }
});
js.get(cc.ResolutionPolicy.prototype, "canvasSize", function () {
  return cc.v2(cc.game.canvas.width, cc.game.canvas.height);
});
/**
 * The entire application is visible in the specified area without trying to preserve the original aspect ratio.<br/>
 * Distortion can occur, and the application may appear stretched or compressed.
 * @property {Number} EXACT_FIT
 * @readonly
 * @static
 */

cc.ResolutionPolicy.EXACT_FIT = 0;
/**
 * The entire application fills the specified area, without distortion but possibly with some cropping,<br/>
 * while maintaining the original aspect ratio of the application.
 * @property {Number} NO_BORDER
 * @readonly
 * @static
 */

cc.ResolutionPolicy.NO_BORDER = 1;
/**
 * The entire application is visible in the specified area without distortion while maintaining the original<br/>
 * aspect ratio of the application. Borders can appear on two sides of the application.
 * @property {Number} SHOW_ALL
 * @readonly
 * @static
 */

cc.ResolutionPolicy.SHOW_ALL = 2;
/**
 * The application takes the height of the design resolution size and modifies the width of the internal<br/>
 * canvas so that it fits the aspect ratio of the device<br/>
 * no distortion will occur however you must make sure your application works on different<br/>
 * aspect ratios
 * @property {Number} FIXED_HEIGHT
 * @readonly
 * @static
 */

cc.ResolutionPolicy.FIXED_HEIGHT = 3;
/**
 * The application takes the width of the design resolution size and modifies the height of the internal<br/>
 * canvas so that it fits the aspect ratio of the device<br/>
 * no distortion will occur however you must make sure your application works on different<br/>
 * aspect ratios
 * @property {Number} FIXED_WIDTH
 * @readonly
 * @static
 */

cc.ResolutionPolicy.FIXED_WIDTH = 4;
/**
 * Unknow policy
 * @property {Number} UNKNOWN
 * @readonly
 * @static
 */

cc.ResolutionPolicy.UNKNOWN = 5;
/**
 * @module cc
 */

/**
 * !#en cc.view is the shared view object.
 * !#zh cc.view 是全局的视图对象。
 * @property view
 * @static
 * @type {View}
 */

cc.view = new View();
/**
 * !#en cc.winSize is the alias object for the size of the current game window.
 * !#zh cc.winSize 为当前的游戏窗口的大小。
 * @property winSize
 * @type Size
 */

cc.winSize = cc.size();
module.exports = cc.view;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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