
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCInputExtension.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var eventManager = require('../event-manager');

var inputManager = require("./CCInputManager");

var PORTRAIT = 0;
var LANDSCAPE_LEFT = -90;
var PORTRAIT_UPSIDE_DOWN = 180;
var LANDSCAPE_RIGHT = 90;

var _didAccelerateFun;
/**
 * !#en the device accelerometer reports values for each axis in units of g-force.
 * !#zh 设备重力传感器传递的各个轴的数据。
 * @class Acceleration
 * @method constructor
 * @param {Number} x
 * @param {Number} y
 * @param {Number} z
 * @param {Number} timestamp
 */


cc.Acceleration = function (x, y, z, timestamp) {
  this.x = x || 0;
  this.y = y || 0;
  this.z = z || 0;
  this.timestamp = timestamp || 0;
};
/**
 * whether enable accelerometer event
 * @method setAccelerometerEnabled
 * @param {Boolean} isEnable
 */


inputManager.setAccelerometerEnabled = function (isEnable) {
  var _t = this;

  if (_t._accelEnabled === isEnable) return;
  _t._accelEnabled = isEnable;
  var scheduler = cc.director.getScheduler();
  scheduler.enableForTarget(_t);

  if (_t._accelEnabled) {
    _t._registerAccelerometerEvent();

    _t._accelCurTime = 0;
    scheduler.scheduleUpdate(_t);
  } else {
    _t._unregisterAccelerometerEvent();

    _t._accelCurTime = 0;
    scheduler.unscheduleUpdate(_t);
  }

  if (CC_JSB || CC_RUNTIME) {
    jsb.device.setMotionEnabled(isEnable);
  }
};
/**
 * set accelerometer interval value
 * @method setAccelerometerInterval
 * @param {Number} interval
 */


inputManager.setAccelerometerInterval = function (interval) {
  if (this._accelInterval !== interval) {
    this._accelInterval = interval;

    if (CC_JSB || CC_RUNTIME) {
      jsb.device.setMotionInterval(interval);
    }
  }
};

inputManager._registerKeyboardEvent = function () {
  cc.game.canvas.addEventListener("keydown", function (e) {
    eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, true));
    e.stopPropagation();
    e.preventDefault();
  }, false);
  cc.game.canvas.addEventListener("keyup", function (e) {
    eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, false));
    e.stopPropagation();
    e.preventDefault();
  }, false);
};

inputManager._registerAccelerometerEvent = function () {
  var w = window,
      _t = this;

  _t._acceleration = new cc.Acceleration();
  _t._accelDeviceEvent = w.DeviceMotionEvent || w.DeviceOrientationEvent; //TODO fix DeviceMotionEvent bug on QQ Browser version 4.1 and below.

  if (cc.sys.browserType === cc.sys.BROWSER_TYPE_MOBILE_QQ) _t._accelDeviceEvent = window.DeviceOrientationEvent;

  var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";

  var ua = navigator.userAgent;

  if (/Android/.test(ua) || /Adr/.test(ua) && cc.sys.browserType === cc.BROWSER_TYPE_UC) {
    _t._minus = -1;
  }

  _didAccelerateFun = _t.didAccelerate.bind(_t);
  w.addEventListener(_deviceEventType, _didAccelerateFun, false);
};

inputManager._unregisterAccelerometerEvent = function () {
  var w = window,
      _t = this;

  var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";

  if (_didAccelerateFun) {
    w.removeEventListener(_deviceEventType, _didAccelerateFun, false);
  }
};

inputManager.didAccelerate = function (eventData) {
  var _t = this,
      w = window;

  if (!_t._accelEnabled) return;
  var mAcceleration = _t._acceleration;
  var x, y, z;

  if (_t._accelDeviceEvent === window.DeviceMotionEvent) {
    var eventAcceleration = eventData["accelerationIncludingGravity"];
    x = _t._accelMinus * eventAcceleration.x * 0.1;
    y = _t._accelMinus * eventAcceleration.y * 0.1;
    z = eventAcceleration.z * 0.1;
  } else {
    x = eventData["gamma"] / 90 * 0.981;
    y = -(eventData["beta"] / 90) * 0.981;
    z = eventData["alpha"] / 90 * 0.981;
  }

  if (cc.view._isRotated) {
    var tmp = x;
    x = -y;
    y = tmp;
  }

  mAcceleration.x = x;
  mAcceleration.y = y;
  mAcceleration.z = z;
  mAcceleration.timestamp = eventData.timeStamp || Date.now();
  var tmpX = mAcceleration.x;

  if (w.orientation === LANDSCAPE_RIGHT) {
    mAcceleration.x = -mAcceleration.y;
    mAcceleration.y = tmpX;
  } else if (w.orientation === LANDSCAPE_LEFT) {
    mAcceleration.x = mAcceleration.y;
    mAcceleration.y = -tmpX;
  } else if (w.orientation === PORTRAIT_UPSIDE_DOWN) {
    mAcceleration.x = -mAcceleration.x;
    mAcceleration.y = -mAcceleration.y;
  } // fix android acc values are opposite


  if (cc.sys.os === cc.sys.OS_ANDROID && cc.sys.browserType !== cc.sys.BROWSER_TYPE_MOBILE_QQ) {
    mAcceleration.x = -mAcceleration.x;
    mAcceleration.y = -mAcceleration.y;
  }
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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