
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/platform/CCClassDecorator.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// const FIX_BABEL6 = true;

/**
 * !#en Some JavaScript decorators which can be accessed with "cc._decorator".
 * !#zh 一些 JavaScript 装饰器，目前可以通过 "cc._decorator" 来访问。
 * （这些 API 仍不完全稳定，有可能随着 JavaScript 装饰器的标准实现而调整）
 *
 * @submodule _decorator
 * @module _decorator
 * @main
 */
// inspired by toddlxt (https://github.com/toddlxt/Creator-TypeScript-Boilerplate)
require('./CCClass');

var Preprocess = require('./preprocess-class');

var js = require('./js');

var isPlainEmptyObj_DEV = CC_DEV && require('./utils').isPlainEmptyObj_DEV; // caches for class construction


var CACHE_KEY = '__ccclassCache__';

function fNOP(ctor) {
  return ctor;
}

function getSubDict(obj, key) {
  return obj[key] || (obj[key] = {});
}

function checkCtorArgument(decorate) {
  return function (target) {
    if (typeof target === 'function') {
      // no parameter, target is ctor
      return decorate(target);
    }

    return function (ctor) {
      return decorate(ctor, target);
    };
  };
}

function _checkNormalArgument(validator_DEV, decorate, decoratorName) {
  return function (target) {
    if (CC_DEV && validator_DEV(target, decoratorName) === false) {
      return function () {
        return fNOP;
      };
    }

    return function (ctor) {
      return decorate(ctor, target);
    };
  };
}

var checkCompArgument = _checkNormalArgument.bind(null, CC_DEV && function (arg, decoratorName) {
  if (!cc.Class._isCCClass(arg)) {
    cc.error('The parameter for %s is missing.', decoratorName);
    return false;
  }
});

function _argumentChecker(type) {
  return _checkNormalArgument.bind(null, CC_DEV && function (arg, decoratorName) {
    if (arg instanceof cc.Component || arg === undefined) {
      cc.error('The parameter for %s is missing.', decoratorName);
      return false;
    } else if (typeof arg !== type) {
      cc.error('The parameter for %s must be type %s.', decoratorName, type);
      return false;
    }
  });
}

var checkStringArgument = _argumentChecker('string');

var checkNumberArgument = _argumentChecker('number'); // var checkBooleanArgument = _argumentChecker('boolean');


function getClassCache(ctor, decoratorName) {
  if (CC_DEV && cc.Class._isCCClass(ctor)) {
    cc.error('`@%s` should be used after @ccclass for class "%s"', decoratorName, js.getClassName(ctor));
    return null;
  }

  return getSubDict(ctor, CACHE_KEY);
}

function getDefaultFromInitializer(initializer) {
  var value;

  try {
    value = initializer();
  } catch (e) {
    // just lazy initialize by CCClass
    return initializer;
  }

  if (typeof value !== 'object' || value === null) {
    // string boolean number function undefined null
    return value;
  } else {
    // The default attribute will not be used in ES6 constructor actually,
    // so we dont need to simplify into `{}` or `[]` or vec2 completely.
    return initializer;
  }
}

function extractActualDefaultValues(ctor) {
  var dummyObj;

  try {
    dummyObj = new ctor();
  } catch (e) {
    if (CC_DEV) {
      cc.errorID(3652, js.getClassName(ctor), e);
    }

    return {};
  }

  return dummyObj;
}

function genProperty(ctor, properties, propName, options, desc, cache) {
  var fullOptions;
  var isGetset = desc && (desc.get || desc.set);

  if (options) {
    fullOptions = CC_DEV ? Preprocess.getFullFormOfProperty(options, isGetset, propName, js.getClassName(ctor)) : Preprocess.getFullFormOfProperty(options, isGetset);
  }

  var existsProperty = properties[propName];
  var prop = js.mixin(existsProperty || {}, fullOptions || options || {});

  if (isGetset) {
    // typescript or babel
    if (CC_DEV && options && ((fullOptions || options).get || (fullOptions || options).set)) {
      var errorProps = getSubDict(cache, 'errorProps');

      if (!errorProps[propName]) {
        errorProps[propName] = true;
        cc.warnID(3655, propName, js.getClassName(ctor), propName, propName);
      }
    }

    if (desc.get) {
      prop.get = desc.get;
    }

    if (desc.set) {
      prop.set = desc.set;
    }
  } else {
    if (CC_DEV && (prop.get || prop.set)) {
      // @property({
      //     get () { ... },
      //     set (...) { ... },
      // })
      // value;
      cc.errorID(3655, propName, js.getClassName(ctor), propName, propName);
      return;
    } // member variables


    var defaultValue = undefined;
    var isDefaultValueSpecified = false;

    if (desc) {
      // babel
      if (desc.initializer) {
        // @property(...)
        // value = null;
        defaultValue = getDefaultFromInitializer(desc.initializer);
        isDefaultValueSpecified = true;
      } else {// @property(...)
        // value;
      }
    } else {
      // typescript
      var actualDefaultValues = cache["default"] || (cache["default"] = extractActualDefaultValues(ctor));

      if (actualDefaultValues.hasOwnProperty(propName)) {
        // @property(...)
        // value = null;
        defaultValue = actualDefaultValues[propName];
        isDefaultValueSpecified = true;
      } else {// @property(...)
        // value;
      }
    }

    if (CC_EDITOR && !Editor.isBuilder || CC_TEST) {
      if (!fullOptions && options && options.hasOwnProperty('default')) {
        cc.warnID(3653, propName, js.getClassName(ctor)); // prop.default = options.default;
      } else if (!isDefaultValueSpecified) {
        cc.warnID(3654, js.getClassName(ctor), propName); // prop.default = fullOptions.hasOwnProperty('default') ? fullOptions.default : undefined;
      }

      if (cc.RawAsset.wasRawAssetType(prop.url) && prop._short && isDefaultValueSpecified && defaultValue == null) {
        // Avoid excessive warning when the ts decorator format is wrong
        if (typeof options !== 'function' || cc.RawAsset.isRawAssetType(options)) {
          cc.errorID(3656, js.getClassName(ctor), propName);
        }
      }
    }

    prop["default"] = defaultValue;
  }

  properties[propName] = prop;
}
/**
 * !#en
 * Declare the standard [ES6 Class](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes)
 * as CCClass, please see [Class](../../../manual/en/scripting/class.html) for details.
 * !#zh
 * 将标准写法的 [ES6 Class](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes) 声明为 CCClass，具体用法请参阅[类型定义](../../../manual/zh/scripting/class.html)。
 *
 * @method ccclass
 * @param {String} [name] - The class name used for serialization.
 * @example
 * const {ccclass} = cc._decorator;
 *
 * // define a CCClass, omit the name
 * &#64;ccclass
 * class NewScript extends cc.Component {
 *     // ...
 * }
 *
 * // define a CCClass with a name
 * &#64;ccclass('LoginData')
 * class LoginData {
 *     // ...
 * }
 * @typescript
 * ccclass(name?: string): Function
 * ccclass(_class?: Function): void
 */


var ccclass = checkCtorArgument(function (ctor, name) {
  // if (FIX_BABEL6) {
  //     eval('if(typeof _classCallCheck==="function"){_classCallCheck=function(){};}');
  // }
  var base = js.getSuper(ctor);

  if (base === Object) {
    base = null;
  }

  var proto = {
    name: name,
    "extends": base,
    ctor: ctor,
    __ES6__: true
  };
  var cache = ctor[CACHE_KEY];

  if (cache) {
    var decoratedProto = cache.proto;

    if (decoratedProto) {
      // decoratedProto.properties = createProperties(ctor, decoratedProto.properties);
      js.mixin(proto, decoratedProto);
    }

    ctor[CACHE_KEY] = undefined;
  }

  var res = cc.Class(proto); // validate methods

  if (CC_DEV) {
    var propNames = Object.getOwnPropertyNames(ctor.prototype);

    for (var i = 0; i < propNames.length; ++i) {
      var prop = propNames[i];

      if (prop !== 'constructor') {
        var desc = Object.getOwnPropertyDescriptor(ctor.prototype, prop);
        var func = desc && desc.value;

        if (typeof func === 'function') {
          Preprocess.doValidateMethodWithProps_DEV(func, prop, js.getClassName(ctor), ctor, base);
        }
      }
    }
  }

  return res;
});
/**
 * !#en
 * Declare property for [CCClass](../../../manual/en/scripting/reference/attributes.html).
 * !#zh
 * 定义 [CCClass](../../../manual/zh/scripting/reference/attributes.html) 所用的属性。
 *
 * @method property
 * @param {Object} [options] - an object with some property attributes
 * @param {Any} [options.type]
 * @param {Boolean|Function} [options.visible]
 * @param {String} [options.displayName]
 * @param {String} [options.tooltip]
 * @param {Boolean} [options.multiline]
 * @param {Boolean} [options.readonly]
 * @param {Number} [options.min]
 * @param {Number} [options.max]
 * @param {Number} [options.step]
 * @param {Number[]} [options.range]
 * @param {Boolean} [options.slide]
 * @param {Boolean} [options.serializable]
 * @param {Boolean} [options.editorOnly]
 * @param {Boolean} [options.override]
 * @param {Boolean} [options.animatable]
 * @param {String} [options.formerlySerializedAs]
 * @example
 * const {ccclass, property} = cc._decorator;
 *
 * &#64;ccclass
 * class NewScript extends cc.Component {
 *     &#64;property({
 *         type: cc.Node
 *     })
 *     targetNode1 = null;
 *
 *     &#64;property(cc.Node)
 *     targetNode2 = null;
 *
 *     &#64;property(cc.Button)
 *     targetButton = null;
 *
 *     &#64;property
 *     _width = 100;
 *
 *     &#64;property
 *     get width () {
 *         return this._width;
 *     }
 *
 *     &#64;property
 *     set width (value) {
 *         this._width = value;
 *     }
 *
 *     &#64;property
 *     offset = new cc.Vec2(100, 100);
 *
 *     &#64;property(cc.Vec2)
 *     offsets = [];
 *
 *     &#64;property(cc.SpriteFrame)
 *     frame = null;
 * }
 *
 * // above is equivalent to (上面的代码相当于):
 *
 * var NewScript = cc.Class({
 *     properties: {
 *         targetNode1: {
 *             default: null,
 *             type: cc.Node
 *         },
 *
 *         targetNode2: {
 *             default: null,
 *             type: cc.Node
 *         },
 *
 *         targetButton: {
 *             default: null,
 *             type: cc.Button
 *         },
 *
 *         _width: 100,
 *
 *         width: {
 *             get () {
 *                 return this._width;
 *             },
 *             set (value) {
 *                 this._width = value;
 *             }
 *         },
 *
 *         offset: new cc.Vec2(100, 100)
 *
 *         offsets: {
 *             default: [],
 *             type: cc.Vec2
 *         }
 *
 *         frame: {
 *             default: null,
 *             type: cc.SpriteFrame
 *         },
 *     }
 * });
 * @typescript
 * property(options?: {type?: any; visible?: boolean|(() => boolean); displayName?: string; tooltip?: string; multiline?: boolean; readonly?: boolean; min?: number; max?: number; step?: number; range?: number[]; slide?: boolean; serializable?: boolean; formerlySerializedAs?: string; editorOnly?: boolean; override?: boolean; animatable?: boolean} | any[]|Function|cc.ValueType|number|string|boolean): Function
 * property(_target: Object, _key: any, _desc?: any): void
 */

function property(ctorProtoOrOptions, propName, desc) {
  var options = null;

  function normalized(ctorProto, propName, desc) {
    var cache = getClassCache(ctorProto.constructor);

    if (cache) {
      var ccclassProto = getSubDict(cache, 'proto');
      var properties = getSubDict(ccclassProto, 'properties');
      genProperty(ctorProto.constructor, properties, propName, options, desc, cache);
    }
  }

  if (typeof propName === 'undefined') {
    options = ctorProtoOrOptions;
    return normalized;
  } else {
    normalized(ctorProtoOrOptions, propName, desc);
  }
} // Editor Decorators


function createEditorDecorator(argCheckFunc, editorPropName, staticValue) {
  return argCheckFunc(function (ctor, decoratedValue) {
    var cache = getClassCache(ctor, editorPropName);

    if (cache) {
      var value = staticValue !== undefined ? staticValue : decoratedValue;
      var proto = getSubDict(cache, 'proto');
      getSubDict(proto, 'editor')[editorPropName] = value;
    }
  }, editorPropName);
}

function createDummyDecorator(argCheckFunc) {
  return argCheckFunc(fNOP);
}
/**
 * !#en
 * Makes a CCClass that inherit from component execute in edit mode.<br>
 * By default, all components are only executed in play mode,
 * which means they will not have their callback functions executed while the Editor is in edit mode.
 * !#zh
 * 允许继承自 Component 的 CCClass 在编辑器里执行。<br>
 * 默认情况下，所有 Component 都只会在运行时才会执行，也就是说它们的生命周期回调不会在编辑器里触发。
 *
 * @method executeInEditMode
 * @example
 * const {ccclass, executeInEditMode} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;executeInEditMode
 * class NewScript extends cc.Component {
 *     // ...
 * }
 * @typescript
 * executeInEditMode(): Function
 * executeInEditMode(_class: Function): void
 */


var executeInEditMode = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkCtorArgument, 'executeInEditMode', true);
/**
 * !#en
 * Automatically add required component as a dependency for the CCClass that inherit from component.
 * !#zh
 * 为声明为 CCClass 的组件添加依赖的其它组件。当组件添加到节点上时，如果依赖的组件不存在，引擎将会自动将依赖组件添加到同一个节点，防止脚本出错。该设置在运行时同样有效。
 *
 * @method requireComponent
 * @param {Component} requiredComponent
 * @example
 * const {ccclass, requireComponent} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;requireComponent(cc.Sprite)
 * class SpriteCtrl extends cc.Component {
 *     // ...
 * }
 * @typescript
 * requireComponent(requiredComponent: typeof cc.Component): Function
 */

var requireComponent = createEditorDecorator(checkCompArgument, 'requireComponent');
/**
 * !#en
 * The menu path to register a component to the editors "Component" menu. Eg. "Rendering/CameraCtrl".
 * !#zh
 * 将当前组件添加到组件菜单中，方便用户查找。例如 "Rendering/CameraCtrl"。
 *
 * @method menu
 * @param {String} path - The path is the menu represented like a pathname.
 *                        For example the menu could be "Rendering/CameraCtrl".
 * @example
 * const {ccclass, menu} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;menu("Rendering/CameraCtrl")
 * class NewScript extends cc.Component {
 *     // ...
 * }
 * @typescript
 * menu(path: string): Function
 */

var menu = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkStringArgument, 'menu');
/**
 * !#en
 * The execution order of lifecycle methods for Component.
 * Those less than 0 will execute before while those greater than 0 will execute after.
 * The order will only affect onLoad, onEnable, start, update and lateUpdate while onDisable and onDestroy will not be affected.
 * !#zh
 * 设置脚本生命周期方法调用的优先级。优先级小于 0 的组件将会优先执行，优先级大于 0 的组件将会延后执行。优先级仅会影响 onLoad, onEnable, start, update 和 lateUpdate，而 onDisable 和 onDestroy 不受影响。
 *
 * @method executionOrder
 * @param {Number} order - The execution order of lifecycle methods for Component. Those less than 0 will execute before while those greater than 0 will execute after.
 * @example
 * const {ccclass, executionOrder} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;executionOrder(1)
 * class CameraCtrl extends cc.Component {
 *     // ...
 * }
 * @typescript
 * executionOrder(order: number): Function
 */

var executionOrder = createEditorDecorator(checkNumberArgument, 'executionOrder');
/**
 * !#en
 * Prevents Component of the same type (or subtype) to be added more than once to a Node.
 * !#zh
 * 防止多个相同类型（或子类型）的组件被添加到同一个节点。
 *
 * @method disallowMultiple
 * @example
 * const {ccclass, disallowMultiple} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;disallowMultiple
 * class CameraCtrl extends cc.Component {
 *     // ...
 * }
 * @typescript
 * disallowMultiple(): Function
 * disallowMultiple(_class: Function): void
 */

var disallowMultiple = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkCtorArgument, 'disallowMultiple');
/**
 * !#en
 * If specified, the editor's scene view will keep updating this node in 60 fps when it is selected, otherwise, it will update only if necessary.<br>
 * This property is only available if executeInEditMode is true.
 * !#zh
 * 当指定了 "executeInEditMode" 以后，playOnFocus 可以在选中当前组件所在的节点时，提高编辑器的场景刷新频率到 60 FPS，否则场景就只会在必要的时候进行重绘。
 *
 * @method playOnFocus
 * @example
 * const {ccclass, playOnFocus, executeInEditMode} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;executeInEditMode
 * &#64;playOnFocus
 * class CameraCtrl extends cc.Component {
 *     // ...
 * }
 * @typescript
 * playOnFocus(): Function
 * playOnFocus(_class: Function): void
 */

var playOnFocus = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkCtorArgument, 'playOnFocus', true);
/**
 * !#en
 * Specifying the url of the custom html to draw the component in **Properties**.
 * !#zh
 * 自定义当前组件在 **属性检查器** 中渲染时所用的网页 url。
 *
 * @method inspector
 * @param {String} url
 * @example
 * const {ccclass, inspector} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;inspector("packages://inspector/inspectors/comps/camera-ctrl.js")
 * class NewScript extends cc.Component {
 *     // ...
 * }
 * @typescript
 * inspector(path: string): Function
 */

var inspector = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkStringArgument, 'inspector');
/**
 * !#en
 * Specifying the url of the icon to display in the editor.
 * !#zh
 * 自定义当前组件在编辑器中显示的图标 url。
 *
 * @method icon
 * @param {String} url
 * @private
 * @example
 * const {ccclass, icon} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;icon("xxxx.png")
 * class NewScript extends cc.Component {
 *     // ...
 * }
 * @typescript
 * icon(path: string): Function
 */

var icon = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkStringArgument, 'icon');
/**
 * !#en
 * The custom documentation URL.
 * !#zh
 * 指定当前组件的帮助文档的 url，设置过后，在 **属性检查器** 中就会出现一个帮助图标，用户点击将打开指定的网页。
 *
 * @method help
 * @param {String} url
 * @example
 * const {ccclass, help} = cc._decorator;
 *
 * &#64;ccclass
 * &#64;help("app://docs/html/components/spine.html")
 * class NewScript extends cc.Component {
 *     // ...
 * }
 * @typescript
 * help(path: string): Function
 */

var help = (CC_DEV ? createEditorDecorator : createDummyDecorator)(checkStringArgument, 'help'); // Other Decorators

/**
 * NOTE:<br>
 * The old mixins implemented in cc.Class(ES5) behaves exact the same as multiple inheritance.
 * But since ES6, class constructor can't be function-called and class methods become non-enumerable,
 * so we can not mix in ES6 Classes.<br>
 * See:<br>
 * [https://esdiscuss.org/topic/traits-are-now-impossible-in-es6-until-es7-since-rev32](https://esdiscuss.org/topic/traits-are-now-impossible-in-es6-until-es7-since-rev32)<br>
 * One possible solution (but IDE unfriendly):<br>
 * [http://justinfagnani.com/2015/12/21/real-mixins-with-javascript-classes](http://justinfagnani.com/2015/12/21/real-mixins-with-javascript-classes/)<br>
 * <br>
 * NOTE:<br>
 * You must manually call mixins constructor, this is different from cc.Class(ES5).
 *
 * @method mixins
 * @param {Function} ...ctor - constructors to mix, only support ES5 constructors or classes defined by using `cc.Class`,
 *                             not support ES6 Classes.
 * @example
 * const {ccclass, mixins} = cc._decorator;
 *
 * class Animal { ... }
 *
 * const Fly = cc.Class({
 *     constructor () { ... }
 * });
 *
 * &#64;ccclass
 * &#64;mixins(cc.EventTarget, Fly)
 * class Bird extends Animal {
 *     constructor () {
 *         super();
 *
 *         // You must manually call mixins constructor, this is different from cc.Class(ES5)
 *         cc.EventTarget.call(this);
 *         Fly.call(this);
 *     }
 *     // ...
 * }
 * @typescript
 * mixins(ctor: Function, ...rest: Function[]): Function
 */

function mixins() {
  var mixins = [];

  for (var i = 0; i < arguments.length; i++) {
    mixins[i] = arguments[i];
  }

  return function (ctor) {
    var cache = getClassCache(ctor, 'mixins');

    if (cache) {
      getSubDict(cache, 'proto').mixins = mixins;
    }
  };
}

cc._decorator = module.exports = {
  ccclass: ccclass,
  property: property,
  executeInEditMode: executeInEditMode,
  requireComponent: requireComponent,
  menu: menu,
  executionOrder: executionOrder,
  disallowMultiple: disallowMultiple,
  playOnFocus: playOnFocus,
  inspector: inspector,
  icon: icon,
  help: help,
  mixins: mixins
}; // fix submodule pollute ...

/**
 * @submodule cc
 */
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL3BsYXRmb3JtL0NDQ2xhc3NEZWNvcmF0b3IuanMiXSwibmFtZXMiOlsicmVxdWlyZSIsIlByZXByb2Nlc3MiLCJqcyIsImlzUGxhaW5FbXB0eU9ial9ERVYiLCJDQ19ERVYiLCJDQUNIRV9LRVkiLCJmTk9QIiwiY3RvciIsImdldFN1YkRpY3QiLCJvYmoiLCJrZXkiLCJjaGVja0N0b3JBcmd1bWVudCIsImRlY29yYXRlIiwidGFyZ2V0IiwiX2NoZWNrTm9ybWFsQXJndW1lbnQiLCJ2YWxpZGF0b3JfREVWIiwiZGVjb3JhdG9yTmFtZSIsImNoZWNrQ29tcEFyZ3VtZW50IiwiYmluZCIsImFyZyIsImNjIiwiQ2xhc3MiLCJfaXNDQ0NsYXNzIiwiZXJyb3IiLCJfYXJndW1lbnRDaGVja2VyIiwidHlwZSIsIkNvbXBvbmVudCIsInVuZGVmaW5lZCIsImNoZWNrU3RyaW5nQXJndW1lbnQiLCJjaGVja051bWJlckFyZ3VtZW50IiwiZ2V0Q2xhc3NDYWNoZSIsImdldENsYXNzTmFtZSIsImdldERlZmF1bHRGcm9tSW5pdGlhbGl6ZXIiLCJpbml0aWFsaXplciIsInZhbHVlIiwiZSIsImV4dHJhY3RBY3R1YWxEZWZhdWx0VmFsdWVzIiwiZHVtbXlPYmoiLCJlcnJvcklEIiwiZ2VuUHJvcGVydHkiLCJwcm9wZXJ0aWVzIiwicHJvcE5hbWUiLCJvcHRpb25zIiwiZGVzYyIsImNhY2hlIiwiZnVsbE9wdGlvbnMiLCJpc0dldHNldCIsImdldCIsInNldCIsImdldEZ1bGxGb3JtT2ZQcm9wZXJ0eSIsImV4aXN0c1Byb3BlcnR5IiwicHJvcCIsIm1peGluIiwiZXJyb3JQcm9wcyIsIndhcm5JRCIsImRlZmF1bHRWYWx1ZSIsImlzRGVmYXVsdFZhbHVlU3BlY2lmaWVkIiwiYWN0dWFsRGVmYXVsdFZhbHVlcyIsImhhc093blByb3BlcnR5IiwiQ0NfRURJVE9SIiwiRWRpdG9yIiwiaXNCdWlsZGVyIiwiQ0NfVEVTVCIsIlJhd0Fzc2V0Iiwid2FzUmF3QXNzZXRUeXBlIiwidXJsIiwiX3Nob3J0IiwiaXNSYXdBc3NldFR5cGUiLCJjY2NsYXNzIiwibmFtZSIsImJhc2UiLCJnZXRTdXBlciIsIk9iamVjdCIsInByb3RvIiwiX19FUzZfXyIsImRlY29yYXRlZFByb3RvIiwicmVzIiwicHJvcE5hbWVzIiwiZ2V0T3duUHJvcGVydHlOYW1lcyIsInByb3RvdHlwZSIsImkiLCJsZW5ndGgiLCJnZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IiLCJmdW5jIiwiZG9WYWxpZGF0ZU1ldGhvZFdpdGhQcm9wc19ERVYiLCJwcm9wZXJ0eSIsImN0b3JQcm90b09yT3B0aW9ucyIsIm5vcm1hbGl6ZWQiLCJjdG9yUHJvdG8iLCJjb25zdHJ1Y3RvciIsImNjY2xhc3NQcm90byIsImNyZWF0ZUVkaXRvckRlY29yYXRvciIsImFyZ0NoZWNrRnVuYyIsImVkaXRvclByb3BOYW1lIiwic3RhdGljVmFsdWUiLCJkZWNvcmF0ZWRWYWx1ZSIsImNyZWF0ZUR1bW15RGVjb3JhdG9yIiwiZXhlY3V0ZUluRWRpdE1vZGUiLCJyZXF1aXJlQ29tcG9uZW50IiwibWVudSIsImV4ZWN1dGlvbk9yZGVyIiwiZGlzYWxsb3dNdWx0aXBsZSIsInBsYXlPbkZvY3VzIiwiaW5zcGVjdG9yIiwiaWNvbiIsImhlbHAiLCJtaXhpbnMiLCJhcmd1bWVudHMiLCJfZGVjb3JhdG9yIiwibW9kdWxlIiwiZXhwb3J0cyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBMEJBOztBQUVBOzs7Ozs7Ozs7QUFVQTtBQUVBQSxPQUFPLENBQUMsV0FBRCxDQUFQOztBQUNBLElBQU1DLFVBQVUsR0FBR0QsT0FBTyxDQUFDLG9CQUFELENBQTFCOztBQUNBLElBQU1FLEVBQUUsR0FBR0YsT0FBTyxDQUFDLE1BQUQsQ0FBbEI7O0FBQ0EsSUFBTUcsbUJBQW1CLEdBQUdDLE1BQU0sSUFBSUosT0FBTyxDQUFDLFNBQUQsQ0FBUCxDQUFtQkcsbUJBQXpELEVBRUE7OztBQUNBLElBQU1FLFNBQVMsR0FBRyxrQkFBbEI7O0FBRUEsU0FBU0MsSUFBVCxDQUFlQyxJQUFmLEVBQXFCO0FBQ2pCLFNBQU9BLElBQVA7QUFDSDs7QUFFRCxTQUFTQyxVQUFULENBQXFCQyxHQUFyQixFQUEwQkMsR0FBMUIsRUFBK0I7QUFDM0IsU0FBT0QsR0FBRyxDQUFDQyxHQUFELENBQUgsS0FBYUQsR0FBRyxDQUFDQyxHQUFELENBQUgsR0FBVyxFQUF4QixDQUFQO0FBQ0g7O0FBRUQsU0FBU0MsaUJBQVQsQ0FBNEJDLFFBQTVCLEVBQXNDO0FBQ2xDLFNBQU8sVUFBVUMsTUFBVixFQUFrQjtBQUNyQixRQUFJLE9BQU9BLE1BQVAsS0FBa0IsVUFBdEIsRUFBa0M7QUFDOUI7QUFDQSxhQUFPRCxRQUFRLENBQUNDLE1BQUQsQ0FBZjtBQUNIOztBQUNELFdBQU8sVUFBVU4sSUFBVixFQUFnQjtBQUNuQixhQUFPSyxRQUFRLENBQUNMLElBQUQsRUFBT00sTUFBUCxDQUFmO0FBQ0gsS0FGRDtBQUdILEdBUkQ7QUFTSDs7QUFFRCxTQUFTQyxvQkFBVCxDQUErQkMsYUFBL0IsRUFBOENILFFBQTlDLEVBQXdESSxhQUF4RCxFQUF1RTtBQUNuRSxTQUFPLFVBQVVILE1BQVYsRUFBa0I7QUFDckIsUUFBSVQsTUFBTSxJQUFJVyxhQUFhLENBQUNGLE1BQUQsRUFBU0csYUFBVCxDQUFiLEtBQXlDLEtBQXZELEVBQThEO0FBQzFELGFBQU8sWUFBWTtBQUNmLGVBQU9WLElBQVA7QUFDSCxPQUZEO0FBR0g7O0FBQ0QsV0FBTyxVQUFVQyxJQUFWLEVBQWdCO0FBQ25CLGFBQU9LLFFBQVEsQ0FBQ0wsSUFBRCxFQUFPTSxNQUFQLENBQWY7QUFDSCxLQUZEO0FBR0gsR0FURDtBQVVIOztBQUVELElBQUlJLGlCQUFpQixHQUFHSCxvQkFBb0IsQ0FBQ0ksSUFBckIsQ0FBMEIsSUFBMUIsRUFBZ0NkLE1BQU0sSUFBSSxVQUFVZSxHQUFWLEVBQWVILGFBQWYsRUFBOEI7QUFDNUYsTUFBSSxDQUFDSSxFQUFFLENBQUNDLEtBQUgsQ0FBU0MsVUFBVCxDQUFvQkgsR0FBcEIsQ0FBTCxFQUErQjtBQUMzQkMsSUFBQUEsRUFBRSxDQUFDRyxLQUFILENBQVMsa0NBQVQsRUFBNkNQLGFBQTdDO0FBQ0EsV0FBTyxLQUFQO0FBQ0g7QUFDSixDQUx1QixDQUF4Qjs7QUFPQSxTQUFTUSxnQkFBVCxDQUEyQkMsSUFBM0IsRUFBaUM7QUFDN0IsU0FBT1gsb0JBQW9CLENBQUNJLElBQXJCLENBQTBCLElBQTFCLEVBQWdDZCxNQUFNLElBQUksVUFBVWUsR0FBVixFQUFlSCxhQUFmLEVBQThCO0FBQzNFLFFBQUlHLEdBQUcsWUFBWUMsRUFBRSxDQUFDTSxTQUFsQixJQUErQlAsR0FBRyxLQUFLUSxTQUEzQyxFQUFzRDtBQUNsRFAsTUFBQUEsRUFBRSxDQUFDRyxLQUFILENBQVMsa0NBQVQsRUFBNkNQLGFBQTdDO0FBQ0EsYUFBTyxLQUFQO0FBQ0gsS0FIRCxNQUlLLElBQUksT0FBT0csR0FBUCxLQUFlTSxJQUFuQixFQUF5QjtBQUMxQkwsTUFBQUEsRUFBRSxDQUFDRyxLQUFILENBQVMsdUNBQVQsRUFBa0RQLGFBQWxELEVBQWlFUyxJQUFqRTtBQUNBLGFBQU8sS0FBUDtBQUNIO0FBQ0osR0FUTSxDQUFQO0FBVUg7O0FBQ0QsSUFBSUcsbUJBQW1CLEdBQUdKLGdCQUFnQixDQUFDLFFBQUQsQ0FBMUM7O0FBQ0EsSUFBSUssbUJBQW1CLEdBQUdMLGdCQUFnQixDQUFDLFFBQUQsQ0FBMUMsRUFDQTs7O0FBR0EsU0FBU00sYUFBVCxDQUF3QnZCLElBQXhCLEVBQThCUyxhQUE5QixFQUE2QztBQUN6QyxNQUFJWixNQUFNLElBQUlnQixFQUFFLENBQUNDLEtBQUgsQ0FBU0MsVUFBVCxDQUFvQmYsSUFBcEIsQ0FBZCxFQUF5QztBQUNyQ2EsSUFBQUEsRUFBRSxDQUFDRyxLQUFILENBQVMsb0RBQVQsRUFBK0RQLGFBQS9ELEVBQThFZCxFQUFFLENBQUM2QixZQUFILENBQWdCeEIsSUFBaEIsQ0FBOUU7QUFDQSxXQUFPLElBQVA7QUFDSDs7QUFDRCxTQUFPQyxVQUFVLENBQUNELElBQUQsRUFBT0YsU0FBUCxDQUFqQjtBQUNIOztBQUVELFNBQVMyQix5QkFBVCxDQUFvQ0MsV0FBcEMsRUFBaUQ7QUFDN0MsTUFBSUMsS0FBSjs7QUFDQSxNQUFJO0FBQ0FBLElBQUFBLEtBQUssR0FBR0QsV0FBVyxFQUFuQjtBQUNILEdBRkQsQ0FHQSxPQUFPRSxDQUFQLEVBQVU7QUFDTjtBQUNBLFdBQU9GLFdBQVA7QUFDSDs7QUFDRCxNQUFJLE9BQU9DLEtBQVAsS0FBaUIsUUFBakIsSUFBNkJBLEtBQUssS0FBSyxJQUEzQyxFQUFpRDtBQUM3QztBQUNBLFdBQU9BLEtBQVA7QUFDSCxHQUhELE1BSUs7QUFDRDtBQUNBO0FBQ0EsV0FBT0QsV0FBUDtBQUNIO0FBQ0o7O0FBR0QsU0FBU0csMEJBQVQsQ0FBcUM3QixJQUFyQyxFQUEyQztBQUN2QyxNQUFJOEIsUUFBSjs7QUFDQSxNQUFJO0FBQ0FBLElBQUFBLFFBQVEsR0FBRyxJQUFJOUIsSUFBSixFQUFYO0FBQ0gsR0FGRCxDQUdBLE9BQU80QixDQUFQLEVBQVU7QUFDTixRQUFJL0IsTUFBSixFQUFZO0FBQ1JnQixNQUFBQSxFQUFFLENBQUNrQixPQUFILENBQVcsSUFBWCxFQUFpQnBDLEVBQUUsQ0FBQzZCLFlBQUgsQ0FBZ0J4QixJQUFoQixDQUFqQixFQUF3QzRCLENBQXhDO0FBQ0g7O0FBQ0QsV0FBTyxFQUFQO0FBQ0g7O0FBQ0QsU0FBT0UsUUFBUDtBQUNIOztBQUVELFNBQVNFLFdBQVQsQ0FBc0JoQyxJQUF0QixFQUE0QmlDLFVBQTVCLEVBQXdDQyxRQUF4QyxFQUFrREMsT0FBbEQsRUFBMkRDLElBQTNELEVBQWlFQyxLQUFqRSxFQUF3RTtBQUNwRSxNQUFJQyxXQUFKO0FBQ0EsTUFBSUMsUUFBUSxHQUFHSCxJQUFJLEtBQUtBLElBQUksQ0FBQ0ksR0FBTCxJQUFZSixJQUFJLENBQUNLLEdBQXRCLENBQW5COztBQUNBLE1BQUlOLE9BQUosRUFBYTtBQUNURyxJQUFBQSxXQUFXLEdBQUd6QyxNQUFNLEdBQUdILFVBQVUsQ0FBQ2dELHFCQUFYLENBQWlDUCxPQUFqQyxFQUEwQ0ksUUFBMUMsRUFBb0RMLFFBQXBELEVBQThEdkMsRUFBRSxDQUFDNkIsWUFBSCxDQUFnQnhCLElBQWhCLENBQTlELENBQUgsR0FDR04sVUFBVSxDQUFDZ0QscUJBQVgsQ0FBaUNQLE9BQWpDLEVBQTBDSSxRQUExQyxDQUR2QjtBQUVIOztBQUNELE1BQUlJLGNBQWMsR0FBR1YsVUFBVSxDQUFDQyxRQUFELENBQS9CO0FBQ0EsTUFBSVUsSUFBSSxHQUFHakQsRUFBRSxDQUFDa0QsS0FBSCxDQUFTRixjQUFjLElBQUksRUFBM0IsRUFBK0JMLFdBQVcsSUFBSUgsT0FBZixJQUEwQixFQUF6RCxDQUFYOztBQUVBLE1BQUlJLFFBQUosRUFBYztBQUNWO0FBQ0EsUUFBSTFDLE1BQU0sSUFBSXNDLE9BQVYsS0FBc0IsQ0FBQ0csV0FBVyxJQUFJSCxPQUFoQixFQUF5QkssR0FBekIsSUFBZ0MsQ0FBQ0YsV0FBVyxJQUFJSCxPQUFoQixFQUF5Qk0sR0FBL0UsQ0FBSixFQUF5RjtBQUNyRixVQUFJSyxVQUFVLEdBQUc3QyxVQUFVLENBQUNvQyxLQUFELEVBQVEsWUFBUixDQUEzQjs7QUFDQSxVQUFJLENBQUNTLFVBQVUsQ0FBQ1osUUFBRCxDQUFmLEVBQTJCO0FBQ3ZCWSxRQUFBQSxVQUFVLENBQUNaLFFBQUQsQ0FBVixHQUF1QixJQUF2QjtBQUNBckIsUUFBQUEsRUFBRSxDQUFDa0MsTUFBSCxDQUFVLElBQVYsRUFBZ0JiLFFBQWhCLEVBQTBCdkMsRUFBRSxDQUFDNkIsWUFBSCxDQUFnQnhCLElBQWhCLENBQTFCLEVBQWlEa0MsUUFBakQsRUFBMkRBLFFBQTNEO0FBQ0g7QUFDSjs7QUFDRCxRQUFJRSxJQUFJLENBQUNJLEdBQVQsRUFBYztBQUNWSSxNQUFBQSxJQUFJLENBQUNKLEdBQUwsR0FBV0osSUFBSSxDQUFDSSxHQUFoQjtBQUNIOztBQUNELFFBQUlKLElBQUksQ0FBQ0ssR0FBVCxFQUFjO0FBQ1ZHLE1BQUFBLElBQUksQ0FBQ0gsR0FBTCxHQUFXTCxJQUFJLENBQUNLLEdBQWhCO0FBQ0g7QUFDSixHQWZELE1BZ0JLO0FBQ0QsUUFBSTVDLE1BQU0sS0FBSytDLElBQUksQ0FBQ0osR0FBTCxJQUFZSSxJQUFJLENBQUNILEdBQXRCLENBQVYsRUFBc0M7QUFDbEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBNUIsTUFBQUEsRUFBRSxDQUFDa0IsT0FBSCxDQUFXLElBQVgsRUFBaUJHLFFBQWpCLEVBQTJCdkMsRUFBRSxDQUFDNkIsWUFBSCxDQUFnQnhCLElBQWhCLENBQTNCLEVBQWtEa0MsUUFBbEQsRUFBNERBLFFBQTVEO0FBQ0E7QUFDSCxLQVRBLENBVUQ7OztBQUNBLFFBQUljLFlBQVksR0FBRzVCLFNBQW5CO0FBQ0EsUUFBSTZCLHVCQUF1QixHQUFHLEtBQTlCOztBQUNBLFFBQUliLElBQUosRUFBVTtBQUNOO0FBQ0EsVUFBSUEsSUFBSSxDQUFDVixXQUFULEVBQXNCO0FBQ2xCO0FBQ0E7QUFDQXNCLFFBQUFBLFlBQVksR0FBR3ZCLHlCQUF5QixDQUFDVyxJQUFJLENBQUNWLFdBQU4sQ0FBeEM7QUFDQXVCLFFBQUFBLHVCQUF1QixHQUFHLElBQTFCO0FBQ0gsT0FMRCxNQU1LLENBQ0Q7QUFDQTtBQUNIO0FBQ0osS0FaRCxNQWFLO0FBQ0Q7QUFDQSxVQUFJQyxtQkFBbUIsR0FBR2IsS0FBSyxXQUFMLEtBQWtCQSxLQUFLLFdBQUwsR0FBZ0JSLDBCQUEwQixDQUFDN0IsSUFBRCxDQUE1RCxDQUExQjs7QUFDQSxVQUFJa0QsbUJBQW1CLENBQUNDLGNBQXBCLENBQW1DakIsUUFBbkMsQ0FBSixFQUFrRDtBQUM5QztBQUNBO0FBQ0FjLFFBQUFBLFlBQVksR0FBR0UsbUJBQW1CLENBQUNoQixRQUFELENBQWxDO0FBQ0FlLFFBQUFBLHVCQUF1QixHQUFHLElBQTFCO0FBQ0gsT0FMRCxNQU1LLENBQ0Q7QUFDQTtBQUNIO0FBQ0o7O0FBRUQsUUFBS0csU0FBUyxJQUFJLENBQUNDLE1BQU0sQ0FBQ0MsU0FBdEIsSUFBb0NDLE9BQXhDLEVBQWlEO0FBQzdDLFVBQUksQ0FBQ2pCLFdBQUQsSUFBZ0JILE9BQWhCLElBQTJCQSxPQUFPLENBQUNnQixjQUFSLENBQXVCLFNBQXZCLENBQS9CLEVBQWtFO0FBQzlEdEMsUUFBQUEsRUFBRSxDQUFDa0MsTUFBSCxDQUFVLElBQVYsRUFBZ0JiLFFBQWhCLEVBQTBCdkMsRUFBRSxDQUFDNkIsWUFBSCxDQUFnQnhCLElBQWhCLENBQTFCLEVBRDhELENBRTlEO0FBQ0gsT0FIRCxNQUlLLElBQUksQ0FBQ2lELHVCQUFMLEVBQThCO0FBQy9CcEMsUUFBQUEsRUFBRSxDQUFDa0MsTUFBSCxDQUFVLElBQVYsRUFBZ0JwRCxFQUFFLENBQUM2QixZQUFILENBQWdCeEIsSUFBaEIsQ0FBaEIsRUFBdUNrQyxRQUF2QyxFQUQrQixDQUUvQjtBQUNIOztBQUNELFVBQUlyQixFQUFFLENBQUMyQyxRQUFILENBQVlDLGVBQVosQ0FBNEJiLElBQUksQ0FBQ2MsR0FBakMsS0FDQWQsSUFBSSxDQUFDZSxNQURMLElBRUFWLHVCQUZBLElBR0FELFlBQVksSUFBSSxJQUhwQixFQUlFO0FBQ0U7QUFDQSxZQUFJLE9BQU9iLE9BQVAsS0FBbUIsVUFBbkIsSUFBaUN0QixFQUFFLENBQUMyQyxRQUFILENBQVlJLGNBQVosQ0FBMkJ6QixPQUEzQixDQUFyQyxFQUEwRTtBQUN0RXRCLFVBQUFBLEVBQUUsQ0FBQ2tCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCcEMsRUFBRSxDQUFDNkIsWUFBSCxDQUFnQnhCLElBQWhCLENBQWpCLEVBQXdDa0MsUUFBeEM7QUFDSDtBQUNKO0FBQ0o7O0FBQ0RVLElBQUFBLElBQUksV0FBSixHQUFlSSxZQUFmO0FBQ0g7O0FBRURmLEVBQUFBLFVBQVUsQ0FBQ0MsUUFBRCxDQUFWLEdBQXVCVSxJQUF2QjtBQUNIO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBMkJBLElBQUlpQixPQUFPLEdBQUd6RCxpQkFBaUIsQ0FBQyxVQUFVSixJQUFWLEVBQWdCOEQsSUFBaEIsRUFBc0I7QUFDbEQ7QUFDQTtBQUNBO0FBQ0EsTUFBSUMsSUFBSSxHQUFHcEUsRUFBRSxDQUFDcUUsUUFBSCxDQUFZaEUsSUFBWixDQUFYOztBQUNBLE1BQUkrRCxJQUFJLEtBQUtFLE1BQWIsRUFBcUI7QUFDakJGLElBQUFBLElBQUksR0FBRyxJQUFQO0FBQ0g7O0FBRUQsTUFBSUcsS0FBSyxHQUFHO0FBQ1JKLElBQUFBLElBQUksRUFBSkEsSUFEUTtBQUVSLGVBQVNDLElBRkQ7QUFHUi9ELElBQUFBLElBQUksRUFBSkEsSUFIUTtBQUlSbUUsSUFBQUEsT0FBTyxFQUFFO0FBSkQsR0FBWjtBQU1BLE1BQUk5QixLQUFLLEdBQUdyQyxJQUFJLENBQUNGLFNBQUQsQ0FBaEI7O0FBQ0EsTUFBSXVDLEtBQUosRUFBVztBQUNQLFFBQUkrQixjQUFjLEdBQUcvQixLQUFLLENBQUM2QixLQUEzQjs7QUFDQSxRQUFJRSxjQUFKLEVBQW9CO0FBQ2hCO0FBQ0F6RSxNQUFBQSxFQUFFLENBQUNrRCxLQUFILENBQVNxQixLQUFULEVBQWdCRSxjQUFoQjtBQUNIOztBQUNEcEUsSUFBQUEsSUFBSSxDQUFDRixTQUFELENBQUosR0FBa0JzQixTQUFsQjtBQUNIOztBQUVELE1BQUlpRCxHQUFHLEdBQUd4RCxFQUFFLENBQUNDLEtBQUgsQ0FBU29ELEtBQVQsQ0FBVixDQXpCa0QsQ0EyQmxEOztBQUNBLE1BQUlyRSxNQUFKLEVBQVk7QUFDUixRQUFJeUUsU0FBUyxHQUFHTCxNQUFNLENBQUNNLG1CQUFQLENBQTJCdkUsSUFBSSxDQUFDd0UsU0FBaEMsQ0FBaEI7O0FBQ0EsU0FBSyxJQUFJQyxDQUFDLEdBQUcsQ0FBYixFQUFnQkEsQ0FBQyxHQUFHSCxTQUFTLENBQUNJLE1BQTlCLEVBQXNDLEVBQUVELENBQXhDLEVBQTJDO0FBQ3ZDLFVBQUk3QixJQUFJLEdBQUcwQixTQUFTLENBQUNHLENBQUQsQ0FBcEI7O0FBQ0EsVUFBSTdCLElBQUksS0FBSyxhQUFiLEVBQTRCO0FBQ3hCLFlBQUlSLElBQUksR0FBRzZCLE1BQU0sQ0FBQ1Usd0JBQVAsQ0FBZ0MzRSxJQUFJLENBQUN3RSxTQUFyQyxFQUFnRDVCLElBQWhELENBQVg7QUFDQSxZQUFJZ0MsSUFBSSxHQUFHeEMsSUFBSSxJQUFJQSxJQUFJLENBQUNULEtBQXhCOztBQUNBLFlBQUksT0FBT2lELElBQVAsS0FBZ0IsVUFBcEIsRUFBZ0M7QUFDNUJsRixVQUFBQSxVQUFVLENBQUNtRiw2QkFBWCxDQUF5Q0QsSUFBekMsRUFBK0NoQyxJQUEvQyxFQUFxRGpELEVBQUUsQ0FBQzZCLFlBQUgsQ0FBZ0J4QixJQUFoQixDQUFyRCxFQUE0RUEsSUFBNUUsRUFBa0YrRCxJQUFsRjtBQUNIO0FBQ0o7QUFDSjtBQUNKOztBQUVELFNBQU9NLEdBQVA7QUFDSCxDQTNDOEIsQ0FBL0I7QUE2Q0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQThHQSxTQUFTUyxRQUFULENBQW1CQyxrQkFBbkIsRUFBdUM3QyxRQUF2QyxFQUFpREUsSUFBakQsRUFBdUQ7QUFDbkQsTUFBSUQsT0FBTyxHQUFHLElBQWQ7O0FBQ0EsV0FBUzZDLFVBQVQsQ0FBcUJDLFNBQXJCLEVBQWdDL0MsUUFBaEMsRUFBMENFLElBQTFDLEVBQWdEO0FBQzVDLFFBQUlDLEtBQUssR0FBR2QsYUFBYSxDQUFDMEQsU0FBUyxDQUFDQyxXQUFYLENBQXpCOztBQUNBLFFBQUk3QyxLQUFKLEVBQVc7QUFDUCxVQUFJOEMsWUFBWSxHQUFHbEYsVUFBVSxDQUFDb0MsS0FBRCxFQUFRLE9BQVIsQ0FBN0I7QUFDQSxVQUFJSixVQUFVLEdBQUdoQyxVQUFVLENBQUNrRixZQUFELEVBQWUsWUFBZixDQUEzQjtBQUNBbkQsTUFBQUEsV0FBVyxDQUFDaUQsU0FBUyxDQUFDQyxXQUFYLEVBQXdCakQsVUFBeEIsRUFBb0NDLFFBQXBDLEVBQThDQyxPQUE5QyxFQUF1REMsSUFBdkQsRUFBNkRDLEtBQTdELENBQVg7QUFDSDtBQUNKOztBQUNELE1BQUksT0FBT0gsUUFBUCxLQUFvQixXQUF4QixFQUFxQztBQUNqQ0MsSUFBQUEsT0FBTyxHQUFHNEMsa0JBQVY7QUFDQSxXQUFPQyxVQUFQO0FBQ0gsR0FIRCxNQUlLO0FBQ0RBLElBQUFBLFVBQVUsQ0FBQ0Qsa0JBQUQsRUFBcUI3QyxRQUFyQixFQUErQkUsSUFBL0IsQ0FBVjtBQUNIO0FBQ0osRUFFRDs7O0FBRUEsU0FBU2dELHFCQUFULENBQWdDQyxZQUFoQyxFQUE4Q0MsY0FBOUMsRUFBOERDLFdBQTlELEVBQTJFO0FBQ3ZFLFNBQU9GLFlBQVksQ0FBQyxVQUFVckYsSUFBVixFQUFnQndGLGNBQWhCLEVBQWdDO0FBQ2hELFFBQUluRCxLQUFLLEdBQUdkLGFBQWEsQ0FBQ3ZCLElBQUQsRUFBT3NGLGNBQVAsQ0FBekI7O0FBQ0EsUUFBSWpELEtBQUosRUFBVztBQUNQLFVBQUlWLEtBQUssR0FBSTRELFdBQVcsS0FBS25FLFNBQWpCLEdBQThCbUUsV0FBOUIsR0FBNENDLGNBQXhEO0FBQ0EsVUFBSXRCLEtBQUssR0FBR2pFLFVBQVUsQ0FBQ29DLEtBQUQsRUFBUSxPQUFSLENBQXRCO0FBQ0FwQyxNQUFBQSxVQUFVLENBQUNpRSxLQUFELEVBQVEsUUFBUixDQUFWLENBQTRCb0IsY0FBNUIsSUFBOEMzRCxLQUE5QztBQUNIO0FBQ0osR0FQa0IsRUFPaEIyRCxjQVBnQixDQUFuQjtBQVFIOztBQUVELFNBQVNHLG9CQUFULENBQStCSixZQUEvQixFQUE2QztBQUN6QyxTQUFPQSxZQUFZLENBQUN0RixJQUFELENBQW5CO0FBQ0g7QUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBc0JBLElBQUkyRixpQkFBaUIsR0FBRyxDQUFDN0YsTUFBTSxHQUFHdUYscUJBQUgsR0FBMkJLLG9CQUFsQyxFQUF3RHJGLGlCQUF4RCxFQUEyRSxtQkFBM0UsRUFBZ0csSUFBaEcsQ0FBeEI7QUFFQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFtQkEsSUFBSXVGLGdCQUFnQixHQUFHUCxxQkFBcUIsQ0FBQzFFLGlCQUFELEVBQW9CLGtCQUFwQixDQUE1QztBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFvQkEsSUFBSWtGLElBQUksR0FBRyxDQUFDL0YsTUFBTSxHQUFHdUYscUJBQUgsR0FBMkJLLG9CQUFsQyxFQUF3RHBFLG1CQUF4RCxFQUE2RSxNQUE3RSxDQUFYO0FBRUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFxQkEsSUFBSXdFLGNBQWMsR0FBR1QscUJBQXFCLENBQUM5RCxtQkFBRCxFQUFzQixnQkFBdEIsQ0FBMUM7QUFFQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFtQkEsSUFBSXdFLGdCQUFnQixHQUFHLENBQUNqRyxNQUFNLEdBQUd1RixxQkFBSCxHQUEyQkssb0JBQWxDLEVBQXdEckYsaUJBQXhELEVBQTJFLGtCQUEzRSxDQUF2QjtBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBcUJBLElBQUkyRixXQUFXLEdBQUcsQ0FBQ2xHLE1BQU0sR0FBR3VGLHFCQUFILEdBQTJCSyxvQkFBbEMsRUFBd0RyRixpQkFBeEQsRUFBMkUsYUFBM0UsRUFBMEYsSUFBMUYsQ0FBbEI7QUFFQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFtQkEsSUFBSTRGLFNBQVMsR0FBRyxDQUFDbkcsTUFBTSxHQUFHdUYscUJBQUgsR0FBMkJLLG9CQUFsQyxFQUF3RHBFLG1CQUF4RCxFQUE2RSxXQUE3RSxDQUFoQjtBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFvQkEsSUFBSTRFLElBQUksR0FBRyxDQUFDcEcsTUFBTSxHQUFHdUYscUJBQUgsR0FBMkJLLG9CQUFsQyxFQUF3RHBFLG1CQUF4RCxFQUE2RSxNQUE3RSxDQUFYO0FBRUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBbUJBLElBQUk2RSxJQUFJLEdBQUcsQ0FBQ3JHLE1BQU0sR0FBR3VGLHFCQUFILEdBQTJCSyxvQkFBbEMsRUFBd0RwRSxtQkFBeEQsRUFBNkUsTUFBN0UsQ0FBWCxFQUVBOztBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQXdDQSxTQUFTOEUsTUFBVCxHQUFtQjtBQUNmLE1BQUlBLE1BQU0sR0FBRyxFQUFiOztBQUNBLE9BQUssSUFBSTFCLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUcyQixTQUFTLENBQUMxQixNQUE5QixFQUFzQ0QsQ0FBQyxFQUF2QyxFQUEyQztBQUN2QzBCLElBQUFBLE1BQU0sQ0FBQzFCLENBQUQsQ0FBTixHQUFZMkIsU0FBUyxDQUFDM0IsQ0FBRCxDQUFyQjtBQUNIOztBQUNELFNBQU8sVUFBVXpFLElBQVYsRUFBZ0I7QUFDbkIsUUFBSXFDLEtBQUssR0FBR2QsYUFBYSxDQUFDdkIsSUFBRCxFQUFPLFFBQVAsQ0FBekI7O0FBQ0EsUUFBSXFDLEtBQUosRUFBVztBQUNQcEMsTUFBQUEsVUFBVSxDQUFDb0MsS0FBRCxFQUFRLE9BQVIsQ0FBVixDQUEyQjhELE1BQTNCLEdBQW9DQSxNQUFwQztBQUNIO0FBQ0osR0FMRDtBQU1IOztBQUVEdEYsRUFBRSxDQUFDd0YsVUFBSCxHQUFnQkMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCO0FBQzdCMUMsRUFBQUEsT0FBTyxFQUFQQSxPQUQ2QjtBQUU3QmlCLEVBQUFBLFFBQVEsRUFBUkEsUUFGNkI7QUFHN0JZLEVBQUFBLGlCQUFpQixFQUFqQkEsaUJBSDZCO0FBSTdCQyxFQUFBQSxnQkFBZ0IsRUFBaEJBLGdCQUo2QjtBQUs3QkMsRUFBQUEsSUFBSSxFQUFKQSxJQUw2QjtBQU03QkMsRUFBQUEsY0FBYyxFQUFkQSxjQU42QjtBQU83QkMsRUFBQUEsZ0JBQWdCLEVBQWhCQSxnQkFQNkI7QUFRN0JDLEVBQUFBLFdBQVcsRUFBWEEsV0FSNkI7QUFTN0JDLEVBQUFBLFNBQVMsRUFBVEEsU0FUNkI7QUFVN0JDLEVBQUFBLElBQUksRUFBSkEsSUFWNkI7QUFXN0JDLEVBQUFBLElBQUksRUFBSkEsSUFYNkI7QUFZN0JDLEVBQUFBLE1BQU0sRUFBTkE7QUFaNkIsQ0FBakMsRUFlQTs7QUFDQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDEzLTIwMTYgQ2h1a29uZyBUZWNobm9sb2dpZXMgSW5jLlxuIENvcHlyaWdodCAoYykgMjAxNy0yMDE4IFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLlxuXG4gaHR0cHM6Ly93d3cuY29jb3MuY29tL1xuXG4gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZW5naW5lIHNvdXJjZSBjb2RlICh0aGUgXCJTb2Z0d2FyZVwiKSwgYSBsaW1pdGVkLFxuICB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiAgbm90IHVzZSBDb2NvcyBDcmVhdG9yIHNvZnR3YXJlIGZvciBkZXZlbG9waW5nIG90aGVyIHNvZnR3YXJlIG9yIHRvb2xzIHRoYXQnc1xuICB1c2VkIGZvciBkZXZlbG9waW5nIGdhbWVzLiBZb3UgYXJlIG5vdCBncmFudGVkIHRvIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsXG4gIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuLy8gY29uc3QgRklYX0JBQkVMNiA9IHRydWU7XG5cbi8qKlxuICogISNlbiBTb21lIEphdmFTY3JpcHQgZGVjb3JhdG9ycyB3aGljaCBjYW4gYmUgYWNjZXNzZWQgd2l0aCBcImNjLl9kZWNvcmF0b3JcIi5cbiAqICEjemgg5LiA5LqbIEphdmFTY3JpcHQg6KOF6aWw5Zmo77yM55uu5YmN5Y+v5Lul6YCa6L+HIFwiY2MuX2RlY29yYXRvclwiIOadpeiuv+mXruOAglxuICog77yI6L+Z5LqbIEFQSSDku43kuI3lrozlhajnqLPlrprvvIzmnInlj6/og73pmo/nnYAgSmF2YVNjcmlwdCDoo4XppbDlmajnmoTmoIflh4blrp7njrDogIzosIPmlbTvvIlcbiAqXG4gKiBAc3VibW9kdWxlIF9kZWNvcmF0b3JcbiAqIEBtb2R1bGUgX2RlY29yYXRvclxuICogQG1haW5cbiAqL1xuXG4vLyBpbnNwaXJlZCBieSB0b2RkbHh0IChodHRwczovL2dpdGh1Yi5jb20vdG9kZGx4dC9DcmVhdG9yLVR5cGVTY3JpcHQtQm9pbGVycGxhdGUpXG5cbnJlcXVpcmUoJy4vQ0NDbGFzcycpO1xuY29uc3QgUHJlcHJvY2VzcyA9IHJlcXVpcmUoJy4vcHJlcHJvY2Vzcy1jbGFzcycpO1xuY29uc3QganMgPSByZXF1aXJlKCcuL2pzJyk7XG5jb25zdCBpc1BsYWluRW1wdHlPYmpfREVWID0gQ0NfREVWICYmIHJlcXVpcmUoJy4vdXRpbHMnKS5pc1BsYWluRW1wdHlPYmpfREVWO1xuXG4vLyBjYWNoZXMgZm9yIGNsYXNzIGNvbnN0cnVjdGlvblxuY29uc3QgQ0FDSEVfS0VZID0gJ19fY2NjbGFzc0NhY2hlX18nO1xuXG5mdW5jdGlvbiBmTk9QIChjdG9yKSB7XG4gICAgcmV0dXJuIGN0b3I7XG59XG5cbmZ1bmN0aW9uIGdldFN1YkRpY3QgKG9iaiwga2V5KSB7XG4gICAgcmV0dXJuIG9ialtrZXldIHx8IChvYmpba2V5XSA9IHt9KTtcbn1cblxuZnVuY3Rpb24gY2hlY2tDdG9yQXJndW1lbnQgKGRlY29yYXRlKSB7XG4gICAgcmV0dXJuIGZ1bmN0aW9uICh0YXJnZXQpIHtcbiAgICAgICAgaWYgKHR5cGVvZiB0YXJnZXQgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgICAgIC8vIG5vIHBhcmFtZXRlciwgdGFyZ2V0IGlzIGN0b3JcbiAgICAgICAgICAgIHJldHVybiBkZWNvcmF0ZSh0YXJnZXQpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBmdW5jdGlvbiAoY3Rvcikge1xuICAgICAgICAgICAgcmV0dXJuIGRlY29yYXRlKGN0b3IsIHRhcmdldCk7XG4gICAgICAgIH07XG4gICAgfTtcbn1cblxuZnVuY3Rpb24gX2NoZWNrTm9ybWFsQXJndW1lbnQgKHZhbGlkYXRvcl9ERVYsIGRlY29yYXRlLCBkZWNvcmF0b3JOYW1lKSB7XG4gICAgcmV0dXJuIGZ1bmN0aW9uICh0YXJnZXQpIHtcbiAgICAgICAgaWYgKENDX0RFViAmJiB2YWxpZGF0b3JfREVWKHRhcmdldCwgZGVjb3JhdG9yTmFtZSkgPT09IGZhbHNlKSB7XG4gICAgICAgICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiBmTk9QO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gZnVuY3Rpb24gKGN0b3IpIHtcbiAgICAgICAgICAgIHJldHVybiBkZWNvcmF0ZShjdG9yLCB0YXJnZXQpO1xuICAgICAgICB9O1xuICAgIH07XG59XG5cbnZhciBjaGVja0NvbXBBcmd1bWVudCA9IF9jaGVja05vcm1hbEFyZ3VtZW50LmJpbmQobnVsbCwgQ0NfREVWICYmIGZ1bmN0aW9uIChhcmcsIGRlY29yYXRvck5hbWUpIHtcbiAgICBpZiAoIWNjLkNsYXNzLl9pc0NDQ2xhc3MoYXJnKSkge1xuICAgICAgICBjYy5lcnJvcignVGhlIHBhcmFtZXRlciBmb3IgJXMgaXMgbWlzc2luZy4nLCBkZWNvcmF0b3JOYW1lKTtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbn0pO1xuXG5mdW5jdGlvbiBfYXJndW1lbnRDaGVja2VyICh0eXBlKSB7XG4gICAgcmV0dXJuIF9jaGVja05vcm1hbEFyZ3VtZW50LmJpbmQobnVsbCwgQ0NfREVWICYmIGZ1bmN0aW9uIChhcmcsIGRlY29yYXRvck5hbWUpIHtcbiAgICAgICAgaWYgKGFyZyBpbnN0YW5jZW9mIGNjLkNvbXBvbmVudCB8fCBhcmcgPT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgY2MuZXJyb3IoJ1RoZSBwYXJhbWV0ZXIgZm9yICVzIGlzIG1pc3NpbmcuJywgZGVjb3JhdG9yTmFtZSk7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSBpZiAodHlwZW9mIGFyZyAhPT0gdHlwZSkge1xuICAgICAgICAgICAgY2MuZXJyb3IoJ1RoZSBwYXJhbWV0ZXIgZm9yICVzIG11c3QgYmUgdHlwZSAlcy4nLCBkZWNvcmF0b3JOYW1lLCB0eXBlKTtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuICAgIH0pO1xufVxudmFyIGNoZWNrU3RyaW5nQXJndW1lbnQgPSBfYXJndW1lbnRDaGVja2VyKCdzdHJpbmcnKTtcbnZhciBjaGVja051bWJlckFyZ3VtZW50ID0gX2FyZ3VtZW50Q2hlY2tlcignbnVtYmVyJyk7XG4vLyB2YXIgY2hlY2tCb29sZWFuQXJndW1lbnQgPSBfYXJndW1lbnRDaGVja2VyKCdib29sZWFuJyk7XG5cblxuZnVuY3Rpb24gZ2V0Q2xhc3NDYWNoZSAoY3RvciwgZGVjb3JhdG9yTmFtZSkge1xuICAgIGlmIChDQ19ERVYgJiYgY2MuQ2xhc3MuX2lzQ0NDbGFzcyhjdG9yKSkge1xuICAgICAgICBjYy5lcnJvcignYEAlc2Agc2hvdWxkIGJlIHVzZWQgYWZ0ZXIgQGNjY2xhc3MgZm9yIGNsYXNzIFwiJXNcIicsIGRlY29yYXRvck5hbWUsIGpzLmdldENsYXNzTmFtZShjdG9yKSk7XG4gICAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgICByZXR1cm4gZ2V0U3ViRGljdChjdG9yLCBDQUNIRV9LRVkpO1xufVxuXG5mdW5jdGlvbiBnZXREZWZhdWx0RnJvbUluaXRpYWxpemVyIChpbml0aWFsaXplcikge1xuICAgIHZhciB2YWx1ZTtcbiAgICB0cnkge1xuICAgICAgICB2YWx1ZSA9IGluaXRpYWxpemVyKCk7XG4gICAgfVxuICAgIGNhdGNoIChlKSB7XG4gICAgICAgIC8vIGp1c3QgbGF6eSBpbml0aWFsaXplIGJ5IENDQ2xhc3NcbiAgICAgICAgcmV0dXJuIGluaXRpYWxpemVyO1xuICAgIH1cbiAgICBpZiAodHlwZW9mIHZhbHVlICE9PSAnb2JqZWN0JyB8fCB2YWx1ZSA9PT0gbnVsbCkge1xuICAgICAgICAvLyBzdHJpbmcgYm9vbGVhbiBudW1iZXIgZnVuY3Rpb24gdW5kZWZpbmVkIG51bGxcbiAgICAgICAgcmV0dXJuIHZhbHVlO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgICAgLy8gVGhlIGRlZmF1bHQgYXR0cmlidXRlIHdpbGwgbm90IGJlIHVzZWQgaW4gRVM2IGNvbnN0cnVjdG9yIGFjdHVhbGx5LFxuICAgICAgICAvLyBzbyB3ZSBkb250IG5lZWQgdG8gc2ltcGxpZnkgaW50byBge31gIG9yIGBbXWAgb3IgdmVjMiBjb21wbGV0ZWx5LlxuICAgICAgICByZXR1cm4gaW5pdGlhbGl6ZXI7XG4gICAgfVxufVxuXG5cbmZ1bmN0aW9uIGV4dHJhY3RBY3R1YWxEZWZhdWx0VmFsdWVzIChjdG9yKSB7XG4gICAgdmFyIGR1bW15T2JqO1xuICAgIHRyeSB7XG4gICAgICAgIGR1bW15T2JqID0gbmV3IGN0b3IoKTtcbiAgICB9XG4gICAgY2F0Y2ggKGUpIHtcbiAgICAgICAgaWYgKENDX0RFVikge1xuICAgICAgICAgICAgY2MuZXJyb3JJRCgzNjUyLCBqcy5nZXRDbGFzc05hbWUoY3RvciksIGUpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB7fTtcbiAgICB9XG4gICAgcmV0dXJuIGR1bW15T2JqO1xufVxuXG5mdW5jdGlvbiBnZW5Qcm9wZXJ0eSAoY3RvciwgcHJvcGVydGllcywgcHJvcE5hbWUsIG9wdGlvbnMsIGRlc2MsIGNhY2hlKSB7XG4gICAgdmFyIGZ1bGxPcHRpb25zO1xuICAgIHZhciBpc0dldHNldCA9IGRlc2MgJiYgKGRlc2MuZ2V0IHx8IGRlc2Muc2V0KTtcbiAgICBpZiAob3B0aW9ucykge1xuICAgICAgICBmdWxsT3B0aW9ucyA9IENDX0RFViA/IFByZXByb2Nlc3MuZ2V0RnVsbEZvcm1PZlByb3BlcnR5KG9wdGlvbnMsIGlzR2V0c2V0LCBwcm9wTmFtZSwganMuZ2V0Q2xhc3NOYW1lKGN0b3IpKSA6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUHJlcHJvY2Vzcy5nZXRGdWxsRm9ybU9mUHJvcGVydHkob3B0aW9ucywgaXNHZXRzZXQpO1xuICAgIH1cbiAgICB2YXIgZXhpc3RzUHJvcGVydHkgPSBwcm9wZXJ0aWVzW3Byb3BOYW1lXTtcbiAgICB2YXIgcHJvcCA9IGpzLm1peGluKGV4aXN0c1Byb3BlcnR5IHx8IHt9LCBmdWxsT3B0aW9ucyB8fCBvcHRpb25zIHx8IHt9KTtcblxuICAgIGlmIChpc0dldHNldCkge1xuICAgICAgICAvLyB0eXBlc2NyaXB0IG9yIGJhYmVsXG4gICAgICAgIGlmIChDQ19ERVYgJiYgb3B0aW9ucyAmJiAoKGZ1bGxPcHRpb25zIHx8IG9wdGlvbnMpLmdldCB8fCAoZnVsbE9wdGlvbnMgfHwgb3B0aW9ucykuc2V0KSkge1xuICAgICAgICAgICAgdmFyIGVycm9yUHJvcHMgPSBnZXRTdWJEaWN0KGNhY2hlLCAnZXJyb3JQcm9wcycpO1xuICAgICAgICAgICAgaWYgKCFlcnJvclByb3BzW3Byb3BOYW1lXSkge1xuICAgICAgICAgICAgICAgIGVycm9yUHJvcHNbcHJvcE5hbWVdID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICBjYy53YXJuSUQoMzY1NSwgcHJvcE5hbWUsIGpzLmdldENsYXNzTmFtZShjdG9yKSwgcHJvcE5hbWUsIHByb3BOYW1lKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBpZiAoZGVzYy5nZXQpIHtcbiAgICAgICAgICAgIHByb3AuZ2V0ID0gZGVzYy5nZXQ7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKGRlc2Muc2V0KSB7XG4gICAgICAgICAgICBwcm9wLnNldCA9IGRlc2Muc2V0O1xuICAgICAgICB9XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICBpZiAoQ0NfREVWICYmIChwcm9wLmdldCB8fCBwcm9wLnNldCkpIHtcbiAgICAgICAgICAgIC8vIEBwcm9wZXJ0eSh7XG4gICAgICAgICAgICAvLyAgICAgZ2V0ICgpIHsgLi4uIH0sXG4gICAgICAgICAgICAvLyAgICAgc2V0ICguLi4pIHsgLi4uIH0sXG4gICAgICAgICAgICAvLyB9KVxuICAgICAgICAgICAgLy8gdmFsdWU7XG4gICAgICAgICAgICBjYy5lcnJvcklEKDM2NTUsIHByb3BOYW1lLCBqcy5nZXRDbGFzc05hbWUoY3RvciksIHByb3BOYW1lLCBwcm9wTmFtZSk7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgLy8gbWVtYmVyIHZhcmlhYmxlc1xuICAgICAgICB2YXIgZGVmYXVsdFZhbHVlID0gdW5kZWZpbmVkO1xuICAgICAgICB2YXIgaXNEZWZhdWx0VmFsdWVTcGVjaWZpZWQgPSBmYWxzZTtcbiAgICAgICAgaWYgKGRlc2MpIHtcbiAgICAgICAgICAgIC8vIGJhYmVsXG4gICAgICAgICAgICBpZiAoZGVzYy5pbml0aWFsaXplcikge1xuICAgICAgICAgICAgICAgIC8vIEBwcm9wZXJ0eSguLi4pXG4gICAgICAgICAgICAgICAgLy8gdmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgIGRlZmF1bHRWYWx1ZSA9IGdldERlZmF1bHRGcm9tSW5pdGlhbGl6ZXIoZGVzYy5pbml0aWFsaXplcik7XG4gICAgICAgICAgICAgICAgaXNEZWZhdWx0VmFsdWVTcGVjaWZpZWQgPSB0cnVlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgLy8gQHByb3BlcnR5KC4uLilcbiAgICAgICAgICAgICAgICAvLyB2YWx1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIC8vIHR5cGVzY3JpcHRcbiAgICAgICAgICAgIHZhciBhY3R1YWxEZWZhdWx0VmFsdWVzID0gY2FjaGUuZGVmYXVsdCB8fCAoY2FjaGUuZGVmYXVsdCA9IGV4dHJhY3RBY3R1YWxEZWZhdWx0VmFsdWVzKGN0b3IpKTtcbiAgICAgICAgICAgIGlmIChhY3R1YWxEZWZhdWx0VmFsdWVzLmhhc093blByb3BlcnR5KHByb3BOYW1lKSkge1xuICAgICAgICAgICAgICAgIC8vIEBwcm9wZXJ0eSguLi4pXG4gICAgICAgICAgICAgICAgLy8gdmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgIGRlZmF1bHRWYWx1ZSA9IGFjdHVhbERlZmF1bHRWYWx1ZXNbcHJvcE5hbWVdO1xuICAgICAgICAgICAgICAgIGlzRGVmYXVsdFZhbHVlU3BlY2lmaWVkID0gdHJ1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIEBwcm9wZXJ0eSguLi4pXG4gICAgICAgICAgICAgICAgLy8gdmFsdWU7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoKENDX0VESVRPUiAmJiAhRWRpdG9yLmlzQnVpbGRlcikgfHwgQ0NfVEVTVCkge1xuICAgICAgICAgICAgaWYgKCFmdWxsT3B0aW9ucyAmJiBvcHRpb25zICYmIG9wdGlvbnMuaGFzT3duUHJvcGVydHkoJ2RlZmF1bHQnKSkge1xuICAgICAgICAgICAgICAgIGNjLndhcm5JRCgzNjUzLCBwcm9wTmFtZSwganMuZ2V0Q2xhc3NOYW1lKGN0b3IpKTtcbiAgICAgICAgICAgICAgICAvLyBwcm9wLmRlZmF1bHQgPSBvcHRpb25zLmRlZmF1bHQ7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIGlmICghaXNEZWZhdWx0VmFsdWVTcGVjaWZpZWQpIHtcbiAgICAgICAgICAgICAgICBjYy53YXJuSUQoMzY1NCwganMuZ2V0Q2xhc3NOYW1lKGN0b3IpLCBwcm9wTmFtZSk7XG4gICAgICAgICAgICAgICAgLy8gcHJvcC5kZWZhdWx0ID0gZnVsbE9wdGlvbnMuaGFzT3duUHJvcGVydHkoJ2RlZmF1bHQnKSA/IGZ1bGxPcHRpb25zLmRlZmF1bHQgOiB1bmRlZmluZWQ7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoY2MuUmF3QXNzZXQud2FzUmF3QXNzZXRUeXBlKHByb3AudXJsKSAmJlxuICAgICAgICAgICAgICAgIHByb3AuX3Nob3J0ICYmXG4gICAgICAgICAgICAgICAgaXNEZWZhdWx0VmFsdWVTcGVjaWZpZWQgJiZcbiAgICAgICAgICAgICAgICBkZWZhdWx0VmFsdWUgPT0gbnVsbFxuICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgLy8gQXZvaWQgZXhjZXNzaXZlIHdhcm5pbmcgd2hlbiB0aGUgdHMgZGVjb3JhdG9yIGZvcm1hdCBpcyB3cm9uZ1xuICAgICAgICAgICAgICAgIGlmICh0eXBlb2Ygb3B0aW9ucyAhPT0gJ2Z1bmN0aW9uJyB8fCBjYy5SYXdBc3NldC5pc1Jhd0Fzc2V0VHlwZShvcHRpb25zKSkge1xuICAgICAgICAgICAgICAgICAgICBjYy5lcnJvcklEKDM2NTYsIGpzLmdldENsYXNzTmFtZShjdG9yKSwgcHJvcE5hbWUpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBwcm9wLmRlZmF1bHQgPSBkZWZhdWx0VmFsdWU7XG4gICAgfVxuXG4gICAgcHJvcGVydGllc1twcm9wTmFtZV0gPSBwcm9wO1xufVxuXG4vKipcbiAqICEjZW5cbiAqIERlY2xhcmUgdGhlIHN0YW5kYXJkIFtFUzYgQ2xhc3NdKGh0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvV2ViL0phdmFTY3JpcHQvUmVmZXJlbmNlL0NsYXNzZXMpXG4gKiBhcyBDQ0NsYXNzLCBwbGVhc2Ugc2VlIFtDbGFzc10oLi4vLi4vLi4vbWFudWFsL2VuL3NjcmlwdGluZy9jbGFzcy5odG1sKSBmb3IgZGV0YWlscy5cbiAqICEjemhcbiAqIOWwhuagh+WHhuWGmeazleeahCBbRVM2IENsYXNzXShodHRwczovL2RldmVsb3Blci5tb3ppbGxhLm9yZy9lbi1VUy9kb2NzL1dlYi9KYXZhU2NyaXB0L1JlZmVyZW5jZS9DbGFzc2VzKSDlo7DmmI7kuLogQ0NDbGFzc++8jOWFt+S9k+eUqOazleivt+WPgumYhVvnsbvlnovlrprkuYldKC4uLy4uLy4uL21hbnVhbC96aC9zY3JpcHRpbmcvY2xhc3MuaHRtbCnjgIJcbiAqXG4gKiBAbWV0aG9kIGNjY2xhc3NcbiAqIEBwYXJhbSB7U3RyaW5nfSBbbmFtZV0gLSBUaGUgY2xhc3MgbmFtZSB1c2VkIGZvciBzZXJpYWxpemF0aW9uLlxuICogQGV4YW1wbGVcbiAqIGNvbnN0IHtjY2NsYXNzfSA9IGNjLl9kZWNvcmF0b3I7XG4gKlxuICogLy8gZGVmaW5lIGEgQ0NDbGFzcywgb21pdCB0aGUgbmFtZVxuICogJiM2NDtjY2NsYXNzXG4gKiBjbGFzcyBOZXdTY3JpcHQgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICpcbiAqIC8vIGRlZmluZSBhIENDQ2xhc3Mgd2l0aCBhIG5hbWVcbiAqICYjNjQ7Y2NjbGFzcygnTG9naW5EYXRhJylcbiAqIGNsYXNzIExvZ2luRGF0YSB7XG4gKiAgICAgLy8gLi4uXG4gKiB9XG4gKiBAdHlwZXNjcmlwdFxuICogY2NjbGFzcyhuYW1lPzogc3RyaW5nKTogRnVuY3Rpb25cbiAqIGNjY2xhc3MoX2NsYXNzPzogRnVuY3Rpb24pOiB2b2lkXG4gKi9cbnZhciBjY2NsYXNzID0gY2hlY2tDdG9yQXJndW1lbnQoZnVuY3Rpb24gKGN0b3IsIG5hbWUpIHtcbiAgICAvLyBpZiAoRklYX0JBQkVMNikge1xuICAgIC8vICAgICBldmFsKCdpZih0eXBlb2YgX2NsYXNzQ2FsbENoZWNrPT09XCJmdW5jdGlvblwiKXtfY2xhc3NDYWxsQ2hlY2s9ZnVuY3Rpb24oKXt9O30nKTtcbiAgICAvLyB9XG4gICAgdmFyIGJhc2UgPSBqcy5nZXRTdXBlcihjdG9yKTtcbiAgICBpZiAoYmFzZSA9PT0gT2JqZWN0KSB7XG4gICAgICAgIGJhc2UgPSBudWxsO1xuICAgIH1cblxuICAgIHZhciBwcm90byA9IHtcbiAgICAgICAgbmFtZSxcbiAgICAgICAgZXh0ZW5kczogYmFzZSxcbiAgICAgICAgY3RvcixcbiAgICAgICAgX19FUzZfXzogdHJ1ZSxcbiAgICB9O1xuICAgIHZhciBjYWNoZSA9IGN0b3JbQ0FDSEVfS0VZXTtcbiAgICBpZiAoY2FjaGUpIHtcbiAgICAgICAgdmFyIGRlY29yYXRlZFByb3RvID0gY2FjaGUucHJvdG87XG4gICAgICAgIGlmIChkZWNvcmF0ZWRQcm90bykge1xuICAgICAgICAgICAgLy8gZGVjb3JhdGVkUHJvdG8ucHJvcGVydGllcyA9IGNyZWF0ZVByb3BlcnRpZXMoY3RvciwgZGVjb3JhdGVkUHJvdG8ucHJvcGVydGllcyk7XG4gICAgICAgICAgICBqcy5taXhpbihwcm90bywgZGVjb3JhdGVkUHJvdG8pO1xuICAgICAgICB9XG4gICAgICAgIGN0b3JbQ0FDSEVfS0VZXSA9IHVuZGVmaW5lZDtcbiAgICB9XG5cbiAgICB2YXIgcmVzID0gY2MuQ2xhc3MocHJvdG8pO1xuXG4gICAgLy8gdmFsaWRhdGUgbWV0aG9kc1xuICAgIGlmIChDQ19ERVYpIHtcbiAgICAgICAgdmFyIHByb3BOYW1lcyA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzKGN0b3IucHJvdG90eXBlKTtcbiAgICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCBwcm9wTmFtZXMubGVuZ3RoOyArK2kpIHtcbiAgICAgICAgICAgIHZhciBwcm9wID0gcHJvcE5hbWVzW2ldO1xuICAgICAgICAgICAgaWYgKHByb3AgIT09ICdjb25zdHJ1Y3RvcicpIHtcbiAgICAgICAgICAgICAgICB2YXIgZGVzYyA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IoY3Rvci5wcm90b3R5cGUsIHByb3ApO1xuICAgICAgICAgICAgICAgIHZhciBmdW5jID0gZGVzYyAmJiBkZXNjLnZhbHVlO1xuICAgICAgICAgICAgICAgIGlmICh0eXBlb2YgZnVuYyA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgICAgICAgICAgICAgICBQcmVwcm9jZXNzLmRvVmFsaWRhdGVNZXRob2RXaXRoUHJvcHNfREVWKGZ1bmMsIHByb3AsIGpzLmdldENsYXNzTmFtZShjdG9yKSwgY3RvciwgYmFzZSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHJlcztcbn0pO1xuXG4vKipcbiAqICEjZW5cbiAqIERlY2xhcmUgcHJvcGVydHkgZm9yIFtDQ0NsYXNzXSguLi8uLi8uLi9tYW51YWwvZW4vc2NyaXB0aW5nL3JlZmVyZW5jZS9hdHRyaWJ1dGVzLmh0bWwpLlxuICogISN6aFxuICog5a6a5LmJIFtDQ0NsYXNzXSguLi8uLi8uLi9tYW51YWwvemgvc2NyaXB0aW5nL3JlZmVyZW5jZS9hdHRyaWJ1dGVzLmh0bWwpIOaJgOeUqOeahOWxnuaAp+OAglxuICpcbiAqIEBtZXRob2QgcHJvcGVydHlcbiAqIEBwYXJhbSB7T2JqZWN0fSBbb3B0aW9uc10gLSBhbiBvYmplY3Qgd2l0aCBzb21lIHByb3BlcnR5IGF0dHJpYnV0ZXNcbiAqIEBwYXJhbSB7QW55fSBbb3B0aW9ucy50eXBlXVxuICogQHBhcmFtIHtCb29sZWFufEZ1bmN0aW9ufSBbb3B0aW9ucy52aXNpYmxlXVxuICogQHBhcmFtIHtTdHJpbmd9IFtvcHRpb25zLmRpc3BsYXlOYW1lXVxuICogQHBhcmFtIHtTdHJpbmd9IFtvcHRpb25zLnRvb2x0aXBdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLm11bHRpbGluZV1cbiAqIEBwYXJhbSB7Qm9vbGVhbn0gW29wdGlvbnMucmVhZG9ubHldXG4gKiBAcGFyYW0ge051bWJlcn0gW29wdGlvbnMubWluXVxuICogQHBhcmFtIHtOdW1iZXJ9IFtvcHRpb25zLm1heF1cbiAqIEBwYXJhbSB7TnVtYmVyfSBbb3B0aW9ucy5zdGVwXVxuICogQHBhcmFtIHtOdW1iZXJbXX0gW29wdGlvbnMucmFuZ2VdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLnNsaWRlXVxuICogQHBhcmFtIHtCb29sZWFufSBbb3B0aW9ucy5zZXJpYWxpemFibGVdXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLmVkaXRvck9ubHldXG4gKiBAcGFyYW0ge0Jvb2xlYW59IFtvcHRpb25zLm92ZXJyaWRlXVxuICogQHBhcmFtIHtCb29sZWFufSBbb3B0aW9ucy5hbmltYXRhYmxlXVxuICogQHBhcmFtIHtTdHJpbmd9IFtvcHRpb25zLmZvcm1lcmx5U2VyaWFsaXplZEFzXVxuICogQGV4YW1wbGVcbiAqIGNvbnN0IHtjY2NsYXNzLCBwcm9wZXJ0eX0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogY2xhc3MgTmV3U2NyaXB0IGV4dGVuZHMgY2MuQ29tcG9uZW50IHtcbiAqICAgICAmIzY0O3Byb3BlcnR5KHtcbiAqICAgICAgICAgdHlwZTogY2MuTm9kZVxuICogICAgIH0pXG4gKiAgICAgdGFyZ2V0Tm9kZTEgPSBudWxsO1xuICpcbiAqICAgICAmIzY0O3Byb3BlcnR5KGNjLk5vZGUpXG4gKiAgICAgdGFyZ2V0Tm9kZTIgPSBudWxsO1xuICpcbiAqICAgICAmIzY0O3Byb3BlcnR5KGNjLkJ1dHRvbilcbiAqICAgICB0YXJnZXRCdXR0b24gPSBudWxsO1xuICpcbiAqICAgICAmIzY0O3Byb3BlcnR5XG4gKiAgICAgX3dpZHRoID0gMTAwO1xuICpcbiAqICAgICAmIzY0O3Byb3BlcnR5XG4gKiAgICAgZ2V0IHdpZHRoICgpIHtcbiAqICAgICAgICAgcmV0dXJuIHRoaXMuX3dpZHRoO1xuICogICAgIH1cbiAqXG4gKiAgICAgJiM2NDtwcm9wZXJ0eVxuICogICAgIHNldCB3aWR0aCAodmFsdWUpIHtcbiAqICAgICAgICAgdGhpcy5fd2lkdGggPSB2YWx1ZTtcbiAqICAgICB9XG4gKlxuICogICAgICYjNjQ7cHJvcGVydHlcbiAqICAgICBvZmZzZXQgPSBuZXcgY2MuVmVjMigxMDAsIDEwMCk7XG4gKlxuICogICAgICYjNjQ7cHJvcGVydHkoY2MuVmVjMilcbiAqICAgICBvZmZzZXRzID0gW107XG4gKlxuICogICAgICYjNjQ7cHJvcGVydHkoY2MuU3ByaXRlRnJhbWUpXG4gKiAgICAgZnJhbWUgPSBudWxsO1xuICogfVxuICpcbiAqIC8vIGFib3ZlIGlzIGVxdWl2YWxlbnQgdG8gKOS4iumdoueahOS7o+eggeebuOW9k+S6jik6XG4gKlxuICogdmFyIE5ld1NjcmlwdCA9IGNjLkNsYXNzKHtcbiAqICAgICBwcm9wZXJ0aWVzOiB7XG4gKiAgICAgICAgIHRhcmdldE5vZGUxOiB7XG4gKiAgICAgICAgICAgICBkZWZhdWx0OiBudWxsLFxuICogICAgICAgICAgICAgdHlwZTogY2MuTm9kZVxuICogICAgICAgICB9LFxuICpcbiAqICAgICAgICAgdGFyZ2V0Tm9kZTI6IHtcbiAqICAgICAgICAgICAgIGRlZmF1bHQ6IG51bGwsXG4gKiAgICAgICAgICAgICB0eXBlOiBjYy5Ob2RlXG4gKiAgICAgICAgIH0sXG4gKlxuICogICAgICAgICB0YXJnZXRCdXR0b246IHtcbiAqICAgICAgICAgICAgIGRlZmF1bHQ6IG51bGwsXG4gKiAgICAgICAgICAgICB0eXBlOiBjYy5CdXR0b25cbiAqICAgICAgICAgfSxcbiAqXG4gKiAgICAgICAgIF93aWR0aDogMTAwLFxuICpcbiAqICAgICAgICAgd2lkdGg6IHtcbiAqICAgICAgICAgICAgIGdldCAoKSB7XG4gKiAgICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuX3dpZHRoO1xuICogICAgICAgICAgICAgfSxcbiAqICAgICAgICAgICAgIHNldCAodmFsdWUpIHtcbiAqICAgICAgICAgICAgICAgICB0aGlzLl93aWR0aCA9IHZhbHVlO1xuICogICAgICAgICAgICAgfVxuICogICAgICAgICB9LFxuICpcbiAqICAgICAgICAgb2Zmc2V0OiBuZXcgY2MuVmVjMigxMDAsIDEwMClcbiAqXG4gKiAgICAgICAgIG9mZnNldHM6IHtcbiAqICAgICAgICAgICAgIGRlZmF1bHQ6IFtdLFxuICogICAgICAgICAgICAgdHlwZTogY2MuVmVjMlxuICogICAgICAgICB9XG4gKlxuICogICAgICAgICBmcmFtZToge1xuICogICAgICAgICAgICAgZGVmYXVsdDogbnVsbCxcbiAqICAgICAgICAgICAgIHR5cGU6IGNjLlNwcml0ZUZyYW1lXG4gKiAgICAgICAgIH0sXG4gKiAgICAgfVxuICogfSk7XG4gKiBAdHlwZXNjcmlwdFxuICogcHJvcGVydHkob3B0aW9ucz86IHt0eXBlPzogYW55OyB2aXNpYmxlPzogYm9vbGVhbnwoKCkgPT4gYm9vbGVhbik7IGRpc3BsYXlOYW1lPzogc3RyaW5nOyB0b29sdGlwPzogc3RyaW5nOyBtdWx0aWxpbmU/OiBib29sZWFuOyByZWFkb25seT86IGJvb2xlYW47IG1pbj86IG51bWJlcjsgbWF4PzogbnVtYmVyOyBzdGVwPzogbnVtYmVyOyByYW5nZT86IG51bWJlcltdOyBzbGlkZT86IGJvb2xlYW47IHNlcmlhbGl6YWJsZT86IGJvb2xlYW47IGZvcm1lcmx5U2VyaWFsaXplZEFzPzogc3RyaW5nOyBlZGl0b3JPbmx5PzogYm9vbGVhbjsgb3ZlcnJpZGU/OiBib29sZWFuOyBhbmltYXRhYmxlPzogYm9vbGVhbn0gfCBhbnlbXXxGdW5jdGlvbnxjYy5WYWx1ZVR5cGV8bnVtYmVyfHN0cmluZ3xib29sZWFuKTogRnVuY3Rpb25cbiAqIHByb3BlcnR5KF90YXJnZXQ6IE9iamVjdCwgX2tleTogYW55LCBfZGVzYz86IGFueSk6IHZvaWRcbiAqL1xuZnVuY3Rpb24gcHJvcGVydHkgKGN0b3JQcm90b09yT3B0aW9ucywgcHJvcE5hbWUsIGRlc2MpIHtcbiAgICB2YXIgb3B0aW9ucyA9IG51bGw7XG4gICAgZnVuY3Rpb24gbm9ybWFsaXplZCAoY3RvclByb3RvLCBwcm9wTmFtZSwgZGVzYykge1xuICAgICAgICB2YXIgY2FjaGUgPSBnZXRDbGFzc0NhY2hlKGN0b3JQcm90by5jb25zdHJ1Y3Rvcik7XG4gICAgICAgIGlmIChjYWNoZSkge1xuICAgICAgICAgICAgdmFyIGNjY2xhc3NQcm90byA9IGdldFN1YkRpY3QoY2FjaGUsICdwcm90bycpO1xuICAgICAgICAgICAgdmFyIHByb3BlcnRpZXMgPSBnZXRTdWJEaWN0KGNjY2xhc3NQcm90bywgJ3Byb3BlcnRpZXMnKTtcbiAgICAgICAgICAgIGdlblByb3BlcnR5KGN0b3JQcm90by5jb25zdHJ1Y3RvciwgcHJvcGVydGllcywgcHJvcE5hbWUsIG9wdGlvbnMsIGRlc2MsIGNhY2hlKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICBpZiAodHlwZW9mIHByb3BOYW1lID09PSAndW5kZWZpbmVkJykge1xuICAgICAgICBvcHRpb25zID0gY3RvclByb3RvT3JPcHRpb25zO1xuICAgICAgICByZXR1cm4gbm9ybWFsaXplZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICAgIG5vcm1hbGl6ZWQoY3RvclByb3RvT3JPcHRpb25zLCBwcm9wTmFtZSwgZGVzYyk7XG4gICAgfVxufVxuXG4vLyBFZGl0b3IgRGVjb3JhdG9yc1xuXG5mdW5jdGlvbiBjcmVhdGVFZGl0b3JEZWNvcmF0b3IgKGFyZ0NoZWNrRnVuYywgZWRpdG9yUHJvcE5hbWUsIHN0YXRpY1ZhbHVlKSB7XG4gICAgcmV0dXJuIGFyZ0NoZWNrRnVuYyhmdW5jdGlvbiAoY3RvciwgZGVjb3JhdGVkVmFsdWUpIHtcbiAgICAgICAgdmFyIGNhY2hlID0gZ2V0Q2xhc3NDYWNoZShjdG9yLCBlZGl0b3JQcm9wTmFtZSk7XG4gICAgICAgIGlmIChjYWNoZSkge1xuICAgICAgICAgICAgdmFyIHZhbHVlID0gKHN0YXRpY1ZhbHVlICE9PSB1bmRlZmluZWQpID8gc3RhdGljVmFsdWUgOiBkZWNvcmF0ZWRWYWx1ZTtcbiAgICAgICAgICAgIHZhciBwcm90byA9IGdldFN1YkRpY3QoY2FjaGUsICdwcm90bycpO1xuICAgICAgICAgICAgZ2V0U3ViRGljdChwcm90bywgJ2VkaXRvcicpW2VkaXRvclByb3BOYW1lXSA9IHZhbHVlO1xuICAgICAgICB9XG4gICAgfSwgZWRpdG9yUHJvcE5hbWUpO1xufVxuXG5mdW5jdGlvbiBjcmVhdGVEdW1teURlY29yYXRvciAoYXJnQ2hlY2tGdW5jKSB7XG4gICAgcmV0dXJuIGFyZ0NoZWNrRnVuYyhmTk9QKTtcbn1cblxuLyoqXG4gKiAhI2VuXG4gKiBNYWtlcyBhIENDQ2xhc3MgdGhhdCBpbmhlcml0IGZyb20gY29tcG9uZW50IGV4ZWN1dGUgaW4gZWRpdCBtb2RlLjxicj5cbiAqIEJ5IGRlZmF1bHQsIGFsbCBjb21wb25lbnRzIGFyZSBvbmx5IGV4ZWN1dGVkIGluIHBsYXkgbW9kZSxcbiAqIHdoaWNoIG1lYW5zIHRoZXkgd2lsbCBub3QgaGF2ZSB0aGVpciBjYWxsYmFjayBmdW5jdGlvbnMgZXhlY3V0ZWQgd2hpbGUgdGhlIEVkaXRvciBpcyBpbiBlZGl0IG1vZGUuXG4gKiAhI3poXG4gKiDlhYHorrjnu6fmib/oh6ogQ29tcG9uZW50IOeahCBDQ0NsYXNzIOWcqOe8lui+keWZqOmHjOaJp+ihjOOAgjxicj5cbiAqIOm7mOiupOaDheWGteS4i++8jOaJgOaciSBDb21wb25lbnQg6YO95Y+q5Lya5Zyo6L+Q6KGM5pe25omN5Lya5omn6KGM77yM5Lmf5bCx5piv6K+05a6D5Lus55qE55Sf5ZG95ZGo5pyf5Zue6LCD5LiN5Lya5Zyo57yW6L6R5Zmo6YeM6Kem5Y+R44CCXG4gKlxuICogQG1ldGhvZCBleGVjdXRlSW5FZGl0TW9kZVxuICogQGV4YW1wbGVcbiAqIGNvbnN0IHtjY2NsYXNzLCBleGVjdXRlSW5FZGl0TW9kZX0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogJiM2NDtleGVjdXRlSW5FZGl0TW9kZVxuICogY2xhc3MgTmV3U2NyaXB0IGV4dGVuZHMgY2MuQ29tcG9uZW50IHtcbiAqICAgICAvLyAuLi5cbiAqIH1cbiAqIEB0eXBlc2NyaXB0XG4gKiBleGVjdXRlSW5FZGl0TW9kZSgpOiBGdW5jdGlvblxuICogZXhlY3V0ZUluRWRpdE1vZGUoX2NsYXNzOiBGdW5jdGlvbik6IHZvaWRcbiAqL1xudmFyIGV4ZWN1dGVJbkVkaXRNb2RlID0gKENDX0RFViA/IGNyZWF0ZUVkaXRvckRlY29yYXRvciA6IGNyZWF0ZUR1bW15RGVjb3JhdG9yKShjaGVja0N0b3JBcmd1bWVudCwgJ2V4ZWN1dGVJbkVkaXRNb2RlJywgdHJ1ZSk7XG5cbi8qKlxuICogISNlblxuICogQXV0b21hdGljYWxseSBhZGQgcmVxdWlyZWQgY29tcG9uZW50IGFzIGEgZGVwZW5kZW5jeSBmb3IgdGhlIENDQ2xhc3MgdGhhdCBpbmhlcml0IGZyb20gY29tcG9uZW50LlxuICogISN6aFxuICog5Li65aOw5piO5Li6IENDQ2xhc3Mg55qE57uE5Lu25re75Yqg5L6d6LWW55qE5YW25a6D57uE5Lu244CC5b2T57uE5Lu25re75Yqg5Yiw6IqC54K55LiK5pe277yM5aaC5p6c5L6d6LWW55qE57uE5Lu25LiN5a2Y5Zyo77yM5byV5pOO5bCG5Lya6Ieq5Yqo5bCG5L6d6LWW57uE5Lu25re75Yqg5Yiw5ZCM5LiA5Liq6IqC54K577yM6Ziy5q2i6ISa5pys5Ye66ZSZ44CC6K+l6K6+572u5Zyo6L+Q6KGM5pe25ZCM5qC35pyJ5pWI44CCXG4gKlxuICogQG1ldGhvZCByZXF1aXJlQ29tcG9uZW50XG4gKiBAcGFyYW0ge0NvbXBvbmVudH0gcmVxdWlyZWRDb21wb25lbnRcbiAqIEBleGFtcGxlXG4gKiBjb25zdCB7Y2NjbGFzcywgcmVxdWlyZUNvbXBvbmVudH0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogJiM2NDtyZXF1aXJlQ29tcG9uZW50KGNjLlNwcml0ZSlcbiAqIGNsYXNzIFNwcml0ZUN0cmwgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIHJlcXVpcmVDb21wb25lbnQocmVxdWlyZWRDb21wb25lbnQ6IHR5cGVvZiBjYy5Db21wb25lbnQpOiBGdW5jdGlvblxuICovXG52YXIgcmVxdWlyZUNvbXBvbmVudCA9IGNyZWF0ZUVkaXRvckRlY29yYXRvcihjaGVja0NvbXBBcmd1bWVudCwgJ3JlcXVpcmVDb21wb25lbnQnKTtcblxuLyoqXG4gKiAhI2VuXG4gKiBUaGUgbWVudSBwYXRoIHRvIHJlZ2lzdGVyIGEgY29tcG9uZW50IHRvIHRoZSBlZGl0b3JzIFwiQ29tcG9uZW50XCIgbWVudS4gRWcuIFwiUmVuZGVyaW5nL0NhbWVyYUN0cmxcIi5cbiAqICEjemhcbiAqIOWwhuW9k+WJjee7hOS7tua3u+WKoOWIsOe7hOS7tuiPnOWNleS4re+8jOaWueS+v+eUqOaIt+afpeaJvuOAguS+i+WmgiBcIlJlbmRlcmluZy9DYW1lcmFDdHJsXCLjgIJcbiAqXG4gKiBAbWV0aG9kIG1lbnVcbiAqIEBwYXJhbSB7U3RyaW5nfSBwYXRoIC0gVGhlIHBhdGggaXMgdGhlIG1lbnUgcmVwcmVzZW50ZWQgbGlrZSBhIHBhdGhuYW1lLlxuICogICAgICAgICAgICAgICAgICAgICAgICBGb3IgZXhhbXBsZSB0aGUgbWVudSBjb3VsZCBiZSBcIlJlbmRlcmluZy9DYW1lcmFDdHJsXCIuXG4gKiBAZXhhbXBsZVxuICogY29uc3Qge2NjY2xhc3MsIG1lbnV9ID0gY2MuX2RlY29yYXRvcjtcbiAqXG4gKiAmIzY0O2NjY2xhc3NcbiAqICYjNjQ7bWVudShcIlJlbmRlcmluZy9DYW1lcmFDdHJsXCIpXG4gKiBjbGFzcyBOZXdTY3JpcHQgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIG1lbnUocGF0aDogc3RyaW5nKTogRnVuY3Rpb25cbiAqL1xudmFyIG1lbnUgPSAoQ0NfREVWID8gY3JlYXRlRWRpdG9yRGVjb3JhdG9yIDogY3JlYXRlRHVtbXlEZWNvcmF0b3IpKGNoZWNrU3RyaW5nQXJndW1lbnQsICdtZW51Jyk7XG5cbi8qKlxuICogISNlblxuICogVGhlIGV4ZWN1dGlvbiBvcmRlciBvZiBsaWZlY3ljbGUgbWV0aG9kcyBmb3IgQ29tcG9uZW50LlxuICogVGhvc2UgbGVzcyB0aGFuIDAgd2lsbCBleGVjdXRlIGJlZm9yZSB3aGlsZSB0aG9zZSBncmVhdGVyIHRoYW4gMCB3aWxsIGV4ZWN1dGUgYWZ0ZXIuXG4gKiBUaGUgb3JkZXIgd2lsbCBvbmx5IGFmZmVjdCBvbkxvYWQsIG9uRW5hYmxlLCBzdGFydCwgdXBkYXRlIGFuZCBsYXRlVXBkYXRlIHdoaWxlIG9uRGlzYWJsZSBhbmQgb25EZXN0cm95IHdpbGwgbm90IGJlIGFmZmVjdGVkLlxuICogISN6aFxuICog6K6+572u6ISa5pys55Sf5ZG95ZGo5pyf5pa55rOV6LCD55So55qE5LyY5YWI57qn44CC5LyY5YWI57qn5bCP5LqOIDAg55qE57uE5Lu25bCG5Lya5LyY5YWI5omn6KGM77yM5LyY5YWI57qn5aSn5LqOIDAg55qE57uE5Lu25bCG5Lya5bu25ZCO5omn6KGM44CC5LyY5YWI57qn5LuF5Lya5b2x5ZONIG9uTG9hZCwgb25FbmFibGUsIHN0YXJ0LCB1cGRhdGUg5ZKMIGxhdGVVcGRhdGXvvIzogIwgb25EaXNhYmxlIOWSjCBvbkRlc3Ryb3kg5LiN5Y+X5b2x5ZON44CCXG4gKlxuICogQG1ldGhvZCBleGVjdXRpb25PcmRlclxuICogQHBhcmFtIHtOdW1iZXJ9IG9yZGVyIC0gVGhlIGV4ZWN1dGlvbiBvcmRlciBvZiBsaWZlY3ljbGUgbWV0aG9kcyBmb3IgQ29tcG9uZW50LiBUaG9zZSBsZXNzIHRoYW4gMCB3aWxsIGV4ZWN1dGUgYmVmb3JlIHdoaWxlIHRob3NlIGdyZWF0ZXIgdGhhbiAwIHdpbGwgZXhlY3V0ZSBhZnRlci5cbiAqIEBleGFtcGxlXG4gKiBjb25zdCB7Y2NjbGFzcywgZXhlY3V0aW9uT3JkZXJ9ID0gY2MuX2RlY29yYXRvcjtcbiAqXG4gKiAmIzY0O2NjY2xhc3NcbiAqICYjNjQ7ZXhlY3V0aW9uT3JkZXIoMSlcbiAqIGNsYXNzIENhbWVyYUN0cmwgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIGV4ZWN1dGlvbk9yZGVyKG9yZGVyOiBudW1iZXIpOiBGdW5jdGlvblxuICovXG52YXIgZXhlY3V0aW9uT3JkZXIgPSBjcmVhdGVFZGl0b3JEZWNvcmF0b3IoY2hlY2tOdW1iZXJBcmd1bWVudCwgJ2V4ZWN1dGlvbk9yZGVyJyk7XG5cbi8qKlxuICogISNlblxuICogUHJldmVudHMgQ29tcG9uZW50IG9mIHRoZSBzYW1lIHR5cGUgKG9yIHN1YnR5cGUpIHRvIGJlIGFkZGVkIG1vcmUgdGhhbiBvbmNlIHRvIGEgTm9kZS5cbiAqICEjemhcbiAqIOmYsuatouWkmuS4quebuOWQjOexu+Wei++8iOaIluWtkOexu+Wei++8ieeahOe7hOS7tuiiq+a3u+WKoOWIsOWQjOS4gOS4quiKgueCueOAglxuICpcbiAqIEBtZXRob2QgZGlzYWxsb3dNdWx0aXBsZVxuICogQGV4YW1wbGVcbiAqIGNvbnN0IHtjY2NsYXNzLCBkaXNhbGxvd011bHRpcGxlfSA9IGNjLl9kZWNvcmF0b3I7XG4gKlxuICogJiM2NDtjY2NsYXNzXG4gKiAmIzY0O2Rpc2FsbG93TXVsdGlwbGVcbiAqIGNsYXNzIENhbWVyYUN0cmwgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIGRpc2FsbG93TXVsdGlwbGUoKTogRnVuY3Rpb25cbiAqIGRpc2FsbG93TXVsdGlwbGUoX2NsYXNzOiBGdW5jdGlvbik6IHZvaWRcbiAqL1xudmFyIGRpc2FsbG93TXVsdGlwbGUgPSAoQ0NfREVWID8gY3JlYXRlRWRpdG9yRGVjb3JhdG9yIDogY3JlYXRlRHVtbXlEZWNvcmF0b3IpKGNoZWNrQ3RvckFyZ3VtZW50LCAnZGlzYWxsb3dNdWx0aXBsZScpO1xuXG4vKipcbiAqICEjZW5cbiAqIElmIHNwZWNpZmllZCwgdGhlIGVkaXRvcidzIHNjZW5lIHZpZXcgd2lsbCBrZWVwIHVwZGF0aW5nIHRoaXMgbm9kZSBpbiA2MCBmcHMgd2hlbiBpdCBpcyBzZWxlY3RlZCwgb3RoZXJ3aXNlLCBpdCB3aWxsIHVwZGF0ZSBvbmx5IGlmIG5lY2Vzc2FyeS48YnI+XG4gKiBUaGlzIHByb3BlcnR5IGlzIG9ubHkgYXZhaWxhYmxlIGlmIGV4ZWN1dGVJbkVkaXRNb2RlIGlzIHRydWUuXG4gKiAhI3poXG4gKiDlvZPmjIflrprkuoYgXCJleGVjdXRlSW5FZGl0TW9kZVwiIOS7peWQju+8jHBsYXlPbkZvY3VzIOWPr+S7peWcqOmAieS4reW9k+WJjee7hOS7tuaJgOWcqOeahOiKgueCueaXtu+8jOaPkOmrmOe8lui+keWZqOeahOWcuuaZr+WIt+aWsOmikeeOh+WIsCA2MCBGUFPvvIzlkKbliJnlnLrmma/lsLHlj6rkvJrlnKjlv4XopoHnmoTml7blgJnov5vooYzph43nu5jjgIJcbiAqXG4gKiBAbWV0aG9kIHBsYXlPbkZvY3VzXG4gKiBAZXhhbXBsZVxuICogY29uc3Qge2NjY2xhc3MsIHBsYXlPbkZvY3VzLCBleGVjdXRlSW5FZGl0TW9kZX0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogJiM2NDtleGVjdXRlSW5FZGl0TW9kZVxuICogJiM2NDtwbGF5T25Gb2N1c1xuICogY2xhc3MgQ2FtZXJhQ3RybCBleHRlbmRzIGNjLkNvbXBvbmVudCB7XG4gKiAgICAgLy8gLi4uXG4gKiB9XG4gKiBAdHlwZXNjcmlwdFxuICogcGxheU9uRm9jdXMoKTogRnVuY3Rpb25cbiAqIHBsYXlPbkZvY3VzKF9jbGFzczogRnVuY3Rpb24pOiB2b2lkXG4gKi9cbnZhciBwbGF5T25Gb2N1cyA9IChDQ19ERVYgPyBjcmVhdGVFZGl0b3JEZWNvcmF0b3IgOiBjcmVhdGVEdW1teURlY29yYXRvcikoY2hlY2tDdG9yQXJndW1lbnQsICdwbGF5T25Gb2N1cycsIHRydWUpO1xuXG4vKipcbiAqICEjZW5cbiAqIFNwZWNpZnlpbmcgdGhlIHVybCBvZiB0aGUgY3VzdG9tIGh0bWwgdG8gZHJhdyB0aGUgY29tcG9uZW50IGluICoqUHJvcGVydGllcyoqLlxuICogISN6aFxuICog6Ieq5a6a5LmJ5b2T5YmN57uE5Lu25ZyoICoq5bGe5oCn5qOA5p+l5ZmoKiog5Lit5riy5p+T5pe25omA55So55qE572R6aG1IHVybOOAglxuICpcbiAqIEBtZXRob2QgaW5zcGVjdG9yXG4gKiBAcGFyYW0ge1N0cmluZ30gdXJsXG4gKiBAZXhhbXBsZVxuICogY29uc3Qge2NjY2xhc3MsIGluc3BlY3Rvcn0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogJiM2NDtpbnNwZWN0b3IoXCJwYWNrYWdlczovL2luc3BlY3Rvci9pbnNwZWN0b3JzL2NvbXBzL2NhbWVyYS1jdHJsLmpzXCIpXG4gKiBjbGFzcyBOZXdTY3JpcHQgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIGluc3BlY3RvcihwYXRoOiBzdHJpbmcpOiBGdW5jdGlvblxuICovXG52YXIgaW5zcGVjdG9yID0gKENDX0RFViA/IGNyZWF0ZUVkaXRvckRlY29yYXRvciA6IGNyZWF0ZUR1bW15RGVjb3JhdG9yKShjaGVja1N0cmluZ0FyZ3VtZW50LCAnaW5zcGVjdG9yJyk7XG5cbi8qKlxuICogISNlblxuICogU3BlY2lmeWluZyB0aGUgdXJsIG9mIHRoZSBpY29uIHRvIGRpc3BsYXkgaW4gdGhlIGVkaXRvci5cbiAqICEjemhcbiAqIOiHquWumuS5ieW9k+WJjee7hOS7tuWcqOe8lui+keWZqOS4reaYvuekuueahOWbvuaghyB1cmzjgIJcbiAqXG4gKiBAbWV0aG9kIGljb25cbiAqIEBwYXJhbSB7U3RyaW5nfSB1cmxcbiAqIEBwcml2YXRlXG4gKiBAZXhhbXBsZVxuICogY29uc3Qge2NjY2xhc3MsIGljb259ID0gY2MuX2RlY29yYXRvcjtcbiAqXG4gKiAmIzY0O2NjY2xhc3NcbiAqICYjNjQ7aWNvbihcInh4eHgucG5nXCIpXG4gKiBjbGFzcyBOZXdTY3JpcHQgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuICogICAgIC8vIC4uLlxuICogfVxuICogQHR5cGVzY3JpcHRcbiAqIGljb24ocGF0aDogc3RyaW5nKTogRnVuY3Rpb25cbiAqL1xudmFyIGljb24gPSAoQ0NfREVWID8gY3JlYXRlRWRpdG9yRGVjb3JhdG9yIDogY3JlYXRlRHVtbXlEZWNvcmF0b3IpKGNoZWNrU3RyaW5nQXJndW1lbnQsICdpY29uJyk7XG5cbi8qKlxuICogISNlblxuICogVGhlIGN1c3RvbSBkb2N1bWVudGF0aW9uIFVSTC5cbiAqICEjemhcbiAqIOaMh+WumuW9k+WJjee7hOS7tueahOW4ruWKqeaWh+aho+eahCB1cmzvvIzorr7nva7ov4flkI7vvIzlnKggKirlsZ7mgKfmo4Dmn6XlmagqKiDkuK3lsLHkvJrlh7rnjrDkuIDkuKrluK7liqnlm77moIfvvIznlKjmiLfngrnlh7vlsIbmiZPlvIDmjIflrprnmoTnvZHpobXjgIJcbiAqXG4gKiBAbWV0aG9kIGhlbHBcbiAqIEBwYXJhbSB7U3RyaW5nfSB1cmxcbiAqIEBleGFtcGxlXG4gKiBjb25zdCB7Y2NjbGFzcywgaGVscH0gPSBjYy5fZGVjb3JhdG9yO1xuICpcbiAqICYjNjQ7Y2NjbGFzc1xuICogJiM2NDtoZWxwKFwiYXBwOi8vZG9jcy9odG1sL2NvbXBvbmVudHMvc3BpbmUuaHRtbFwiKVxuICogY2xhc3MgTmV3U2NyaXB0IGV4dGVuZHMgY2MuQ29tcG9uZW50IHtcbiAqICAgICAvLyAuLi5cbiAqIH1cbiAqIEB0eXBlc2NyaXB0XG4gKiBoZWxwKHBhdGg6IHN0cmluZyk6IEZ1bmN0aW9uXG4gKi9cbnZhciBoZWxwID0gKENDX0RFViA/IGNyZWF0ZUVkaXRvckRlY29yYXRvciA6IGNyZWF0ZUR1bW15RGVjb3JhdG9yKShjaGVja1N0cmluZ0FyZ3VtZW50LCAnaGVscCcpO1xuXG4vLyBPdGhlciBEZWNvcmF0b3JzXG5cbi8qKlxuICogTk9URTo8YnI+XG4gKiBUaGUgb2xkIG1peGlucyBpbXBsZW1lbnRlZCBpbiBjYy5DbGFzcyhFUzUpIGJlaGF2ZXMgZXhhY3QgdGhlIHNhbWUgYXMgbXVsdGlwbGUgaW5oZXJpdGFuY2UuXG4gKiBCdXQgc2luY2UgRVM2LCBjbGFzcyBjb25zdHJ1Y3RvciBjYW4ndCBiZSBmdW5jdGlvbi1jYWxsZWQgYW5kIGNsYXNzIG1ldGhvZHMgYmVjb21lIG5vbi1lbnVtZXJhYmxlLFxuICogc28gd2UgY2FuIG5vdCBtaXggaW4gRVM2IENsYXNzZXMuPGJyPlxuICogU2VlOjxicj5cbiAqIFtodHRwczovL2VzZGlzY3Vzcy5vcmcvdG9waWMvdHJhaXRzLWFyZS1ub3ctaW1wb3NzaWJsZS1pbi1lczYtdW50aWwtZXM3LXNpbmNlLXJldjMyXShodHRwczovL2VzZGlzY3Vzcy5vcmcvdG9waWMvdHJhaXRzLWFyZS1ub3ctaW1wb3NzaWJsZS1pbi1lczYtdW50aWwtZXM3LXNpbmNlLXJldjMyKTxicj5cbiAqIE9uZSBwb3NzaWJsZSBzb2x1dGlvbiAoYnV0IElERSB1bmZyaWVuZGx5KTo8YnI+XG4gKiBbaHR0cDovL2p1c3RpbmZhZ25hbmkuY29tLzIwMTUvMTIvMjEvcmVhbC1taXhpbnMtd2l0aC1qYXZhc2NyaXB0LWNsYXNzZXNdKGh0dHA6Ly9qdXN0aW5mYWduYW5pLmNvbS8yMDE1LzEyLzIxL3JlYWwtbWl4aW5zLXdpdGgtamF2YXNjcmlwdC1jbGFzc2VzLyk8YnI+XG4gKiA8YnI+XG4gKiBOT1RFOjxicj5cbiAqIFlvdSBtdXN0IG1hbnVhbGx5IGNhbGwgbWl4aW5zIGNvbnN0cnVjdG9yLCB0aGlzIGlzIGRpZmZlcmVudCBmcm9tIGNjLkNsYXNzKEVTNSkuXG4gKlxuICogQG1ldGhvZCBtaXhpbnNcbiAqIEBwYXJhbSB7RnVuY3Rpb259IC4uLmN0b3IgLSBjb25zdHJ1Y3RvcnMgdG8gbWl4LCBvbmx5IHN1cHBvcnQgRVM1IGNvbnN0cnVjdG9ycyBvciBjbGFzc2VzIGRlZmluZWQgYnkgdXNpbmcgYGNjLkNsYXNzYCxcbiAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICBub3Qgc3VwcG9ydCBFUzYgQ2xhc3Nlcy5cbiAqIEBleGFtcGxlXG4gKiBjb25zdCB7Y2NjbGFzcywgbWl4aW5zfSA9IGNjLl9kZWNvcmF0b3I7XG4gKlxuICogY2xhc3MgQW5pbWFsIHsgLi4uIH1cbiAqXG4gKiBjb25zdCBGbHkgPSBjYy5DbGFzcyh7XG4gKiAgICAgY29uc3RydWN0b3IgKCkgeyAuLi4gfVxuICogfSk7XG4gKlxuICogJiM2NDtjY2NsYXNzXG4gKiAmIzY0O21peGlucyhjYy5FdmVudFRhcmdldCwgRmx5KVxuICogY2xhc3MgQmlyZCBleHRlbmRzIEFuaW1hbCB7XG4gKiAgICAgY29uc3RydWN0b3IgKCkge1xuICogICAgICAgICBzdXBlcigpO1xuICpcbiAqICAgICAgICAgLy8gWW91IG11c3QgbWFudWFsbHkgY2FsbCBtaXhpbnMgY29uc3RydWN0b3IsIHRoaXMgaXMgZGlmZmVyZW50IGZyb20gY2MuQ2xhc3MoRVM1KVxuICogICAgICAgICBjYy5FdmVudFRhcmdldC5jYWxsKHRoaXMpO1xuICogICAgICAgICBGbHkuY2FsbCh0aGlzKTtcbiAqICAgICB9XG4gKiAgICAgLy8gLi4uXG4gKiB9XG4gKiBAdHlwZXNjcmlwdFxuICogbWl4aW5zKGN0b3I6IEZ1bmN0aW9uLCAuLi5yZXN0OiBGdW5jdGlvbltdKTogRnVuY3Rpb25cbiAqL1xuZnVuY3Rpb24gbWl4aW5zICgpIHtcbiAgICB2YXIgbWl4aW5zID0gW107XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBhcmd1bWVudHMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgbWl4aW5zW2ldID0gYXJndW1lbnRzW2ldO1xuICAgIH1cbiAgICByZXR1cm4gZnVuY3Rpb24gKGN0b3IpIHtcbiAgICAgICAgdmFyIGNhY2hlID0gZ2V0Q2xhc3NDYWNoZShjdG9yLCAnbWl4aW5zJyk7XG4gICAgICAgIGlmIChjYWNoZSkge1xuICAgICAgICAgICAgZ2V0U3ViRGljdChjYWNoZSwgJ3Byb3RvJykubWl4aW5zID0gbWl4aW5zO1xuICAgICAgICB9XG4gICAgfVxufVxuXG5jYy5fZGVjb3JhdG9yID0gbW9kdWxlLmV4cG9ydHMgPSB7XG4gICAgY2NjbGFzcyxcbiAgICBwcm9wZXJ0eSxcbiAgICBleGVjdXRlSW5FZGl0TW9kZSxcbiAgICByZXF1aXJlQ29tcG9uZW50LFxuICAgIG1lbnUsXG4gICAgZXhlY3V0aW9uT3JkZXIsXG4gICAgZGlzYWxsb3dNdWx0aXBsZSxcbiAgICBwbGF5T25Gb2N1cyxcbiAgICBpbnNwZWN0b3IsXG4gICAgaWNvbixcbiAgICBoZWxwLFxuICAgIG1peGlucyxcbn07XG5cbi8vIGZpeCBzdWJtb2R1bGUgcG9sbHV0ZSAuLi5cbi8qKlxuICogQHN1Ym1vZHVsZSBjY1xuICovXG4iXSwic291cmNlUm9vdCI6Ii8ifQ==