
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/physics/platform/CCPhysicsDebugDraw.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var PTM_RATIO = require('../CCPhysicsTypes').PTM_RATIO;

var _tmp_vec2 = cc.v2();

var GREEN_COLOR = cc.Color.GREEN;
var RED_COLOR = cc.Color.RED;

function PhysicsDebugDraw(drawer) {
  b2.Draw.call(this);
  this._drawer = drawer;
  this._xf = this._dxf = new b2.Transform();
}

cc.js.extend(PhysicsDebugDraw, b2.Draw);
cc.js.mixin(PhysicsDebugDraw.prototype, {
  _DrawPolygon: function _DrawPolygon(vertices, vertexCount) {
    var drawer = this._drawer;

    for (var i = 0; i < vertexCount; i++) {
      b2.Transform.MulXV(this._xf, vertices[i], _tmp_vec2);
      var x = _tmp_vec2.x * PTM_RATIO,
          y = _tmp_vec2.y * PTM_RATIO;
      if (i === 0) drawer.moveTo(x, y);else {
        drawer.lineTo(x, y);
      }
    }

    drawer.close();
  },
  DrawPolygon: function DrawPolygon(vertices, vertexCount, color) {
    this._applyStrokeColor(color);

    this._DrawPolygon(vertices, vertexCount);

    this._drawer.stroke();
  },
  DrawSolidPolygon: function DrawSolidPolygon(vertices, vertexCount, color) {
    this._applyFillColor(color);

    this._DrawPolygon(vertices, vertexCount);

    this._drawer.fill();

    this._drawer.stroke();
  },
  _DrawCircle: function _DrawCircle(center, radius) {
    var p = this._xf.p;

    this._drawer.circle((center.x + p.x) * PTM_RATIO, (center.y + p.y) * PTM_RATIO, radius * PTM_RATIO);
  },
  DrawCircle: function DrawCircle(center, radius, color) {
    this._applyStrokeColor(color);

    this._DrawCircle(center, radius);

    this._drawer.stroke();
  },
  DrawSolidCircle: function DrawSolidCircle(center, radius, axis, color) {
    this._applyFillColor(color);

    this._DrawCircle(center, radius);

    this._drawer.fill();
  },
  DrawSegment: function DrawSegment(p1, p2, color) {
    var drawer = this._drawer;

    if (p1.x === p2.x && p1.y === p2.y) {
      this._applyFillColor(color);

      this._DrawCircle(p1, 2 / PTM_RATIO);

      drawer.fill();
      return;
    }

    this._applyStrokeColor(color);

    b2.Transform.MulXV(this._xf, p1, _tmp_vec2);
    drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    b2.Transform.MulXV(this._xf, p2, _tmp_vec2);
    drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    drawer.stroke();
  },
  DrawTransform: function DrawTransform(xf) {
    var drawer = this._drawer;
    drawer.strokeColor = RED_COLOR;
    _tmp_vec2.x = _tmp_vec2.y = 0;
    b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
    drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    _tmp_vec2.x = 1;
    _tmp_vec2.y = 0;
    b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
    drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    drawer.stroke();
    drawer.strokeColor = GREEN_COLOR;
    _tmp_vec2.x = _tmp_vec2.y = 0;
    b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
    drawer.moveTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    _tmp_vec2.x = 0;
    _tmp_vec2.y = 1;
    b2.Transform.MulXV(xf, _tmp_vec2, _tmp_vec2);
    drawer.lineTo(_tmp_vec2.x * PTM_RATIO, _tmp_vec2.y * PTM_RATIO);
    drawer.stroke();
  },
  DrawPoint: function DrawPoint(center, radius, color) {},
  _applyStrokeColor: function _applyStrokeColor(color) {
    var strokeColor = this._drawer.strokeColor;
    strokeColor.r = color.r * 255;
    strokeColor.g = color.g * 255;
    strokeColor.b = color.b * 255;
    strokeColor.a = 150;
    this._drawer.strokeColor = strokeColor;
  },
  _applyFillColor: function _applyFillColor(color) {
    var fillColor = this._drawer.fillColor;
    fillColor.r = color.r * 255;
    fillColor.g = color.g * 255;
    fillColor.b = color.b * 255;
    fillColor.a = 150;
    this._drawer.fillColor = fillColor;
  },
  PushTransform: function PushTransform(xf) {
    this._xf = xf;
  },
  PopTransform: function PopTransform() {
    this._xf = this._dxf;
  }
});
module.exports = PhysicsDebugDraw;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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