
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/physics/collider/CCPhysicsChainCollider.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var PTM_RATIO = require('../CCPhysicsTypes').PTM_RATIO;
/**
 * @class PhysicsChainCollider
 * @extends PolygonCollider
 */


var PhysicsChainCollider = cc.Class({
  name: 'cc.PhysicsChainCollider',
  "extends": cc.PhysicsCollider,
  editor: {
    menu: CC_EDITOR && 'i18n:MAIN_MENU.component.physics/Collider/Chain',
    inspector: CC_EDITOR && 'packages://inspector/inspectors/comps/physics/points-base-collider.js',
    requireComponent: cc.RigidBody
  },
  properties: {
    /**
     * !#en Whether the chain is loop
     * !#zh 链条是否首尾相连
     * @property loop
     * @type {Boolean}
     */
    loop: false,

    /**
     * !#en Chain points
     * !#zh 链条顶点数组
     * @property points
     * @type {Vec2[]}
     */
    points: {
      "default": function _default() {
        return [cc.v2(-50, 0), cc.v2(50, 0)];
      },
      type: [cc.Vec2]
    },
    threshold: {
      "default": 1,
      serializable: false,
      visible: false
    }
  },
  _createShape: function _createShape(scale) {
    var shape = new b2.ChainShape();
    var points = this.points;
    var vertices = [];

    for (var i = 0; i < points.length; i++) {
      var p = points[i];
      vertices.push(new b2.Vec2(p.x / PTM_RATIO * scale.x, p.y / PTM_RATIO * scale.y));
    }

    if (this.loop) {
      shape.CreateLoop(vertices, vertices.length);
    } else {
      shape.CreateChain(vertices, vertices.length);
    }

    return shape;
  },
  resetInEditor: CC_EDITOR && function () {
    this.resetPointsByContour();
  },
  resetPointsByContour: CC_EDITOR && function () {
    var PhysicsUtils = Editor.require('scene://utils/physics');

    PhysicsUtils.resetPoints(this, {
      threshold: this.threshold,
      loop: this.loop
    });
  }
});
cc.PhysicsChainCollider = module.exports = PhysicsChainCollider;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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