
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/physics/CCPolygonSeparator.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// http://answers.unity3d.com/questions/977416/2d-polygon-convex-decomposition-code.html
/// <summary>
/// This class is took from the "FarseerUnity" physics engine, which uses Mark Bayazit's decomposition algorithm.
/// I also have to make it work with self-intersecting polygons, so I'll use another different algorithm to decompose a self-intersecting polygon into several simple polygons,
/// and then I would decompose each of them into convex polygons.
/// </summary>
//From phed rev 36
/// <summary>
/// Convex decomposition algorithm created by Mark Bayazit (http://mnbayazit.com/)
/// For more information about this algorithm, see http://mnbayazit.com/406/bayazit
/// </summary>
function At(i, vertices) {
  var s = vertices.length;
  return vertices[i < 0 ? s - -i % s : i % s];
}

function Copy(i, j, vertices) {
  var p = [];

  while (j < i) {
    j += vertices.length;
  } //p.reserve(j - i + 1);


  for (; i <= j; ++i) {
    p.push(At(i, vertices));
  }

  return p;
} /// <summary>
/// Decompose the polygon into several smaller non-concave polygon.
/// If the polygon is already convex, it will return the original polygon, unless it is over Settings.MaxPolygonVertices.
/// Precondition: Counter Clockwise polygon
/// </summary>
/// <param name="vertices"></param>
/// <returns></returns>


function ConvexPartition(vertices) {
  //We force it to CCW as it is a precondition in this algorithm.
  ForceCounterClockWise(vertices);
  var list = [];
  var d, lowerDist, upperDist;
  var p;
  var lowerInt = cc.v2();
  var upperInt = cc.v2(); // intersection points

  var lowerIndex = 0,
      upperIndex = 0;
  var lowerPoly, upperPoly;

  for (var i = 0; i < vertices.length; ++i) {
    if (Reflex(i, vertices)) {
      lowerDist = upperDist = 10e7; // std::numeric_limits<qreal>::max();

      for (var j = 0; j < vertices.length; ++j) {
        // if line intersects with an edge
        if (Left(At(i - 1, vertices), At(i, vertices), At(j, vertices)) && RightOn(At(i - 1, vertices), At(i, vertices), At(j - 1, vertices))) {
          // find the povar of intersection
          p = LineIntersect(At(i - 1, vertices), At(i, vertices), At(j, vertices), At(j - 1, vertices));

          if (Right(At(i + 1, vertices), At(i, vertices), p)) {
            // make sure it's inside the poly
            d = SquareDist(At(i, vertices), p);

            if (d < lowerDist) {
              // keep only the closest intersection
              lowerDist = d;
              lowerInt = p;
              lowerIndex = j;
            }
          }
        }

        if (Left(At(i + 1, vertices), At(i, vertices), At(j + 1, vertices)) && RightOn(At(i + 1, vertices), At(i, vertices), At(j, vertices))) {
          p = LineIntersect(At(i + 1, vertices), At(i, vertices), At(j, vertices), At(j + 1, vertices));

          if (Left(At(i - 1, vertices), At(i, vertices), p)) {
            d = SquareDist(At(i, vertices), p);

            if (d < upperDist) {
              upperDist = d;
              upperIndex = j;
              upperInt = p;
            }
          }
        }
      } // if there are no vertices to connect to, choose a povar in the middle


      if (lowerIndex == (upperIndex + 1) % vertices.length) {
        var sp = lowerInt.add(upperInt).div(2);
        lowerPoly = Copy(i, upperIndex, vertices);
        lowerPoly.push(sp);
        upperPoly = Copy(lowerIndex, i, vertices);
        upperPoly.push(sp);
      } else {
        var highestScore = 0,
            bestIndex = lowerIndex;

        while (upperIndex < lowerIndex) {
          upperIndex += vertices.length;
        }

        for (var j = lowerIndex; j <= upperIndex; ++j) {
          if (CanSee(i, j, vertices)) {
            var score = 1 / (SquareDist(At(i, vertices), At(j, vertices)) + 1);

            if (Reflex(j, vertices)) {
              if (RightOn(At(j - 1, vertices), At(j, vertices), At(i, vertices)) && LeftOn(At(j + 1, vertices), At(j, vertices), At(i, vertices))) {
                score += 3;
              } else {
                score += 2;
              }
            } else {
              score += 1;
            }

            if (score > highestScore) {
              bestIndex = j;
              highestScore = score;
            }
          }
        }

        lowerPoly = Copy(i, bestIndex, vertices);
        upperPoly = Copy(bestIndex, i, vertices);
      }

      list = list.concat(ConvexPartition(lowerPoly));
      list = list.concat(ConvexPartition(upperPoly));
      return list;
    }
  } // polygon is already convex


  list.push(vertices); //Remove empty vertice collections

  for (var i = list.length - 1; i >= 0; i--) {
    if (list[i].length == 0) list.splice(i, 0);
  }

  return list;
}

function CanSee(i, j, vertices) {
  if (Reflex(i, vertices)) {
    if (LeftOn(At(i, vertices), At(i - 1, vertices), At(j, vertices)) && RightOn(At(i, vertices), At(i + 1, vertices), At(j, vertices))) return false;
  } else {
    if (RightOn(At(i, vertices), At(i + 1, vertices), At(j, vertices)) || LeftOn(At(i, vertices), At(i - 1, vertices), At(j, vertices))) return false;
  }

  if (Reflex(j, vertices)) {
    if (LeftOn(At(j, vertices), At(j - 1, vertices), At(i, vertices)) && RightOn(At(j, vertices), At(j + 1, vertices), At(i, vertices))) return false;
  } else {
    if (RightOn(At(j, vertices), At(j + 1, vertices), At(i, vertices)) || LeftOn(At(j, vertices), At(j - 1, vertices), At(i, vertices))) return false;
  }

  for (var k = 0; k < vertices.length; ++k) {
    if ((k + 1) % vertices.length == i || k == i || (k + 1) % vertices.length == j || k == j) {
      continue; // ignore incident edges
    }

    var intersectionPoint = cc.v2();

    if (LineIntersect2(At(i, vertices), At(j, vertices), At(k, vertices), At(k + 1, vertices), intersectionPoint)) {
      return false;
    }
  }

  return true;
} // precondition: ccw


function Reflex(i, vertices) {
  return Right(i, vertices);
}

function Right(a, b, c) {
  if (typeof c === 'undefined') {
    var i = a,
        vertices = b;
    a = At(i - 1, vertices);
    b = At(i, vertices);
    c = At(i + 1, vertices);
  }

  return Area(a, b, c) < 0;
}

function Left(a, b, c) {
  return Area(a, b, c) > 0;
}

function LeftOn(a, b, c) {
  return Area(a, b, c) >= 0;
}

function RightOn(a, b, c) {
  return Area(a, b, c) <= 0;
}

function SquareDist(a, b) {
  var dx = b.x - a.x;
  var dy = b.y - a.y;
  return dx * dx + dy * dy;
} //forces counter clock wise order.


function ForceCounterClockWise(vertices) {
  if (!IsCounterClockWise(vertices)) {
    vertices.reverse();
  }
}

function IsCounterClockWise(vertices) {
  //We just return true for lines
  if (vertices.length < 3) return true;
  return GetSignedArea(vertices) > 0;
} //gets the signed area.


function GetSignedArea(vertices) {
  var i;
  var area = 0;

  for (i = 0; i < vertices.length; i++) {
    var j = (i + 1) % vertices.length;
    area += vertices[i].x * vertices[j].y;
    area -= vertices[i].y * vertices[j].x;
  }

  area /= 2;
  return area;
} //From Mark Bayazit's convex decomposition algorithm


function LineIntersect(p1, p2, q1, q2) {
  var i = cc.v2();
  var a1 = p2.y - p1.y;
  var b1 = p1.x - p2.x;
  var c1 = a1 * p1.x + b1 * p1.y;
  var a2 = q2.y - q1.y;
  var b2 = q1.x - q2.x;
  var c2 = a2 * q1.x + b2 * q1.y;
  var det = a1 * b2 - a2 * b1;

  if (!FloatEquals(det, 0)) {
    // lines are not parallel
    i.x = (b2 * c1 - b1 * c2) / det;
    i.y = (a1 * c2 - a2 * c1) / det;
  }

  return i;
} //from Eric Jordan's convex decomposition library, it checks if the lines a0->a1 and b0->b1 cross.
//if they do, intersectionPovar will be filled with the povar of crossing. Grazing lines should not return true.


function LineIntersect2(a0, a1, b0, b1, intersectionPoint) {
  if (a0 == b0 || a0 == b1 || a1 == b0 || a1 == b1) return false;
  var x1 = a0.x;
  var y1 = a0.y;
  var x2 = a1.x;
  var y2 = a1.y;
  var x3 = b0.x;
  var y3 = b0.y;
  var x4 = b1.x;
  var y4 = b1.y; //AABB early exit

  if (Math.max(x1, x2) < Math.min(x3, x4) || Math.max(x3, x4) < Math.min(x1, x2)) return false;
  if (Math.max(y1, y2) < Math.min(y3, y4) || Math.max(y3, y4) < Math.min(y1, y2)) return false;
  var ua = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
  var ub = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
  var denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);

  if (Math.abs(denom) < 10e-7) {
    //Lines are too close to parallel to call
    return false;
  }

  ua /= denom;
  ub /= denom;

  if (0 < ua && ua < 1 && 0 < ub && ub < 1) {
    intersectionPoint.x = x1 + ua * (x2 - x1);
    intersectionPoint.y = y1 + ua * (y2 - y1);
    return true;
  }

  return false;
}

function FloatEquals(value1, value2) {
  return Math.abs(value1 - value2) <= 10e-7;
} //returns a positive number if c is to the left of the line going from a to b. Positive number if povar is left, negative if povar is right, and 0 if points are collinear.</returns>


function Area(a, b, c) {
  return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
}

module.exports = {
  ConvexPartition: ConvexPartition,
  ForceCounterClockWise: ForceCounterClockWise,
  IsCounterClockWise: IsCounterClockWise
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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