
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/mesh/mesh-renderer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler = _interopRequireDefault(require("../renderer/assembler"));

var _gfx = _interopRequireDefault(require("../../renderer/gfx"));

var _vec = _interopRequireDefault(require("../value-types/vec3"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var MeshRenderer = require('./CCMeshRenderer');

var _tmp_vec3 = new _vec["default"]();

var MeshRendererAssembler =
/*#__PURE__*/
function (_Assembler) {
  _inheritsLoose(MeshRendererAssembler, _Assembler);

  function MeshRendererAssembler() {
    return _Assembler.apply(this, arguments) || this;
  }

  var _proto = MeshRendererAssembler.prototype;

  _proto.init = function init(renderComp) {
    _Assembler.prototype.init.call(this, renderComp);

    this._worldDatas = {};
    this._renderNode = null;
  };

  _proto.setRenderNode = function setRenderNode(node) {
    this._renderNode = node;
  };

  _proto.fillBuffers = function fillBuffers(comp, renderer) {
    if (!comp.mesh) return;

    comp.mesh._uploadData(); // update culling mask


    var isCullingMaskSame = renderer.cullingMask === comp.node._cullingMask;
    var enableAutoBatch = comp.enableAutoBatch;
    var materials = comp._materials;
    var submeshes = comp.mesh._subMeshes;
    var subDatas = comp.mesh.subDatas;

    for (var i = 0; i < submeshes.length; i++) {
      var ia = submeshes[i];
      var meshData = subDatas[i];
      var material = materials[i] || materials[0];

      if (!enableAutoBatch || !meshData.canBatch || ia._primitiveType !== _gfx["default"].PT_TRIANGLES) {
        renderer._flush();

        renderer.material = material;
        renderer.cullingMask = comp.node._cullingMask;
        renderer.node = this._renderNode;

        renderer._flushIA(ia);

        continue;
      }

      if (!isCullingMaskSame || material.getHash() !== renderer.material.getHash()) {
        renderer._flush();
      }

      renderer.material = material;
      renderer.cullingMask = comp.node._cullingMask;
      renderer.node = renderer._dummyNode;

      this._fillBuffer(comp, meshData, renderer, i);
    }

    if (CC_DEBUG && (cc.macro.SHOW_MESH_WIREFRAME || cc.macro.SHOW_MESH_NORMAL) && !(comp.node._cullingMask & 1 << cc.Node.BuiltinGroupIndex.DEBUG)) {
      renderer._flush();

      renderer.node = this._renderNode;

      comp._updateDebugDatas();

      if (cc.macro.SHOW_MESH_WIREFRAME) {
        this._drawDebugDatas(comp, renderer, 'wireFrame');
      }

      if (cc.macro.SHOW_MESH_NORMAL) {
        this._drawDebugDatas(comp, renderer, 'normal');
      }
    }
  };

  _proto._fillBuffer = function _fillBuffer(comp, meshData, renderer, dataIndex) {
    var vData = meshData.getVData(Float32Array);
    var vtxFormat = meshData.vfm;
    var vertexCount = vData.byteLength / vtxFormat._bytes | 0;
    var indices = meshData.getIData(Uint16Array);
    var indicesCount = indices.length;
    var buffer = renderer.getBuffer('mesh', vtxFormat);
    var offsetInfo = buffer.request(vertexCount, indicesCount); // buffer data may be realloc, need get reference after request.

    var indiceOffset = offsetInfo.indiceOffset,
        vertexOffset = offsetInfo.byteOffset >> 2,
        vertexId = offsetInfo.vertexOffset,
        vbuf = buffer._vData,
        ibuf = buffer._iData;

    if (renderer.worldMatDirty || !this._worldDatas[dataIndex]) {
      this._updateWorldVertices(dataIndex, vertexCount, vData, vtxFormat, comp.node._worldMatrix);
    }

    vbuf.set(this._worldDatas[dataIndex], vertexOffset);

    for (var i = 0; i < indicesCount; i++) {
      ibuf[indiceOffset + i] = vertexId + indices[i];
    }
  };

  _proto._updateWorldVertices = function _updateWorldVertices(dataIndex, vertexCount, local, vtxFormat, wolrdMatrix) {
    var world = this._worldDatas[dataIndex];

    if (!world) {
      world = this._worldDatas[dataIndex] = new Float32Array(local.length);
      world.set(local);
    }

    var floatCount = vtxFormat._bytes / 4;
    var elements = vtxFormat._elements;

    for (var i = 0, n = elements.length; i < n; i++) {
      var element = elements[i];
      var attrOffset = element.offset / 4;

      if (element.name === _gfx["default"].ATTR_POSITION || element.name === _gfx["default"].ATTR_NORMAL) {
        var transformMat4 = element.name === _gfx["default"].ATTR_NORMAL ? _vec["default"].transformMat4Normal : _vec["default"].transformMat4;

        for (var j = 0; j < vertexCount; j++) {
          var offset = j * floatCount + attrOffset;
          _tmp_vec3.x = local[offset];
          _tmp_vec3.y = local[offset + 1];
          _tmp_vec3.z = local[offset + 2];
          transformMat4(_tmp_vec3, _tmp_vec3, wolrdMatrix);
          world[offset] = _tmp_vec3.x;
          world[offset + 1] = _tmp_vec3.y;
          world[offset + 2] = _tmp_vec3.z;
        }
      }
    }
  };

  _proto._drawDebugDatas = function _drawDebugDatas(comp, renderer, name) {
    var debugDatas = comp._debugDatas[name];
    if (!debugDatas) return;

    for (var i = 0; i < debugDatas.length; i++) {
      var debugData = debugDatas[i];
      if (!debugData) continue;
      var material = debugData.material;
      renderer.material = material;

      renderer._flushIA(debugData.ia);
    }
  };

  return MeshRendererAssembler;
}(_assembler["default"]);

exports["default"] = MeshRendererAssembler;

_assembler["default"].register(MeshRenderer, MeshRendererAssembler);

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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