
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/mesh/CCMeshRenderer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _gfx = _interopRequireDefault(require("../../renderer/gfx"));

var _inputAssembler = _interopRequireDefault(require("../../renderer/core/input-assembler"));

var _aabb = _interopRequireDefault(require("../geom-utils/aabb"));

var _meshUtil = require("../utils/mesh-util");

var _vec = _interopRequireDefault(require("../value-types/vec3"));

var _mat = _interopRequireDefault(require("../value-types/mat4"));

var _materialVariant = _interopRequireDefault(require("../assets/material/material-variant"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var RenderComponent = require('../components/CCRenderComponent');

var Mesh = require('./CCMesh');

var RenderFlow = require('../renderer/render-flow');

var Renderer = require('../renderer');

var Material = require('../assets/material/CCMaterial');
/**
 * !#en Shadow projection mode
 *
 * !#ch 阴影投射方式
 * @static
 * @enum MeshRenderer.ShadowCastingMode
 */


var ShadowCastingMode = cc.Enum({
  /**
   * !#en
   *
   * !#ch 关闭阴影投射
   * @property OFF
   * @readonly
   * @type {Number}
   */
  OFF: 0,

  /**
   * !#en
   *
   * !#ch 开启阴影投射，当阴影光产生的时候
   * @property ON
   * @readonly
   * @type {Number}
   */
  ON: 1 // /**
  //  * !#en
  //  *
  //  * !#ch 可以从网格的任意一遍投射出阴影
  //  * @property TWO_SIDED
  //  * @readonly
  //  * @type {Number}
  //  */
  // TWO_SIDED: 2,
  // /**
  //  * !#en
  //  *
  //  * !#ch 只显示阴影
  //  * @property SHADOWS_ONLY
  //  * @readonly
  //  * @type {Number}
  //  */
  // SHADOWS_ONLY: 3,

});
/**
 * !#en
 * Mesh Renderer Component
 * !#zh
 * 网格渲染组件
 * @class MeshRenderer
 * @extends RenderComponent
 */

var MeshRenderer = cc.Class({
  name: 'cc.MeshRenderer',
  "extends": RenderComponent,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.mesh/MeshRenderer'
  },
  properties: {
    _mesh: {
      "default": null,
      type: Mesh
    },
    _receiveShadows: false,
    _shadowCastingMode: ShadowCastingMode.OFF,
    _enableAutoBatch: false,

    /**
     * !#en
     * The mesh which the renderer uses.
     * !#zh
     * 设置使用的网格
     * @property {Mesh} mesh
     */
    mesh: {
      get: function get() {
        return this._mesh;
      },
      set: function set(v) {
        if (this._mesh === v) return;

        this._setMesh(v);

        if (!v) {
          this.disableRender();
          return;
        }

        this.markForRender(true);
        this.node._renderFlag |= RenderFlow.FLAG_TRANSFORM;
      },
      type: Mesh,
      animatable: false
    },
    textures: {
      "default": [],
      type: cc.Texture2D,
      visible: false
    },

    /**
     * !#en
     * Whether the mesh should receive shadows.
     * !#zh
     * 网格是否接受光源投射的阴影
     * @property {Boolean} receiveShadows
     */
    receiveShadows: {
      get: function get() {
        return this._receiveShadows;
      },
      set: function set(val) {
        this._receiveShadows = val;

        this._updateReceiveShadow();
      },
      animatable: false
    },

    /**
     * !#en
     * Shadow Casting Mode
     * !#zh
     * 网格投射阴影的模式
     * @property {ShadowCastingMode} shadowCastingMode
     */
    shadowCastingMode: {
      get: function get() {
        return this._shadowCastingMode;
      },
      set: function set(val) {
        this._shadowCastingMode = val;

        this._updateCastShadow();
      },
      type: ShadowCastingMode,
      animatable: false
    },

    /**
     * !#en
     * Enable auto merge mesh, only support when mesh's VertexFormat, PrimitiveType, materials are all the same
     * !#zh 
     * 开启自动合并 mesh 功能，只有在网格的 顶点格式，PrimitiveType, 使用的材质 都一致的情况下才会有效
     * @property {Boolean} enableAutoBatch
     */
    enableAutoBatch: {
      get: function get() {
        return this._enableAutoBatch;
      },
      set: function set(val) {
        this._enableAutoBatch = val;
      }
    }
  },
  statics: {
    ShadowCastingMode: ShadowCastingMode
  },
  ctor: function ctor() {
    this._boundingBox = cc.geomUtils && new _aabb["default"]();

    if (CC_DEBUG) {
      this._debugDatas = {
        wireFrame: [],
        normal: []
      };
    }
  },
  onEnable: function onEnable() {
    var _this = this;

    this._super();

    if (this._mesh && !this._mesh.loaded) {
      this.disableRender();

      this._mesh.once('load', function () {
        if (!_this.isValid) return;

        _this._setMesh(_this._mesh);

        _this.markForRender(true);
      });

      (0, _meshUtil.postLoadMesh)(this._mesh);
    } else {
      this._setMesh(this._mesh);
    }

    this._updateRenderNode();

    this._updateMaterial();
  },
  onDestroy: function onDestroy() {
    this._setMesh(null);

    cc.pool.assembler.put(this._assembler);
  },
  _updateRenderNode: function _updateRenderNode() {
    this._assembler.setRenderNode(this.node);
  },
  _setMesh: function _setMesh(mesh) {
    if (cc.geomUtils && mesh) {
      _aabb["default"].fromPoints(this._boundingBox, mesh._minPos, mesh._maxPos);
    }

    if (this._mesh) {
      this._mesh.off('init-format', this._updateMeshAttribute, this);
    }

    if (mesh) {
      mesh.on('init-format', this._updateMeshAttribute, this);
    }

    this._mesh = mesh;

    this._updateMeshAttribute();
  },
  _getDefaultMaterial: function _getDefaultMaterial() {
    return Material.getBuiltinMaterial('unlit');
  },
  _validateRender: function _validateRender() {
    var mesh = this._mesh;

    if (mesh && mesh._subDatas.length > 0) {
      return;
    }

    this.disableRender();
  },
  _updateMaterial: function _updateMaterial() {
    // TODO: used to upgrade from 2.1, should be removed
    var textures = this.textures;

    if (textures && textures.length > 0) {
      var defaultMaterial = this._getDefaultMaterial();

      for (var i = 0; i < textures.length; i++) {
        var material = this._materials[i];
        if (material && material._uuid !== defaultMaterial._uuid) continue;

        if (!material) {
          material = _materialVariant["default"].create(defaultMaterial, this);
          this.setMaterial(i, material);
        }

        material.setProperty('diffuseTexture', textures[i]);
      }
    }

    this._updateReceiveShadow();

    this._updateCastShadow();

    this._updateMeshAttribute();
  },
  _updateReceiveShadow: function _updateReceiveShadow() {
    var materials = this.getMaterials();

    for (var i = 0; i < materials.length; i++) {
      materials[i].define('CC_USE_SHADOW_MAP', this._receiveShadows, undefined, true);
    }
  },
  _updateCastShadow: function _updateCastShadow() {
    var materials = this.getMaterials();

    for (var i = 0; i < materials.length; i++) {
      materials[i].define('CC_CASTING_SHADOW', this._shadowCastingMode === ShadowCastingMode.ON, undefined, true);
    }
  },
  _updateMeshAttribute: function _updateMeshAttribute() {
    var subDatas = this._mesh && this._mesh.subDatas;
    if (!subDatas) return;
    var materials = this.getMaterials();

    for (var i = 0; i < materials.length; i++) {
      if (!subDatas[i]) break;
      var vfm = subDatas[i].vfm;
      var material = materials[i];
      material.define('CC_USE_ATTRIBUTE_COLOR', !!vfm.element(_gfx["default"].ATTR_COLOR), undefined, true);
      material.define('CC_USE_ATTRIBUTE_UV0', !!vfm.element(_gfx["default"].ATTR_UV0), undefined, true);
      material.define('CC_USE_ATTRIBUTE_NORMAL', !!vfm.element(_gfx["default"].ATTR_NORMAL), undefined, true);
      material.define('CC_USE_ATTRIBUTE_TANGENT', !!vfm.element(_gfx["default"].ATTR_TANGENT), undefined, true);
    }

    if (CC_DEBUG) {
      for (var name in this._debugDatas) {
        this._debugDatas[name].length = 0;
      }
    }

    if (CC_JSB && CC_NATIVERENDERER) {
      this._assembler.updateMeshData(this);
    }
  },
  _checkBacth: function _checkBacth() {}
});

if (CC_DEBUG) {
  var BLACK_COLOR = cc.Color.BLACK;
  var RED_COLOR = cc.Color.RED;
  var v3_tmp = [cc.v3(), cc.v3()];
  var mat4_tmp = cc.mat4();
  var createDebugDataFns = {
    normal: function normal(comp, ia, subData, subIndex) {
      var oldVfm = subData.vfm;
      var normalEle = oldVfm.element(_gfx["default"].ATTR_NORMAL);
      var posEle = oldVfm.element(_gfx["default"].ATTR_POSITION);
      var jointEle = oldVfm.element(_gfx["default"].ATTR_JOINTS);
      var weightEle = oldVfm.element(_gfx["default"].ATTR_WEIGHTS);

      if (!normalEle || !posEle) {
        return;
      }

      var indices = [];
      var vbData = [];
      var lineLength = 100;

      _vec["default"].set(v3_tmp[0], 5, 0, 0);

      _mat["default"].invert(mat4_tmp, comp.node._worldMatrix);

      _vec["default"].transformMat4Normal(v3_tmp[0], v3_tmp[0], mat4_tmp);

      lineLength = v3_tmp[0].mag();
      var mesh = comp.mesh;

      var posData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_POSITION);

      var normalData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_NORMAL);

      var jointData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_JOINTS);

      var weightData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_WEIGHTS);

      var vertexCount = posData.length / posEle.num;

      for (var i = 0; i < vertexCount; i++) {
        var normalIndex = i * normalEle.num;
        var posIndex = i * posEle.num;

        _vec["default"].set(v3_tmp[0], normalData[normalIndex], normalData[normalIndex + 1], normalData[normalIndex + 2]);

        _vec["default"].set(v3_tmp[1], posData[posIndex], posData[posIndex + 1], posData[posIndex + 2]);

        _vec["default"].scaleAndAdd(v3_tmp[0], v3_tmp[1], v3_tmp[0], lineLength);

        for (var lineIndex = 0; lineIndex < 2; lineIndex++) {
          vbData.push(v3_tmp[lineIndex].x, v3_tmp[lineIndex].y, v3_tmp[lineIndex].z);

          if (jointEle) {
            var jointIndex = i * jointEle.num;

            for (var j = 0; j < jointEle.num; j++) {
              vbData.push(jointData[jointIndex + j]);
            }
          }

          if (weightEle) {
            var weightIndex = i * weightEle.num;

            for (var _j = 0; _j < weightEle.num; _j++) {
              vbData.push(weightData[weightIndex + _j]);
            }
          }
        }

        indices.push(i * 2, i * 2 + 1);
      }

      var formatOpts = [{
        name: _gfx["default"].ATTR_POSITION,
        type: _gfx["default"].ATTR_TYPE_FLOAT32,
        num: 3
      }];

      if (jointEle) {
        formatOpts.push({
          name: _gfx["default"].ATTR_JOINTS,
          type: _gfx["default"].ATTR_TYPE_FLOAT32,
          num: jointEle.num
        });
      }

      if (weightEle) {
        formatOpts.push({
          name: _gfx["default"].ATTR_WEIGHTS,
          type: _gfx["default"].ATTR_TYPE_FLOAT32,
          num: weightEle.num
        });
      }

      var gfxVFmt = new _gfx["default"].VertexFormat(formatOpts);
      var vb = new _gfx["default"].VertexBuffer(Renderer.device, gfxVFmt, _gfx["default"].USAGE_STATIC, new Float32Array(vbData));
      var ibData = new Uint16Array(indices);
      var ib = new _gfx["default"].IndexBuffer(Renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_STATIC, ibData, ibData.length);

      var m = _materialVariant["default"].createWithBuiltin('unlit');

      m.setProperty('diffuseColor', RED_COLOR);
      return {
        material: m,
        ia: new _inputAssembler["default"](vb, ib, _gfx["default"].PT_LINES)
      };
    },
    wireFrame: function wireFrame(comp, ia, subData) {
      var oldIbData = subData.getIData(Uint16Array);

      var m = _materialVariant["default"].createWithBuiltin('unlit');

      m.setProperty('diffuseColor', BLACK_COLOR);
      var indices = [];

      for (var i = 0; i < oldIbData.length; i += 3) {
        var a = oldIbData[i + 0];
        var b = oldIbData[i + 1];
        var c = oldIbData[i + 2];
        indices.push(a, b, b, c, c, a);
      }

      var ibData = new Uint16Array(indices);
      var ib = new _gfx["default"].IndexBuffer(Renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_STATIC, ibData, ibData.length);
      return {
        material: m,
        ia: new _inputAssembler["default"](ia._vertexBuffer, ib, _gfx["default"].PT_LINES)
      };
    }
  };
  var _proto = MeshRenderer.prototype;

  _proto._updateDebugDatas = function () {
    var debugDatas = this._debugDatas;
    var subMeshes = this._mesh.subMeshes;
    var subDatas = this._mesh._subDatas;

    for (var name in debugDatas) {
      var debugData = debugDatas[name];
      if (debugData.length === subMeshes.length) continue;
      if (!cc.macro['SHOW_MESH_' + name.toUpperCase()]) continue;
      debugData.length = subMeshes.length;

      for (var i = 0; i < subMeshes.length; i++) {
        debugData[i] = createDebugDataFns[name](this, subMeshes[i], subDatas[i], i);
      }
    }
  };
}

cc.MeshRenderer = module.exports = MeshRenderer;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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