
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/uuid-loader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var MissingClass = CC_EDITOR && Editor.require('app://editor/page/scene-utils/missing-class-reporter').MissingClass;

var js = require('../platform/js');

var debug = require('../CCDebug');

require('../platform/deserialize');

var LoadingItems = require('./loading-items');

function isSceneObj(json) {
  var SCENE_ID = 'cc.Scene';
  var PREFAB_ID = 'cc.Prefab';
  return json && (json[0] && json[0].__type__ === SCENE_ID || json[1] && json[1].__type__ === SCENE_ID || json[0] && json[0].__type__ === PREFAB_ID);
}

function parseDepends(item, asset, tdInfo, deferredLoadRawAssetsInRuntime) {
  var uuidList = tdInfo.uuidList;
  var objList = tdInfo.uuidObjList;
  var propList = tdInfo.uuidPropList;
  var stillUseUrl = tdInfo._stillUseUrl;
  var depends;
  var i, dependUuid; // cache dependencies for auto release

  var dependKeys = item.dependKeys = [];

  if (deferredLoadRawAssetsInRuntime) {
    depends = []; // parse depends assets

    for (i = 0; i < uuidList.length; i++) {
      dependUuid = uuidList[i];
      var obj = objList[i];
      var prop = propList[i];

      var info = cc.AssetLibrary._getAssetInfoInRuntime(dependUuid);

      if (info.raw) {
        // skip preloading raw assets
        var url = info.url;
        obj[prop] = url;
        dependKeys.push(url);
      } else {
        // declare depends assets
        depends.push({
          type: 'uuid',
          uuid: dependUuid,
          deferredLoadRaw: true,
          _owner: obj,
          _ownerProp: prop,
          _stillUseUrl: stillUseUrl[i]
        });
      }
    }
  } else {
    depends = new Array(uuidList.length); // declare depends assets

    for (i = 0; i < uuidList.length; i++) {
      dependUuid = uuidList[i];
      depends[i] = {
        type: 'uuid',
        uuid: dependUuid,
        _owner: objList[i],
        _ownerProp: propList[i],
        _stillUseUrl: stillUseUrl[i]
      };
    } // load native object (Image/Audio) as depends


    if (asset._native && !asset.constructor.preventPreloadNativeObject) {
      depends.push({
        url: asset.nativeUrl,
        _owner: asset,
        _ownerProp: '_nativeAsset'
      });
    }
  }

  return depends;
}

function loadDepends(pipeline, item, asset, depends, callback) {
  // Predefine content for dependencies usage
  item.content = asset;
  var dependKeys = item.dependKeys;
  pipeline.flowInDeps(item, depends, function (errors, items) {
    var item, missingAssetReporter;
    var itemsMap = items.map;

    for (var src in itemsMap) {
      item = itemsMap[src];

      if (item.uuid && item.content) {
        item.content._uuid = item.uuid;
      }
    }

    function loadCallback(item) {
      var value = item.content;

      if (this._stillUseUrl) {
        value = value && cc.RawAsset.wasRawAssetType(value.constructor) ? value.nativeUrl : item.rawUrl;
      }

      if (this._ownerProp === '_nativeAsset') {
        this._owner.url = item.url;
      }

      this._owner[this._ownerProp] = value;

      if (item.uuid !== asset._uuid && dependKeys.indexOf(item.id) < 0) {
        dependKeys.push(item.id);
      }
    }

    for (var i = 0; i < depends.length; i++) {
      var dep = depends[i];
      var dependSrc = dep.uuid;
      var dependUrl = dep.url;
      var dependObj = dep._owner;
      var dependProp = dep._ownerProp;
      item = itemsMap[dependUrl];

      if (!item) {
        continue;
      }

      var loadCallbackCtx = dep;

      if (item.complete || item.content) {
        if (item.error) {
          if (CC_EDITOR && item.error.errorCode === 'db.NOTFOUND') {
            if (!missingAssetReporter) {
              var MissingObjectReporter = Editor.require('app://editor/page/scene-utils/missing-object-reporter');

              missingAssetReporter = new MissingObjectReporter(asset);
            }

            missingAssetReporter.stashByOwner(dependObj, dependProp, Editor.serialize.asAsset(dependSrc));
          } else {
            cc._throw(item.error.message || item.error.errorMessage || item.error);
          }
        } else {
          loadCallback.call(loadCallbackCtx, item);
        }
      } else {
        // item was removed from cache, but ready in pipeline actually
        var queue = LoadingItems.getQueue(item); // Hack to get a better behavior

        var list = queue._callbackTable[dependSrc];

        if (list) {
          list.unshift(loadCallback, loadCallbackCtx);
        } else {
          queue.addListener(dependSrc, loadCallback, loadCallbackCtx);
        }
      }
    } // Emit dependency errors in runtime, but not in editor,
    // because editor need to open the scene / prefab to let user fix missing asset issues


    if (CC_EDITOR && missingAssetReporter) {
      missingAssetReporter.reportByOwner();
      callback(null, asset);
    } else {
      if (!errors && asset.onLoad) {
        try {
          asset.onLoad();
        } catch (e) {
          cc._throw(e);
        }
      }

      callback(errors, asset);
    }
  });
} // can deferred load raw assets in runtime


function canDeferredLoad(asset, item, isScene) {
  if (CC_EDITOR) {
    return false;
  }

  var res = item.deferredLoadRaw;

  if (res) {
    // check if asset support deferred
    if (asset instanceof cc.Asset && asset.constructor.preventDeferredLoadDependents) {
      res = false;
    }
  } else if (isScene) {
    if (asset instanceof cc.SceneAsset || asset instanceof cc.Prefab) {
      res = asset.asyncLoadAssets; //if (res) {
      //    cc.log('deferred load raw assets for ' + item.id);
      //}
    }
  }

  return res;
}

function loadUuid(item, callback) {
  var json;

  if (typeof item.content === 'string') {
    try {
      json = JSON.parse(item.content);
    } catch (e) {
      return new Error(debug.getError(4923, item.id, e.stack));
    }
  } else if (typeof item.content === 'object') {
    json = item.content;
  } else {
    return new Error(debug.getError(4924));
  }

  var classFinder, missingClass;
  var isScene = isSceneObj(json);

  if (isScene) {
    if (CC_EDITOR) {
      missingClass = MissingClass;

      classFinder = function classFinder(type, data, owner, propName) {
        var res = missingClass.classFinder(type, data, owner, propName);

        if (res) {
          return res;
        }

        return cc._MissingScript.getMissingWrapper(type, data);
      };

      classFinder.onDereferenced = missingClass.classFinder.onDereferenced;
    } else {
      classFinder = cc._MissingScript.safeFindClass;
    }
  } else {
    classFinder = function classFinder(id) {
      var cls = js._getClassById(id);

      if (cls) {
        return cls;
      }

      cc.warnID(4903, id);
      return Object;
    };
  }

  var tdInfo = cc.deserialize.Details.pool.get();
  var asset;

  try {
    asset = cc.deserialize(json, tdInfo, {
      classFinder: classFinder,
      target: item.existingAsset,
      customEnv: item
    });
  } catch (e) {
    cc.deserialize.Details.pool.put(tdInfo);
    var err = CC_JSB || CC_RUNTIME ? e + '\n' + e.stack : e.stack;
    return new Error(debug.getError(4925, item.id, err));
  }

  asset._uuid = item.uuid;
  asset.url = asset.nativeUrl;

  if (CC_EDITOR && missingClass) {
    missingClass.reportMissingClass(asset);
    missingClass.reset();
  }

  var deferredLoad = canDeferredLoad(asset, item, isScene);
  var depends = parseDepends(item, asset, tdInfo, deferredLoad);
  cc.deserialize.Details.pool.put(tdInfo);

  if (depends.length === 0) {
    if (asset.onLoad) asset.onLoad();
    return callback(null, asset);
  }

  loadDepends(this.pipeline, item, asset, depends, callback);
}

module.exports = loadUuid;
loadUuid.isSceneObj = isSceneObj;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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