
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/unpackers.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Texture2D = require('../assets/CCTexture2D');

var js = require('../platform/js');

function JsonUnpacker() {
  this.jsons = {};
}
/**
 * @param {String[]} indices
 * @param {Object[]} packedJson
 */


JsonUnpacker.prototype.load = function (indices, packedJson) {
  if (packedJson.length !== indices.length) {
    cc.errorID(4915);
  }

  for (var i = 0; i < indices.length; i++) {
    var key = indices[i];
    var json = packedJson[i];
    this.jsons[key] = json;
  }
};

JsonUnpacker.prototype.retrieve = function (key) {
  return this.jsons[key] || null;
};

function TextureUnpacker() {
  this.contents = {};
}

TextureUnpacker.ID = js._getClassId(Texture2D);
/**
 * @param {String[]} indices
 * @param {Object[]} packedJson
 */

TextureUnpacker.prototype.load = function (indices, packedJson) {
  var datas = packedJson.data.split('|');

  if (datas.length !== indices.length) {
    cc.errorID(4915);
  }

  for (var i = 0; i < indices.length; i++) {
    this.contents[indices[i]] = datas[i];
  }
};

TextureUnpacker.prototype.retrieve = function (key) {
  var content = this.contents[key];

  if (content) {
    return {
      __type__: TextureUnpacker.ID,
      content: content
    };
  } else {
    return null;
  }
};

if (CC_TEST) {
  cc._Test.JsonUnpacker = JsonUnpacker;
  cc._Test.TextureUnpacker = TextureUnpacker;
}

module.exports = {
  JsonUnpacker: JsonUnpacker,
  TextureUnpacker: TextureUnpacker
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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