
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/subpackage-pipe.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
 https://www.cocos.com/
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.
 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Pipeline = require('./pipeline');

var ID = 'SubPackPipe';
var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;

function getUuidFromURL(url) {
  var matches = url.match(UuidRegex);

  if (matches) {
    return matches[1];
  }

  return "";
}

var _uuidToSubPack = Object.create(null);

var SubPackPipe = function SubPackPipe(subpackage) {
  this.id = ID;
  this.async = false;
  this.pipeline = null;

  for (var packName in subpackage) {
    var pack = subpackage[packName];
    pack.uuids && pack.uuids.forEach(function (val) {
      _uuidToSubPack[val] = pack.path;
    });
  }
};

SubPackPipe.ID = ID;

SubPackPipe.prototype.handle = function (item) {
  item.url = this.transformURL(item.url);
  return null;
};

SubPackPipe.prototype.transformURL = function (url) {
  var uuid = getUuidFromURL(url);

  if (uuid) {
    var subpackage = _uuidToSubPack[uuid];

    if (subpackage) {
      // only replace url of native assets
      return url.replace('res/raw-assets/', subpackage + 'raw-assets/');
    }
  }

  return url;
};

Pipeline.SubPackPipe = module.exports = SubPackPipe;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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