
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/released-asset-checker.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
if (CC_DEBUG) {
  // checks if asset was releasable
  var ReleasedAssetChecker = function ReleasedAssetChecker() {
    // { dependKey: true }
    this._releasedKeys = js.createMap(true);
    this._dirty = false;
  }; // mark as released for further checking dependencies


  var getItemDesc = function getItemDesc(item) {
    if (item.uuid) {
      if (!tmpInfo) {
        tmpInfo = {
          path: "",
          type: null
        };
      }

      if (cc.loader._assetTables.assets._getInfo_DEBUG(item.uuid, tmpInfo)) {
        tmpInfo.path = 'resources/' + tmpInfo.path;
        return "\"" + tmpInfo.path + "\" (type: " + js.getClassName(tmpInfo.type) + ", uuid: " + item.uuid + ")";
      } else {
        return "\"" + item.rawUrl + "\" (" + item.uuid + ")";
      }
    } else {
      return "\"" + item.rawUrl + "\"";
    }
  };

  var doCheckCouldRelease = function doCheckCouldRelease(releasedKey, refOwnerItem, caches) {
    var loadedAgain = caches[releasedKey];

    if (!loadedAgain) {
      cc.log("\"" + releasedKey + "\" was released but maybe still referenced by " + getItemDesc(refOwnerItem));
    }
  }; // check dependencies


  var js = require('../platform/js');

  ReleasedAssetChecker.prototype.setReleased = function (item, releasedKey) {
    this._releasedKeys[releasedKey] = true;
    this._dirty = true;
  };

  var tmpInfo = null;

  ReleasedAssetChecker.prototype.checkCouldRelease = function (caches) {
    if (!this._dirty) {
      return;
    }

    this._dirty = false;
    var released = this._releasedKeys; // check loader cache

    for (var id in caches) {
      var item = caches[id];

      if (item.alias) {
        item = item.alias;
      }

      var depends = item.dependKeys;

      if (depends) {
        for (var i = 0; i < depends.length; ++i) {
          var depend = depends[i];

          if (released[depend]) {
            doCheckCouldRelease(depend, item, caches);
            delete released[depend];
          }
        }
      }
    } // // check current scene
    // let depends = cc.director.getScene().dependAssets;
    // for (let i = 0; i < depends.length; ++i) {
    //     let depend = depends[i];
    //     if (released[depend]) {
    //         doCheckCouldRelease(depend, item, caches);
    //         delete released[depend];
    //     }
    // }
    // clear released


    js.clear(released);
  };

  module.exports = ReleasedAssetChecker;
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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