
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/pack-downloader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Unpackers = require('./unpackers');

var pushToMap = require('../utils/misc').pushToMap; // when more than one package contains the required asset,
// choose to load from the package with the largest state value.


var PackState = {
  Invalid: 0,
  Removed: 1,
  Downloading: 2,
  Loaded: 3
};

function UnpackerData() {
  this.unpacker = null;
  this.state = PackState.Invalid;
  this.duration = 0;
} // {assetUuid: packUuid|[packUuid]}
// If value is array of packUuid, then the first one will be prioritized for download,
// so the smallest pack must be at the beginning of the array.


var uuidToPack = {}; // {packUuid: assetIndices}

var packIndices = {}; // {packUuid: UnpackerData}
// We have to cache all packs in global because for now there's no operation context in loader.

var globalUnpackers = {};
var toBeChecked = [];
var timer = null;
var checkPeriod = 5000;

function error(uuid, packUuid) {
  return new Error('Can not retrieve ' + uuid + ' from packer ' + packUuid);
}

module.exports = {
  // two minutes
  msToRelease: 2 * 60 * 1000,
  initPacks: function initPacks(packs) {
    packIndices = packs;
    uuidToPack = {};

    for (var packUuid in packs) {
      var uuids = packs[packUuid];

      for (var i = 0; i < uuids.length; i++) {
        var uuid = uuids[i]; // the smallest pack must be at the beginning of the array to download more first

        var pushFront = uuids.length === 1;
        pushToMap(uuidToPack, uuid, packUuid, pushFront);
      }
    }
  },
  _loadNewPack: function _loadNewPack(uuid, packUuid, callback) {
    var self = this;
    var packUrl = cc.AssetLibrary.getLibUrlNoExt(packUuid) + '.json';
    cc.loader.load({
      url: packUrl,
      ignoreMaxConcurrency: true
    }, function (err, packJson) {
      if (err) {
        cc.errorID(4916, uuid);
        return callback(err);
      }

      globalUnpackers[packUuid].url = packUrl;

      var res = self._doLoadNewPack(uuid, packUuid, packJson);

      if (res) {
        callback(null, res);
      } else {
        callback(error(uuid, packUuid));
      }
    });
  },
  _doPreload: function _doPreload(packUuid, packJson) {
    var unpackerData = globalUnpackers[packUuid];

    if (!unpackerData) {
      unpackerData = globalUnpackers[packUuid] = new UnpackerData();
      unpackerData.state = PackState.Downloading;
    }

    if (unpackerData.state !== PackState.Loaded) {
      unpackerData.unpacker = new Unpackers.JsonUnpacker();
      unpackerData.unpacker.load(packIndices[packUuid], packJson);
      unpackerData.state = PackState.Loaded;
    } // can not release subdomain packed json because it would not be reloaded. 

  },
  _doLoadNewPack: function _doLoadNewPack(uuid, packUuid, packedJson) {
    var unpackerData = globalUnpackers[packUuid]; // double check cache after load

    if (unpackerData.state !== PackState.Loaded) {
      // init unpacker
      if (typeof packedJson === 'string') {
        packedJson = JSON.parse(packedJson);
      }

      if (Array.isArray(packedJson)) {
        unpackerData.unpacker = new Unpackers.JsonUnpacker();
      } else if (packedJson.type === Unpackers.TextureUnpacker.ID) {
        unpackerData.unpacker = new Unpackers.TextureUnpacker();
      }

      unpackerData.unpacker.load(packIndices[packUuid], packedJson);
      unpackerData.state = PackState.Loaded;
      unpackerData.duration = 0;
      toBeChecked.push(packUuid);
      var self = this;
      if (!timer) timer = setInterval(function () {
        var maxDuration = self.msToRelease / checkPeriod;

        for (var i = toBeChecked.length - 1; i >= 0; i--) {
          var id = toBeChecked[i];
          var pack = globalUnpackers[id];

          if (++pack.duration > maxDuration) {
            self.release(id);
          }
        }

        if (toBeChecked.length === 0) {
          clearInterval(timer);
          timer = null;
        }
      }, checkPeriod);
    }

    return unpackerData.unpacker.retrieve(uuid);
  },
  _selectLoadedPack: function _selectLoadedPack(packUuids) {
    var existsPackState = PackState.Invalid;
    var existsPackUuid = '';

    for (var i = 0; i < packUuids.length; i++) {
      var packUuid = packUuids[i];
      var unpackerData = globalUnpackers[packUuid];

      if (unpackerData) {
        var state = unpackerData.state;

        if (state === PackState.Loaded) {
          return packUuid;
        } else if (state > existsPackState) {
          // load from the package with the largest state value,
          existsPackState = state;
          existsPackUuid = packUuid;
        }
      }
    } // otherwise the first one (smallest one) will be load


    return existsPackState !== PackState.Invalid ? existsPackUuid : packUuids[0];
  },

  /**
   * @returns {Object} When returns undefined, the requested item is not in any pack, when returns null, the item is in a loading pack, when item json exists, it will return the result directly.
   */
  load: function load(item, callback) {
    var uuid = item.uuid;
    var packUuid = uuidToPack[uuid];

    if (!packUuid) {
      // Return undefined to let caller know it's not recognized.
      // We don't use false here because changing return value type may cause jit fail, 
      // though return undefined may have the same issue.
      return;
    }

    if (Array.isArray(packUuid)) {
      packUuid = this._selectLoadedPack(packUuid);
    }

    var unpackerData = globalUnpackers[packUuid];

    if (unpackerData && unpackerData.state === PackState.Loaded) {
      // update duration
      unpackerData.duration = 0; // ensure async

      var json = unpackerData.unpacker.retrieve(uuid);

      if (json) {
        return json;
      } else {
        return error(uuid, packUuid);
      }
    } else {
      if (!unpackerData) {
        if (!CC_TEST) {
          console.log('Create unpacker %s for %s', packUuid, uuid);
        }

        unpackerData = globalUnpackers[packUuid] = new UnpackerData();
        unpackerData.state = PackState.Downloading;
      }

      this._loadNewPack(uuid, packUuid, callback);
    } // Return null to let caller know it's loading asynchronously


    return null;
  },
  release: function release(packUuid) {
    var unpackerData = globalUnpackers[packUuid];

    if (unpackerData) {
      cc.loader.release(unpackerData.url);
      delete globalUnpackers[packUuid];
      cc.js.array.fastRemove(toBeChecked, packUuid);
    }
  }
};

if (CC_TEST) {
  cc._Test.PackDownloader = module.exports;

  cc._Test.PackDownloader.reset = function () {
    uuidToPack = {};
    packIndices = {};
    globalUnpackers = {};
  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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