
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/md5-pipe.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Pipeline = require('./pipeline');

var ID = 'MD5Pipe';
var UuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;

var MD5Pipe = function MD5Pipe(md5AssetsMap, md5NativeAssetsMap, libraryBase) {
  this.id = ID;
  this.async = false;
  this.pipeline = null;
  this.md5AssetsMap = md5AssetsMap;
  this.md5NativeAssetsMap = md5NativeAssetsMap;
  this.libraryBase = libraryBase;
};

MD5Pipe.ID = ID;

MD5Pipe.prototype.handle = function (item) {
  item.url = this.transformURL(item.url);
  return null;
};

MD5Pipe.prototype.transformURL = function (url) {
  var isNativeAsset = !url.startsWith(this.libraryBase);
  var map = isNativeAsset ? this.md5NativeAssetsMap : this.md5AssetsMap;
  url = url.replace(UuidRegex, function (match, uuid) {
    var hashValue = map[uuid];
    return hashValue ? match + '.' + hashValue : match;
  });
  return url;
};

Pipeline.MD5Pipe = module.exports = MD5Pipe;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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