
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/loader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = require('../platform/js');

var plistParser = require('../platform/CCSAXParser').plistParser;

var Pipeline = require('./pipeline');

var Texture2D = require('../assets/CCTexture2D');

var loadUuid = require('./uuid-loader');

var fontLoader = require('./font-loader');

function loadNothing() {
  return null;
}

function loadJSON(item) {
  if (typeof item.content !== 'string') {
    return new Error('JSON Loader: Input item doesn\'t contain string content');
  }

  try {
    var result = JSON.parse(item.content);
    return result;
  } catch (e) {
    return new Error('JSON Loader: Parse json [' + item.id + '] failed : ' + e);
  }
}

function loadImage(item) {
  var loadByDeserializedAsset = item._owner instanceof cc.Asset;

  if (loadByDeserializedAsset) {
    // already has cc.Asset
    return null;
  }

  var image = item.content;

  if (cc.sys.platform !== cc.sys.FB_PLAYABLE_ADS && !(image instanceof Image)) {
    return new Error('Image Loader: Input item doesn\'t contain Image content');
  } // load cc.Texture2D


  var tex = item.texture || new Texture2D();
  tex._uuid = item.uuid;
  tex.url = item.url;

  tex._setRawAsset(item.rawUrl, false);

  tex._nativeAsset = image;
  return tex;
} // If audio is loaded by url directly, than this loader will wrap it into a new cc.AudioClip object.
// If audio is loaded by deserialized AudioClip, than this loader will be skipped.


function loadAudioAsAsset(item, callback) {
  var loadByDeserializedAsset = item._owner instanceof cc.Asset;

  if (loadByDeserializedAsset) {
    // already has cc.Asset
    return null;
  }

  var audioClip = new cc.AudioClip();

  audioClip._setRawAsset(item.rawUrl, false);

  audioClip._nativeAsset = item.content;
  audioClip.url = item.url;
  return audioClip;
}

function loadPlist(item) {
  if (typeof item.content !== 'string') {
    return new Error('Plist Loader: Input item doesn\'t contain string content');
  }

  var result = plistParser.parse(item.content);

  if (result) {
    return result;
  } else {
    return new Error('Plist Loader: Parse [' + item.id + '] failed');
  }
}

function loadBinary(item) {
  // Invoke custom handle
  if (item.load) {
    return item.load(item.content);
  } else {
    return null;
  }
} //===============//
// PVR constants //
//===============//
// https://github.com/toji/texture-tester/blob/master/js/webgl-texture-util.js#L424


var PVR_HEADER_LENGTH = 13; // The header length in 32 bit ints.

var PVR_MAGIC = 0x03525650; //0x50565203;
// Offsets into the header array.

var PVR_HEADER_MAGIC = 0;
var PVR_HEADER_FORMAT = 2;
var PVR_HEADER_HEIGHT = 6;
var PVR_HEADER_WIDTH = 7;
var PVR_HEADER_MIPMAPCOUNT = 11;
var PVR_HEADER_METADATA = 12;

function loadPVRTex(item) {
  var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer; // Get a view of the arrayBuffer that represents the DDS header.

  var header = new Int32Array(buffer, 0, PVR_HEADER_LENGTH); // Do some sanity checks to make sure this is a valid DDS file.

  if (header[PVR_HEADER_MAGIC] != PVR_MAGIC) {
    return new Error("Invalid magic number in PVR header");
  } // Gather other basic metrics and a view of the raw the DXT data.


  var width = header[PVR_HEADER_WIDTH];
  var height = header[PVR_HEADER_HEIGHT];
  var dataOffset = header[PVR_HEADER_METADATA] + 52;
  var pvrtcData = new Uint8Array(buffer, dataOffset);
  var pvrAsset = {
    _data: pvrtcData,
    _compressed: true,
    width: width,
    height: height
  };
  return pvrAsset;
} //===============//
// ETC constants //
//===============//


var ETC_PKM_HEADER_SIZE = 16;
var ETC_PKM_FORMAT_OFFSET = 6;
var ETC_PKM_ENCODED_WIDTH_OFFSET = 8;
var ETC_PKM_ENCODED_HEIGHT_OFFSET = 10;
var ETC_PKM_WIDTH_OFFSET = 12;
var ETC_PKM_HEIGHT_OFFSET = 14;
var ETC1_RGB_NO_MIPMAPS = 0;
var ETC2_RGB_NO_MIPMAPS = 1;
var ETC2_RGBA_NO_MIPMAPS = 3;

function readBEUint16(header, offset) {
  return header[offset] << 8 | header[offset + 1];
}

function loadPKMTex(item) {
  var buffer = item.content instanceof ArrayBuffer ? item.content : item.content.buffer;
  var header = new Uint8Array(buffer);
  var format = readBEUint16(header, ETC_PKM_FORMAT_OFFSET);

  if (format !== ETC1_RGB_NO_MIPMAPS && format !== ETC2_RGB_NO_MIPMAPS && format !== ETC2_RGBA_NO_MIPMAPS) {
    return new Error("Invalid magic number in ETC header");
  }

  var width = readBEUint16(header, ETC_PKM_WIDTH_OFFSET);
  var height = readBEUint16(header, ETC_PKM_HEIGHT_OFFSET);
  var encodedWidth = readBEUint16(header, ETC_PKM_ENCODED_WIDTH_OFFSET);
  var encodedHeight = readBEUint16(header, ETC_PKM_ENCODED_HEIGHT_OFFSET);
  var etcData = new Uint8Array(buffer, ETC_PKM_HEADER_SIZE);
  var etcAsset = {
    _data: etcData,
    _compressed: true,
    width: width,
    height: height
  };
  return etcAsset;
}

var defaultMap = {
  // Images
  'png': loadImage,
  'jpg': loadImage,
  'bmp': loadImage,
  'jpeg': loadImage,
  'gif': loadImage,
  'ico': loadImage,
  'tiff': loadImage,
  'webp': loadImage,
  'image': loadImage,
  'pvr': loadPVRTex,
  'pkm': loadPKMTex,
  // Audio
  'mp3': loadAudioAsAsset,
  'ogg': loadAudioAsAsset,
  'wav': loadAudioAsAsset,
  'm4a': loadAudioAsAsset,
  // json
  'json': loadJSON,
  'ExportJson': loadJSON,
  // plist
  'plist': loadPlist,
  // asset
  'uuid': loadUuid,
  'prefab': loadUuid,
  'fire': loadUuid,
  'scene': loadUuid,
  // binary
  'binary': loadBinary,
  'dbbin': loadBinary,
  'bin': loadBinary,
  'skel': loadBinary,
  // Font
  'font': fontLoader.loadFont,
  'eot': fontLoader.loadFont,
  'ttf': fontLoader.loadFont,
  'woff': fontLoader.loadFont,
  'svg': fontLoader.loadFont,
  'ttc': fontLoader.loadFont,
  'default': loadNothing
};
var ID = 'Loader';
/**
 * The loader pipe, it can load several types of files:
 * 1. Images
 * 2. JSON
 * 3. Plist
 * 4. Audio
 * 5. Font
 * 6. Cocos Creator scene
 * It will not interfere with items of unknown type.
 * You can pass custom supported types in the constructor.
 * @class Pipeline.Loader
 */

/**
 * Constructor of Loader, you can pass custom supported types.
 *
 * @method constructor
 * @param {Object} extMap Custom supported types with corresponded handler
 * @example
 *var loader = new Loader({
 *    // This will match all url with `.scene` extension or all url with `scene` type
 *    'scene' : function (url, callback) {}
 *});
 */

var Loader = function Loader(extMap) {
  this.id = ID;
  this.async = true;
  this.pipeline = null;
  this.extMap = js.mixin(extMap, defaultMap);
};

Loader.ID = ID;
/**
 * Add custom supported types handler or modify existing type handler.
 * @method addHandlers
 * @param {Object} extMap Custom supported types with corresponded handler
 */

Loader.prototype.addHandlers = function (extMap) {
  this.extMap = js.mixin(this.extMap, extMap);
};

Loader.prototype.handle = function (item, callback) {
  var loadFunc = this.extMap[item.type] || this.extMap['default'];
  return loadFunc.call(this, item, callback);
};

Pipeline.Loader = module.exports = Loader;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL2xvYWQtcGlwZWxpbmUvbG9hZGVyLmpzIl0sIm5hbWVzIjpbImpzIiwicmVxdWlyZSIsInBsaXN0UGFyc2VyIiwiUGlwZWxpbmUiLCJUZXh0dXJlMkQiLCJsb2FkVXVpZCIsImZvbnRMb2FkZXIiLCJsb2FkTm90aGluZyIsImxvYWRKU09OIiwiaXRlbSIsImNvbnRlbnQiLCJFcnJvciIsInJlc3VsdCIsIkpTT04iLCJwYXJzZSIsImUiLCJpZCIsImxvYWRJbWFnZSIsImxvYWRCeURlc2VyaWFsaXplZEFzc2V0IiwiX293bmVyIiwiY2MiLCJBc3NldCIsImltYWdlIiwic3lzIiwicGxhdGZvcm0iLCJGQl9QTEFZQUJMRV9BRFMiLCJJbWFnZSIsInRleCIsInRleHR1cmUiLCJfdXVpZCIsInV1aWQiLCJ1cmwiLCJfc2V0UmF3QXNzZXQiLCJyYXdVcmwiLCJfbmF0aXZlQXNzZXQiLCJsb2FkQXVkaW9Bc0Fzc2V0IiwiY2FsbGJhY2siLCJhdWRpb0NsaXAiLCJBdWRpb0NsaXAiLCJsb2FkUGxpc3QiLCJsb2FkQmluYXJ5IiwibG9hZCIsIlBWUl9IRUFERVJfTEVOR1RIIiwiUFZSX01BR0lDIiwiUFZSX0hFQURFUl9NQUdJQyIsIlBWUl9IRUFERVJfRk9STUFUIiwiUFZSX0hFQURFUl9IRUlHSFQiLCJQVlJfSEVBREVSX1dJRFRIIiwiUFZSX0hFQURFUl9NSVBNQVBDT1VOVCIsIlBWUl9IRUFERVJfTUVUQURBVEEiLCJsb2FkUFZSVGV4IiwiYnVmZmVyIiwiQXJyYXlCdWZmZXIiLCJoZWFkZXIiLCJJbnQzMkFycmF5Iiwid2lkdGgiLCJoZWlnaHQiLCJkYXRhT2Zmc2V0IiwicHZydGNEYXRhIiwiVWludDhBcnJheSIsInB2ckFzc2V0IiwiX2RhdGEiLCJfY29tcHJlc3NlZCIsIkVUQ19QS01fSEVBREVSX1NJWkUiLCJFVENfUEtNX0ZPUk1BVF9PRkZTRVQiLCJFVENfUEtNX0VOQ09ERURfV0lEVEhfT0ZGU0VUIiwiRVRDX1BLTV9FTkNPREVEX0hFSUdIVF9PRkZTRVQiLCJFVENfUEtNX1dJRFRIX09GRlNFVCIsIkVUQ19QS01fSEVJR0hUX09GRlNFVCIsIkVUQzFfUkdCX05PX01JUE1BUFMiLCJFVEMyX1JHQl9OT19NSVBNQVBTIiwiRVRDMl9SR0JBX05PX01JUE1BUFMiLCJyZWFkQkVVaW50MTYiLCJvZmZzZXQiLCJsb2FkUEtNVGV4IiwiZm9ybWF0IiwiZW5jb2RlZFdpZHRoIiwiZW5jb2RlZEhlaWdodCIsImV0Y0RhdGEiLCJldGNBc3NldCIsImRlZmF1bHRNYXAiLCJsb2FkRm9udCIsIklEIiwiTG9hZGVyIiwiZXh0TWFwIiwiYXN5bmMiLCJwaXBlbGluZSIsIm1peGluIiwicHJvdG90eXBlIiwiYWRkSGFuZGxlcnMiLCJoYW5kbGUiLCJsb2FkRnVuYyIsInR5cGUiLCJjYWxsIiwibW9kdWxlIiwiZXhwb3J0cyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBMEJBLElBQU1BLEVBQUUsR0FBR0MsT0FBTyxDQUFDLGdCQUFELENBQWxCOztBQUNBLElBQU1DLFdBQVcsR0FBR0QsT0FBTyxDQUFDLHlCQUFELENBQVAsQ0FBbUNDLFdBQXZEOztBQUNBLElBQU1DLFFBQVEsR0FBR0YsT0FBTyxDQUFDLFlBQUQsQ0FBeEI7O0FBQ0EsSUFBTUcsU0FBUyxHQUFHSCxPQUFPLENBQUMsdUJBQUQsQ0FBekI7O0FBQ0EsSUFBTUksUUFBUSxHQUFHSixPQUFPLENBQUMsZUFBRCxDQUF4Qjs7QUFDQSxJQUFNSyxVQUFVLEdBQUdMLE9BQU8sQ0FBQyxlQUFELENBQTFCOztBQUVBLFNBQVNNLFdBQVQsR0FBd0I7QUFDcEIsU0FBTyxJQUFQO0FBQ0g7O0FBRUQsU0FBU0MsUUFBVCxDQUFtQkMsSUFBbkIsRUFBeUI7QUFDckIsTUFBSSxPQUFPQSxJQUFJLENBQUNDLE9BQVosS0FBd0IsUUFBNUIsRUFBc0M7QUFDbEMsV0FBTyxJQUFJQyxLQUFKLENBQVUseURBQVYsQ0FBUDtBQUNIOztBQUVELE1BQUk7QUFDQSxRQUFJQyxNQUFNLEdBQUdDLElBQUksQ0FBQ0MsS0FBTCxDQUFXTCxJQUFJLENBQUNDLE9BQWhCLENBQWI7QUFDQSxXQUFPRSxNQUFQO0FBQ0gsR0FIRCxDQUlBLE9BQU9HLENBQVAsRUFBVTtBQUNOLFdBQU8sSUFBSUosS0FBSixDQUFVLDhCQUE4QkYsSUFBSSxDQUFDTyxFQUFuQyxHQUF3QyxhQUF4QyxHQUF3REQsQ0FBbEUsQ0FBUDtBQUNIO0FBQ0o7O0FBRUQsU0FBU0UsU0FBVCxDQUFvQlIsSUFBcEIsRUFBMEI7QUFDdEIsTUFBSVMsdUJBQXVCLEdBQUlULElBQUksQ0FBQ1UsTUFBTCxZQUF1QkMsRUFBRSxDQUFDQyxLQUF6RDs7QUFDQSxNQUFJSCx1QkFBSixFQUE2QjtBQUN6QjtBQUNBLFdBQU8sSUFBUDtBQUNIOztBQUVELE1BQUlJLEtBQUssR0FBR2IsSUFBSSxDQUFDQyxPQUFqQjs7QUFDQSxNQUFJVSxFQUFFLENBQUNHLEdBQUgsQ0FBT0MsUUFBUCxLQUFvQkosRUFBRSxDQUFDRyxHQUFILENBQU9FLGVBQTNCLElBQThDLEVBQUVILEtBQUssWUFBWUksS0FBbkIsQ0FBbEQsRUFBNkU7QUFDekUsV0FBTyxJQUFJZixLQUFKLENBQVUseURBQVYsQ0FBUDtBQUNILEdBVnFCLENBWXRCOzs7QUFDQSxNQUFJZ0IsR0FBRyxHQUFHbEIsSUFBSSxDQUFDbUIsT0FBTCxJQUFnQixJQUFJeEIsU0FBSixFQUExQjtBQUNBdUIsRUFBQUEsR0FBRyxDQUFDRSxLQUFKLEdBQVlwQixJQUFJLENBQUNxQixJQUFqQjtBQUNBSCxFQUFBQSxHQUFHLENBQUNJLEdBQUosR0FBVXRCLElBQUksQ0FBQ3NCLEdBQWY7O0FBQ0FKLEVBQUFBLEdBQUcsQ0FBQ0ssWUFBSixDQUFpQnZCLElBQUksQ0FBQ3dCLE1BQXRCLEVBQThCLEtBQTlCOztBQUNBTixFQUFBQSxHQUFHLENBQUNPLFlBQUosR0FBbUJaLEtBQW5CO0FBQ0EsU0FBT0ssR0FBUDtBQUNILEVBRUQ7QUFDQTs7O0FBQ0EsU0FBU1EsZ0JBQVQsQ0FBMkIxQixJQUEzQixFQUFpQzJCLFFBQWpDLEVBQTJDO0FBQ3ZDLE1BQUlsQix1QkFBdUIsR0FBSVQsSUFBSSxDQUFDVSxNQUFMLFlBQXVCQyxFQUFFLENBQUNDLEtBQXpEOztBQUNBLE1BQUlILHVCQUFKLEVBQTZCO0FBQ3pCO0FBQ0EsV0FBTyxJQUFQO0FBQ0g7O0FBRUQsTUFBSW1CLFNBQVMsR0FBRyxJQUFJakIsRUFBRSxDQUFDa0IsU0FBUCxFQUFoQjs7QUFDQUQsRUFBQUEsU0FBUyxDQUFDTCxZQUFWLENBQXVCdkIsSUFBSSxDQUFDd0IsTUFBNUIsRUFBb0MsS0FBcEM7O0FBQ0FJLEVBQUFBLFNBQVMsQ0FBQ0gsWUFBVixHQUF5QnpCLElBQUksQ0FBQ0MsT0FBOUI7QUFDQTJCLEVBQUFBLFNBQVMsQ0FBQ04sR0FBVixHQUFnQnRCLElBQUksQ0FBQ3NCLEdBQXJCO0FBQ0EsU0FBT00sU0FBUDtBQUNIOztBQUVELFNBQVNFLFNBQVQsQ0FBb0I5QixJQUFwQixFQUEwQjtBQUN0QixNQUFJLE9BQU9BLElBQUksQ0FBQ0MsT0FBWixLQUF3QixRQUE1QixFQUFzQztBQUNsQyxXQUFPLElBQUlDLEtBQUosQ0FBVSwwREFBVixDQUFQO0FBQ0g7O0FBQ0QsTUFBSUMsTUFBTSxHQUFHVixXQUFXLENBQUNZLEtBQVosQ0FBa0JMLElBQUksQ0FBQ0MsT0FBdkIsQ0FBYjs7QUFDQSxNQUFJRSxNQUFKLEVBQVk7QUFDUixXQUFPQSxNQUFQO0FBQ0gsR0FGRCxNQUdLO0FBQ0QsV0FBTyxJQUFJRCxLQUFKLENBQVUsMEJBQTBCRixJQUFJLENBQUNPLEVBQS9CLEdBQW9DLFVBQTlDLENBQVA7QUFDSDtBQUNKOztBQUVELFNBQVN3QixVQUFULENBQXFCL0IsSUFBckIsRUFBMkI7QUFDdkI7QUFDQSxNQUFJQSxJQUFJLENBQUNnQyxJQUFULEVBQWU7QUFDWCxXQUFPaEMsSUFBSSxDQUFDZ0MsSUFBTCxDQUFVaEMsSUFBSSxDQUFDQyxPQUFmLENBQVA7QUFDSCxHQUZELE1BR0s7QUFDRCxXQUFPLElBQVA7QUFDSDtBQUNKLEVBRUQ7QUFDQTtBQUNBO0FBQ0E7OztBQUNBLElBQU1nQyxpQkFBaUIsR0FBRyxFQUExQixFQUE4Qjs7QUFDOUIsSUFBTUMsU0FBUyxHQUFHLFVBQWxCLEVBQThCO0FBRTlCOztBQUNBLElBQU1DLGdCQUFnQixHQUFHLENBQXpCO0FBQ0EsSUFBTUMsaUJBQWlCLEdBQUcsQ0FBMUI7QUFDQSxJQUFNQyxpQkFBaUIsR0FBRyxDQUExQjtBQUNBLElBQU1DLGdCQUFnQixHQUFHLENBQXpCO0FBQ0EsSUFBTUMsc0JBQXNCLEdBQUcsRUFBL0I7QUFDQSxJQUFNQyxtQkFBbUIsR0FBRyxFQUE1Qjs7QUFFQSxTQUFTQyxVQUFULENBQXFCekMsSUFBckIsRUFBMkI7QUFDdkIsTUFBSTBDLE1BQU0sR0FBRzFDLElBQUksQ0FBQ0MsT0FBTCxZQUF3QjBDLFdBQXhCLEdBQXNDM0MsSUFBSSxDQUFDQyxPQUEzQyxHQUFxREQsSUFBSSxDQUFDQyxPQUFMLENBQWF5QyxNQUEvRSxDQUR1QixDQUV2Qjs7QUFDQSxNQUFJRSxNQUFNLEdBQUcsSUFBSUMsVUFBSixDQUFlSCxNQUFmLEVBQXVCLENBQXZCLEVBQTBCVCxpQkFBMUIsQ0FBYixDQUh1QixDQUt2Qjs7QUFDQSxNQUFHVyxNQUFNLENBQUNULGdCQUFELENBQU4sSUFBNEJELFNBQS9CLEVBQTBDO0FBQ3hDLFdBQU8sSUFBSWhDLEtBQUosQ0FBVSxvQ0FBVixDQUFQO0FBQ0QsR0FSc0IsQ0FVdkI7OztBQUNBLE1BQUk0QyxLQUFLLEdBQUdGLE1BQU0sQ0FBQ04sZ0JBQUQsQ0FBbEI7QUFDQSxNQUFJUyxNQUFNLEdBQUdILE1BQU0sQ0FBQ1AsaUJBQUQsQ0FBbkI7QUFDQSxNQUFJVyxVQUFVLEdBQUdKLE1BQU0sQ0FBQ0osbUJBQUQsQ0FBTixHQUE4QixFQUEvQztBQUNBLE1BQUlTLFNBQVMsR0FBRyxJQUFJQyxVQUFKLENBQWVSLE1BQWYsRUFBdUJNLFVBQXZCLENBQWhCO0FBRUEsTUFBSUcsUUFBUSxHQUFHO0FBQ1hDLElBQUFBLEtBQUssRUFBRUgsU0FESTtBQUVYSSxJQUFBQSxXQUFXLEVBQUUsSUFGRjtBQUlYUCxJQUFBQSxLQUFLLEVBQUVBLEtBSkk7QUFLWEMsSUFBQUEsTUFBTSxFQUFFQTtBQUxHLEdBQWY7QUFRQSxTQUFPSSxRQUFQO0FBQ0gsRUFFRDtBQUNBO0FBQ0E7OztBQUVBLElBQU1HLG1CQUFtQixHQUFHLEVBQTVCO0FBRUEsSUFBTUMscUJBQXFCLEdBQUcsQ0FBOUI7QUFDQSxJQUFNQyw0QkFBNEIsR0FBRyxDQUFyQztBQUNBLElBQU1DLDZCQUE2QixHQUFHLEVBQXRDO0FBQ0EsSUFBTUMsb0JBQW9CLEdBQUcsRUFBN0I7QUFDQSxJQUFNQyxxQkFBcUIsR0FBRyxFQUE5QjtBQUVBLElBQU1DLG1CQUFtQixHQUFLLENBQTlCO0FBQ0EsSUFBTUMsbUJBQW1CLEdBQUssQ0FBOUI7QUFDQSxJQUFNQyxvQkFBb0IsR0FBSSxDQUE5Qjs7QUFHQSxTQUFTQyxZQUFULENBQXNCbkIsTUFBdEIsRUFBOEJvQixNQUE5QixFQUFzQztBQUNsQyxTQUFRcEIsTUFBTSxDQUFDb0IsTUFBRCxDQUFOLElBQWtCLENBQW5CLEdBQXdCcEIsTUFBTSxDQUFDb0IsTUFBTSxHQUFDLENBQVIsQ0FBckM7QUFDSDs7QUFDRCxTQUFTQyxVQUFULENBQW9CakUsSUFBcEIsRUFBMEI7QUFDdEIsTUFBSTBDLE1BQU0sR0FBRzFDLElBQUksQ0FBQ0MsT0FBTCxZQUF3QjBDLFdBQXhCLEdBQXNDM0MsSUFBSSxDQUFDQyxPQUEzQyxHQUFxREQsSUFBSSxDQUFDQyxPQUFMLENBQWF5QyxNQUEvRTtBQUNBLE1BQUlFLE1BQU0sR0FBRyxJQUFJTSxVQUFKLENBQWVSLE1BQWYsQ0FBYjtBQUNBLE1BQUl3QixNQUFNLEdBQUdILFlBQVksQ0FBQ25CLE1BQUQsRUFBU1cscUJBQVQsQ0FBekI7O0FBQ0EsTUFBSVcsTUFBTSxLQUFLTixtQkFBWCxJQUFrQ00sTUFBTSxLQUFLTCxtQkFBN0MsSUFBb0VLLE1BQU0sS0FBS0osb0JBQW5GLEVBQXlHO0FBQ3JHLFdBQU8sSUFBSTVELEtBQUosQ0FBVSxvQ0FBVixDQUFQO0FBQ0g7O0FBQ0QsTUFBSTRDLEtBQUssR0FBR2lCLFlBQVksQ0FBQ25CLE1BQUQsRUFBU2Msb0JBQVQsQ0FBeEI7QUFDQSxNQUFJWCxNQUFNLEdBQUdnQixZQUFZLENBQUNuQixNQUFELEVBQVNlLHFCQUFULENBQXpCO0FBQ0EsTUFBSVEsWUFBWSxHQUFHSixZQUFZLENBQUNuQixNQUFELEVBQVNZLDRCQUFULENBQS9CO0FBQ0EsTUFBSVksYUFBYSxHQUFHTCxZQUFZLENBQUNuQixNQUFELEVBQVNhLDZCQUFULENBQWhDO0FBQ0EsTUFBSVksT0FBTyxHQUFHLElBQUluQixVQUFKLENBQWVSLE1BQWYsRUFBdUJZLG1CQUF2QixDQUFkO0FBQ0EsTUFBSWdCLFFBQVEsR0FBRztBQUNYbEIsSUFBQUEsS0FBSyxFQUFFaUIsT0FESTtBQUVYaEIsSUFBQUEsV0FBVyxFQUFFLElBRkY7QUFHWFAsSUFBQUEsS0FBSyxFQUFFQSxLQUhJO0FBSVhDLElBQUFBLE1BQU0sRUFBRUE7QUFKRyxHQUFmO0FBTUEsU0FBT3VCLFFBQVA7QUFDSDs7QUFFRCxJQUFJQyxVQUFVLEdBQUc7QUFDYjtBQUNBLFNBQVEvRCxTQUZLO0FBR2IsU0FBUUEsU0FISztBQUliLFNBQVFBLFNBSks7QUFLYixVQUFTQSxTQUxJO0FBTWIsU0FBUUEsU0FOSztBQU9iLFNBQVFBLFNBUEs7QUFRYixVQUFTQSxTQVJJO0FBU2IsVUFBU0EsU0FUSTtBQVViLFdBQVVBLFNBVkc7QUFXYixTQUFRaUMsVUFYSztBQVliLFNBQVF3QixVQVpLO0FBY2I7QUFDQSxTQUFRdkMsZ0JBZks7QUFnQmIsU0FBUUEsZ0JBaEJLO0FBaUJiLFNBQVFBLGdCQWpCSztBQWtCYixTQUFRQSxnQkFsQks7QUFvQmI7QUFDQSxVQUFTM0IsUUFyQkk7QUFzQmIsZ0JBQWVBLFFBdEJGO0FBd0JiO0FBQ0EsV0FBVStCLFNBekJHO0FBMkJiO0FBQ0EsVUFBU2xDLFFBNUJJO0FBNkJiLFlBQVdBLFFBN0JFO0FBOEJiLFVBQVNBLFFBOUJJO0FBK0JiLFdBQVVBLFFBL0JHO0FBaUNiO0FBQ0EsWUFBV21DLFVBbENFO0FBbUNiLFdBQVVBLFVBbkNHO0FBb0NiLFNBQVFBLFVBcENLO0FBcUNiLFVBQVNBLFVBckNJO0FBdUNiO0FBQ0EsVUFBU2xDLFVBQVUsQ0FBQzJFLFFBeENQO0FBeUNiLFNBQVEzRSxVQUFVLENBQUMyRSxRQXpDTjtBQTBDYixTQUFRM0UsVUFBVSxDQUFDMkUsUUExQ047QUEyQ2IsVUFBUzNFLFVBQVUsQ0FBQzJFLFFBM0NQO0FBNENiLFNBQVEzRSxVQUFVLENBQUMyRSxRQTVDTjtBQTZDYixTQUFRM0UsVUFBVSxDQUFDMkUsUUE3Q047QUErQ2IsYUFBWTFFO0FBL0NDLENBQWpCO0FBa0RBLElBQUkyRSxFQUFFLEdBQUcsUUFBVDtBQUVBOzs7Ozs7Ozs7Ozs7O0FBWUE7Ozs7Ozs7Ozs7OztBQVdBLElBQUlDLE1BQU0sR0FBRyxTQUFUQSxNQUFTLENBQVVDLE1BQVYsRUFBa0I7QUFDM0IsT0FBS3BFLEVBQUwsR0FBVWtFLEVBQVY7QUFDQSxPQUFLRyxLQUFMLEdBQWEsSUFBYjtBQUNBLE9BQUtDLFFBQUwsR0FBZ0IsSUFBaEI7QUFFQSxPQUFLRixNQUFMLEdBQWNwRixFQUFFLENBQUN1RixLQUFILENBQVNILE1BQVQsRUFBaUJKLFVBQWpCLENBQWQ7QUFDSCxDQU5EOztBQU9BRyxNQUFNLENBQUNELEVBQVAsR0FBWUEsRUFBWjtBQUVBOzs7Ozs7QUFLQUMsTUFBTSxDQUFDSyxTQUFQLENBQWlCQyxXQUFqQixHQUErQixVQUFVTCxNQUFWLEVBQWtCO0FBQzdDLE9BQUtBLE1BQUwsR0FBY3BGLEVBQUUsQ0FBQ3VGLEtBQUgsQ0FBUyxLQUFLSCxNQUFkLEVBQXNCQSxNQUF0QixDQUFkO0FBQ0gsQ0FGRDs7QUFJQUQsTUFBTSxDQUFDSyxTQUFQLENBQWlCRSxNQUFqQixHQUEwQixVQUFVakYsSUFBVixFQUFnQjJCLFFBQWhCLEVBQTBCO0FBQ2hELE1BQUl1RCxRQUFRLEdBQUcsS0FBS1AsTUFBTCxDQUFZM0UsSUFBSSxDQUFDbUYsSUFBakIsS0FBMEIsS0FBS1IsTUFBTCxDQUFZLFNBQVosQ0FBekM7QUFDQSxTQUFPTyxRQUFRLENBQUNFLElBQVQsQ0FBYyxJQUFkLEVBQW9CcEYsSUFBcEIsRUFBMEIyQixRQUExQixDQUFQO0FBQ0gsQ0FIRDs7QUFLQWpDLFFBQVEsQ0FBQ2dGLE1BQVQsR0FBa0JXLE1BQU0sQ0FBQ0MsT0FBUCxHQUFpQlosTUFBbkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCAoYykgMjAxMy0yMDE2IENodWtvbmcgVGVjaG5vbG9naWVzIEluYy5cbiBDb3B5cmlnaHQgKGMpIDIwMTctMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiAgd29ybGR3aWRlLCByb3lhbHR5LWZyZWUsIG5vbi1hc3NpZ25hYmxlLCByZXZvY2FibGUgYW5kIG5vbi1leGNsdXNpdmUgbGljZW5zZVxuIHRvIHVzZSBDb2NvcyBDcmVhdG9yIHNvbGVseSB0byBkZXZlbG9wIGdhbWVzIG9uIHlvdXIgdGFyZ2V0IHBsYXRmb3Jtcy4gWW91IHNoYWxsXG4gIG5vdCB1c2UgQ29jb3MgQ3JlYXRvciBzb2Z0d2FyZSBmb3IgZGV2ZWxvcGluZyBvdGhlciBzb2Z0d2FyZSBvciB0b29scyB0aGF0J3NcbiAgdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuICBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbCBjb3BpZXMgb2YgQ29jb3MgQ3JlYXRvci5cblxuIFRoZSBzb2Z0d2FyZSBvciB0b29scyBpbiB0aGlzIExpY2Vuc2UgQWdyZWVtZW50IGFyZSBsaWNlbnNlZCwgbm90IHNvbGQuXG4gWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuIHJlc2VydmVzIGFsbCByaWdodHMgbm90IGV4cHJlc3NseSBncmFudGVkIHRvIHlvdS5cblxuIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1JcbiBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbiBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbiBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbiBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4gVEhFIFNPRlRXQVJFLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiovXG5cbmNvbnN0IGpzID0gcmVxdWlyZSgnLi4vcGxhdGZvcm0vanMnKTtcbmNvbnN0IHBsaXN0UGFyc2VyID0gcmVxdWlyZSgnLi4vcGxhdGZvcm0vQ0NTQVhQYXJzZXInKS5wbGlzdFBhcnNlcjtcbmNvbnN0IFBpcGVsaW5lID0gcmVxdWlyZSgnLi9waXBlbGluZScpO1xuY29uc3QgVGV4dHVyZTJEID0gcmVxdWlyZSgnLi4vYXNzZXRzL0NDVGV4dHVyZTJEJyk7XG5jb25zdCBsb2FkVXVpZCA9IHJlcXVpcmUoJy4vdXVpZC1sb2FkZXInKTtcbmNvbnN0IGZvbnRMb2FkZXIgPSByZXF1aXJlKCcuL2ZvbnQtbG9hZGVyJyk7XG5cbmZ1bmN0aW9uIGxvYWROb3RoaW5nICgpIHtcbiAgICByZXR1cm4gbnVsbDtcbn1cblxuZnVuY3Rpb24gbG9hZEpTT04gKGl0ZW0pIHtcbiAgICBpZiAodHlwZW9mIGl0ZW0uY29udGVudCAhPT0gJ3N0cmluZycpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBFcnJvcignSlNPTiBMb2FkZXI6IElucHV0IGl0ZW0gZG9lc25cXCd0IGNvbnRhaW4gc3RyaW5nIGNvbnRlbnQnKTtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgICB2YXIgcmVzdWx0ID0gSlNPTi5wYXJzZShpdGVtLmNvbnRlbnQpO1xuICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgIH1cbiAgICBjYXRjaCAoZSkge1xuICAgICAgICByZXR1cm4gbmV3IEVycm9yKCdKU09OIExvYWRlcjogUGFyc2UganNvbiBbJyArIGl0ZW0uaWQgKyAnXSBmYWlsZWQgOiAnICsgZSk7XG4gICAgfVxufVxuXG5mdW5jdGlvbiBsb2FkSW1hZ2UgKGl0ZW0pIHtcbiAgICB2YXIgbG9hZEJ5RGVzZXJpYWxpemVkQXNzZXQgPSAoaXRlbS5fb3duZXIgaW5zdGFuY2VvZiBjYy5Bc3NldCk7XG4gICAgaWYgKGxvYWRCeURlc2VyaWFsaXplZEFzc2V0KSB7XG4gICAgICAgIC8vIGFscmVhZHkgaGFzIGNjLkFzc2V0XG4gICAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIHZhciBpbWFnZSA9IGl0ZW0uY29udGVudDtcbiAgICBpZiAoY2Muc3lzLnBsYXRmb3JtICE9PSBjYy5zeXMuRkJfUExBWUFCTEVfQURTICYmICEoaW1hZ2UgaW5zdGFuY2VvZiBJbWFnZSkpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBFcnJvcignSW1hZ2UgTG9hZGVyOiBJbnB1dCBpdGVtIGRvZXNuXFwndCBjb250YWluIEltYWdlIGNvbnRlbnQnKTtcbiAgICB9IFxuXG4gICAgLy8gbG9hZCBjYy5UZXh0dXJlMkRcbiAgICB2YXIgdGV4ID0gaXRlbS50ZXh0dXJlIHx8IG5ldyBUZXh0dXJlMkQoKTtcbiAgICB0ZXguX3V1aWQgPSBpdGVtLnV1aWQ7XG4gICAgdGV4LnVybCA9IGl0ZW0udXJsO1xuICAgIHRleC5fc2V0UmF3QXNzZXQoaXRlbS5yYXdVcmwsIGZhbHNlKTtcbiAgICB0ZXguX25hdGl2ZUFzc2V0ID0gaW1hZ2U7XG4gICAgcmV0dXJuIHRleDtcbn1cblxuLy8gSWYgYXVkaW8gaXMgbG9hZGVkIGJ5IHVybCBkaXJlY3RseSwgdGhhbiB0aGlzIGxvYWRlciB3aWxsIHdyYXAgaXQgaW50byBhIG5ldyBjYy5BdWRpb0NsaXAgb2JqZWN0LlxuLy8gSWYgYXVkaW8gaXMgbG9hZGVkIGJ5IGRlc2VyaWFsaXplZCBBdWRpb0NsaXAsIHRoYW4gdGhpcyBsb2FkZXIgd2lsbCBiZSBza2lwcGVkLlxuZnVuY3Rpb24gbG9hZEF1ZGlvQXNBc3NldCAoaXRlbSwgY2FsbGJhY2spIHtcbiAgICB2YXIgbG9hZEJ5RGVzZXJpYWxpemVkQXNzZXQgPSAoaXRlbS5fb3duZXIgaW5zdGFuY2VvZiBjYy5Bc3NldCk7XG4gICAgaWYgKGxvYWRCeURlc2VyaWFsaXplZEFzc2V0KSB7XG4gICAgICAgIC8vIGFscmVhZHkgaGFzIGNjLkFzc2V0XG4gICAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIHZhciBhdWRpb0NsaXAgPSBuZXcgY2MuQXVkaW9DbGlwKCk7XG4gICAgYXVkaW9DbGlwLl9zZXRSYXdBc3NldChpdGVtLnJhd1VybCwgZmFsc2UpO1xuICAgIGF1ZGlvQ2xpcC5fbmF0aXZlQXNzZXQgPSBpdGVtLmNvbnRlbnQ7XG4gICAgYXVkaW9DbGlwLnVybCA9IGl0ZW0udXJsO1xuICAgIHJldHVybiBhdWRpb0NsaXA7XG59XG5cbmZ1bmN0aW9uIGxvYWRQbGlzdCAoaXRlbSkge1xuICAgIGlmICh0eXBlb2YgaXRlbS5jb250ZW50ICE9PSAnc3RyaW5nJykge1xuICAgICAgICByZXR1cm4gbmV3IEVycm9yKCdQbGlzdCBMb2FkZXI6IElucHV0IGl0ZW0gZG9lc25cXCd0IGNvbnRhaW4gc3RyaW5nIGNvbnRlbnQnKTtcbiAgICB9XG4gICAgdmFyIHJlc3VsdCA9IHBsaXN0UGFyc2VyLnBhcnNlKGl0ZW0uY29udGVudCk7XG4gICAgaWYgKHJlc3VsdCkge1xuICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgICAgcmV0dXJuIG5ldyBFcnJvcignUGxpc3QgTG9hZGVyOiBQYXJzZSBbJyArIGl0ZW0uaWQgKyAnXSBmYWlsZWQnKTtcbiAgICB9XG59XG5cbmZ1bmN0aW9uIGxvYWRCaW5hcnkgKGl0ZW0pIHtcbiAgICAvLyBJbnZva2UgY3VzdG9tIGhhbmRsZVxuICAgIGlmIChpdGVtLmxvYWQpIHtcbiAgICAgICAgcmV0dXJuIGl0ZW0ubG9hZChpdGVtLmNvbnRlbnQpO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxufVxuXG4vLz09PT09PT09PT09PT09PS8vXG4vLyBQVlIgY29uc3RhbnRzIC8vXG4vLz09PT09PT09PT09PT09PS8vXG4vLyBodHRwczovL2dpdGh1Yi5jb20vdG9qaS90ZXh0dXJlLXRlc3Rlci9ibG9iL21hc3Rlci9qcy93ZWJnbC10ZXh0dXJlLXV0aWwuanMjTDQyNFxuY29uc3QgUFZSX0hFQURFUl9MRU5HVEggPSAxMzsgLy8gVGhlIGhlYWRlciBsZW5ndGggaW4gMzIgYml0IGludHMuXG5jb25zdCBQVlJfTUFHSUMgPSAweDAzNTI1NjUwOyAvLzB4NTA1NjUyMDM7XG5cbi8vIE9mZnNldHMgaW50byB0aGUgaGVhZGVyIGFycmF5LlxuY29uc3QgUFZSX0hFQURFUl9NQUdJQyA9IDA7XG5jb25zdCBQVlJfSEVBREVSX0ZPUk1BVCA9IDI7XG5jb25zdCBQVlJfSEVBREVSX0hFSUdIVCA9IDY7XG5jb25zdCBQVlJfSEVBREVSX1dJRFRIID0gNztcbmNvbnN0IFBWUl9IRUFERVJfTUlQTUFQQ09VTlQgPSAxMTtcbmNvbnN0IFBWUl9IRUFERVJfTUVUQURBVEEgPSAxMjtcblxuZnVuY3Rpb24gbG9hZFBWUlRleCAoaXRlbSkge1xuICAgIGxldCBidWZmZXIgPSBpdGVtLmNvbnRlbnQgaW5zdGFuY2VvZiBBcnJheUJ1ZmZlciA/IGl0ZW0uY29udGVudCA6IGl0ZW0uY29udGVudC5idWZmZXI7XG4gICAgLy8gR2V0IGEgdmlldyBvZiB0aGUgYXJyYXlCdWZmZXIgdGhhdCByZXByZXNlbnRzIHRoZSBERFMgaGVhZGVyLlxuICAgIGxldCBoZWFkZXIgPSBuZXcgSW50MzJBcnJheShidWZmZXIsIDAsIFBWUl9IRUFERVJfTEVOR1RIKTtcblxuICAgIC8vIERvIHNvbWUgc2FuaXR5IGNoZWNrcyB0byBtYWtlIHN1cmUgdGhpcyBpcyBhIHZhbGlkIEREUyBmaWxlLlxuICAgIGlmKGhlYWRlcltQVlJfSEVBREVSX01BR0lDXSAhPSBQVlJfTUFHSUMpIHtcbiAgICAgIHJldHVybiBuZXcgRXJyb3IoXCJJbnZhbGlkIG1hZ2ljIG51bWJlciBpbiBQVlIgaGVhZGVyXCIpO1xuICAgIH1cblxuICAgIC8vIEdhdGhlciBvdGhlciBiYXNpYyBtZXRyaWNzIGFuZCBhIHZpZXcgb2YgdGhlIHJhdyB0aGUgRFhUIGRhdGEuXG4gICAgbGV0IHdpZHRoID0gaGVhZGVyW1BWUl9IRUFERVJfV0lEVEhdO1xuICAgIGxldCBoZWlnaHQgPSBoZWFkZXJbUFZSX0hFQURFUl9IRUlHSFRdO1xuICAgIGxldCBkYXRhT2Zmc2V0ID0gaGVhZGVyW1BWUl9IRUFERVJfTUVUQURBVEFdICsgNTI7XG4gICAgbGV0IHB2cnRjRGF0YSA9IG5ldyBVaW50OEFycmF5KGJ1ZmZlciwgZGF0YU9mZnNldCk7XG5cbiAgICBsZXQgcHZyQXNzZXQgPSB7XG4gICAgICAgIF9kYXRhOiBwdnJ0Y0RhdGEsXG4gICAgICAgIF9jb21wcmVzc2VkOiB0cnVlLFxuXG4gICAgICAgIHdpZHRoOiB3aWR0aCxcbiAgICAgICAgaGVpZ2h0OiBoZWlnaHQsXG4gICAgfTtcblxuICAgIHJldHVybiBwdnJBc3NldDtcbn1cblxuLy89PT09PT09PT09PT09PT0vL1xuLy8gRVRDIGNvbnN0YW50cyAvL1xuLy89PT09PT09PT09PT09PT0vL1xuXG5jb25zdCBFVENfUEtNX0hFQURFUl9TSVpFID0gMTY7XG5cbmNvbnN0IEVUQ19QS01fRk9STUFUX09GRlNFVCA9IDY7XG5jb25zdCBFVENfUEtNX0VOQ09ERURfV0lEVEhfT0ZGU0VUID0gODtcbmNvbnN0IEVUQ19QS01fRU5DT0RFRF9IRUlHSFRfT0ZGU0VUID0gMTA7XG5jb25zdCBFVENfUEtNX1dJRFRIX09GRlNFVCA9IDEyO1xuY29uc3QgRVRDX1BLTV9IRUlHSFRfT0ZGU0VUID0gMTQ7XG5cbmNvbnN0IEVUQzFfUkdCX05PX01JUE1BUFMgICA9IDA7XG5jb25zdCBFVEMyX1JHQl9OT19NSVBNQVBTICAgPSAxO1xuY29uc3QgRVRDMl9SR0JBX05PX01JUE1BUFMgID0gMztcblxuXG5mdW5jdGlvbiByZWFkQkVVaW50MTYoaGVhZGVyLCBvZmZzZXQpIHtcbiAgICByZXR1cm4gKGhlYWRlcltvZmZzZXRdIDw8IDgpIHwgaGVhZGVyW29mZnNldCsxXTtcbn1cbmZ1bmN0aW9uIGxvYWRQS01UZXgoaXRlbSkge1xuICAgIGxldCBidWZmZXIgPSBpdGVtLmNvbnRlbnQgaW5zdGFuY2VvZiBBcnJheUJ1ZmZlciA/IGl0ZW0uY29udGVudCA6IGl0ZW0uY29udGVudC5idWZmZXI7XG4gICAgbGV0IGhlYWRlciA9IG5ldyBVaW50OEFycmF5KGJ1ZmZlcik7XG4gICAgbGV0IGZvcm1hdCA9IHJlYWRCRVVpbnQxNihoZWFkZXIsIEVUQ19QS01fRk9STUFUX09GRlNFVCk7XG4gICAgaWYgKGZvcm1hdCAhPT0gRVRDMV9SR0JfTk9fTUlQTUFQUyAmJiBmb3JtYXQgIT09IEVUQzJfUkdCX05PX01JUE1BUFMgJiYgZm9ybWF0ICE9PSBFVEMyX1JHQkFfTk9fTUlQTUFQUykge1xuICAgICAgICByZXR1cm4gbmV3IEVycm9yKFwiSW52YWxpZCBtYWdpYyBudW1iZXIgaW4gRVRDIGhlYWRlclwiKTtcbiAgICB9XG4gICAgbGV0IHdpZHRoID0gcmVhZEJFVWludDE2KGhlYWRlciwgRVRDX1BLTV9XSURUSF9PRkZTRVQpO1xuICAgIGxldCBoZWlnaHQgPSByZWFkQkVVaW50MTYoaGVhZGVyLCBFVENfUEtNX0hFSUdIVF9PRkZTRVQpO1xuICAgIGxldCBlbmNvZGVkV2lkdGggPSByZWFkQkVVaW50MTYoaGVhZGVyLCBFVENfUEtNX0VOQ09ERURfV0lEVEhfT0ZGU0VUKTtcbiAgICBsZXQgZW5jb2RlZEhlaWdodCA9IHJlYWRCRVVpbnQxNihoZWFkZXIsIEVUQ19QS01fRU5DT0RFRF9IRUlHSFRfT0ZGU0VUKTtcbiAgICBsZXQgZXRjRGF0YSA9IG5ldyBVaW50OEFycmF5KGJ1ZmZlciwgRVRDX1BLTV9IRUFERVJfU0laRSk7XG4gICAgbGV0IGV0Y0Fzc2V0ID0ge1xuICAgICAgICBfZGF0YTogZXRjRGF0YSxcbiAgICAgICAgX2NvbXByZXNzZWQ6IHRydWUsXG4gICAgICAgIHdpZHRoOiB3aWR0aCxcbiAgICAgICAgaGVpZ2h0OiBoZWlnaHRcbiAgICB9O1xuICAgIHJldHVybiBldGNBc3NldDtcbn1cblxudmFyIGRlZmF1bHRNYXAgPSB7XG4gICAgLy8gSW1hZ2VzXG4gICAgJ3BuZycgOiBsb2FkSW1hZ2UsXG4gICAgJ2pwZycgOiBsb2FkSW1hZ2UsXG4gICAgJ2JtcCcgOiBsb2FkSW1hZ2UsXG4gICAgJ2pwZWcnIDogbG9hZEltYWdlLFxuICAgICdnaWYnIDogbG9hZEltYWdlLFxuICAgICdpY28nIDogbG9hZEltYWdlLFxuICAgICd0aWZmJyA6IGxvYWRJbWFnZSxcbiAgICAnd2VicCcgOiBsb2FkSW1hZ2UsXG4gICAgJ2ltYWdlJyA6IGxvYWRJbWFnZSxcbiAgICAncHZyJyA6IGxvYWRQVlJUZXgsXG4gICAgJ3BrbScgOiBsb2FkUEtNVGV4LFxuXG4gICAgLy8gQXVkaW9cbiAgICAnbXAzJyA6IGxvYWRBdWRpb0FzQXNzZXQsXG4gICAgJ29nZycgOiBsb2FkQXVkaW9Bc0Fzc2V0LFxuICAgICd3YXYnIDogbG9hZEF1ZGlvQXNBc3NldCxcbiAgICAnbTRhJyA6IGxvYWRBdWRpb0FzQXNzZXQsXG5cbiAgICAvLyBqc29uXG4gICAgJ2pzb24nIDogbG9hZEpTT04sXG4gICAgJ0V4cG9ydEpzb24nIDogbG9hZEpTT04sXG5cbiAgICAvLyBwbGlzdFxuICAgICdwbGlzdCcgOiBsb2FkUGxpc3QsXG5cbiAgICAvLyBhc3NldFxuICAgICd1dWlkJyA6IGxvYWRVdWlkLFxuICAgICdwcmVmYWInIDogbG9hZFV1aWQsXG4gICAgJ2ZpcmUnIDogbG9hZFV1aWQsXG4gICAgJ3NjZW5lJyA6IGxvYWRVdWlkLFxuXG4gICAgLy8gYmluYXJ5XG4gICAgJ2JpbmFyeScgOiBsb2FkQmluYXJ5LFxuICAgICdkYmJpbicgOiBsb2FkQmluYXJ5LFxuICAgICdiaW4nIDogbG9hZEJpbmFyeSxcbiAgICAnc2tlbCcgOiBsb2FkQmluYXJ5LFxuXG4gICAgLy8gRm9udFxuICAgICdmb250JyA6IGZvbnRMb2FkZXIubG9hZEZvbnQsXG4gICAgJ2VvdCcgOiBmb250TG9hZGVyLmxvYWRGb250LFxuICAgICd0dGYnIDogZm9udExvYWRlci5sb2FkRm9udCxcbiAgICAnd29mZicgOiBmb250TG9hZGVyLmxvYWRGb250LFxuICAgICdzdmcnIDogZm9udExvYWRlci5sb2FkRm9udCxcbiAgICAndHRjJyA6IGZvbnRMb2FkZXIubG9hZEZvbnQsXG5cbiAgICAnZGVmYXVsdCcgOiBsb2FkTm90aGluZ1xufTtcblxudmFyIElEID0gJ0xvYWRlcic7XG5cbi8qKlxuICogVGhlIGxvYWRlciBwaXBlLCBpdCBjYW4gbG9hZCBzZXZlcmFsIHR5cGVzIG9mIGZpbGVzOlxuICogMS4gSW1hZ2VzXG4gKiAyLiBKU09OXG4gKiAzLiBQbGlzdFxuICogNC4gQXVkaW9cbiAqIDUuIEZvbnRcbiAqIDYuIENvY29zIENyZWF0b3Igc2NlbmVcbiAqIEl0IHdpbGwgbm90IGludGVyZmVyZSB3aXRoIGl0ZW1zIG9mIHVua25vd24gdHlwZS5cbiAqIFlvdSBjYW4gcGFzcyBjdXN0b20gc3VwcG9ydGVkIHR5cGVzIGluIHRoZSBjb25zdHJ1Y3Rvci5cbiAqIEBjbGFzcyBQaXBlbGluZS5Mb2FkZXJcbiAqL1xuLyoqXG4gKiBDb25zdHJ1Y3RvciBvZiBMb2FkZXIsIHlvdSBjYW4gcGFzcyBjdXN0b20gc3VwcG9ydGVkIHR5cGVzLlxuICpcbiAqIEBtZXRob2QgY29uc3RydWN0b3JcbiAqIEBwYXJhbSB7T2JqZWN0fSBleHRNYXAgQ3VzdG9tIHN1cHBvcnRlZCB0eXBlcyB3aXRoIGNvcnJlc3BvbmRlZCBoYW5kbGVyXG4gKiBAZXhhbXBsZVxuICp2YXIgbG9hZGVyID0gbmV3IExvYWRlcih7XG4gKiAgICAvLyBUaGlzIHdpbGwgbWF0Y2ggYWxsIHVybCB3aXRoIGAuc2NlbmVgIGV4dGVuc2lvbiBvciBhbGwgdXJsIHdpdGggYHNjZW5lYCB0eXBlXG4gKiAgICAnc2NlbmUnIDogZnVuY3Rpb24gKHVybCwgY2FsbGJhY2spIHt9XG4gKn0pO1xuICovXG52YXIgTG9hZGVyID0gZnVuY3Rpb24gKGV4dE1hcCkge1xuICAgIHRoaXMuaWQgPSBJRDtcbiAgICB0aGlzLmFzeW5jID0gdHJ1ZTtcbiAgICB0aGlzLnBpcGVsaW5lID0gbnVsbDtcblxuICAgIHRoaXMuZXh0TWFwID0ganMubWl4aW4oZXh0TWFwLCBkZWZhdWx0TWFwKTtcbn07XG5Mb2FkZXIuSUQgPSBJRDtcblxuLyoqXG4gKiBBZGQgY3VzdG9tIHN1cHBvcnRlZCB0eXBlcyBoYW5kbGVyIG9yIG1vZGlmeSBleGlzdGluZyB0eXBlIGhhbmRsZXIuXG4gKiBAbWV0aG9kIGFkZEhhbmRsZXJzXG4gKiBAcGFyYW0ge09iamVjdH0gZXh0TWFwIEN1c3RvbSBzdXBwb3J0ZWQgdHlwZXMgd2l0aCBjb3JyZXNwb25kZWQgaGFuZGxlclxuICovXG5Mb2FkZXIucHJvdG90eXBlLmFkZEhhbmRsZXJzID0gZnVuY3Rpb24gKGV4dE1hcCkge1xuICAgIHRoaXMuZXh0TWFwID0ganMubWl4aW4odGhpcy5leHRNYXAsIGV4dE1hcCk7XG59O1xuXG5Mb2FkZXIucHJvdG90eXBlLmhhbmRsZSA9IGZ1bmN0aW9uIChpdGVtLCBjYWxsYmFjaykge1xuICAgIHZhciBsb2FkRnVuYyA9IHRoaXMuZXh0TWFwW2l0ZW0udHlwZV0gfHwgdGhpcy5leHRNYXBbJ2RlZmF1bHQnXTtcbiAgICByZXR1cm4gbG9hZEZ1bmMuY2FsbCh0aGlzLCBpdGVtLCBjYWxsYmFjayk7XG59O1xuXG5QaXBlbGluZS5Mb2FkZXIgPSBtb2R1bGUuZXhwb3J0cyA9IExvYWRlcjtcbiJdLCJzb3VyY2VSb290IjoiLyJ9