
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/font-loader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var textUtils = require('../utils/text-utils');

var _canvasContext = null; // letter symbol number CJK

var _testString = "BES bswy:->@123\u4E01\u3041\u1101";
var _fontFaces = {};

var _intervalId = -1;

var _loadingFonts = []; // 3 seconds timeout

var _timeout = 3000; // Refer to https://github.com/typekit/webfontloader/blob/master/src/core/fontwatcher.js

var useNativeCheck = function () {
  var nativeCheck = undefined;
  return function () {
    if (nativeCheck === undefined) {
      if (!!window.FontFace) {
        var match = /Gecko.*Firefox\/(\d+)/.exec(window.navigator.userAgent);
        var safari10Match = /OS X.*Version\/10\..*Safari/.exec(window.navigator.userAgent) && /Apple/.exec(window.navigator.vendor);

        if (match) {
          nativeCheck = parseInt(match[1], 10) > 42;
        } else if (safari10Match) {
          nativeCheck = false;
        } else {
          nativeCheck = true;
        }
      } else {
        nativeCheck = false;
      }
    }

    return nativeCheck;
  };
}();

function _checkFontLoaded() {
  var allFontsLoaded = true;
  var now = Date.now();

  for (var i = _loadingFonts.length - 1; i >= 0; i--) {
    var fontLoadHandle = _loadingFonts[i];
    var fontFamily = fontLoadHandle.fontFamilyName; // load timeout

    if (now - fontLoadHandle.startTime > _timeout) {
      cc.warnID(4933, fontFamily);
      fontLoadHandle.callback(null, fontFamily);

      _loadingFonts.splice(i, 1);

      continue;
    }

    var oldWidth = fontLoadHandle.refWidth;
    var fontDesc = '40px ' + fontFamily;
    _canvasContext.font = fontDesc;
    var newWidth = textUtils.safeMeasureText(_canvasContext, _testString, fontDesc); // loaded successfully

    if (oldWidth !== newWidth) {
      _loadingFonts.splice(i, 1);

      fontLoadHandle.callback(null, fontFamily);
    } else {
      allFontsLoaded = false;
    }
  }

  if (allFontsLoaded) {
    clearInterval(_intervalId);
    _intervalId = -1;
  }
} // refer to https://github.com/typekit/webfontloader/blob/master/src/core/nativefontwatchrunner.js


function nativeCheckFontLoaded(start, font, callback) {
  var loader = new Promise(function (resolve, reject) {
    var check = function check() {
      var now = Date.now();

      if (now - start >= _timeout) {
        reject();
      } else {
        document.fonts.load('40px ' + font).then(function (fonts) {
          if (fonts.length >= 1) {
            resolve();
          } else {
            setTimeout(check, 100);
          }
        }, function () {
          reject();
        });
      }
    };

    check();
  });
  var timeoutId = null,
      timer = new Promise(function (resolve, reject) {
    timeoutId = setTimeout(reject, _timeout);
  });
  Promise.race([timer, loader]).then(function () {
    if (timeoutId) {
      clearTimeout(timeoutId);
      timeoutId = null;
    }

    callback(null, font);
  }, function () {
    cc.warnID(4933, font);
    callback(null, font);
  });
}

var fontLoader = {
  loadFont: function loadFont(item, callback) {
    var url = item.url;

    var fontFamilyName = fontLoader._getFontFamily(url); // Already loaded fonts


    if (_fontFaces[fontFamilyName]) {
      return fontFamilyName;
    }

    if (!_canvasContext) {
      var labelCanvas = document.createElement('canvas');
      labelCanvas.width = 100;
      labelCanvas.height = 100;
      _canvasContext = labelCanvas.getContext('2d');
    } // Default width reference to test whether new font is loaded correctly


    var fontDesc = '40px ' + fontFamilyName;
    _canvasContext.font = fontDesc;
    var refWidth = textUtils.safeMeasureText(_canvasContext, _testString, fontDesc); // Setup font face style

    var fontStyle = document.createElement("style");
    fontStyle.type = "text/css";
    var fontStr = "";
    if (isNaN(fontFamilyName - 0)) fontStr += "@font-face { font-family:" + fontFamilyName + "; src:";else fontStr += "@font-face { font-family:'" + fontFamilyName + "'; src:";
    fontStr += "url('" + url + "');";
    fontStyle.textContent = fontStr + "}";
    document.body.appendChild(fontStyle); // Preload font with div

    var preloadDiv = document.createElement("div");
    var divStyle = preloadDiv.style;
    divStyle.fontFamily = fontFamilyName;
    preloadDiv.innerHTML = ".";
    divStyle.position = "absolute";
    divStyle.left = "-100px";
    divStyle.top = "-100px";
    document.body.appendChild(preloadDiv);

    if (useNativeCheck()) {
      nativeCheckFontLoaded(Date.now(), fontFamilyName, callback);
    } else {
      // Save loading font
      var fontLoadHandle = {
        fontFamilyName: fontFamilyName,
        refWidth: refWidth,
        callback: callback,
        startTime: Date.now()
      };

      _loadingFonts.push(fontLoadHandle);

      if (_intervalId === -1) {
        _intervalId = setInterval(_checkFontLoaded, 100);
      }
    }

    _fontFaces[fontFamilyName] = fontStyle;
  },
  _getFontFamily: function _getFontFamily(fontHandle) {
    var ttfIndex = fontHandle.lastIndexOf(".ttf");
    if (ttfIndex === -1) return fontHandle;
    var slashPos = fontHandle.lastIndexOf("/");
    var fontFamilyName;

    if (slashPos === -1) {
      fontFamilyName = fontHandle.substring(0, ttfIndex) + "_LABEL";
    } else {
      fontFamilyName = fontHandle.substring(slashPos + 1, ttfIndex) + "_LABEL";
    }

    if (fontFamilyName.indexOf(' ') !== -1) {
      fontFamilyName = '"' + fontFamilyName + '"';
    }

    return fontFamilyName;
  }
};
module.exports = fontLoader;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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