
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/downloader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = require('../platform/js');

var debug = require('../CCDebug');

require('../utils/CCPath');

var Pipeline = require('./pipeline');

var PackDownloader = require('./pack-downloader');

var downloadBinary = require('./binary-downloader');

var downloadText = require('./text-downloader');

var urlAppendTimestamp = require('./utils').urlAppendTimestamp;

var downloadAudio;

if (!CC_EDITOR || !Editor.isMainProcess) {
  downloadAudio = require('./audio-downloader');
} else {
  downloadAudio = null;
}

function skip() {
  return null;
}

function downloadScript(item, callback, isAsync) {
  var url = item.url,
      d = document,
      s = document.createElement('script');

  if (window.location.protocol !== 'file:') {
    s.crossOrigin = 'anonymous';
  }

  s.async = isAsync;
  s.src = urlAppendTimestamp(url);

  function loadHandler() {
    s.parentNode.removeChild(s);
    s.removeEventListener('load', loadHandler, false);
    s.removeEventListener('error', errorHandler, false);
    callback(null, url);
  }

  function errorHandler() {
    s.parentNode.removeChild(s);
    s.removeEventListener('load', loadHandler, false);
    s.removeEventListener('error', errorHandler, false);
    callback(new Error(debug.getError(4928, url)));
  }

  s.addEventListener('load', loadHandler, false);
  s.addEventListener('error', errorHandler, false);
  d.body.appendChild(s);
}

function downloadImage(item, callback, isCrossOrigin, img) {
  if (isCrossOrigin === undefined) {
    isCrossOrigin = true;
  }

  var url = urlAppendTimestamp(item.url);
  img = img || new Image();

  if (isCrossOrigin && window.location.protocol !== 'file:') {
    img.crossOrigin = 'anonymous';
  } else {
    img.crossOrigin = null;
  }

  if (img.complete && img.naturalWidth > 0 && img.src === url) {
    return img;
  } else {
    var loadCallback = function loadCallback() {
      img.removeEventListener('load', loadCallback);
      img.removeEventListener('error', errorCallback);
      img.id = item.id;
      callback(null, img);
    };

    var errorCallback = function errorCallback() {
      img.removeEventListener('load', loadCallback);
      img.removeEventListener('error', errorCallback); // Retry without crossOrigin mark if crossOrigin loading fails
      // Do not retry if protocol is https, even if the image is loaded, cross origin image isn't renderable.

      if (window.location.protocol !== 'https:' && img.crossOrigin && img.crossOrigin.toLowerCase() === 'anonymous') {
        downloadImage(item, callback, false, img);
      } else {
        callback(new Error(debug.getError(4930, url)));
      }
    };

    img.addEventListener('load', loadCallback);
    img.addEventListener('error', errorCallback);
    img.src = url;
  }
}

function downloadUuid(item, callback) {
  var result = PackDownloader.load(item, callback);

  if (result === undefined) {
    return this.extMap['json'](item, callback);
  }

  return result || undefined;
}

function downloadVideo(item, callback) {
  callback(null, item.url);
}

var defaultMap = {
  // JS
  'js': downloadScript,
  // Images
  'png': downloadImage,
  'jpg': downloadImage,
  'bmp': downloadImage,
  'jpeg': downloadImage,
  'gif': downloadImage,
  'ico': downloadImage,
  'tiff': downloadImage,
  'webp': downloadImage,
  'image': downloadImage,
  'pvr': downloadBinary,
  'pkm': downloadBinary,
  // Audio
  'mp3': downloadAudio,
  'ogg': downloadAudio,
  'wav': downloadAudio,
  'm4a': downloadAudio,
  // Txt
  'txt': downloadText,
  'xml': downloadText,
  'vsh': downloadText,
  'fsh': downloadText,
  'atlas': downloadText,
  'tmx': downloadText,
  'tsx': downloadText,
  'json': downloadText,
  'ExportJson': downloadText,
  'plist': downloadText,
  'fnt': downloadText,
  // Font
  'font': skip,
  'eot': skip,
  'ttf': skip,
  'woff': skip,
  'svg': skip,
  'ttc': skip,
  // Deserializer
  'uuid': downloadUuid,
  // Binary
  'binary': downloadBinary,
  'bin': downloadBinary,
  'dbbin': downloadBinary,
  'skel': downloadBinary,
  // Video
  'mp4': downloadVideo,
  'avi': downloadVideo,
  'mov': downloadVideo,
  'mpg': downloadVideo,
  'mpeg': downloadVideo,
  'rm': downloadVideo,
  'rmvb': downloadVideo,
  'default': downloadText
};
var ID = 'Downloader';
/**
 * The downloader pipe, it can download several types of files:
 * 1. Text
 * 2. Image
 * 3. Script
 * 4. Audio
 * 5. Assets
 * All unknown type will be downloaded as plain text.
 * You can pass custom supported types in the constructor.
 * @class Pipeline.Downloader
 */

/**
 * Constructor of Downloader, you can pass custom supported types.
 *
 * @method constructor
 * @param {Object} extMap Custom supported types with corresponded handler
 * @example
 *  var downloader = new Downloader({
 *      // This will match all url with `.scene` extension or all url with `scene` type
 *      'scene' : function (url, callback) {}
 *  });
 */

var Downloader = function Downloader(extMap) {
  this.id = ID;
  this.async = true;
  this.pipeline = null;
  this._curConcurrent = 0;
  this._loadQueue = [];
  this._subpackages = {};
  this.extMap = js.mixin(extMap, defaultMap);
};

Downloader.ID = ID;
Downloader.PackDownloader = PackDownloader;
/**
 * Add custom supported types handler or modify existing type handler.
 * @method addHandlers
 * @param {Object} extMap Custom supported types with corresponded handler
 */

Downloader.prototype.addHandlers = function (extMap) {
  js.mixin(this.extMap, extMap);
};

Downloader.prototype._handleLoadQueue = function () {
  while (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
    var nextOne = this._loadQueue.shift();

    if (!nextOne) {
      break;
    }

    var syncRet = this.handle(nextOne.item, nextOne.callback);

    if (syncRet !== undefined) {
      if (syncRet instanceof Error) {
        nextOne.callback(syncRet);
      } else {
        nextOne.callback(null, syncRet);
      }
    }
  }
};

Downloader.prototype.handle = function (item, callback) {
  var self = this;
  var downloadFunc = this.extMap[item.type] || this.extMap['default'];
  var syncRet = undefined;

  if (this._curConcurrent < cc.macro.DOWNLOAD_MAX_CONCURRENT) {
    this._curConcurrent++;
    syncRet = downloadFunc.call(this, item, function (err, result) {
      self._curConcurrent = Math.max(0, self._curConcurrent - 1);

      self._handleLoadQueue();

      callback && callback(err, result);
    });

    if (syncRet !== undefined) {
      this._curConcurrent = Math.max(0, this._curConcurrent - 1);

      this._handleLoadQueue();

      return syncRet;
    }
  } else if (item.ignoreMaxConcurrency) {
    syncRet = downloadFunc.call(this, item, callback);

    if (syncRet !== undefined) {
      return syncRet;
    }
  } else {
    this._loadQueue.push({
      item: item,
      callback: callback
    });
  }
};
/**
 * !#en
 * Load subpackage with name.
 * !#zh
 * 通过子包名加载子包代码。
 * @method loadSubpackage
 * @param {String} name - Subpackage name
 * @param {Function} [progressCallback] - Callback when progress changed
 * @param {Function} [completeCallback] -  Callback invoked when subpackage loaded
 * @param {Error} completeCallback.error - error information
 */


Downloader.prototype.loadSubpackage = function (name, progressCallback, completeCallback) {
  if (!completeCallback && progressCallback) {
    completeCallback = progressCallback;
    progressCallback = null;
  }

  var pac = this._subpackages[name];

  if (pac) {
    if (pac.loaded) {
      if (completeCallback) completeCallback();
    } else {
      downloadScript({
        url: pac.path + 'index.js'
      }, function (err) {
        if (!err) {
          pac.loaded = true;
        }

        if (completeCallback) completeCallback(err);
      });
    }
  } else if (completeCallback) {
    completeCallback(new Error("Can't find subpackage " + name));
  }
};

Pipeline.Downloader = module.exports = Downloader;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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