
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/auto-release-utils.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = require('../platform/js');

function parseDepends(key, parsed) {
  var item = cc.loader.getItem(key);

  if (item) {
    var depends = item.dependKeys;

    if (depends) {
      for (var i = 0; i < depends.length; i++) {
        var depend = depends[i];

        if (!parsed[depend]) {
          parsed[depend] = true;
          parseDepends(depend, parsed);
        }
      }
    }
  }
}

function visitAsset(asset, excludeMap) {
  // Skip assets generated programmatically or by user (e.g. label texture)
  if (!asset._uuid) {
    return;
  }

  var key = cc.loader._getReferenceKey(asset);

  if (!excludeMap[key]) {
    excludeMap[key] = true;
    parseDepends(key, excludeMap);
  }
}

function visitComponent(comp, excludeMap) {
  var props = Object.getOwnPropertyNames(comp);

  for (var i = 0; i < props.length; i++) {
    var value = comp[props[i]];

    if (typeof value === 'object' && value) {
      if (Array.isArray(value)) {
        for (var j = 0; j < value.length; j++) {
          var val = value[j];

          if (val instanceof cc.RawAsset) {
            visitAsset(val, excludeMap);
          }
        }
      } else if (!value.constructor || value.constructor === Object) {
        var keys = Object.getOwnPropertyNames(value);

        for (var _j = 0; _j < keys.length; _j++) {
          var _val = value[keys[_j]];

          if (_val instanceof cc.RawAsset) {
            visitAsset(_val, excludeMap);
          }
        }
      } else if (value instanceof cc.RawAsset) {
        visitAsset(value, excludeMap);
      }
    }
  }
}

function visitNode(node, excludeMap) {
  for (var i = 0; i < node._components.length; i++) {
    visitComponent(node._components[i], excludeMap);
  }

  for (var _i = 0; _i < node._children.length; _i++) {
    visitNode(node._children[_i], excludeMap);
  }
}

module.exports = {
  // do auto release
  autoRelease: function autoRelease(oldSceneAssets, nextSceneAssets, persistNodes) {
    var releaseSettings = cc.loader._autoReleaseSetting;
    var excludeMap = js.createMap(); // collect next scene assets

    if (nextSceneAssets) {
      for (var i = 0; i < nextSceneAssets.length; i++) {
        excludeMap[nextSceneAssets[i]] = true;
      }
    } // collect assets used by persist nodes


    for (var _i2 = 0; _i2 < persistNodes.length; _i2++) {
      visitNode(persistNodes[_i2], excludeMap);
    } // remove ununsed scene assets


    if (oldSceneAssets) {
      for (var _i3 = 0; _i3 < oldSceneAssets.length; _i3++) {
        var key = oldSceneAssets[_i3];

        if (releaseSettings[key] !== false && !excludeMap[key]) {
          cc.loader.release(key);
        }
      }
    } // remove auto release assets
    // (releasing asset will change _autoReleaseSetting, so don't use for-in)


    var keys = Object.keys(releaseSettings);

    for (var _i4 = 0; _i4 < keys.length; _i4++) {
      var _key = keys[_i4];

      if (releaseSettings[_key] === true && !excludeMap[_key]) {
        cc.loader.release(_key);
      }
    }
  },
  // get dependencies not including self
  getDependsRecursively: function getDependsRecursively(key) {
    var depends = {};
    parseDepends(key, depends);
    return Object.keys(depends);
  }
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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