
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/audio-downloader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var sys = require('../platform/CCSys');

var debug = require('../CCDebug');

var __audioSupport = sys.__audioSupport;
var formatSupport = __audioSupport.format;
var context = __audioSupport.context;

function loadDomAudio(item, callback) {
  var dom = document.createElement('audio');
  dom.src = item.url;

  var clearEvent = function clearEvent() {
    clearTimeout(timer);
    dom.removeEventListener("canplaythrough", success, false);
    dom.removeEventListener("error", failure, false);
    if (__audioSupport.USE_LOADER_EVENT) dom.removeEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
  };

  var timer = setTimeout(function () {
    if (dom.readyState === 0) failure();else success();
  }, 8000);

  var success = function success() {
    clearEvent();
    callback(null, dom);
  };

  var failure = function failure() {
    clearEvent();
    var message = 'load audio failure - ' + item.url;
    cc.log(message);
    callback(message);
  };

  dom.addEventListener("canplaythrough", success, false);
  dom.addEventListener("error", failure, false);
  if (__audioSupport.USE_LOADER_EVENT) dom.addEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
}

function loadWebAudio(item, callback) {
  if (!context) callback(new Error(debug.getError(4926)));
  var request = cc.loader.getXMLHttpRequest();
  request.open("GET", item.url, true);
  request.responseType = "arraybuffer"; // Our asynchronous callback

  request.onload = function () {
    context["decodeAudioData"](request.response, function (buffer) {
      //success
      callback(null, buffer);
    }, function () {
      //error
      callback('decode error - ' + item.id, null);
    });
  };

  request.onerror = function () {
    callback('request error - ' + item.id, null);
  };

  request.send();
}

function downloadAudio(item, callback) {
  if (formatSupport.length === 0) {
    return new Error(debug.getError(4927));
  }

  var loader;

  if (!__audioSupport.WEB_AUDIO) {
    // If WebAudio is not supported, load using DOM mode
    loader = loadDomAudio;
  } else {
    var loadByDeserializedAudio = item._owner instanceof cc.AudioClip;

    if (loadByDeserializedAudio) {
      loader = item._owner.loadMode === cc.AudioClip.LoadMode.WEB_AUDIO ? loadWebAudio : loadDomAudio;
    } else {
      loader = item.urlParam && item.urlParam['useDom'] ? loadDomAudio : loadWebAudio;
    }
  }

  loader(item, callback);
}

module.exports = downloadAudio;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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