
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/asset-table.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var pushToMap = require('../utils/misc').pushToMap;

var js = require('../platform/js');

function Entry(uuid, type) {
  this.uuid = uuid;
  this.type = type;
}
/*
 * !#en AssetTable is used to find asset's uuid by url.
 * !#zh AssetTable 用于查找资源的 uuid 和 url。
 * @class AssetTable
 *
 */


function AssetTable() {
  this._pathToUuid = js.createMap(true);
}

function isMatchByWord(path, test) {
  if (path.length > test.length) {
    var nextAscii = path.charCodeAt(test.length);
    return nextAscii === 46 || nextAscii === 47; // '.' or '/'
  }

  return true;
}

var proto = AssetTable.prototype;

proto.getUuid = function (path, type) {
  path = cc.url.normalize(path);
  var item = this._pathToUuid[path];

  if (item) {
    if (Array.isArray(item)) {
      if (type) {
        for (var i = 0; i < item.length; i++) {
          var entry = item[i];

          if (js.isChildClassOf(entry.type, type)) {
            return entry.uuid;
          }
        } // not found


        if (CC_DEBUG && js.isChildClassOf(type, cc.SpriteFrame)) {
          for (var _i = 0; _i < item.length; _i++) {
            var _entry = item[_i];

            if (js.isChildClassOf(_entry.type, cc.SpriteAtlas)) {
              // not support sprite frame in atlas
              cc.errorID(4932, path);
              break;
            }
          }
        }
      } else {
        return item[0].uuid;
      }
    } else if (!type || js.isChildClassOf(item.type, type)) {
      return item.uuid;
    } else if (CC_DEBUG && js.isChildClassOf(type, cc.SpriteFrame) && js.isChildClassOf(item.type, cc.SpriteAtlas)) {
      // not support sprite frame in atlas
      cc.errorID(4932, path);
    }
  }

  return '';
};

proto.getUuidArray = function (path, type, out_urls) {
  path = cc.url.normalize(path);

  if (path[path.length - 1] === '/') {
    path = path.slice(0, -1);
  }

  var path2uuid = this._pathToUuid;
  var uuids = [];
  var isChildClassOf = js.isChildClassOf;

  var _foundAtlasUrl;

  for (var p in path2uuid) {
    if (p.startsWith(path) && isMatchByWord(p, path) || !path) {
      var item = path2uuid[p];

      if (Array.isArray(item)) {
        for (var i = 0; i < item.length; i++) {
          var entry = item[i];

          if (!type || isChildClassOf(entry.type, type)) {
            uuids.push(entry.uuid);

            if (out_urls) {
              out_urls.push(p);
            }
          } else if (CC_DEBUG && entry.type === cc.SpriteAtlas) {
            _foundAtlasUrl = p;
          }
        }
      } else {
        if (!type || isChildClassOf(item.type, type)) {
          uuids.push(item.uuid);

          if (out_urls) {
            out_urls.push(p);
          }
        } else if (CC_DEBUG && item.type === cc.SpriteAtlas) {
          _foundAtlasUrl = p;
        }
      }
    }
  }

  if (CC_DEBUG && uuids.length === 0 && _foundAtlasUrl && js.isChildClassOf(type, cc.SpriteFrame)) {
    // not support sprite frame in atlas
    cc.errorID(4932, _foundAtlasUrl);
  }

  return uuids;
}; // /**
//  * !#en Returns all asset paths in the table.
//  * !#zh 返回表中的所有资源路径。
//  * @method getAllPaths
//  * @return {string[]}
//  */
// proto.getAllPaths = function () {
//     return Object.keys(this._pathToUuid);
// };

/**
 * !#en TODO
 * !#zh 以路径为 key，uuid 为值添加到表中。
 * @method add
 * @param {String} path - the path to load, should NOT include filename extensions.
 * @param {String} uuid
 * @param {Function} type
 * @param {Boolean} isMainAsset
 * @private
 */


proto.add = function (path, uuid, type, isMainAsset) {
  // remove extname
  // (can not use path.slice because length of extname maybe 0)
  path = path.substring(0, path.length - cc.path.extname(path).length);
  var newEntry = new Entry(uuid, type);
  pushToMap(this._pathToUuid, path, newEntry, isMainAsset);
};

proto._getInfo_DEBUG = CC_DEBUG && function (uuid, out_info) {
  var path2uuid = this._pathToUuid;
  var paths = Object.keys(path2uuid);

  for (var p = 0; p < paths.length; ++p) {
    var path = paths[p];
    var item = path2uuid[path];

    if (Array.isArray(item)) {
      for (var i = 0; i < item.length; i++) {
        var entry = item[i];

        if (entry.uuid === uuid) {
          out_info.path = path;
          out_info.type = entry.type;
          return true;
        }
      }
    } else if (item.uuid === uuid) {
      out_info.path = path;
      out_info.type = item.type;
      return true;
    }
  }

  return false;
};

proto.reset = function () {
  this._pathToUuid = js.createMap(true);
};

module.exports = AssetTable;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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