
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/load-pipeline/asset-loader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
require('../utils/CCPath');

var debug = require('../CCDebug');

var Pipeline = require('./pipeline');

var LoadingItems = require('./loading-items');

var ID = 'AssetLoader';

var AssetLoader = function AssetLoader(extMap) {
  this.id = ID;
  this.async = true;
  this.pipeline = null;
};

AssetLoader.ID = ID;
var reusedArray = [];

AssetLoader.prototype.handle = function (item, callback) {
  var uuid = item.uuid;

  if (!uuid) {
    return item.content || null;
  }

  var self = this;
  cc.AssetLibrary.queryAssetInfo(uuid, function (error, url, isRawAsset) {
    if (error) {
      callback(error);
    } else {
      item.url = item.rawUrl = url;
      item.isRawAsset = isRawAsset;

      if (isRawAsset) {
        var ext = cc.path.extname(url).toLowerCase();

        if (!ext) {
          callback(new Error(debug.getError(4931, uuid, url)));
          return;
        }

        ext = ext.substr(1);
        var queue = LoadingItems.getQueue(item);
        reusedArray[0] = {
          queueId: item.queueId,
          id: url,
          url: url,
          type: ext,
          error: null,
          alias: item,
          complete: true
        };

        if (CC_EDITOR) {
          self.pipeline._cache[url] = reusedArray[0];
        }

        queue.append(reusedArray); // Dispatch to other raw type downloader

        item.type = ext;
        callback(null, item.content);
      } else {
        item.type = 'uuid';
        callback(null, item.content);
      }
    }
  });
};

Pipeline.AssetLoader = module.exports = AssetLoader;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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