
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/graphics/helper.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var PointFlags = require('./types').PointFlags;

var PI = Math.PI;
var min = Math.min;
var max = Math.max;
var cos = Math.cos;
var sin = Math.sin;
var abs = Math.abs;
var sign = Math.sign;
var KAPPA90 = 0.5522847493;

function arc(ctx, cx, cy, r, startAngle, endAngle, counterclockwise) {
  counterclockwise = counterclockwise || false;
  var a = 0,
      da = 0,
      hda = 0,
      kappa = 0;
  var dx = 0,
      dy = 0,
      x = 0,
      y = 0,
      tanx = 0,
      tany = 0;
  var px = 0,
      py = 0,
      ptanx = 0,
      ptany = 0;
  var i, ndivs; // Clamp angles

  da = endAngle - startAngle;

  if (counterclockwise) {
    if (abs(da) >= PI * 2) {
      da = PI * 2;
    } else {
      while (da < 0) {
        da += PI * 2;
      }
    }
  } else {
    if (abs(da) >= PI * 2) {
      da = -PI * 2;
    } else {
      while (da > 0) {
        da -= PI * 2;
      }
    }
  } // Split arc into max 90 degree segments.


  ndivs = max(1, min(abs(da) / (PI * 0.5) + 0.5, 5)) | 0;
  hda = da / ndivs / 2.0;
  kappa = abs(4.0 / 3.0 * (1 - cos(hda)) / sin(hda));
  if (!counterclockwise) kappa = -kappa;

  for (i = 0; i <= ndivs; i++) {
    a = startAngle + da * (i / ndivs);
    dx = cos(a);
    dy = sin(a);
    x = cx + dx * r;
    y = cy + dy * r;
    tanx = -dy * r * kappa;
    tany = dx * r * kappa;

    if (i === 0) {
      ctx.moveTo(x, y);
    } else {
      ctx.bezierCurveTo(px + ptanx, py + ptany, x - tanx, y - tany, x, y);
    }

    px = x;
    py = y;
    ptanx = tanx;
    ptany = tany;
  }
}

function ellipse(ctx, cx, cy, rx, ry) {
  ctx.moveTo(cx - rx, cy);
  ctx.bezierCurveTo(cx - rx, cy + ry * KAPPA90, cx - rx * KAPPA90, cy + ry, cx, cy + ry);
  ctx.bezierCurveTo(cx + rx * KAPPA90, cy + ry, cx + rx, cy + ry * KAPPA90, cx + rx, cy);
  ctx.bezierCurveTo(cx + rx, cy - ry * KAPPA90, cx + rx * KAPPA90, cy - ry, cx, cy - ry);
  ctx.bezierCurveTo(cx - rx * KAPPA90, cy - ry, cx - rx, cy - ry * KAPPA90, cx - rx, cy);
  ctx.close();
}

function roundRect(ctx, x, y, w, h, r) {
  if (r < 0.1) {
    ctx.rect(x, y, w, h);
    return;
  } else {
    var rx = min(r, abs(w) * 0.5) * sign(w),
        ry = min(r, abs(h) * 0.5) * sign(h);
    ctx.moveTo(x, y + ry);
    ctx.lineTo(x, y + h - ry);
    ctx.bezierCurveTo(x, y + h - ry * (1 - KAPPA90), x + rx * (1 - KAPPA90), y + h, x + rx, y + h);
    ctx.lineTo(x + w - rx, y + h);
    ctx.bezierCurveTo(x + w - rx * (1 - KAPPA90), y + h, x + w, y + h - ry * (1 - KAPPA90), x + w, y + h - ry);
    ctx.lineTo(x + w, y + ry);
    ctx.bezierCurveTo(x + w, y + ry * (1 - KAPPA90), x + w - rx * (1 - KAPPA90), y, x + w - rx, y);
    ctx.lineTo(x + rx, y);
    ctx.bezierCurveTo(x + rx * (1 - KAPPA90), y, x, y + ry * (1 - KAPPA90), x, y + ry);
    ctx.close();
  }
}

function tesselateBezier(ctx, x1, y1, x2, y2, x3, y3, x4, y4, level, type) {
  var x12, y12, x23, y23, x34, y34, x123, y123, x234, y234, x1234, y1234;
  var dx, dy, d2, d3;
  if (level > 10) return;
  x12 = (x1 + x2) * 0.5;
  y12 = (y1 + y2) * 0.5;
  x23 = (x2 + x3) * 0.5;
  y23 = (y2 + y3) * 0.5;
  x34 = (x3 + x4) * 0.5;
  y34 = (y3 + y4) * 0.5;
  x123 = (x12 + x23) * 0.5;
  y123 = (y12 + y23) * 0.5;
  dx = x4 - x1;
  dy = y4 - y1;
  d2 = abs((x2 - x4) * dy - (y2 - y4) * dx);
  d3 = abs((x3 - x4) * dy - (y3 - y4) * dx);

  if ((d2 + d3) * (d2 + d3) < ctx._tessTol * (dx * dx + dy * dy)) {
    ctx._addPoint(x4, y4, type === 0 ? type | PointFlags.PT_BEVEL : type);

    return;
  }

  x234 = (x23 + x34) * 0.5;
  y234 = (y23 + y34) * 0.5;
  x1234 = (x123 + x234) * 0.5;
  y1234 = (y123 + y234) * 0.5;
  tesselateBezier(ctx, x1, y1, x12, y12, x123, y123, x1234, y1234, level + 1, 0);
  tesselateBezier(ctx, x1234, y1234, x234, y234, x34, y34, x4, y4, level + 1, type);
}

module.exports = {
  arc: arc,
  ellipse: ellipse,
  roundRect: roundRect,
  tesselateBezier: tesselateBezier
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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