
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/geom-utils/triangle.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _vec = _interopRequireDefault(require("../value-types/vec3"));

var _enums = _interopRequireDefault(require("./enums"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * Triangle
 * @class geomUtils.Triangle
 */
var triangle =
/*#__PURE__*/
function () {
  /**
   * create a new triangle
   * @method create
   * @param {number} ax
   * @param {number} ay
   * @param {number} az
   * @param {number} bx
   * @param {number} by
   * @param {number} bz
   * @param {number} cx
   * @param {number} cy
   * @param {number} cz
   * @return {geomUtils.Triangle}
   */
  triangle.create = function create(ax, ay, az, bx, by, bz, cx, cy, cz) {
    return new triangle(ax, ay, az, bx, by, bz, cx, cy, cz);
  }
  /**
   * clone a new triangle
   * @method clone
   * @param {geomUtils.Triangle} t the source plane
   * @return {geomUtils.Triangle}
   */
  ;

  triangle.clone = function clone(t) {
    return new triangle(t.a.x, t.a.y, t.a.z, t.b.x, t.b.y, t.b.z, t.c.x, t.c.y, t.c.z);
  }
  /**
   * copy the values from one triangle to another
   * @method copy
   * @param {geomUtils.Triangle} out the receiving triangle
   * @param {geomUtils.Triangle} t the source triangle
   * @return {geomUtils.Triangle}
   */
  ;

  triangle.copy = function copy(out, t) {
    _vec["default"].copy(out.a, t.a);

    _vec["default"].copy(out.b, t.b);

    _vec["default"].copy(out.c, t.c);

    return out;
  }
  /**
   * Create a triangle from three points
   * @method fromPoints
   * @param {geomUtils.Triangle} out the receiving triangle
   * @param {Vec3} a
   * @param {Vec3} b
   * @param {Vec3} c
   * @return {geomUtils.Triangle}
   */
  ;

  triangle.fromPoints = function fromPoints(out, a, b, c) {
    _vec["default"].copy(out.a, a);

    _vec["default"].copy(out.b, b);

    _vec["default"].copy(out.c, c);

    return out;
  }
  /**
   * Set the components of a triangle to the given values
   *
   * @method set
   * @param {geomUtils.Triangle} out the receiving plane
   * @param {number} ax X component of a
   * @param {number} ay Y component of a
   * @param {number} az Z component of a
   * @param {number} bx X component of b
   * @param {number} by Y component of b
   * @param {number} bz Z component of b
   * @param {number} cx X component of c
   * @param {number} cy Y component of c
   * @param {number} cz Z component of c
   * @return {Plane}
   */
  ;

  triangle.set = function set(out, ax, ay, az, bx, by, bz, cx, cy, cz) {
    out.a.x = ax;
    out.a.y = ay;
    out.a.z = az;
    out.b.x = bx;
    out.b.y = by;
    out.b.z = bz;
    out.c.x = cx;
    out.c.y = cy;
    out.c.z = cz;
    return out;
  }
  /**
   * @property {Vec3} a
   */
  ;

  /**
   * create a new triangle
   * @constructor
   * @param {number} ax
   * @param {number} ay
   * @param {number} az
   * @param {number} bx
   * @param {number} by
   * @param {number} bz
   * @param {number} cx
   * @param {number} cy
   * @param {number} cz
   */
  function triangle(ax, ay, az, bx, by, bz, cx, cy, cz) {
    this.a = void 0;
    this.b = void 0;
    this.c = void 0;
    this._type = void 0;
    this.a = new _vec["default"](ax, ay, az);
    this.b = new _vec["default"](bx, by, bz);
    this.c = new _vec["default"](cx, cy, cz);
    this._type = _enums["default"].SHAPE_TRIANGLE;
    ;
  }

  return triangle;
}();

exports["default"] = triangle;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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