
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/geom-utils/obb.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../value-types");

var _enums = _interopRequireDefault(require("./enums"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _v3_tmp = new _valueTypes.Vec3();

var _v3_tmp2 = new _valueTypes.Vec3();

var _m3_tmp = new _valueTypes.Mat3(); // https://zeuxcg.org/2010/10/17/aabb-from-obb-with-component-wise-abs/


var transform_extent_m3 = function transform_extent_m3(out, extent, m3) {
  var m3_tmpm = _m3_tmp.m,
      m3m = m3.m;
  m3_tmpm[0] = Math.abs(m3m[0]);
  m3_tmpm[1] = Math.abs(m3m[1]);
  m3_tmpm[2] = Math.abs(m3m[2]);
  m3_tmpm[3] = Math.abs(m3m[3]);
  m3_tmpm[4] = Math.abs(m3m[4]);
  m3_tmpm[5] = Math.abs(m3m[5]);
  m3_tmpm[6] = Math.abs(m3m[6]);
  m3_tmpm[7] = Math.abs(m3m[7]);
  m3_tmpm[8] = Math.abs(m3m[8]);

  _valueTypes.Vec3.transformMat3(out, extent, _m3_tmp);
};
/**
 * !#en obb
 * !#zh
 * 基础几何  方向包围盒。
 * @class geomUtils.Obb
 */


var obb =
/*#__PURE__*/
function () {
  /**
   * !#en
   * create a new obb
   * !#zh
   * 创建一个新的 obb 实例。
   * @method create
   * @param {Number} cx X coordinates of the shape relative to the origin.
   * @param {Number} cy Y coordinates of the shape relative to the origin.
   * @param {Number} cz Z coordinates of the shape relative to the origin.
   * @param {Number} hw Obb is half the width.
   * @param {Number} hh Obb is half the height.
   * @param {Number} hl Obb is half the Length.
   * @param {Number} ox_1 Direction matrix parameter.
   * @param {Number} ox_2 Direction matrix parameter.
   * @param {Number} ox_3 Direction matrix parameter.
   * @param {Number} oy_1 Direction matrix parameter.
   * @param {Number} oy_2 Direction matrix parameter.
   * @param {Number} oy_3 Direction matrix parameter.
   * @param {Number} oz_1 Direction matrix parameter.
   * @param {Number} oz_2 Direction matrix parameter.
   * @param {Number} oz_3 Direction matrix parameter.
   * @return {Obb} Direction Box.
   */
  obb.create = function create(cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3) {
    return new obb(cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);
  }
  /**
   * !#en
   * clone a new obb
   * !#zh
   * 克隆一个 obb。
   * @method clone
   * @param {Obb} a The target of cloning.
   * @returns {Obb} New object cloned.
   */
  ;

  obb.clone = function clone(a) {
    var aom = a.orientation.m;
    return new obb(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z, aom[0], aom[1], aom[2], aom[3], aom[4], aom[5], aom[6], aom[7], aom[8]);
  }
  /**
   * !#en
   * copy the values from one obb to another
   * !#zh
   * 将从一个 obb 的值复制到另一个 obb。
   * @method copy
   * @param {Obb} out Obb that accepts the operation.
   * @param {Obb} a Obb being copied.
   * @return {Obb} out Obb that accepts the operation.
   */
  ;

  obb.copy = function copy(out, a) {
    _valueTypes.Vec3.copy(out.center, a.center);

    _valueTypes.Vec3.copy(out.halfExtents, a.halfExtents);

    _valueTypes.Mat3.copy(out.orientation, a.orientation);

    return out;
  }
  /**
   * !#en
   * create a new obb from two corner points
   * !#zh
   * 用两个点创建一个新的 obb。
   * @method fromPoints
   * @param {Obb} out Obb that accepts the operation.
   * @param {Vec3} minPos The smallest point of obb.
   * @param {Vec3} maxPos Obb's maximum point.
   * @returns {Obb} out Obb that accepts the operation.
   */
  ;

  obb.fromPoints = function fromPoints(out, minPos, maxPos) {
    _valueTypes.Vec3.multiplyScalar(out.center, _valueTypes.Vec3.add(_v3_tmp, minPos, maxPos), 0.5);

    _valueTypes.Vec3.multiplyScalar(out.halfExtents, _valueTypes.Vec3.subtract(_v3_tmp2, maxPos, minPos), 0.5);

    _valueTypes.Mat3.identity(out.orientation);

    return out;
  }
  /**
   * !#en
   * Set the components of a obb to the given values
   * !#zh
   * 将给定 obb 的属性设置为给定的值。
   * @method set
   * @param {Number} cx X coordinates of the shape relative to the origin.
   * @param {Number} cy Y coordinates of the shape relative to the origin.
   * @param {Number} cz Z coordinates of the shape relative to the origin.
   * @param {Number} hw Obb is half the width.
   * @param {Number} hh Obb is half the height.
   * @param {Number} hl Obb is half the Length.
   * @param {Number} ox_1 Direction matrix parameter.
   * @param {Number} ox_2 Direction matrix parameter.
   * @param {Number} ox_3 Direction matrix parameter.
   * @param {Number} oy_1 Direction matrix parameter.
   * @param {Number} oy_2 Direction matrix parameter.
   * @param {Number} oy_3 Direction matrix parameter.
   * @param {Number} oz_1 Direction matrix parameter.
   * @param {Number} oz_2 Direction matrix parameter.
   * @param {Number} oz_3 Direction matrix parameter.
   * @return {Obb} out
   */
  ;

  obb.set = function set(out, cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3) {
    _valueTypes.Vec3.set(out.center, cx, cy, cz);

    _valueTypes.Vec3.set(out.halfExtents, hw, hh, hl);

    _valueTypes.Mat3.set(out.orientation, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);

    return out;
  }
  /**
   * !#en
   * The center of the local coordinate.
   * !#zh
   * 本地坐标的中心点。
   * @property {Vec3} center
   */
  ;

  _createClass(obb, [{
    key: "type",

    /**
     * !#zh
     * 获取形状的类型。
     * @property {number} type
     * @readonly
     */
    get: function get() {
      return this._type;
    }
  }]);

  function obb(cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3) {
    if (cx === void 0) {
      cx = 0;
    }

    if (cy === void 0) {
      cy = 0;
    }

    if (cz === void 0) {
      cz = 0;
    }

    if (hw === void 0) {
      hw = 1;
    }

    if (hh === void 0) {
      hh = 1;
    }

    if (hl === void 0) {
      hl = 1;
    }

    if (ox_1 === void 0) {
      ox_1 = 1;
    }

    if (ox_2 === void 0) {
      ox_2 = 0;
    }

    if (ox_3 === void 0) {
      ox_3 = 0;
    }

    if (oy_1 === void 0) {
      oy_1 = 0;
    }

    if (oy_2 === void 0) {
      oy_2 = 1;
    }

    if (oy_3 === void 0) {
      oy_3 = 0;
    }

    if (oz_1 === void 0) {
      oz_1 = 0;
    }

    if (oz_2 === void 0) {
      oz_2 = 0;
    }

    if (oz_3 === void 0) {
      oz_3 = 1;
    }

    this.center = void 0;
    this.halfExtents = void 0;
    this.orientation = void 0;
    this._type = void 0;
    this._type = _enums["default"].SHAPE_OBB;
    this.center = new _valueTypes.Vec3(cx, cy, cz);
    this.halfExtents = new _valueTypes.Vec3(hw, hh, hl);
    this.orientation = new _valueTypes.Mat3(ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);
  }
  /**
   * !#en
   * Get the bounding points of this shape
   * !#zh
   * 获取 obb 的最小点和最大点。
   * @method getBoundary
   * @param {Vec3} minPos
   * @param {Vec3} maxPos
   */


  var _proto = obb.prototype;

  _proto.getBoundary = function getBoundary(minPos, maxPos) {
    transform_extent_m3(_v3_tmp, this.halfExtents, this.orientation);

    _valueTypes.Vec3.subtract(minPos, this.center, _v3_tmp);

    _valueTypes.Vec3.add(maxPos, this.center, _v3_tmp);
  }
  /**
   * !#en Transform this shape
   * !#zh
   * 将 out 根据这个 obb 的数据进行变换。
   * @method transform
   * @param {Mat4} m The transformation matrix.
   * @param {Vec3} pos The position part of the transformation.
   * @param {Quat} rot The rotating part of the transformation.
   * @param {Vec3} scale The scaling part of the transformation.
   * @param {Obb} out Target of transformation.
   */
  ;

  _proto.transform = function transform(m, pos, rot, scale, out) {
    _valueTypes.Vec3.transformMat4(out.center, this.center, m); // parent shape doesn't contain rotations for now


    _valueTypes.Mat3.fromQuat(out.orientation, rot);

    _valueTypes.Vec3.multiply(out.halfExtents, this.halfExtents, scale);
  }
  /**
   * !#en
   * Transform out based on this obb data.
   * !#zh
   * 将 out 根据这个 obb 的数据进行变换。
   * @method translateAndRotate
   * @param {Mat4} m The transformation matrix.
   * @param {Quat} rot The rotating part of the transformation.
   * @param {Obb} out Target of transformation.
   */
  ;

  _proto.translateAndRotate = function translateAndRotate(m, rot, out) {
    _valueTypes.Vec3.transformMat4(out.center, this.center, m); // parent shape doesn't contain rotations for now


    _valueTypes.Mat3.fromQuat(out.orientation, rot);
  }
  /**
   * !#en
   * Scale out based on this obb data.
   * !#zh
   * 将 out 根据这个 obb 的数据进行缩放。
   * @method setScale
   * @param {Vec3} scale Scale value.
   * @param {Obb} out Scaled target.
   */
  ;

  _proto.setScale = function setScale(scale, out) {
    _valueTypes.Vec3.multiply(out.halfExtents, this.halfExtents, scale);
  };

  return obb;
}();

exports["default"] = obb;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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