
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/geom-utils/line.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../value-types");

var _enums = _interopRequireDefault(require("./enums"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en 
 * line
 * !#zh
 * 直线
 * @class geomUtils.Line
 */
var line =
/*#__PURE__*/
function () {
  /**
   * !#en
   * create a new line
   * !#zh
   * 创建一个新的 line。
   * @method create
   * @param {Number} sx The x part of the starting point.
   * @param {Number} sy The y part of the starting point.
   * @param {Number} sz The z part of the starting point.
   * @param {Number} ex The x part of the end point.
   * @param {Number} ey The y part of the end point.
   * @param {Number} ez The z part of the end point.
   * @return {Line}
   */
  line.create = function create(sx, sy, sz, ex, ey, ez) {
    return new line(sx, sy, sz, ex, ey, ez);
  }
  /**
   * !#en
   * Creates a new line initialized with values from an existing line
   * !#zh
   * 克隆一个新的 line。
   * @method clone
   * @param {Line} a The source of cloning.
   * @return {Line} The cloned object.
   */
  ;

  line.clone = function clone(a) {
    return new line(a.s.x, a.s.y, a.s.z, a.e.x, a.e.y, a.e.z);
  }
  /**
   * !#en
   * Copy the values from one line to another
   * !#zh
   * 复制一个线的值到另一个。
   * @method copy
   * @param {Line} out The object that accepts the action.
   * @param {Line} a The source of the copy.
   * @return {Line} The object that accepts the action.
   */
  ;

  line.copy = function copy(out, a) {
    _valueTypes.Vec3.copy(out.s, a.s);

    _valueTypes.Vec3.copy(out.e, a.e);

    return out;
  }
  /**
   * !#en
   * create a line from two points
   * !#zh
   * 用两个点创建一个线。
   * @method fromPoints
   * @param {Line} out The object that accepts the action.
   * @param {Vec3} start The starting point.
   * @param {Vec3} end At the end.
   * @return {Line} out The object that accepts the action.
   */
  ;

  line.fromPoints = function fromPoints(out, start, end) {
    _valueTypes.Vec3.copy(out.s, start);

    _valueTypes.Vec3.copy(out.e, end);

    return out;
  }
  /**
   * !#en
   * Set the components of a Vec3 to the given values
   * !#zh
   * 将给定线的属性设置为给定值。
   * @method set
   * @param {Line} out The object that accepts the action.
   * @param {Number} sx The x part of the starting point.
   * @param {Number} sy The y part of the starting point.
   * @param {Number} sz The z part of the starting point.
   * @param {Number} ex The x part of the end point.
   * @param {Number} ey The y part of the end point.
   * @param {Number} ez The z part of the end point.
   * @return {Line} out The object that accepts the action.
   */
  ;

  line.set = function set(out, sx, sy, sz, ex, ey, ez) {
    out.s.x = sx;
    out.s.y = sy;
    out.s.z = sz;
    out.e.x = ex;
    out.e.y = ey;
    out.e.z = ez;
    return out;
  }
  /**
   * !#en
   * Calculate the length of the line.
   * !#zh
   * 计算线的长度。
   * @method len
   * @param {Line} a The line to calculate.
   * @return {Number} Length.
   */
  ;

  line.len = function len(a) {
    return _valueTypes.Vec3.distance(a.s, a.e);
  }
  /**
   * !#en
   * Start points.
   * !#zh
   * 起点。
   * @property {Vec3} s
   */
  ;

  /**
   * !#en Construct a line.
   * !#zh 构造一条线。
   * @constructor
   * @param {Number} sx The x part of the starting point.
   * @param {Number} sy The y part of the starting point.
   * @param {Number} sz The z part of the starting point.
   * @param {Number} ex The x part of the end point.
   * @param {Number} ey The y part of the end point.
   * @param {Number} ez The z part of the end point.
   */
  function line(sx, sy, sz, ex, ey, ez) {
    if (sx === void 0) {
      sx = 0;
    }

    if (sy === void 0) {
      sy = 0;
    }

    if (sz === void 0) {
      sz = 0;
    }

    if (ex === void 0) {
      ex = 0;
    }

    if (ey === void 0) {
      ey = 0;
    }

    if (ez === void 0) {
      ez = -1;
    }

    this.s = void 0;
    this.e = void 0;
    this._type = void 0;
    this._type = _enums["default"].SHAPE_LINE;
    this.s = new _valueTypes.Vec3(sx, sy, sz);
    this.e = new _valueTypes.Vec3(ex, ey, ez);
  }
  /**
   * !#en
   * Calculate the length of the line.
   * !#zh
   * 计算线的长度。
   * @method length
   * @return {Number} Length.
   */


  var _proto = line.prototype;

  _proto.length = function length() {
    return _valueTypes.Vec3.distance(this.s, this.e);
  };

  return line;
}();

exports["default"] = line;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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