
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/geom-utils/aabb.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _vec = _interopRequireDefault(require("../value-types/vec3"));

var _mat = _interopRequireDefault(require("../value-types/mat3"));

var _enums = _interopRequireDefault(require("./enums"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var _v3_tmp = new _vec["default"]();

var _v3_tmp2 = new _vec["default"]();

var _m3_tmp = new _mat["default"](); // https://zeuxcg.org/2010/10/17/aabb-from-obb-with-component-wise-abs/


var transform_extent_m4 = function transform_extent_m4(out, extent, m4) {
  var _m3_tmpm = _m3_tmp.m,
      m4m = m4.m;
  _m3_tmpm[0] = Math.abs(m4m[0]);
  _m3_tmpm[1] = Math.abs(m4m[1]);
  _m3_tmpm[2] = Math.abs(m4m[2]);
  _m3_tmpm[3] = Math.abs(m4m[4]);
  _m3_tmpm[4] = Math.abs(m4m[5]);
  _m3_tmpm[5] = Math.abs(m4m[6]);
  _m3_tmpm[6] = Math.abs(m4m[8]);
  _m3_tmpm[7] = Math.abs(m4m[9]);
  _m3_tmpm[8] = Math.abs(m4m[10]);

  _vec["default"].transformMat3(out, extent, _m3_tmp);
};
/**
 * Aabb
 * @class geomUtils.Aabb
 */


var aabb =
/*#__PURE__*/
function () {
  /**
   * create a new aabb
   * @method create
   * @param {number} px X coordinates for aabb's original point
   * @param {number} py Y coordinates for aabb's original point
   * @param {number} pz Z coordinates for aabb's original point
   * @param {number} w the half of aabb width
   * @param {number} h the half of aabb height
   * @param {number} l the half of aabb length
   * @return {geomUtils.Aabb}
   */
  aabb.create = function create(px, py, pz, w, h, l) {
    return new aabb(px, py, pz, w, h, l);
  }
  /**
   * clone a new aabb
   * @method clone
   * @param {geomUtils.Aabb} a the source aabb
   * @return {geomUtils.Aabb}
   */
  ;

  aabb.clone = function clone(a) {
    return new aabb(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z);
  }
  /**
   * copy the values from one aabb to another
   * @method copy
   * @param {geomUtils.Aabb} out the receiving aabb
   * @param {geomUtils.Aabb} a the source aabb
   * @return {geomUtils.Aabb}
   */
  ;

  aabb.copy = function copy(out, a) {
    _vec["default"].copy(out.center, a.center);

    _vec["default"].copy(out.halfExtents, a.halfExtents);

    return out;
  }
  /**
   * create a new aabb from two corner points
   * @method fromPoints
   * @param {geomUtils.Aabb} out the receiving aabb
   * @param {Vec3} minPos lower corner position of the aabb
   * @param {Vec3} maxPos upper corner position of the aabb
   * @return {geomUtils.Aabb}
   */
  ;

  aabb.fromPoints = function fromPoints(out, minPos, maxPos) {
    _vec["default"].scale(out.center, _vec["default"].add(_v3_tmp, minPos, maxPos), 0.5);

    _vec["default"].scale(out.halfExtents, _vec["default"].sub(_v3_tmp2, maxPos, minPos), 0.5);

    return out;
  }
  /**
   * Set the components of a aabb to the given values
   * @method set
   * @param {geomUtils.Aabb} out the receiving aabb
   * @param {number} px X coordinates for aabb's original point
   * @param {number} py Y coordinates for aabb's original point
   * @param {number} pz Z coordinates for aabb's original point
   * @param {number} w the half of aabb width
   * @param {number} h the half of aabb height
   * @param {number} l the half of aabb length
   * @return {geomUtils.Aabb} out
   */
  ;

  aabb.set = function set(out, px, py, pz, w, h, l) {
    _vec["default"].set(out.center, px, py, pz);

    _vec["default"].set(out.halfExtents, w, h, l);

    return out;
  }
  /**
   * @property {Vec3} center
   */
  ;

  function aabb(px, py, pz, w, h, l) {
    this.center = void 0;
    this.halfExtents = void 0;
    this._type = void 0;
    this._type = _enums["default"].SHAPE_AABB;
    this.center = new _vec["default"](px, py, pz);
    this.halfExtents = new _vec["default"](w, h, l);
  }
  /**
   * Get the bounding points of this shape
   * @method getBoundary
   * @param {Vec3} minPos
   * @param {Vec3} maxPos
   */


  var _proto = aabb.prototype;

  _proto.getBoundary = function getBoundary(minPos, maxPos) {
    _vec["default"].sub(minPos, this.center, this.halfExtents);

    _vec["default"].add(maxPos, this.center, this.halfExtents);
  }
  /**
   * Transform this shape
   * @method transform
   * @param {Mat4} m the transform matrix
   * @param {Vec3} pos the position part of the transform
   * @param {Quat} rot the rotation part of the transform
   * @param {Vec3} scale the scale part of the transform
   * @param {geomUtils.Aabb} [out] the target shape
   */
  ;

  _proto.transform = function transform(m, pos, rot, scale, out) {
    if (!out) out = this;

    _vec["default"].transformMat4(out.center, this.center, m);

    transform_extent_m4(out.halfExtents, this.halfExtents, m);
  };

  return aabb;
}();

exports["default"] = aabb;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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