
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/editbox/WebEditBoxImpl.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _mat = _interopRequireDefault(require("../../value-types/mat4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var utils = require('../../platform/utils');

var macro = require('../../platform/CCMacro');

var Types = require('./types');

var Label = require('../CCLabel');

var tabIndexUtil = require('./tabIndexUtil');

var EditBox = cc.EditBox;
var js = cc.js;
var InputMode = Types.InputMode;
var InputFlag = Types.InputFlag;
var KeyboardReturnType = Types.KeyboardReturnType; // polyfill

var polyfill = {
  zoomInvalid: false
};

if (cc.sys.OS_ANDROID === cc.sys.os && (cc.sys.browserType === cc.sys.BROWSER_TYPE_SOUGOU || cc.sys.browserType === cc.sys.BROWSER_TYPE_360)) {
  polyfill.zoomInvalid = true;
} // https://segmentfault.com/q/1010000002914610


var DELAY_TIME = 800;
var SCROLLY = 100;
var LEFT_PADDING = 2; // private static property

var _domCount = 0;

var _vec3 = cc.v3();

var _currentEditBoxImpl = null; // on mobile

var _fullscreen = false;
var _autoResize = false;
var BaseClass = EditBox._ImplClass; // This is an adapter for EditBoxImpl on web platform.
// For more adapters on other platforms, please inherit from EditBoxImplBase and implement the interface.

function WebEditBoxImpl() {
  BaseClass.call(this);
  this._domId = "EditBoxId_" + ++_domCount;
  this._placeholderStyleSheet = null;
  this._elem = null;
  this._isTextArea = false; // matrix

  this._worldMat = new _mat["default"]();
  this._cameraMat = new _mat["default"](); // matrix cache

  this._m00 = 0;
  this._m01 = 0;
  this._m04 = 0;
  this._m05 = 0;
  this._m12 = 0;
  this._m13 = 0;
  this._w = 0;
  this._h = 0; // viewport cache

  this._cacheViewportRect = cc.rect(0, 0, 0, 0); // inputType cache

  this._inputMode = null;
  this._inputFlag = null;
  this._returnType = null; // event listeners

  this._eventListeners = {}; // update style sheet cache

  this._textLabelFont = null;
  this._textLabelFontSize = null;
  this._textLabelFontColor = null;
  this._textLabelAlign = null;
  this._placeholderLabelFont = null;
  this._placeholderLabelFontSize = null;
  this._placeholderLabelFontColor = null;
  this._placeholderLabelAlign = null;
  this._placeholderLineHeight = null;
}

js.extend(WebEditBoxImpl, BaseClass);
EditBox._ImplClass = WebEditBoxImpl;
Object.assign(WebEditBoxImpl.prototype, {
  // =================================
  // implement EditBoxImplBase interface
  init: function init(delegate) {
    if (!delegate) {
      return;
    }

    this._delegate = delegate;

    if (delegate.inputMode === InputMode.ANY) {
      this._createTextArea();
    } else {
      this._createInput();
    }

    tabIndexUtil.add(this);
    this.setTabIndex(delegate.tabIndex);

    this._initStyleSheet();

    this._registerEventListeners();

    this._addDomToGameContainer();

    _fullscreen = cc.view.isAutoFullScreenEnabled();
    _autoResize = cc.view._resizeWithBrowserSize;
  },
  clear: function clear() {
    this._removeEventListeners();

    this._removeDomFromGameContainer();

    tabIndexUtil.remove(this); // clear while editing

    if (_currentEditBoxImpl === this) {
      _currentEditBoxImpl = null;
    }
  },
  update: function update() {// do nothing...
  },
  setTabIndex: function setTabIndex(index) {
    this._elem.tabIndex = index;
    tabIndexUtil.resort();
  },
  setSize: function setSize(width, height) {
    var elem = this._elem;
    elem.style.width = width + 'px';
    elem.style.height = height + 'px';
  },
  beginEditing: function beginEditing() {
    if (_currentEditBoxImpl && _currentEditBoxImpl !== this) {
      _currentEditBoxImpl.setFocus(false);
    }

    this._editing = true;
    _currentEditBoxImpl = this;

    this._delegate.editBoxEditingDidBegan();

    this._showDom();

    this._elem.focus(); // set focus

  },
  endEditing: function endEditing() {
    if (this._elem) {
      this._elem.blur();
    }
  },
  // ==========================================================================
  // implement dom input
  _createInput: function _createInput() {
    this._isTextArea = false;
    this._elem = document.createElement('input');
  },
  _createTextArea: function _createTextArea() {
    this._isTextArea = true;
    this._elem = document.createElement('textarea');
  },
  _addDomToGameContainer: function _addDomToGameContainer() {
    cc.game.container.appendChild(this._elem);
    document.head.appendChild(this._placeholderStyleSheet);
  },
  _removeDomFromGameContainer: function _removeDomFromGameContainer() {
    var hasElem = utils.contains(cc.game.container, this._elem);

    if (hasElem) {
      cc.game.container.removeChild(this._elem);
    }

    var hasStyleSheet = utils.contains(document.head, this._placeholderStyleSheet);

    if (hasStyleSheet) {
      document.head.removeChild(this._placeholderStyleSheet);
    }

    delete this._elem;
    delete this._placeholderStyleSheet;
  },
  _showDom: function _showDom() {
    this._updateMatrix();

    this._updateMaxLength();

    this._updateInputType();

    this._updateStyleSheet();

    this._elem.style.display = '';

    this._delegate._hideLabels();

    if (cc.sys.isMobile) {
      this._showDomOnMobile();
    }
  },
  _hideDom: function _hideDom() {
    var elem = this._elem;
    elem.style.display = 'none';

    this._delegate._showLabels();

    if (cc.sys.isMobile) {
      this._hideDomOnMobile();
    }
  },
  _showDomOnMobile: function _showDomOnMobile() {
    if (cc.sys.os !== cc.sys.OS_ANDROID) {
      return;
    }

    if (_fullscreen) {
      cc.view.enableAutoFullScreen(false);
      cc.screen.exitFullScreen();
    }

    if (_autoResize) {
      cc.view.resizeWithBrowserSize(false);
    }

    this._adjustWindowScroll();
  },
  _hideDomOnMobile: function _hideDomOnMobile() {
    if (cc.sys.os === cc.sys.OS_ANDROID) {
      if (_autoResize) {
        cc.view.resizeWithBrowserSize(true);
      } // In case enter full screen when soft keyboard still showing


      setTimeout(function () {
        if (!_currentEditBoxImpl) {
          if (_fullscreen) {
            cc.view.enableAutoFullScreen(true);
          }
        }
      }, DELAY_TIME);
    } // Some browser like wechat on iOS need to mannully scroll back window


    this._scrollBackWindow();
  },
  // adjust view to editBox
  _adjustWindowScroll: function _adjustWindowScroll() {
    var self = this;
    setTimeout(function () {
      if (window.scrollY < SCROLLY) {
        self._elem.scrollIntoView({
          block: "start",
          inline: "nearest",
          behavior: "smooth"
        });
      }
    }, DELAY_TIME);
  },
  _scrollBackWindow: function _scrollBackWindow() {
    setTimeout(function () {
      // FIX: wechat browser bug on iOS
      // If gameContainer is included in iframe,
      // Need to scroll the top window, not the one in the iframe
      // Reference: https://developer.mozilla.org/en-US/docs/Web/API/Window/top
      var sys = cc.sys;

      if (sys.browserType === sys.BROWSER_TYPE_WECHAT && sys.os === sys.OS_IOS) {
        window.top && window.top.scrollTo(0, 0);
        return;
      }

      window.scrollTo(0, 0);
    }, DELAY_TIME);
  },
  _updateMatrix: function _updateMatrix() {
    var node = this._delegate.node;
    node.getWorldMatrix(this._worldMat);
    var worldMat = this._worldMat;
    var worldMatm = worldMat.m;
    var localView = cc.view; // check whether need to update

    if (this._m00 === worldMatm[0] && this._m01 === worldMatm[1] && this._m04 === worldMatm[4] && this._m05 === worldMatm[5] && this._m12 === worldMatm[12] && this._m13 === worldMatm[13] && this._w === node._contentSize.width && this._h === node._contentSize.height && this._cacheViewportRect.equals(localView._viewportRect)) {
      return;
    } // update matrix cache


    this._m00 = worldMatm[0];
    this._m01 = worldMatm[1];
    this._m04 = worldMatm[4];
    this._m05 = worldMatm[5];
    this._m12 = worldMatm[12];
    this._m13 = worldMatm[13];
    this._w = node._contentSize.width;
    this._h = node._contentSize.height; // update viewport cache

    this._cacheViewportRect.set(localView._viewportRect);

    var scaleX = localView._scaleX,
        scaleY = localView._scaleY,
        viewport = localView._viewportRect,
        dpr = localView._devicePixelRatio;
    _vec3.x = -node._anchorPoint.x * this._w;
    _vec3.y = -node._anchorPoint.y * this._h;

    _mat["default"].transform(worldMat, worldMat, _vec3); // can't find camera in editor


    var cameraMat;

    if (CC_EDITOR) {
      cameraMat = this._cameraMat = worldMat;
    } else {
      var camera = cc.Camera.findCamera(node);
      camera.getWorldToScreenMatrix2D(this._cameraMat);
      cameraMat = this._cameraMat;

      _mat["default"].mul(cameraMat, cameraMat, worldMat);
    }

    scaleX /= dpr;
    scaleY /= dpr;
    var container = cc.game.container;
    var cameraMatm = cameraMat.m;
    var a = cameraMatm[0] * scaleX,
        b = cameraMatm[1],
        c = cameraMatm[4],
        d = cameraMatm[5] * scaleY;
    var offsetX = container && container.style.paddingLeft && parseInt(container.style.paddingLeft);
    offsetX += viewport.x / dpr;
    var offsetY = container && container.style.paddingBottom && parseInt(container.style.paddingBottom);
    offsetY += viewport.y / dpr;
    var tx = cameraMatm[12] * scaleX + offsetX,
        ty = cameraMatm[13] * scaleY + offsetY;

    if (polyfill.zoomInvalid) {
      this.setSize(node.width * a, node.height * d);
      a = 1;
      d = 1;
    }

    var elem = this._elem;
    var matrix = "matrix(" + a + "," + -b + "," + -c + "," + d + "," + tx + "," + -ty + ")";
    elem.style['transform'] = matrix;
    elem.style['-webkit-transform'] = matrix;
    elem.style['transform-origin'] = '0px 100% 0px';
    elem.style['-webkit-transform-origin'] = '0px 100% 0px';
  },
  // ===========================================
  // input type and max length
  _updateInputType: function _updateInputType() {
    var delegate = this._delegate,
        inputMode = delegate.inputMode,
        inputFlag = delegate.inputFlag,
        returnType = delegate.returnType,
        elem = this._elem; // whether need to update

    if (this._inputMode === inputMode && this._inputFlag === inputFlag && this._returnType === returnType) {
      return;
    } // update cache


    this._inputMode = inputMode;
    this._inputFlag = inputFlag;
    this._returnType = returnType; // FIX ME: TextArea actually dose not support password type.

    if (this._isTextArea) {
      // input flag
      var _textTransform = 'none';

      if (inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS) {
        _textTransform = 'uppercase';
      } else if (inputFlag === InputFlag.INITIAL_CAPS_WORD) {
        _textTransform = 'capitalize';
      }

      elem.style.textTransform = _textTransform;
      return;
    } // begin to updateInputType


    if (inputFlag === InputFlag.PASSWORD) {
      elem.type = 'password';
      return;
    } // input mode


    var type = elem.type;

    if (inputMode === InputMode.EMAIL_ADDR) {
      type = 'email';
    } else if (inputMode === InputMode.NUMERIC || inputMode === InputMode.DECIMAL) {
      type = 'number';
    } else if (inputMode === InputMode.PHONE_NUMBER) {
      type = 'number';
      elem.pattern = '[0-9]*';
    } else if (inputMode === InputMode.URL) {
      type = 'url';
    } else {
      type = 'text';

      if (returnType === KeyboardReturnType.SEARCH) {
        type = 'search';
      }
    }

    elem.type = type; // input flag

    var textTransform = 'none';

    if (inputFlag === InputFlag.INITIAL_CAPS_ALL_CHARACTERS) {
      textTransform = 'uppercase';
    } else if (inputFlag === InputFlag.INITIAL_CAPS_WORD) {
      textTransform = 'capitalize';
    }

    elem.style.textTransform = textTransform;
  },
  _updateMaxLength: function _updateMaxLength() {
    var maxLength = this._delegate.maxLength;

    if (maxLength < 0) {
      //we can't set Number.MAX_VALUE to input's maxLength property
      //so we use a magic number here, it should works at most use cases.
      maxLength = 65535;
    }

    this._elem.maxLength = maxLength;
  },
  // ===========================================
  // style sheet
  _initStyleSheet: function _initStyleSheet() {
    var elem = this._elem;
    elem.style.display = 'none';
    elem.style.border = 0;
    elem.style.background = 'transparent';
    elem.style.width = '100%';
    elem.style.height = '100%';
    elem.style.active = 0;
    elem.style.outline = 'medium';
    elem.style.padding = '0';
    elem.style.textTransform = 'uppercase';
    elem.style.position = "absolute";
    elem.style.bottom = "0px";
    elem.style.left = LEFT_PADDING + "px";
    elem.className = "cocosEditBox";
    elem.id = this._domId;

    if (!this._isTextArea) {
      elem.type = 'text';
      elem.style['-moz-appearance'] = 'textfield';
    } else {
      elem.style.resize = 'none';
      elem.style.overflow_y = 'scroll';
    }

    this._placeholderStyleSheet = document.createElement('style');
  },
  _updateStyleSheet: function _updateStyleSheet() {
    var delegate = this._delegate,
        elem = this._elem;
    elem.value = delegate.string;
    elem.placeholder = delegate.placeholder;

    this._updateTextLabel(delegate.textLabel);

    this._updatePlaceholderLabel(delegate.placeholderLabel);
  },
  _updateTextLabel: function _updateTextLabel(textLabel) {
    if (!textLabel) {
      return;
    } // get font


    var font = textLabel.font;

    if (font && !(font instanceof cc.BitmapFont)) {
      font = font._fontFamily;
    } else {
      font = textLabel.fontFamily;
    } // get font size


    var fontSize = textLabel.fontSize * textLabel.node.scaleY; // whether need to update

    if (this._textLabelFont === font && this._textLabelFontSize === fontSize && this._textLabelFontColor === textLabel.fontColor && this._textLabelAlign === textLabel.horizontalAlign) {
      return;
    } // update cache


    this._textLabelFont = font;
    this._textLabelFontSize = fontSize;
    this._textLabelFontColor = textLabel.fontColor;
    this._textLabelAlign = textLabel.horizontalAlign;
    var elem = this._elem; // font size

    elem.style.fontSize = fontSize + "px"; // font color

    elem.style.color = textLabel.node.color.toCSS(); // font family

    elem.style.fontFamily = font; // text-align

    switch (textLabel.horizontalAlign) {
      case Label.HorizontalAlign.LEFT:
        elem.style.textAlign = 'left';
        break;

      case Label.HorizontalAlign.CENTER:
        elem.style.textAlign = 'center';
        break;

      case Label.HorizontalAlign.RIGHT:
        elem.style.textAlign = 'right';
        break;
    } // lineHeight
    // Can't sync lineHeight property, because lineHeight would change the touch area of input

  },
  _updatePlaceholderLabel: function _updatePlaceholderLabel(placeholderLabel) {
    if (!placeholderLabel) {
      return;
    } // get font


    var font = placeholderLabel.font;

    if (font && !(font instanceof cc.BitmapFont)) {
      font = placeholderLabel.font._fontFamily;
    } else {
      font = placeholderLabel.fontFamily;
    } // get font size


    var fontSize = placeholderLabel.fontSize * placeholderLabel.node.scaleY; // whether need to update

    if (this._placeholderLabelFont === font && this._placeholderLabelFontSize === fontSize && this._placeholderLabelFontColor === placeholderLabel.fontColor && this._placeholderLabelAlign === placeholderLabel.horizontalAlign && this._placeholderLineHeight === placeholderLabel.fontSize) {
      return;
    } // update cache


    this._placeholderLabelFont = font;
    this._placeholderLabelFontSize = fontSize;
    this._placeholderLabelFontColor = placeholderLabel.fontColor;
    this._placeholderLabelAlign = placeholderLabel.horizontalAlign;
    this._placeholderLineHeight = placeholderLabel.fontSize;
    var styleEl = this._placeholderStyleSheet; // font color

    var fontColor = placeholderLabel.node.color.toCSS(); // line height

    var lineHeight = placeholderLabel.fontSize; // top vertical align by default
    // horizontal align

    var horizontalAlign;

    switch (placeholderLabel.horizontalAlign) {
      case Label.HorizontalAlign.LEFT:
        horizontalAlign = 'left';
        break;

      case Label.HorizontalAlign.CENTER:
        horizontalAlign = 'center';
        break;

      case Label.HorizontalAlign.RIGHT:
        horizontalAlign = 'right';
        break;
    }

    styleEl.innerHTML = "#" + this._domId + "::-webkit-input-placeholder,#" + this._domId + "::-moz-placeholder,#" + this._domId + ":-ms-input-placeholder" + ("{text-transform: initial; font-family: " + font + "; font-size: " + fontSize + "px; color: " + fontColor + "; line-height: " + lineHeight + "px; text-align: " + horizontalAlign + ";}"); // EDGE_BUG_FIX: hide clear button, because clearing input box in Edge does not emit input event 
    // issue refference: https://github.com/angular/angular/issues/26307

    if (cc.sys.browserType === cc.sys.BROWSER_TYPE_EDGE) {
      styleEl.innerHTML += "#" + this._domId + "::-ms-clear{display: none;}";
    }
  },
  // ===========================================
  // handle event listeners
  _registerEventListeners: function _registerEventListeners() {
    var impl = this,
        elem = this._elem,
        inputLock = false,
        cbs = this._eventListeners;

    cbs.compositionStart = function () {
      inputLock = true;
    };

    cbs.compositionEnd = function () {
      inputLock = false;

      impl._delegate.editBoxTextChanged(elem.value);
    };

    cbs.onInput = function () {
      if (inputLock) {
        return;
      }

      impl._delegate.editBoxTextChanged(elem.value);
    }; // There are 2 ways to focus on the input element:
    // Click the input element, or call input.focus().
    // Both need to adjust window scroll.


    cbs.onClick = function (e) {
      // In case operation sequence: click input, hide keyboard, then click again.
      if (impl._editing) {
        if (cc.sys.isMobile) {
          impl._adjustWindowScroll();
        }
      }
    };

    cbs.onKeydown = function (e) {
      if (e.keyCode === macro.KEY.enter) {
        e.stopPropagation();

        impl._delegate.editBoxEditingReturn();

        if (!impl._isTextArea) {
          elem.blur();
        }
      } else if (e.keyCode === macro.KEY.tab) {
        e.stopPropagation();
        e.preventDefault();
        tabIndexUtil.next(impl);
      }
    };

    cbs.onBlur = function () {
      impl._editing = false;
      _currentEditBoxImpl = null;

      impl._hideDom();

      impl._delegate.editBoxEditingDidEnded();
    };

    cbs.onResize = function () {
      impl._updateMatrix();
    };

    elem.addEventListener('compositionstart', cbs.compositionStart);
    elem.addEventListener('compositionend', cbs.compositionEnd);
    elem.addEventListener('input', cbs.onInput);
    elem.addEventListener('keydown', cbs.onKeydown);
    elem.addEventListener('blur', cbs.onBlur);
    elem.addEventListener('touchstart', cbs.onClick); // editBox is editing, need to update matrix when window resized or orientation changed

    window.addEventListener('resize', cbs.onResize);
    window.addEventListener('orientationchange', cbs.onResize);
  },
  _removeEventListeners: function _removeEventListeners() {
    var elem = this._elem,
        cbs = this._eventListeners;
    elem.removeEventListener('compositionstart', cbs.compositionStart);
    elem.removeEventListener('compositionend', cbs.compositionEnd);
    elem.removeEventListener('input', cbs.onInput);
    elem.removeEventListener('keydown', cbs.onKeydown);
    elem.removeEventListener('blur', cbs.onBlur);
    elem.removeEventListener('touchstart', cbs.onClick);
    window.removeEventListener('resize', cbs.onResize);
    window.removeEventListener('orientationchange', cbs.onResize);
    cbs.compositionStart = null;
    cbs.compositionEnd = null;
    cbs.onInput = null;
    cbs.onKeydown = null;
    cbs.onBlur = null;
    cbs.onClick = null;
    cbs.onResize = null;
  }
});
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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