
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/WXSubContextView.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Component = require('./CCComponent');
/**
 * !#en WXSubContextView is a view component which controls open data context viewport in WeChat game platform.<br/>
 * The component's node size decide the viewport of the sub context content in main context, 
 * the entire sub context texture will be scaled to the node's bounding box area.<br/>
 * This component provides multiple important features:<br/>
 * 1. Sub context could use its own resolution size and policy.<br/>
 * 2. Sub context could be minized to smallest size it needed.<br/>
 * 3. Resolution of sub context content could be increased.<br/>
 * 4. User touch input is transformed to the correct viewport.<br/>
 * 5. Texture update is handled by this component. User don't need to worry.<br/>
 * One important thing to be noted, whenever the node's bounding box change, 
 * you need to manually reset the viewport of sub context using updateSubContextViewport.
 * !#zh WXSubContextView 可以用来控制微信小游戏平台开放数据域在主域中的视窗的位置。<br/>
 * 这个组件的节点尺寸决定了开放数据域内容在主域中的尺寸，整个开放数据域会被缩放到节点的包围盒范围内。<br/>
 * 在这个组件的控制下，用户可以更自由得控制开放数据域：<br/>
 * 1. 子域中可以使用独立的设计分辨率和适配模式<br/>
 * 2. 子域区域尺寸可以缩小到只容纳内容即可<br/>
 * 3. 子域的分辨率也可以被放大，以便获得更清晰的显示效果<br/>
 * 4. 用户输入坐标会被自动转换到正确的子域视窗中<br/>
 * 5. 子域内容贴图的更新由组件负责，用户不需要处理<br/>
 * 唯一需要注意的是，当子域节点的包围盒发生改变时，开发者需要使用 `updateSubContextViewport` 来手动更新子域视窗。
 * @class WXSubContextView
 * @extends Component
 */


var WXSubContextView = cc.Class({
  name: 'cc.WXSubContextView',
  "extends": Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.others/WXSubContextView',
    help: 'i18n:COMPONENT.help_url.wx_subcontext_view'
  },
  properties: {
    _fps: 60,
    fps: {
      get: function get() {
        return this._fps;
      },
      set: function set(value) {
        if (this._fps === value) {
          return;
        }

        this._fps = value;
        this._updateInterval = 1 / value;

        this._updateSubContextFrameRate();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.wx_subcontext_view.fps'
    }
  },
  ctor: function ctor() {
    this._sprite = null;
    this._tex = new cc.Texture2D();
    this._context = null;
    this._updatedTime = performance.now();
    this._updateInterval = 0;
  },
  onLoad: function onLoad() {
    // Setup subcontext canvas size
    if (wx.getOpenDataContext) {
      this._updateInterval = 1000 / this._fps;
      this._context = wx.getOpenDataContext(); // reset sharedCanvas width and height

      this.reset();

      this._tex.setPremultiplyAlpha(true);

      this._tex.initWithElement(sharedCanvas);

      this._sprite = this.node.getComponent(cc.Sprite);

      if (!this._sprite) {
        this._sprite = this.node.addComponent(cc.Sprite);
        this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
      }

      this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
    } else {
      this.enabled = false;
    }
  },

  /**
   * !#en Reset open data context size and viewport
   * !#zh 重置开放数据域的尺寸和视窗
   * @method reset
   */
  reset: function reset() {
    if (this._context) {
      this.updateSubContextViewport();
      var _sharedCanvas = this._context.canvas;

      if (_sharedCanvas) {
        _sharedCanvas.width = this.node.width;
        _sharedCanvas.height = this.node.height;
      }
    }
  },
  onEnable: function onEnable() {
    this._runSubContextMainLoop();

    this._registerNodeEvent();

    this._updateSubContextFrameRate();

    this.updateSubContextViewport();
  },
  onDisable: function onDisable() {
    this._unregisterNodeEvent();

    this._stopSubContextMainLoop();
  },
  update: function update(dt) {
    var calledUpdateMannually = dt === undefined;

    if (calledUpdateMannually) {
      this._context && this._context.postMessage({
        fromEngine: true,
        event: 'step'
      });

      this._updateSubContextTexture();

      return;
    }

    var now = performance.now();
    var deltaTime = now - this._updatedTime;

    if (deltaTime >= this._updateInterval) {
      this._updatedTime += this._updateInterval;

      this._updateSubContextTexture();
    }
  },
  _updateSubContextTexture: function _updateSubContextTexture() {
    if (!this._tex || !this._context) {
      return;
    }

    this._tex.initWithElement(this._context.canvas);

    this._sprite._activateMaterial();
  },

  /**
   * !#en Update the sub context viewport manually, it should be called whenever the node's bounding box changes.
   * !#zh 更新开放数据域相对于主域的 viewport，这个函数应该在节点包围盒改变时手动调用。
   * @method updateSubContextViewport
   */
  updateSubContextViewport: function updateSubContextViewport() {
    if (this._context) {
      var box = this.node.getBoundingBoxToWorld();
      var sx = cc.view._scaleX;
      var sy = cc.view._scaleY;

      this._context.postMessage({
        fromEngine: true,
        event: 'viewport',
        x: box.x * sx + cc.view._viewportRect.x,
        y: box.y * sy + cc.view._viewportRect.y,
        width: box.width * sx,
        height: box.height * sy
      });
    }
  },
  _registerNodeEvent: function _registerNodeEvent() {
    this.node.on('position-changed', this.updateSubContextViewport, this);
    this.node.on('scale-changed', this.updateSubContextViewport, this);
    this.node.on('size-changed', this.updateSubContextViewport, this);
  },
  _unregisterNodeEvent: function _unregisterNodeEvent() {
    this.node.off('position-changed', this.updateSubContextViewport, this);
    this.node.off('scale-changed', this.updateSubContextViewport, this);
    this.node.off('size-changed', this.updateSubContextViewport, this);
  },
  _runSubContextMainLoop: function _runSubContextMainLoop() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'mainLoop',
        value: true
      });
    }
  },
  _stopSubContextMainLoop: function _stopSubContextMainLoop() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'mainLoop',
        value: false
      });
    }
  },
  _updateSubContextFrameRate: function _updateSubContextFrameRate() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'frameRate',
        value: this._fps
      });
    }
  }
});
cc.WXSubContextView = module.exports = WXSubContextView;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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