
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/SwanSubContextView.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Component = require('./CCComponent');
/**
 * !#en SwanSubContextView is a view component which controls open data context viewport in WeChat game platform.<br/>
 * The component's node size decide the viewport of the sub context content in main context, 
 * the entire sub context texture will be scaled to the node's bounding box area.<br/>
 * This component provides multiple important features:<br/>
 * 1. Sub context could use its own resolution size and policy.<br/>
 * 2. Sub context could be minized to smallest size it needed.<br/>
 * 3. Resolution of sub context content could be increased.<br/>
 * 4. User touch input is transformed to the correct viewport.<br/>
 * 5. Texture update is handled by this component. User don't need to worry.<br/>
 * One important thing to be noted, whenever the node's bounding box change, 
 * you need to manually reset the viewport of sub context using updateSubContextViewport.
 * !#zh SwanSubContextView 可以用来控制百度小游戏平台开放数据域在主域中的视窗的位置。<br/>
 * 这个组件的节点尺寸决定了开放数据域内容在主域中的尺寸，整个开放数据域会被缩放到节点的包围盒范围内。<br/>
 * 在这个组件的控制下，用户可以更自由得控制开放数据域：<br/>
 * 1. 子域中可以使用独立的设计分辨率和适配模式<br/>
 * 2. 子域区域尺寸可以缩小到只容纳内容即可<br/>
 * 3. 子域的分辨率也可以被放大，以便获得更清晰的显示效果<br/>
 * 4. 用户输入坐标会被自动转换到正确的子域视窗中<br/>
 * 5. 子域内容贴图的更新由组件负责，用户不需要处理<br/>
 * 唯一需要注意的是，当子域节点的包围盒发生改变时，开发者需要使用 `updateSubContextViewport` 来手动更新子域视窗。
 * @class SwanSubContextView
 * @extends Component
 */


var SwanSubContextView = cc.Class({
  name: 'cc.SwanSubContextView',
  "extends": Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.others/SwanSubContextView',
    help: 'i18n:COMPONENT.help_url.swan_subcontext_view'
  },
  properties: {
    _fps: 60,
    fps: {
      get: function get() {
        return this._fps;
      },
      set: function set(value) {
        if (this._fps === value) {
          return;
        }

        this._fps = value;
        this._updateInterval = 1 / value;

        this._updateSubContextFrameRate();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.swan_subcontext_view.fps'
    }
  },
  ctor: function ctor() {
    this._sprite = null;
    this._tex = new cc.Texture2D();
    this._context = null;
    this._updatedTime = performance.now();
    this._updateInterval = 0;
  },
  onLoad: function onLoad() {
    // Setup subcontext canvas size
    if (swan.getOpenDataContext) {
      this._updateInterval = 1000 / this._fps;
      this._context = swan.getOpenDataContext();
      var sharedCanvas = this._context.canvas;

      if (sharedCanvas) {
        sharedCanvas.width = this.node.width;
        sharedCanvas.height = this.node.height;
      }

      this._tex.setPremultiplyAlpha(true);

      this._tex.initWithElement(sharedCanvas);

      this._sprite = this.node.getComponent(cc.Sprite);

      if (!this._sprite) {
        this._sprite = this.node.addComponent(cc.Sprite);
        this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
      }

      this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
    } else {
      this.enabled = false;
    }
  },
  onEnable: function onEnable() {
    this._runSubContextMainLoop();

    this._registerNodeEvent();

    this._updateSubContextFrameRate();

    this.updateSubContextViewport();
  },
  onDisable: function onDisable() {
    this._unregisterNodeEvent();

    this._stopSubContextMainLoop();
  },
  update: function update(dt) {
    var calledUpdateMannually = dt === undefined;

    if (calledUpdateMannually) {
      this._context && this._context.postMessage({
        fromEngine: true,
        event: 'step'
      });

      this._updateSubContextTexture();

      return;
    }

    var now = performance.now();
    var deltaTime = now - this._updatedTime;

    if (deltaTime >= this._updateInterval) {
      this._updatedTime += this._updateInterval;

      this._updateSubContextTexture();
    }
  },
  _updateSubContextTexture: function _updateSubContextTexture() {
    if (!this._tex || !this._context) {
      return;
    }

    this._tex.initWithElement(this._context.canvas);

    this._sprite._activateMaterial();
  },

  /**
   * !#en Update the sub context viewport manually, it should be called whenever the node's bounding box changes.
   * !#zh 更新开放数据域相对于主域的 viewport，这个函数应该在节点包围盒改变时手动调用。
   * @method updateSubContextViewport
   */
  updateSubContextViewport: function updateSubContextViewport() {
    if (this._context) {
      var box = this.node.getBoundingBoxToWorld();
      var sx = cc.view._scaleX;
      var sy = cc.view._scaleY;

      this._context.postMessage({
        fromEngine: true,
        event: 'viewport',
        x: box.x * sx + cc.view._viewportRect.x,
        y: box.y * sy + cc.view._viewportRect.y,
        width: box.width * sx,
        height: box.height * sy
      });
    }
  },
  _registerNodeEvent: function _registerNodeEvent() {
    this.node.on('position-changed', this.updateSubContextViewport, this);
    this.node.on('scale-changed', this.updateSubContextViewport, this);
    this.node.on('size-changed', this.updateSubContextViewport, this);
  },
  _unregisterNodeEvent: function _unregisterNodeEvent() {
    this.node.off('position-changed', this.updateSubContextViewport, this);
    this.node.off('scale-changed', this.updateSubContextViewport, this);
    this.node.off('size-changed', this.updateSubContextViewport, this);
  },
  _runSubContextMainLoop: function _runSubContextMainLoop() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'mainLoop',
        value: true
      });
    }
  },
  _stopSubContextMainLoop: function _stopSubContextMainLoop() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'mainLoop',
        value: false
      });
    }
  },
  _updateSubContextFrameRate: function _updateSubContextFrameRate() {
    if (this._context) {
      this._context.postMessage({
        fromEngine: true,
        event: 'frameRate',
        value: this._fps
      });
    }
  }
});
cc.SwanSubContextView = module.exports = SwanSubContextView;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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