
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCToggleContainer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en ToggleContainer is not a visiable UI component but a way to modify the behavior of a set of Toggles. <br/>
 * Toggles that belong to the same group could only have one of them to be switched on at a time.<br/>
 * Note: All the first layer child node containing the toggle component will auto be added to the container
 * !#zh ToggleContainer 不是一个可见的 UI 组件，它可以用来修改一组 Toggle 组件的行为。<br/>
 * 当一组 Toggle 属于同一个 ToggleContainer 的时候，任何时候只能有一个 Toggle 处于选中状态。<br/>
 * 注意：所有包含 Toggle 组件的一级子节点都会自动被添加到该容器中
 * @class ToggleContainer
 * @extends Component
 */
var ToggleContainer = cc.Class({
  name: 'cc.ToggleContainer',
  "extends": cc.Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/ToggleContainer',
    help: 'i18n:COMPONENT.help_url.toggleContainer',
    executeInEditMode: true
  },
  properties: {
    /**
     * !#en If this setting is true, a toggle could be switched off and on when pressed.
     * If it is false, it will make sure there is always only one toggle could be switched on
     * and the already switched on toggle can't be switched off.
     * !#zh 如果这个设置为 true， 那么 toggle 按钮在被点击的时候可以反复地被选中和未选中。
     * @property {Boolean} allowSwitchOff
     */
    allowSwitchOff: {
      tooltip: CC_DEV && 'i18n:COMPONENT.toggle_group.allowSwitchOff',
      "default": false
    },

    /**
     * !#en If Toggle is clicked, it will trigger event's handler
     * !#zh Toggle 按钮的点击事件列表。
     * @property {Component.EventHandler[]} checkEvents
     */
    checkEvents: {
      "default": [],
      type: cc.Component.EventHandler
    }
  },
  updateToggles: function updateToggles(toggle) {
    if (!this.enabledInHierarchy) return;

    if (toggle.isChecked) {
      this.toggleItems.forEach(function (item) {
        if (item !== toggle && item.isChecked && item.enabled) {
          item._hideCheckMark();
        }
      });

      if (this.checkEvents) {
        cc.Component.EventHandler.emitEvents(this.checkEvents, toggle);
      }
    }
  },
  _allowOnlyOneToggleChecked: function _allowOnlyOneToggleChecked() {
    var isChecked = false;
    this.toggleItems.forEach(function (item) {
      if (isChecked) {
        item._hideCheckMark();
      } else if (item.isChecked) {
        isChecked = true;
      }
    });
    return isChecked;
  },
  _makeAtLeastOneToggleChecked: function _makeAtLeastOneToggleChecked() {
    var isChecked = this._allowOnlyOneToggleChecked();

    if (!isChecked && !this.allowSwitchOff) {
      var toggleItems = this.toggleItems;

      if (toggleItems.length > 0) {
        toggleItems[0].check();
      }
    }
  },
  onEnable: function onEnable() {
    this.node.on('child-added', this._allowOnlyOneToggleChecked, this);
    this.node.on('child-removed', this._makeAtLeastOneToggleChecked, this);
  },
  onDisable: function onDisable() {
    this.node.off('child-added', this._allowOnlyOneToggleChecked, this);
    this.node.off('child-removed', this._makeAtLeastOneToggleChecked, this);
  },
  start: function start() {
    this._makeAtLeastOneToggleChecked();
  }
});
/**
 * !#en Read only property, return the toggle items array reference managed by ToggleContainer.
 * !#zh 只读属性，返回 ToggleContainer 管理的 toggle 数组引用
 * @property {Toggle[]} toggleItems
 */

var js = require('../platform/js');

js.get(ToggleContainer.prototype, 'toggleItems', function () {
  return this.node.getComponentsInChildren(cc.Toggle);
});
cc.ToggleContainer = module.exports = ToggleContainer;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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