
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCStudioComponent.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var ComponentType = cc.Enum({
  NONE: 0,
  CHECKBOX: 1,
  TEXT_ATLAS: 2,
  SLIDER_BAR: 3,
  LIST_VIEW: 4,
  PAGE_VIEW: 5
});
var ListDirection = cc.Enum({
  VERTICAL: 0,
  HORIZONTAL: 1
});
var VerticalAlign = cc.Enum({
  TOP: 0,
  CENTER: 1,
  BOTTOM: 2
});
var HorizontalAlign = cc.Enum({
  LEFT: 0,
  CENTER: 1,
  RIGHT: 2
});
var StudioComponent = cc.Class({
  name: 'cc.StudioComponent',
  "extends": cc.Component,
  editor: CC_EDITOR && {
    inspector: 'unpack://engine-dev/extensions/cocostudio/editor/studio-component.js'
  },
  properties: CC_EDITOR && {
    _type: ComponentType.NONE,
    type: {
      get: function get() {
        return this._type;
      },
      set: function set(value) {
        this._type = value;
      },
      readonly: true,
      type: ComponentType
    },
    // props for checkbox
    _checkNormalBackFrame: null,
    checkNormalBackFrame: {
      get: function get() {
        return this._checkNormalBackFrame;
      },
      set: function set(value) {
        this._checkNormalBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkPressedBackFrame: null,
    checkPressedBackFrame: {
      get: function get() {
        return this._checkPressedBackFrame;
      },
      set: function set(value) {
        this._checkPressedBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkDisableBackFrame: null,
    checkDisableBackFrame: {
      get: function get() {
        return this._checkDisableBackFrame;
      },
      set: function set(value) {
        this._checkDisableBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkNormalFrame: null,
    checkNormalFrame: {
      get: function get() {
        return this._checkNormalFrame;
      },
      set: function set(value) {
        this._checkNormalFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _checkDisableFrame: null,
    checkDisableFrame: {
      get: function get() {
        return this._checkDisableFrame;
      },
      set: function set(value) {
        this._checkDisableFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    checkInteractable: {
      readonly: true,
      "default": true
    },
    isChecked: {
      readonly: true,
      "default": true
    },
    // props for TextAtlas
    _atlasFrame: null,
    atlasFrame: {
      get: function get() {
        return this._atlasFrame;
      },
      set: function set(value) {
        this._atlasFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    firstChar: {
      readonly: true,
      "default": '.'
    },
    charWidth: {
      readonly: true,
      "default": 0
    },
    charHeight: {
      readonly: true,
      "default": 0
    },
    string: {
      readonly: true,
      "default": ''
    },
    // props for SliderBar
    _sliderBackFrame: null,
    sliderBackFrame: {
      get: function get() {
        return this._sliderBackFrame;
      },
      set: function set(value) {
        this._sliderBackFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBarFrame: null,
    sliderBarFrame: {
      get: function get() {
        return this._sliderBarFrame;
      },
      set: function set(value) {
        this._sliderBarFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnNormalFrame: null,
    sliderBtnNormalFrame: {
      get: function get() {
        return this._sliderBtnNormalFrame;
      },
      set: function set(value) {
        this._sliderBtnNormalFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnPressedFrame: null,
    sliderBtnPressedFrame: {
      get: function get() {
        return this._sliderBtnPressedFrame;
      },
      set: function set(value) {
        this._sliderBtnPressedFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    _sliderBtnDisabledFrame: null,
    sliderBtnDisabledFrame: {
      get: function get() {
        return this._sliderBtnDisabledFrame;
      },
      set: function set(value) {
        this._sliderBtnDisabledFrame = value;
      },
      readonly: true,
      type: cc.SpriteFrame
    },
    sliderInteractable: {
      readonly: true,
      "default": true
    },
    sliderProgress: {
      "default": 0.5,
      readonly: true,
      type: cc.Float,
      range: [0, 1, 0.1]
    },
    // props for ListView
    listInertia: {
      readonly: true,
      "default": true,
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollview.inertia'
    },
    listDirection: {
      readonly: true,
      "default": ListDirection.VERTICAL,
      type: ListDirection
    },
    listHorizontalAlign: {
      readonly: true,
      "default": HorizontalAlign.LEFT,
      type: HorizontalAlign
    },
    listVerticalAlign: {
      readonly: true,
      "default": VerticalAlign.TOP,
      type: VerticalAlign
    },
    listPadding: {
      readonly: true,
      "default": 0
    }
  },
  statics: {
    ComponentType: ComponentType,
    ListDirection: ListDirection,
    VerticalAlign: VerticalAlign,
    HorizontalAlign: HorizontalAlign
  }
});

var PrefabHelper = require('../utils/prefab-helper');

StudioComponent.PlaceHolder = cc.Class({
  name: 'cc.StudioComponent.PlaceHolder',
  "extends": cc.Component,
  properties: {
    _baseUrl: '',
    nestedPrefab: cc.Prefab
  },
  onLoad: function onLoad() {
    if (!this.nestedPrefab) {
      if (CC_DEV) {
        cc.warn('Unable to find %s resource.', this._baseUrl);
      }

      return;
    }

    this._replaceWithNestedPrefab();
  },
  _replaceWithNestedPrefab: function _replaceWithNestedPrefab() {
    var node = this.node;
    var _prefab = node._prefab;
    _prefab.root = node;
    _prefab.asset = this.nestedPrefab;
    PrefabHelper.syncWithPrefab(node);
  }
});
cc.StudioComponent = module.exports = StudioComponent;
var StudioWidget = cc.Class({
  name: 'cc.StudioWidget',
  "extends": cc.Widget,
  editor: CC_EDITOR && {
    inspector: 'packages://inspector/inspectors/comps/ccwidget.js'
  },
  _validateTargetInDEV: function _validateTargetInDEV() {}
});
cc.StudioWidget = module.exports = StudioWidget;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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