
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCScrollBar.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var misc = require('../utils/misc');

var Component = require('./CCComponent');

var GETTINGSHORTERFACTOR = 20;
/**
 * Enum for Scrollbar direction
 * @enum Scrollbar.Direction
 */

var Direction = cc.Enum({
  /**
   * @property {Number} HORIZONTAL
   */
  HORIZONTAL: 0,

  /**
   * @property {Number} VERTICAL
   */
  VERTICAL: 1
});
/**
 * !#en
 * The Scrollbar control allows the user to scroll an image or other view that is too large to see completely
 * !#zh 滚动条组件
 * @class Scrollbar
 * @extends Component
 */

var Scrollbar = cc.Class({
  name: 'cc.Scrollbar',
  "extends": require('./CCComponent'),
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/ScrollBar',
    help: 'i18n:COMPONENT.help_url.scrollbar'
  },
  properties: {
    _scrollView: null,
    _touching: false,
    _autoHideRemainingTime: {
      "default": 0,
      serializable: false
    },
    _opacity: 255,

    /**
     * !#en The "handle" part of the scrollbar.
     * !#zh 作为当前滚动区域位置显示的滑块 Sprite。
     * @property {Sprite} handle
     */
    handle: {
      "default": null,
      type: cc.Sprite,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollbar.handle',
      notify: function notify() {
        this._onScroll(cc.v2(0, 0));
      },
      animatable: false
    },

    /**
     * !#en The direction of scrollbar.
     * !#zh ScrollBar 的滚动方向。
     * @property {Scrollbar.Direction} direction
     */
    direction: {
      "default": Direction.HORIZONTAL,
      type: Direction,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollbar.direction',
      notify: function notify() {
        this._onScroll(cc.v2(0, 0));
      },
      animatable: false
    },

    /**
     * !#en Whether enable auto hide or not.
     * !#zh 是否在没有滚动动作时自动隐藏 ScrollBar。
     * @property {Boolean} enableAutoHide
     */
    enableAutoHide: {
      "default": true,
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollbar.auto_hide'
    },

    /**
     * !#en
     * The time to hide scrollbar when scroll finished.
     * Note: This value is only useful when enableAutoHide is true.
     * !#zh
     * 没有滚动动作后经过多久会自动隐藏。
     * 注意：只要当 “enableAutoHide” 为 true 时，才有效。
     * @property {Number} autoHideTime
     */
    autoHideTime: {
      "default": 1.0,
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.scrollbar.auto_hide_time'
    }
  },
  statics: {
    Direction: Direction
  },
  setTargetScrollView: function setTargetScrollView(scrollView) {
    this._scrollView = scrollView;
  },
  _convertToScrollViewSpace: function _convertToScrollViewSpace(content) {
    var scrollViewNode = this._scrollView.node;
    var worldSpacePos = content.convertToWorldSpaceAR(cc.v2(-content.anchorX * content.width, -content.anchorY * content.height));
    var scrollViewSpacePos = scrollViewNode.convertToNodeSpaceAR(worldSpacePos);
    scrollViewSpacePos.x += scrollViewNode.anchorX * scrollViewNode.width;
    scrollViewSpacePos.y += scrollViewNode.anchorY * scrollViewNode.height;
    return scrollViewSpacePos;
  },
  _setOpacity: function _setOpacity(opacity) {
    if (this.handle) {
      this.node.opacity = opacity;
      this.handle.node.opacity = opacity;
    }
  },
  _onScroll: function _onScroll(outOfBoundary) {
    if (this._scrollView) {
      var content = this._scrollView.content;

      if (content) {
        var contentSize = content.getContentSize();

        var scrollViewSize = this._scrollView.node.getContentSize();

        var handleNodeSize = this.node.getContentSize();

        if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) {
          return;
        }

        if (this.enableAutoHide) {
          this._autoHideRemainingTime = this.autoHideTime;

          this._setOpacity(this._opacity);
        }

        var contentMeasure = 0;
        var scrollViewMeasure = 0;
        var outOfBoundaryValue = 0;
        var contentPosition = 0;
        var handleNodeMeasure = 0;

        if (this.direction === Direction.HORIZONTAL) {
          contentMeasure = contentSize.width;
          scrollViewMeasure = scrollViewSize.width;
          handleNodeMeasure = handleNodeSize.width;
          outOfBoundaryValue = outOfBoundary.x;
          contentPosition = -this._convertToScrollViewSpace(content).x;
        } else if (this.direction === Direction.VERTICAL) {
          contentMeasure = contentSize.height;
          scrollViewMeasure = scrollViewSize.height;
          handleNodeMeasure = handleNodeSize.height;
          outOfBoundaryValue = outOfBoundary.y;
          contentPosition = -this._convertToScrollViewSpace(content).y;
        }

        var length = this._calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundaryValue);

        var position = this._calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundaryValue, length);

        this._updateLength(length);

        this._updateHanlderPosition(position);
      }
    }
  },
  _updateHanlderPosition: function _updateHanlderPosition(position) {
    if (this.handle) {
      var oldPosition = this._fixupHandlerPosition();

      this.handle.node.setPosition(position.x + oldPosition.x, position.y + oldPosition.y);
    }
  },
  _fixupHandlerPosition: function _fixupHandlerPosition() {
    var barSize = this.node.getContentSize();
    var barAnchor = this.node.getAnchorPoint();
    var handleSize = this.handle.node.getContentSize();
    var handleParent = this.handle.node.parent;
    var leftBottomWorldPosition = this.node.convertToWorldSpaceAR(cc.v2(-barSize.width * barAnchor.x, -barSize.height * barAnchor.y));
    var fixupPosition = handleParent.convertToNodeSpaceAR(leftBottomWorldPosition);

    if (this.direction === Direction.HORIZONTAL) {
      fixupPosition = cc.v2(fixupPosition.x, fixupPosition.y + (barSize.height - handleSize.height) / 2);
    } else if (this.direction === Direction.VERTICAL) {
      fixupPosition = cc.v2(fixupPosition.x + (barSize.width - handleSize.width) / 2, fixupPosition.y);
    }

    this.handle.node.setPosition(fixupPosition);
    return fixupPosition;
  },
  _onTouchBegan: function _onTouchBegan() {
    if (!this.enableAutoHide) {
      return;
    }

    this._touching = true;
  },
  _conditionalDisableScrollBar: function _conditionalDisableScrollBar(contentSize, scrollViewSize) {
    if (contentSize.width <= scrollViewSize.width && this.direction === Direction.HORIZONTAL) {
      return true;
    }

    if (contentSize.height <= scrollViewSize.height && this.direction === Direction.VERTICAL) {
      return true;
    }

    return false;
  },
  _onTouchEnded: function _onTouchEnded() {
    if (!this.enableAutoHide) {
      return;
    }

    this._touching = false;

    if (this.autoHideTime <= 0) {
      return;
    }

    if (this._scrollView) {
      var content = this._scrollView.content;

      if (content) {
        var contentSize = content.getContentSize();

        var scrollViewSize = this._scrollView.node.getContentSize();

        if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) {
          return;
        }
      }
    }

    this._autoHideRemainingTime = this.autoHideTime;
  },
  _calculateLength: function _calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundary) {
    var denominatorValue = contentMeasure;

    if (outOfBoundary) {
      denominatorValue += (outOfBoundary > 0 ? outOfBoundary : -outOfBoundary) * GETTINGSHORTERFACTOR;
    }

    var lengthRation = scrollViewMeasure / denominatorValue;
    return handleNodeMeasure * lengthRation;
  },
  _calculatePosition: function _calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundary, actualLenth) {
    var denominatorValue = contentMeasure - scrollViewMeasure;

    if (outOfBoundary) {
      denominatorValue += Math.abs(outOfBoundary);
    }

    var positionRatio = 0;

    if (denominatorValue) {
      positionRatio = contentPosition / denominatorValue;
      positionRatio = misc.clamp01(positionRatio);
    }

    var position = (handleNodeMeasure - actualLenth) * positionRatio;

    if (this.direction === Direction.VERTICAL) {
      return cc.v2(0, position);
    } else {
      return cc.v2(position, 0);
    }
  },
  _updateLength: function _updateLength(length) {
    if (this.handle) {
      var handleNode = this.handle.node;
      var handleNodeSize = handleNode.getContentSize();
      handleNode.setAnchorPoint(cc.v2(0, 0));

      if (this.direction === Direction.HORIZONTAL) {
        handleNode.setContentSize(length, handleNodeSize.height);
      } else {
        handleNode.setContentSize(handleNodeSize.width, length);
      }
    }
  },
  _processAutoHide: function _processAutoHide(deltaTime) {
    if (!this.enableAutoHide || this._autoHideRemainingTime <= 0) {
      return;
    } else if (this._touching) {
      return;
    }

    this._autoHideRemainingTime -= deltaTime;

    if (this._autoHideRemainingTime <= this.autoHideTime) {
      this._autoHideRemainingTime = Math.max(0, this._autoHideRemainingTime);
      var opacity = this._opacity * (this._autoHideRemainingTime / this.autoHideTime);

      this._setOpacity(opacity);
    }
  },
  start: function start() {
    if (this.enableAutoHide) {
      this._setOpacity(0);
    }
  },
  hide: function hide() {
    this._autoHideRemainingTime = 0;

    this._setOpacity(0);
  },
  show: function show() {
    this._autoHideRemainingTime = this.autoHideTime;

    this._setOpacity(this._opacity);
  },
  update: function update(dt) {
    this._processAutoHide(dt);
  }
});
cc.Scrollbar = module.exports = Scrollbar;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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