
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCRenderComponent.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _assembler = _interopRequireDefault(require("../renderer/assembler"));

var _materialVariant = _interopRequireDefault(require("../assets/material/material-variant"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Component = require('./CCComponent');

var RenderFlow = require('../renderer/render-flow');

var Material = require('../assets/material/CCMaterial');
/**
 * !#en
 * Base class for components which supports rendering features.
 * !#zh
 * 所有支持渲染的组件的基类
 *
 * @class RenderComponent
 * @extends Component
 */


var RenderComponent = cc.Class({
  name: 'RenderComponent',
  "extends": Component,
  editor: CC_EDITOR && {
    executeInEditMode: true,
    disallowMultiple: true
  },
  properties: {
    _materials: {
      "default": [],
      type: Material
    },

    /**
     * !#en The materials used by this render component.
     * !#zh 渲染组件使用的材质。
     * @property {[Material]} sharedMaterials
     */
    materials: {
      get: function get() {
        return this._materials;
      },
      set: function set(val) {
        this._materials = val;

        this._activateMaterial();
      },
      type: [Material],
      displayName: 'Materials',
      animatable: false
    }
  },
  ctor: function ctor() {
    this._vertsDirty = true;
    this._assembler = null;
  },
  _resetAssembler: function _resetAssembler() {
    _assembler["default"].init(this);

    this._updateColor();

    this.setVertsDirty();
  },
  __preload: function __preload() {
    this._resetAssembler();

    this._activateMaterial();
  },
  onEnable: function onEnable() {
    if (this.node._renderComponent) {
      this.node._renderComponent.enabled = false;
    }

    this.node._renderComponent = this;
    this.node._renderFlag |= RenderFlow.FLAG_OPACITY_COLOR;
    this.setVertsDirty();
  },
  onDisable: function onDisable() {
    this.node._renderComponent = null;
    this.disableRender();
  },
  onDestroy: function onDestroy() {
    var materials = this._materials;

    for (var i = 0; i < materials.length; i++) {
      cc.pool.material.put(materials[i]);
    }

    materials.length = 0;
    cc.pool.assembler.put(this._assembler);
  },
  setVertsDirty: function setVertsDirty() {
    this._vertsDirty = true;
    this.markForRender(true);
  },
  _on3DNodeChanged: function _on3DNodeChanged() {
    this._resetAssembler();
  },
  _validateRender: function _validateRender() {},
  markForValidate: function markForValidate() {
    cc.RenderFlow.registerValidate(this);
  },
  markForRender: function markForRender(enable) {
    var flag = RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA;

    if (enable) {
      this.node._renderFlag |= flag;
      this.markForValidate();
    } else {
      this.node._renderFlag &= ~flag;
    }
  },
  disableRender: function disableRender() {
    this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA);
  },

  /**
   * !#en Get the material by index.
   * !#zh 根据指定索引获取材质
   * @method getMaterial
   * @param {Number} index 
   * @return {MaterialVariant}
   */
  getMaterial: function getMaterial(index) {
    if (index < 0 || index >= this._materials.length) {
      return null;
    }

    var material = this._materials[index];
    if (!material) return null;

    var instantiated = _materialVariant["default"].create(material, this);

    if (instantiated !== material) {
      this.setMaterial(index, instantiated);
    }

    return instantiated;
  },

  /**
   * !#en Gets all the materials.
   * !#zh 获取所有材质。
   * @method getMaterials
   * @return {[MaterialVariant]}
   */
  getMaterials: function getMaterials() {
    var materials = this._materials;

    for (var i = 0; i < materials.length; i++) {
      materials[i] = _materialVariant["default"].create(materials[i], this);
    }

    return materials;
  },

  /**
   * !#en Set the material by index.
   * !#zh 根据指定索引设置材质
   * @method setMaterial
   * @param {Number} index 
   * @param {Material} material
   * @return {Material}
   */
  setMaterial: function setMaterial(index, material) {
    if (material !== this._materials[index]) {
      material = _materialVariant["default"].create(material, this);
      this._materials[index] = material;
    }

    this._updateMaterial();

    this.markForRender(true);
    return material;
  },
  _getDefaultMaterial: function _getDefaultMaterial() {
    return Material.getBuiltinMaterial('2d-sprite');
  },

  /**
   * Init material.
   */
  _activateMaterial: function _activateMaterial() {
    var materials = this._materials;

    if (!materials[0]) {
      var material = this._getDefaultMaterial();

      materials[0] = material;
    }

    for (var i = 0; i < materials.length; i++) {
      materials[i] = _materialVariant["default"].create(materials[i], this);
    }

    this._updateMaterial();
  },

  /**
   * Update material properties.
   */
  _updateMaterial: function _updateMaterial() {},
  _updateColor: function _updateColor() {
    if (this._assembler.updateColor) {
      this._assembler.updateColor(this);
    }
  },
  _checkBacth: function _checkBacth(renderer, cullingMask) {
    var material = this._materials[0];

    if (material && material.getHash() !== renderer.material.getHash() || renderer.cullingMask !== cullingMask) {
      renderer._flush();

      renderer.node = material.getDefine('CC_USE_MODEL') ? this.node : renderer._dummyNode;
      renderer.material = material;
      renderer.cullingMask = cullingMask;
    }
  }
});
cc.RenderComponent = module.exports = RenderComponent;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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