
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCProgressBar.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var misc = require('../utils/misc');

var Component = require('./CCComponent');
/**
 * !#en Enum for ProgressBar mode
 * !#zh 进度条模式
 * @enum ProgressBar.Mode
 */


var Mode = cc.Enum({
  /**
   * !#en TODO
   * !#zh 水平方向模式
   * @property {Number} HORIZONTAL
   */
  HORIZONTAL: 0,

  /**
   * !#en TODO
   * !#zh 垂直方向模式
   * @property {Number} VERTICAL
   */
  VERTICAL: 1,

  /**
   * !#en TODO
   * !#zh 填充模式
   * @property {Number} FILLED
   */
  FILLED: 2
});
/**
 * !#en
 * Visual indicator of progress in some operation.
 * Displays a bar to the user representing how far the operation has progressed.
 * !#zh
 * 进度条组件，可用于显示加载资源时的进度。
 * @class ProgressBar
 * @extends Component
 * @example
 * // update progressBar
 * update: function (dt) {
 *     var progress = progressBar.progress;
 *     if (progress > 0) {
 *         progress += dt;
 *     }
 *     else {
 *         progress = 1;
 *     }
 *     progressBar.progress = progress;
 * }
 *
 */

var ProgressBar = cc.Class({
  name: 'cc.ProgressBar',
  "extends": Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/ProgressBar',
    help: 'i18n:COMPONENT.help_url.progressbar'
  },
  _initBarSprite: function _initBarSprite() {
    if (this.barSprite) {
      var entity = this.barSprite.node;
      if (!entity) return;
      var nodeSize = this.node.getContentSize();
      var nodeAnchor = this.node.getAnchorPoint();
      var entitySize = entity.getContentSize();

      if (entity.parent === this.node) {
        this.node.setContentSize(entitySize);
      }

      if (this.barSprite.fillType === cc.Sprite.FillType.RADIAL) {
        this.mode = Mode.FILLED;
      }

      var barSpriteSize = entity.getContentSize();

      if (this.mode === Mode.HORIZONTAL) {
        this.totalLength = barSpriteSize.width;
      } else if (this.mode === Mode.VERTICAL) {
        this.totalLength = barSpriteSize.height;
      } else {
        this.totalLength = this.barSprite.fillRange;
      }

      if (entity.parent === this.node) {
        var x = -nodeSize.width * nodeAnchor.x;
        var y = 0;
        entity.setPosition(cc.v2(x, y));
      }
    }
  },
  _updateBarStatus: function _updateBarStatus() {
    if (this.barSprite) {
      var entity = this.barSprite.node;
      if (!entity) return;
      var entityAnchorPoint = entity.getAnchorPoint();
      var entitySize = entity.getContentSize();
      var entityPosition = entity.getPosition();
      var anchorPoint = cc.v2(0, 0.5);
      var progress = misc.clamp01(this.progress);
      var actualLenth = this.totalLength * progress;
      var finalContentSize;
      var totalWidth;
      var totalHeight;

      switch (this.mode) {
        case Mode.HORIZONTAL:
          if (this.reverse) {
            anchorPoint = cc.v2(1, 0.5);
          }

          finalContentSize = cc.size(actualLenth, entitySize.height);
          totalWidth = this.totalLength;
          totalHeight = entitySize.height;
          break;

        case Mode.VERTICAL:
          if (this.reverse) {
            anchorPoint = cc.v2(0.5, 1);
          } else {
            anchorPoint = cc.v2(0.5, 0);
          }

          finalContentSize = cc.size(entitySize.width, actualLenth);
          totalWidth = entitySize.width;
          totalHeight = this.totalLength;
          break;
      } //handling filled mode


      if (this.mode === Mode.FILLED) {
        if (this.barSprite.type !== cc.Sprite.Type.FILLED) {
          cc.warn('ProgressBar FILLED mode only works when barSprite\'s Type is FILLED!');
        } else {
          if (this.reverse) {
            actualLenth = actualLenth * -1;
          }

          this.barSprite.fillRange = actualLenth;
        }
      } else {
        if (this.barSprite.type !== cc.Sprite.Type.FILLED) {
          var anchorOffsetX = anchorPoint.x - entityAnchorPoint.x;
          var anchorOffsetY = anchorPoint.y - entityAnchorPoint.y;
          var finalPosition = cc.v2(totalWidth * anchorOffsetX, totalHeight * anchorOffsetY);
          entity.setPosition(entityPosition.x + finalPosition.x, entityPosition.y + finalPosition.y);
          entity.setAnchorPoint(anchorPoint);
          entity.setContentSize(finalContentSize);
        } else {
          cc.warn('ProgressBar non-FILLED mode only works when barSprite\'s Type is non-FILLED!');
        }
      }
    }
  },
  properties: {
    /**
     * !#en The targeted Sprite which will be changed progressively.
     * !#zh 用来显示进度条比例的 Sprite 对象。
     * @property {Sprite} barSprite
     */
    barSprite: {
      "default": null,
      type: cc.Sprite,
      tooltip: CC_DEV && 'i18n:COMPONENT.progress.bar_sprite',
      notify: function notify() {
        this._initBarSprite();
      },
      animatable: false
    },

    /**
     * !#en The progress mode, there are two modes supported now: horizontal and vertical.
     * !#zh 进度条的模式
     * @property {ProgressBar.Mode} mode
     */
    mode: {
      "default": Mode.HORIZONTAL,
      type: Mode,
      tooltip: CC_DEV && 'i18n:COMPONENT.progress.mode',
      notify: function notify() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var entitySize = entity.getContentSize();

          if (this.mode === Mode.HORIZONTAL) {
            this.totalLength = entitySize.width;
          } else if (this.mode === Mode.VERTICAL) {
            this.totalLength = entitySize.height;
          } else if (this.mode === Mode.FILLED) {
            this.totalLength = this.barSprite.fillRange;
          }
        }
      },
      animatable: false
    },
    _N$totalLength: 1,

    /**
     * !#en The total width or height of the bar sprite.
     * !#zh 进度条实际的总长度
     * @property {Number} totalLength
     */
    totalLength: {
      range: [0, Number.MAX_VALUE],
      tooltip: CC_DEV && 'i18n:COMPONENT.progress.total_length',
      get: function get() {
        return this._N$totalLength;
      },
      set: function set(value) {
        if (this.mode === Mode.FILLED) {
          value = misc.clamp01(value);
        }

        this._N$totalLength = value;

        this._updateBarStatus();
      }
    },

    /**
     * !#en The current progress of the bar sprite. The valid value is between 0-1.
     * !#zh 当前进度值，该数值的区间是 0-1 之间。
     * @property {Number} progress
     */
    progress: {
      "default": 1,
      type: cc.Float,
      range: [0, 1, 0.1],
      slide: true,
      tooltip: CC_DEV && 'i18n:COMPONENT.progress.progress',
      notify: function notify() {
        this._updateBarStatus();
      }
    },

    /**
     * !#en Whether reverse the progress direction of the bar sprite.
     * !#zh 进度条是否进行反方向变化。
     * @property {Boolean} reverse
     */
    reverse: {
      "default": false,
      tooltip: CC_DEV && 'i18n:COMPONENT.progress.reverse',
      notify: function notify() {
        if (this.barSprite) {
          this.barSprite.fillStart = 1 - this.barSprite.fillStart;
        }

        this._updateBarStatus();
      },
      animatable: false
    }
  },
  statics: {
    Mode: Mode
  }
});
cc.ProgressBar = module.exports = ProgressBar;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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