
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCLabel.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var macro = require('../platform/CCMacro');

var RenderComponent = require('./CCRenderComponent');

var Material = require('../assets/material/CCMaterial');

var LabelFrame = require('../renderer/utils/label/label-frame');
/**
 * !#en Enum for text alignment.
 * !#zh 文本横向对齐类型
 * @enum Label.HorizontalAlign
 */

/**
 * !#en Alignment left for text.
 * !#zh 文本内容左对齐。
 * @property {Number} LEFT
 */

/**
 * !#en Alignment center for text.
 * !#zh 文本内容居中对齐。
 * @property {Number} CENTER
 */

/**
 * !#en Alignment right for text.
 * !#zh 文本内容右边对齐。
 * @property {Number} RIGHT
 */


var HorizontalAlign = macro.TextAlignment;
/**
 * !#en Enum for vertical text alignment.
 * !#zh 文本垂直对齐类型
 * @enum Label.VerticalAlign
 */

/**
 * !#en Vertical alignment top for text.
 * !#zh 文本顶部对齐。
 * @property {Number} TOP
 */

/**
 * !#en Vertical alignment center for text.
 * !#zh 文本居中对齐。
 * @property {Number} CENTER
 */

/**
 * !#en Vertical alignment bottom for text.
 * !#zh 文本底部对齐。
 * @property {Number} BOTTOM
 */

var VerticalAlign = macro.VerticalTextAlignment;
/**
 * !#en Enum for Overflow.
 * !#zh Overflow 类型
 * @enum Label.Overflow
 */

/**
 * !#en NONE.
 * !#zh 不做任何限制。
 * @property {Number} NONE
 */

/**
 * !#en In CLAMP mode, when label content goes out of the bounding box, it will be clipped.
 * !#zh CLAMP 模式中，当文本内容超出边界框时，多余的会被截断。
 * @property {Number} CLAMP
 */

/**
 * !#en In SHRINK mode, the font size will change dynamically to adapt the content size. This mode may takes up more CPU resources when the label is refreshed.
 * !#zh SHRINK 模式，字体大小会动态变化，以适应内容大小。这个模式在文本刷新的时候可能会占用较多 CPU 资源。
 * @property {Number} SHRINK
 */

/**
 * !#en In RESIZE_HEIGHT mode, you can only change the width of label and the height is changed automatically.
 * !#zh 在 RESIZE_HEIGHT 模式下，只能更改文本的宽度，高度是自动改变的。
 * @property {Number} RESIZE_HEIGHT
 */

var Overflow = cc.Enum({
  NONE: 0,
  CLAMP: 1,
  SHRINK: 2,
  RESIZE_HEIGHT: 3
});
/**
 * !#en Enum for font type.
 * !#zh Type 类型
 * @enum Label.Type
 */

/**
 * !#en The TTF font type.
 * !#zh TTF字体
 * @property {Number} TTF
 */

/**
 * !#en The bitmap font type.
 * !#zh 位图字体
 * @property {Number} BMFont
 */

/**
 * !#en The system font type.
 * !#zh 系统字体
 * @property {Number} SystemFont
 */

/**
 * !#en Enum for cache mode.
 * !#zh CacheMode 类型
 * @enum Label.CacheMode
 */

/**
* !#en Do not do any caching.
* !#zh 不做任何缓存。
* @property {Number} NONE
*/

/**
 * !#en In BITMAP mode, cache the label as a static image and add it to the dynamic atlas for batch rendering, and can batching with Sprites using broken images.
 * !#zh BITMAP 模式，将 label 缓存成静态图像并加入到动态图集，以便进行批次合并，可与使用碎图的 Sprite 进行合批（注：动态图集在 Chrome 以及微信小游戏暂时关闭，该功能无效）。
 * @property {Number} BITMAP
 */

/**
 * !#en In CHAR mode, split text into characters and cache characters into a dynamic atlas which the size of 2048*2048. 
 * !#zh CHAR 模式，将文本拆分为字符，并将字符缓存到一张单独的大小为 2048*2048 的图集中进行重复使用，不再使用动态图集（注：当图集满时将不再进行缓存，暂时不支持 SHRINK 自适应文本尺寸（后续完善））。
 * @property {Number} CHAR
 */

var CacheMode = cc.Enum({
  NONE: 0,
  BITMAP: 1,
  CHAR: 2
});
var BOLD_FLAG = 1 << 0;
var ITALIC_FLAG = 1 << 1;
var UNDERLINE_FLAG = 1 << 2;
/**
 * !#en The Label Component.
 * !#zh 文字标签组件
 * @class Label
 * @extends RenderComponent
 */

var Label = cc.Class({
  name: 'cc.Label',
  "extends": RenderComponent,
  ctor: function ctor() {
    if (CC_EDITOR) {
      this._userDefinedFont = null;
    }

    this._actualFontSize = 0;
    this._assemblerData = null;
    this._frame = null;
    this._ttfTexture = null;
    this._letterTexture = null;

    if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
      this._updateMaterial = this._updateMaterialCanvas;
    } else {
      this._updateMaterial = this._updateMaterialWebgl;
    }
  },
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.renderers/Label',
    help: 'i18n:COMPONENT.help_url.label',
    inspector: 'packages://inspector/inspectors/comps/label.js'
  },
  properties: {
    _useOriginalSize: true,

    /**
     * !#en Content string of label.
     * !#zh 标签显示的文本内容。
     * @property {String} string
     */
    _string: {
      "default": '',
      formerlySerializedAs: '_N$string'
    },
    string: {
      get: function get() {
        return this._string;
      },
      set: function set(value) {
        var oldValue = this._string;
        this._string = '' + value;

        if (this.string !== oldValue) {
          this.setVertsDirty();
        }

        this._checkStringEmpty();
      },
      multiline: true,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.string'
    },

    /**
     * !#en Horizontal Alignment of label.
     * !#zh 文本内容的水平对齐方式。
     * @property {Label.HorizontalAlign} horizontalAlign
     */
    horizontalAlign: {
      "default": HorizontalAlign.LEFT,
      type: HorizontalAlign,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.horizontal_align',
      notify: function notify(oldValue) {
        if (this.horizontalAlign === oldValue) return;
        this.setVertsDirty();
      },
      animatable: false
    },

    /**
     * !#en Vertical Alignment of label.
     * !#zh 文本内容的垂直对齐方式。
     * @property {Label.VerticalAlign} verticalAlign
     */
    verticalAlign: {
      "default": VerticalAlign.TOP,
      type: VerticalAlign,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.vertical_align',
      notify: function notify(oldValue) {
        if (this.verticalAlign === oldValue) return;
        this.setVertsDirty();
      },
      animatable: false
    },

    /**
     * !#en The actual rendering font size in shrink mode
     * !#zh SHRINK 模式下面文本实际渲染的字体大小
     * @property {Number} actualFontSize
     */
    actualFontSize: {
      displayName: 'Actual Font Size',
      animatable: false,
      readonly: true,
      get: function get() {
        return this._actualFontSize;
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.label.actualFontSize'
    },
    _fontSize: 40,

    /**
     * !#en Font size of label.
     * !#zh 文本字体大小。
     * @property {Number} fontSize
     */
    fontSize: {
      get: function get() {
        return this._fontSize;
      },
      set: function set(value) {
        if (this._fontSize === value) return;
        this._fontSize = value;
        this.setVertsDirty();
      },
      range: [0, 512],
      tooltip: CC_DEV && 'i18n:COMPONENT.label.font_size'
    },

    /**
     * !#en Font family of label, only take effect when useSystemFont property is true.
     * !#zh 文本字体名称, 只在 useSystemFont 属性为 true 的时候生效。
     * @property {String} fontFamily
     */
    fontFamily: {
      "default": "Arial",
      tooltip: CC_DEV && 'i18n:COMPONENT.label.font_family',
      notify: function notify(oldValue) {
        if (this.fontFamily === oldValue) return;
        this.setVertsDirty();
      },
      animatable: false
    },
    _lineHeight: 40,

    /**
     * !#en Line Height of label.
     * !#zh 文本行高。
     * @property {Number} lineHeight
     */
    lineHeight: {
      get: function get() {
        return this._lineHeight;
      },
      set: function set(value) {
        if (this._lineHeight === value) return;
        this._lineHeight = value;
        this.setVertsDirty();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.label.line_height'
    },

    /**
     * !#en Overflow of label.
     * !#zh 文字显示超出范围时的处理方式。
     * @property {Label.Overflow} overflow
     */
    overflow: {
      "default": Overflow.NONE,
      type: Overflow,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.overflow',
      notify: function notify(oldValue) {
        if (this.overflow === oldValue) return;
        this.setVertsDirty();
      },
      animatable: false
    },
    _enableWrapText: true,

    /**
     * !#en Whether auto wrap label when string width is large than label width.
     * !#zh 是否自动换行。
     * @property {Boolean} enableWrapText
     */
    enableWrapText: {
      get: function get() {
        return this._enableWrapText;
      },
      set: function set(value) {
        if (this._enableWrapText === value) return;
        this._enableWrapText = value;
        this.setVertsDirty();
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.wrap'
    },
    // 这个保存了旧项目的 file 数据
    _N$file: null,

    /**
     * !#en The font of label.
     * !#zh 文本字体。
     * @property {Font} font
     */
    font: {
      get: function get() {
        return this._N$file;
      },
      set: function set(value) {
        if (this.font === value) return; //if delete the font, we should change isSystemFontUsed to true

        if (!value) {
          this._isSystemFontUsed = true;
        }

        if (CC_EDITOR && value) {
          this._userDefinedFont = value;
        }

        this._N$file = value;
        if (value && this._isSystemFontUsed) this._isSystemFontUsed = false;

        if (typeof value === 'string') {
          cc.warnID(4000);
        }

        if (!this.enabledInHierarchy) return;

        this._forceUpdateRenderData();
      },
      type: cc.Font,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.font',
      animatable: false
    },
    _isSystemFontUsed: true,

    /**
     * !#en Whether use system font name or not.
     * !#zh 是否使用系统字体。
     * @property {Boolean} useSystemFont
     */
    useSystemFont: {
      get: function get() {
        return this._isSystemFontUsed;
      },
      set: function set(value) {
        if (this._isSystemFontUsed === value) return;
        this._isSystemFontUsed = !!value;

        if (CC_EDITOR) {
          if (!value && this._userDefinedFont) {
            this.font = this._userDefinedFont;
            this.spacingX = this._spacingX;
            return;
          }
        }

        if (value) {
          this.font = null;
          if (!this.enabledInHierarchy) return;

          this._forceUpdateRenderData();
        }

        this.markForValidate();
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.system_font'
    },
    _bmFontOriginalSize: {
      displayName: 'BMFont Original Size',
      get: function get() {
        if (this._N$file instanceof cc.BitmapFont) {
          return this._N$file.fontSize;
        } else {
          return -1;
        }
      },
      visible: true,
      animatable: false
    },
    _spacingX: 0,

    /**
     * !#en The spacing of the x axis between characters, only take Effect when using bitmap fonts.
     * !#zh 文字之间 x 轴的间距，仅在使用位图字体时生效。
     * @property {Number} spacingX
     */
    spacingX: {
      get: function get() {
        return this._spacingX;
      },
      set: function set(value) {
        this._spacingX = value;
        this.setVertsDirty();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.label.spacingX'
    },
    //For compatibility with v2.0.x temporary reservation.
    _batchAsBitmap: false,

    /**
     * !#en The cache mode of label. This mode only supports system fonts.
     * !#zh 文本缓存模式, 该模式只支持系统字体。
     * @property {Label.CacheMode} cacheMode
     */
    cacheMode: {
      "default": CacheMode.NONE,
      type: CacheMode,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.cacheMode',
      notify: function notify(oldValue) {
        if (this.cacheMode === oldValue) return;

        if (oldValue === CacheMode.BITMAP && !(this.font instanceof cc.BitmapFont)) {
          this._frame && this._frame._resetDynamicAtlasFrame();
        }

        if (oldValue === CacheMode.CHAR) {
          this._ttfTexture = null;
        }

        if (!this.enabledInHierarchy) return;

        this._forceUpdateRenderData();
      },
      animatable: false
    },
    _styleFlags: 0,

    /**
     * !#en Whether enable bold.
     * !#zh 是否启用黑体。
     * @property {Boolean} enableBold
     */
    enableBold: {
      get: function get() {
        return !!(this._styleFlags & BOLD_FLAG);
      },
      set: function set(value) {
        if (value) {
          this._styleFlags |= BOLD_FLAG;
        } else {
          this._styleFlags &= ~BOLD_FLAG;
        }

        this.setVertsDirty();
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.bold'
    },

    /**
     * !#en Whether enable italic.
     * !#zh 是否启用黑体。
     * @property {Boolean} enableItalic
     */
    enableItalic: {
      get: function get() {
        return !!(this._styleFlags & ITALIC_FLAG);
      },
      set: function set(value) {
        if (value) {
          this._styleFlags |= ITALIC_FLAG;
        } else {
          this._styleFlags &= ~ITALIC_FLAG;
        }

        this.setVertsDirty();
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.italic'
    },

    /**
     * !#en Whether enable underline.
     * !#zh 是否启用下划线。
     * @property {Boolean} enableUnderline
     */
    enableUnderline: {
      get: function get() {
        return !!(this._styleFlags & UNDERLINE_FLAG);
      },
      set: function set(value) {
        if (value) {
          this._styleFlags |= UNDERLINE_FLAG;
        } else {
          this._styleFlags &= ~UNDERLINE_FLAG;
        }

        this.setVertsDirty();
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.label.underline'
    },
    _underlineHeight: 0,

    /**
     * !#en The height of underline.
     * !#zh 下划线高度。
     * @property {Number} underlineHeight
     */
    underlineHeight: {
      get: function get() {
        return this._underlineHeight;
      },
      set: function set(value) {
        if (this._underlineHeight === value) return;
        this._underlineHeight = value;
        this.setVertsDirty();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.label.underline_height'
    }
  },
  statics: {
    HorizontalAlign: HorizontalAlign,
    VerticalAlign: VerticalAlign,
    Overflow: Overflow,
    CacheMode: CacheMode,
    _shareAtlas: null,

    /**
     * !#zh 需要保证当前场景中没有使用CHAR缓存的Label才可以清除，否则已渲染的文字没有重新绘制会不显示
     * !#en It can be cleared that need to ensure there is not use the CHAR cache in the current scene. Otherwise, the rendered text will not be displayed without repainting.
     * @method clearCharCache
     * @static
     */
    clearCharCache: function clearCharCache() {
      if (Label._shareAtlas) {
        Label._shareAtlas.clearAllCache();
      }
    }
  },
  onLoad: function onLoad() {
    // For compatibility with v2.0.x temporary reservation.
    if (this._batchAsBitmap && this.cacheMode === CacheMode.NONE) {
      this.cacheMode = CacheMode.BITMAP;
      this._batchAsBitmap = false;
    }

    if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
      // CacheMode is not supported in Canvas.
      this.cacheMode = CacheMode.NONE;
    }
  },
  onEnable: function onEnable() {
    this._super(); // Keep track of Node size


    this.node.on(cc.Node.EventType.SIZE_CHANGED, this._nodeSizeChanged, this);
    this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);

    this._forceUpdateRenderData();
  },
  onDisable: function onDisable() {
    this._super();

    this.node.off(cc.Node.EventType.SIZE_CHANGED, this._nodeSizeChanged, this);
    this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);
  },
  onDestroy: function onDestroy() {
    this._assembler && this._assembler._resetAssemblerData && this._assembler._resetAssemblerData(this._assemblerData);
    this._assemblerData = null;
    this._letterTexture = null;

    if (this._ttfTexture) {
      this._ttfTexture.destroy();

      this._ttfTexture = null;
    }

    this._super();
  },
  _nodeSizeChanged: function _nodeSizeChanged() {
    // Because the content size is automatically updated when overflow is NONE.
    // And this will conflict with the alignment of the CCWidget.
    if (CC_EDITOR || this.overflow !== Overflow.NONE) {
      this.setVertsDirty();
    }
  },
  _updateColor: function _updateColor() {
    if (!(this.font instanceof cc.BitmapFont)) {
      this.setVertsDirty();
    }

    RenderComponent.prototype._updateColor.call(this);
  },
  _validateRender: function _validateRender() {
    if (!this.string) {
      this.disableRender();
      return;
    }

    if (this._materials[0]) {
      var font = this.font;

      if (font instanceof cc.BitmapFont) {
        var spriteFrame = font.spriteFrame;

        if (spriteFrame && spriteFrame.textureLoaded() && font._fntConfig) {
          return;
        }
      } else {
        return;
      }
    }

    this.disableRender();
  },
  _resetAssembler: function _resetAssembler() {
    this._frame = null;

    RenderComponent.prototype._resetAssembler.call(this);
  },
  _checkStringEmpty: function _checkStringEmpty() {
    this.markForRender(!!this.string);
  },
  _on3DNodeChanged: function _on3DNodeChanged() {
    this._resetAssembler();

    this._applyFontTexture();
  },
  _onBMFontTextureLoaded: function _onBMFontTextureLoaded() {
    this._frame._texture = this.font.spriteFrame._texture;
    this.markForRender(true);

    this._updateMaterial();

    this._assembler && this._assembler.updateRenderData(this);
  },
  _applyFontTexture: function _applyFontTexture() {
    var font = this.font;

    if (font instanceof cc.BitmapFont) {
      var spriteFrame = font.spriteFrame;
      this._frame = spriteFrame;

      if (spriteFrame) {
        spriteFrame.onTextureLoaded(this._onBMFontTextureLoaded, this);
      }
    } else {
      if (!this._frame) {
        this._frame = new LabelFrame();
      }

      if (this.cacheMode === CacheMode.CHAR) {
        this._letterTexture = this._assembler._getAssemblerData();

        this._frame._refreshTexture(this._letterTexture);
      } else if (!this._ttfTexture) {
        this._ttfTexture = new cc.Texture2D();
        this._assemblerData = this._assembler._getAssemblerData();

        this._ttfTexture.initWithElement(this._assemblerData.canvas);
      }

      if (this.cacheMode !== CacheMode.CHAR) {
        this._frame._resetDynamicAtlasFrame();

        this._frame._refreshTexture(this._ttfTexture);
      }

      this._updateMaterial();

      this._assembler && this._assembler.updateRenderData(this);
    }

    this.markForValidate();
  },
  _updateMaterialCanvas: function _updateMaterialCanvas() {
    if (!this._frame) return;
    this._frame._texture.url = this.uuid + '_texture';
  },
  _updateMaterialWebgl: function _updateMaterialWebgl() {
    if (!this._frame) return;
    var material = this.getMaterial(0);
    material && material.setProperty('texture', this._frame._texture);
  },
  _forceUpdateRenderData: function _forceUpdateRenderData() {
    this.setVertsDirty();

    this._resetAssembler();

    this._applyFontTexture();
  },

  /**
   * @deprecated `label._enableBold` is deprecated, use `label.enableBold = true` instead please.
   */
  _enableBold: function _enableBold(enabled) {
    if (CC_DEBUG) {
      cc.warn('`label._enableBold` is deprecated, use `label.enableBold = true` instead please');
    }

    this.enableBold = !!enabled;
  },

  /**
   * @deprecated `label._enableItalics` is deprecated, use `label.enableItalics = true` instead please.
   */
  _enableItalics: function _enableItalics(enabled) {
    if (CC_DEBUG) {
      cc.warn('`label._enableItalics` is deprecated, use `label.enableItalics = true` instead please');
    }

    this.enableItalic = !!enabled;
  },

  /**
   * @deprecated `label._enableUnderline` is deprecated, use `label.enableUnderline = true` instead please.
   */
  _enableUnderline: function _enableUnderline(enabled) {
    if (CC_DEBUG) {
      cc.warn('`label._enableUnderline` is deprecated, use `label.enableUnderline = true` instead please');
    }

    this.enableUnderline = !!enabled;
  }
});
cc.Label = module.exports = Label;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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