
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCCanvas.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Camera = require('../camera/CCCamera');

var Component = require('./CCComponent'); // Screen adaptation strategy for Canvas + Widget


function addWidgetComponent(canvas) {
  var widget = canvas.node.getComponent(cc.Widget);

  if (!widget) {
    widget = canvas.node.addComponent(cc.Widget);
  }

  widget.isAlignTop = true;
  widget.isAlignBottom = true;
  widget.isAlignLeft = true;
  widget.isAlignRight = true;
}
/**
 * !#zh: 作为 UI 根节点，为所有子节点提供视窗四边的位置信息以供对齐，另外提供屏幕适配策略接口，方便从编辑器设置。
 * 注：由于本节点的尺寸会跟随屏幕拉伸，所以 anchorPoint 只支持 (0.5, 0.5)，否则适配不同屏幕时坐标会有偏差。
 *
 * @class Canvas
 * @extends Component
 */


var Canvas = cc.Class({
  name: 'cc.Canvas',
  "extends": Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.ui/Canvas',
    help: 'i18n:COMPONENT.help_url.canvas',
    executeInEditMode: true,
    disallowMultiple: true
  },
  resetInEditor: CC_EDITOR && function () {
    _Scene._applyCanvasPreferences(this);

    addWidgetComponent(this);
  },
  statics: {
    /**
     * !#en Current active canvas, the scene should only have one active canvas at the same time.
     * !#zh 当前激活的画布组件，场景同一时间只能有一个激活的画布。
     * @property {Canvas} instance
     * @static
     */
    instance: null
  },
  properties: {
    /**
     * !#en The desigin resolution for current scene.
     * !#zh 当前场景设计分辨率。
     * @property {Size} designResolution
     * @default new cc.Size(960, 640)
     */
    _designResolution: cc.size(960, 640),
    designResolution: {
      get: function get() {
        return cc.size(this._designResolution);
      },
      set: function set(value) {
        this._designResolution.width = value.width;
        this._designResolution.height = value.height;
        this.applySettings();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.canvas.design_resolution'
    },
    _fitWidth: false,
    _fitHeight: true,

    /**
     * !#en TODO
     * !#zh: 是否优先将设计分辨率高度撑满视图高度。
     * @property {Boolean} fitHeight
     * @default false
     */
    fitHeight: {
      get: function get() {
        return this._fitHeight;
      },
      set: function set(value) {
        if (this._fitHeight !== value) {
          this._fitHeight = value;
          this.applySettings();
        }
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.canvas.fit_height'
    },

    /**
     * !#en TODO
     * !#zh: 是否优先将设计分辨率宽度撑满视图宽度。
     * @property {Boolean} fitWidth
     * @default false
     */
    fitWidth: {
      get: function get() {
        return this._fitWidth;
      },
      set: function set(value) {
        if (this._fitWidth !== value) {
          this._fitWidth = value;
          this.applySettings();
        }
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.canvas.fit_width'
    }
  },
  // fit canvas node to design resolution
  _fitDesignResolution: CC_EDITOR && function () {
    // TODO: support paddings of locked widget
    var designSize = cc.engine.getDesignResolutionSize();
    this.node.setPosition(designSize.width * 0.5, designSize.height * 0.5);
    this.node.setContentSize(designSize);
  },
  __preload: function __preload() {
    if (CC_DEV) {
      var Flags = cc.Object.Flags;
      this._objFlags |= Flags.IsPositionLocked | Flags.IsAnchorLocked | Flags.IsSizeLocked;
    }

    if (Canvas.instance) {
      return cc.warnID(6700, this.node.name, Canvas.instance.node.name);
    }

    Canvas.instance = this; // Align node to fit the screen

    this.applySettings(); // Stretch to matched size during the scene initialization

    var widget = this.getComponent(cc.Widget);

    if (widget) {
      widget.updateAlignment();
    } else if (CC_EDITOR) {
      this._fitDesignResolution();
    } // Constantly align canvas node in edit mode


    if (CC_EDITOR) {
      cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this._fitDesignResolution, this);
      cc.engine.on('design-resolution-changed', this._fitDesignResolution, this);
    } // Camera could be removed in canvas render mode


    var cameraNode = cc.find('Main Camera', this.node);

    if (!cameraNode) {
      cameraNode = new cc.Node('Main Camera');
      cameraNode.parent = this.node;
      cameraNode.setSiblingIndex(0);
    }

    var camera = cameraNode.getComponent(Camera);

    if (!camera) {
      camera = cameraNode.addComponent(Camera);
      var ClearFlags = Camera.ClearFlags;
      camera.clearFlags = ClearFlags.COLOR | ClearFlags.DEPTH | ClearFlags.STENCIL;
      camera.depth = -1;
    }

    Camera.main = camera;
  },
  onDestroy: function onDestroy() {
    if (CC_EDITOR) {
      cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this._fitDesignResolution, this);
      cc.engine.off('design-resolution-changed', this._fitDesignResolution, this);
    }

    if (Canvas.instance === this) {
      Canvas.instance = null;
    }
  },
  applySettings: function applySettings() {
    var ResolutionPolicy = cc.ResolutionPolicy;
    var policy;

    if (this.fitHeight && this.fitWidth) {
      policy = ResolutionPolicy.SHOW_ALL;
    } else if (!this.fitHeight && !this.fitWidth) {
      policy = ResolutionPolicy.NO_BORDER;
    } else if (this.fitWidth) {
      policy = ResolutionPolicy.FIXED_WIDTH;
    } else {
      // fitHeight
      policy = ResolutionPolicy.FIXED_HEIGHT;
    }

    var designRes = this._designResolution;

    if (CC_EDITOR) {
      cc.engine.setDesignResolutionSize(designRes.width, designRes.height);
    } else {
      cc.view.setDesignResolutionSize(designRes.width, designRes.height, policy);
    }
  }
});
cc.Canvas = module.exports = Canvas;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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