
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/components/CCAudioSource.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var misc = require('../utils/misc');

var Component = require('./CCComponent');

var AudioClip = require('../assets/CCAudioClip');
/**
 * !#en Audio Source.
 * !#zh 音频源组件，能对音频剪辑。
 * @class AudioSource
 * @extends Component
 */


var AudioSource = cc.Class({
  name: 'cc.AudioSource',
  "extends": Component,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.others/AudioSource',
    help: 'i18n:COMPONENT.help_url.audiosource'
  },
  ctor: function ctor() {
    // We can't require Audio here because jsb Audio is implemented outside the engine,
    // it can only take effect rely on overwriting cc.Audio
    this.audio = new cc.Audio();
  },
  properties: {
    _clip: {
      "default": null,
      type: AudioClip
    },
    _volume: 1,
    _mute: false,
    _loop: false,
    _pausedFlag: {
      "default": false,
      serializable: false
    },

    /**
     * !#en
     * Is the audio source playing (Read Only). <br/>
     * Note: isPlaying is not supported for Native platforms.
     * !#zh
     * 该音频剪辑是否正播放（只读）。<br/>
     * 注意：Native 平台暂时不支持 isPlaying。
     * @property isPlaying
     * @type {Boolean}
     * @readOnly
     * @default false
     */
    isPlaying: {
      get: function get() {
        var state = this.audio.getState();
        return state === cc.Audio.State.PLAYING;
      },
      visible: false
    },

    /**
     * !#en The clip of the audio source to play.
     * !#zh 要播放的音频剪辑。
     * @property clip
     * @type {AudioClip}
     * @default 1
     */
    clip: {
      get: function get() {
        return this._clip;
      },
      set: function set(value) {
        if (typeof value === 'string') {
          // backward compatibility since 1.10
          cc.warnID(8401, 'cc.AudioSource', 'cc.AudioClip', 'AudioClip', 'cc.AudioClip', 'audio');
          var self = this;

          AudioClip._loadByUrl(value, function (err, clip) {
            if (clip) {
              self.clip = clip;
            }
          });

          return;
        }

        if (value === this._clip) {
          return;
        }

        this._clip = value;
        this.audio.stop();

        if (this.preload) {
          this.audio.src = this._clip;
        }
      },
      type: AudioClip,
      tooltip: CC_DEV && 'i18n:COMPONENT.audio.clip',
      animatable: false
    },

    /**
     * !#en The volume of the audio source.
     * !#zh 音频源的音量（0.0 ~ 1.0）。
     * @property volume
     * @type {Number}
     * @default 1
     */
    volume: {
      get: function get() {
        return this._volume;
      },
      set: function set(value) {
        value = misc.clamp01(value);
        this._volume = value;

        if (!this._mute) {
          this.audio.setVolume(value);
        }

        return value;
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.audio.volume'
    },

    /**
     * !#en Is the audio source mute?
     * !#zh 是否静音音频源。Mute 是设置音量为 0，取消静音是恢复原来的音量。
     * @property mute
     * @type {Boolean}
     * @default false
     */
    mute: {
      get: function get() {
        return this._mute;
      },
      set: function set(value) {
        this._mute = value;
        this.audio.setVolume(value ? 0 : this._volume);
        return value;
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.audio.mute'
    },

    /**
     * !#en Is the audio source looping?
     * !#zh 音频源是否循环播放？
     * @property loop
     * @type {Boolean}
     * @default false
     */
    loop: {
      get: function get() {
        return this._loop;
      },
      set: function set(value) {
        this._loop = value;
        this.audio.setLoop(value);
        return value;
      },
      animatable: false,
      tooltip: CC_DEV && 'i18n:COMPONENT.audio.loop'
    },

    /**
     * !#en If set to true, the audio source will automatically start playing on onEnable.
     * !#zh 如果设置为 true，音频源将在 onEnable 时自动播放。
     * @property playOnLoad
     * @type {Boolean}
     * @default true
     */
    playOnLoad: {
      "default": false,
      tooltip: CC_DEV && 'i18n:COMPONENT.audio.play_on_load',
      animatable: false
    },
    preload: {
      "default": false,
      animatable: false
    }
  },
  _ensureDataLoaded: function _ensureDataLoaded() {
    if (this.audio.src !== this._clip) {
      this.audio.src = this._clip;
    }
  },
  _pausedCallback: function _pausedCallback() {
    var state = this.audio.getState();

    if (state === cc.Audio.State.PLAYING) {
      this.audio.pause();
      this._pausedFlag = true;
    }
  },
  _restoreCallback: function _restoreCallback() {
    if (this._pausedFlag) {
      this.audio.resume();
    }

    this._pausedFlag = false;
  },
  onLoad: function onLoad() {
    this.audio.setVolume(this._mute ? 0 : this._volume);
    this.audio.setLoop(this._loop);
  },
  onEnable: function onEnable() {
    if (this.preload) {
      this.audio.src = this._clip;
    }

    if (this.playOnLoad) {
      this.play();
    }

    cc.game.on(cc.game.EVENT_HIDE, this._pausedCallback, this);
    cc.game.on(cc.game.EVENT_SHOW, this._restoreCallback, this);
  },
  onDisable: function onDisable() {
    this.stop();
    cc.game.off(cc.game.EVENT_HIDE, this._pausedCallback, this);
    cc.game.off(cc.game.EVENT_SHOW, this._restoreCallback, this);
  },
  onDestroy: function onDestroy() {
    this.stop();
    this.audio.destroy();
    cc.audioEngine.uncache(this._clip);
  },

  /**
   * !#en Plays the clip.
   * !#zh 播放音频剪辑。
   * @method play
   */
  play: function play() {
    if (!this._clip) return;
    var audio = this.audio;

    if (this._clip.loaded) {
      audio.stop();
    }

    this._ensureDataLoaded();

    audio.setCurrentTime(0);
    audio.play();
  },

  /**
   * !#en Stops the clip.
   * !#zh 停止当前音频剪辑。
   * @method stop
   */
  stop: function stop() {
    this.audio.stop();
  },

  /**
   * !#en Pause the clip.
   * !#zh 暂停当前音频剪辑。
   * @method pause
   */
  pause: function pause() {
    this.audio.pause();
  },

  /**
   * !#en Resume the clip.
   * !#zh 恢复播放。
   * @method resume
   */
  resume: function resume() {
    this._ensureDataLoaded();

    this.audio.resume();
  },

  /**
   * !#en Rewind playing music.
   * !#zh 从头开始播放。
   * @method rewind
   */
  rewind: function rewind() {
    this.audio.setCurrentTime(0);
  },

  /**
   * !#en Get current time
   * !#zh 获取当前的播放时间
   * @method getCurrentTime
   * @return {Number}
   */
  getCurrentTime: function getCurrentTime() {
    return this.audio.getCurrentTime();
  },

  /**
   * !#en Set current time
   * !#zh 设置当前的播放时间
   * @method setCurrentTime
   * @param {Number} time
   * @return {Number}
   */
  setCurrentTime: function setCurrentTime(time) {
    this.audio.setCurrentTime(time);
    return time;
  },

  /**
   * !#en Get audio duration
   * !#zh 获取当前音频的长度
   * @method getDuration
   * @return {Number}
   */
  getDuration: function getDuration() {
    return this.audio.getDuration();
  }
});
cc.AudioSource = module.exports = AudioSource;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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