
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/collider/CCIntersection.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en Intersection helper class
 * !#zh 辅助类，用于测试形状与形状是否相交
 * @class Intersection
 * @static
 */
var Intersection = {};
/**
 * !#en Test line and line
 * !#zh 测试线段与线段是否相交
 * @method lineLine
 * @param {Vec2} a1 - The start point of the first line
 * @param {Vec2} a2 - The end point of the first line
 * @param {Vec2} b1 - The start point of the second line
 * @param {Vec2} b2 - The end point of the second line
 * @return {boolean}
 */

function lineLine(a1, a2, b1, b2) {
  // jshint camelcase:false
  var ua_t = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
  var ub_t = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
  var u_b = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);

  if (u_b !== 0) {
    var ua = ua_t / u_b;
    var ub = ub_t / u_b;

    if (0 <= ua && ua <= 1 && 0 <= ub && ub <= 1) {
      return true;
    }
  }

  return false;
}

Intersection.lineLine = lineLine;
/**
 * !#en Test line and rect
 * !#zh 测试线段与矩形是否相交
 * @method lineRect
 * @param {Vec2} a1 - The start point of the line
 * @param {Vec2} a2 - The end point of the line
 * @param {Rect} b - The rect
 * @return {boolean}
 */

function lineRect(a1, a2, b) {
  var r0 = new cc.Vec2(b.x, b.y);
  var r1 = new cc.Vec2(b.x, b.yMax);
  var r2 = new cc.Vec2(b.xMax, b.yMax);
  var r3 = new cc.Vec2(b.xMax, b.y);
  if (lineLine(a1, a2, r0, r1)) return true;
  if (lineLine(a1, a2, r1, r2)) return true;
  if (lineLine(a1, a2, r2, r3)) return true;
  if (lineLine(a1, a2, r3, r0)) return true;
  return false;
}

Intersection.lineRect = lineRect;
/**
 * !#en Test line and polygon
 * !#zh 测试线段与多边形是否相交
 * @method linePolygon
 * @param {Vec2} a1 - The start point of the line
 * @param {Vec2} a2 - The end point of the line
 * @param {Vec2[]} b - The polygon, a set of points
 * @return {boolean}
 */

function linePolygon(a1, a2, b) {
  var length = b.length;

  for (var i = 0; i < length; ++i) {
    var b1 = b[i];
    var b2 = b[(i + 1) % length];
    if (lineLine(a1, a2, b1, b2)) return true;
  }

  return false;
}

Intersection.linePolygon = linePolygon;
/**
 * !#en Test rect and rect
 * !#zh 测试矩形与矩形是否相交
 * @method rectRect
 * @param {Rect} a - The first rect
 * @param {Rect} b - The second rect
 * @return {boolean}
 */

function rectRect(a, b) {
  // jshint camelcase:false
  var a_min_x = a.x;
  var a_min_y = a.y;
  var a_max_x = a.x + a.width;
  var a_max_y = a.y + a.height;
  var b_min_x = b.x;
  var b_min_y = b.y;
  var b_max_x = b.x + b.width;
  var b_max_y = b.y + b.height;
  return a_min_x <= b_max_x && a_max_x >= b_min_x && a_min_y <= b_max_y && a_max_y >= b_min_y;
}

Intersection.rectRect = rectRect;
/**
 * !#en Test rect and polygon
 * !#zh 测试矩形与多边形是否相交
 * @method rectPolygon
 * @param {Rect} a - The rect
 * @param {Vec2[]} b - The polygon, a set of points
 * @return {boolean}
 */

function rectPolygon(a, b) {
  var i, l;
  var r0 = new cc.Vec2(a.x, a.y);
  var r1 = new cc.Vec2(a.x, a.yMax);
  var r2 = new cc.Vec2(a.xMax, a.yMax);
  var r3 = new cc.Vec2(a.xMax, a.y); // intersection check

  if (linePolygon(r0, r1, b)) return true;
  if (linePolygon(r1, r2, b)) return true;
  if (linePolygon(r2, r3, b)) return true;
  if (linePolygon(r3, r0, b)) return true; // check if a contains b

  for (i = 0, l = b.length; i < l; ++i) {
    if (pointInPolygon(b[i], a)) return true;
  } // check if b contains a


  if (pointInPolygon(r0, b)) return true;
  if (pointInPolygon(r1, b)) return true;
  if (pointInPolygon(r2, b)) return true;
  if (pointInPolygon(r3, b)) return true;
  return false;
}

Intersection.rectPolygon = rectPolygon;
/**
 * !#en Test polygon and polygon
 * !#zh 测试多边形与多边形是否相交
 * @method polygonPolygon
 * @param {Vec2[]} a - The first polygon, a set of points
 * @param {Vec2[]} b - The second polygon, a set of points
 * @return {boolean}
 */

function polygonPolygon(a, b) {
  var i, l; // check if a intersects b

  for (i = 0, l = a.length; i < l; ++i) {
    var a1 = a[i];
    var a2 = a[(i + 1) % l];
    if (linePolygon(a1, a2, b)) return true;
  } // check if a contains b


  for (i = 0, l = b.length; i < l; ++i) {
    if (pointInPolygon(b[i], a)) return true;
  } // check if b contains a


  for (i = 0, l = a.length; i < l; ++i) {
    if (pointInPolygon(a[i], b)) return true;
  }

  return false;
}

Intersection.polygonPolygon = polygonPolygon;
/**
 * !#en Test circle and circle
 * !#zh 测试圆形与圆形是否相交
 * @method circleCircle
 * @param {Object} a - Object contains position and radius
 * @param {Object} b - Object contains position and radius
 * @return {boolean}
 * @typescript circleCircle(a: {position: Vec2, radius: number}, b: {position: Vec2, radius: number}): boolean
 */

function circleCircle(a, b) {
  var distance = a.position.sub(b.position).mag();
  return distance < a.radius + b.radius;
}

Intersection.circleCircle = circleCircle;
/**
 * !#en Test polygon and circle
 * !#zh 测试矩形与圆形是否相交
 * @method polygonCircle
 * @param {Vec2[]} polygon - The Polygon, a set of points
 * @param {Object} circle - Object contains position and radius
 * @return {boolean}
 * @typescript polygonCircle(polygon: Vec2[], circle: {position: Vec2, radius: number}): boolean
 */

function polygonCircle(polygon, circle) {
  var position = circle.position;

  if (pointInPolygon(position, polygon)) {
    return true;
  }

  for (var i = 0, l = polygon.length; i < l; i++) {
    var start = i === 0 ? polygon[polygon.length - 1] : polygon[i - 1];
    var end = polygon[i];

    if (pointLineDistance(position, start, end, true) < circle.radius) {
      return true;
    }
  }

  return false;
}

Intersection.polygonCircle = polygonCircle;
/**
 * !#en Test whether the point is in the polygon
 * !#zh 测试一个点是否在一个多边形中
 * @method pointInPolygon
 * @param {Vec2} point - The point
 * @param {Vec2[]} polygon - The polygon, a set of points
 * @return {boolean}
 */

function pointInPolygon(point, polygon) {
  var inside = false;
  var x = point.x;
  var y = point.y; // use some raycasting to test hits
  // https://github.com/substack/point-in-polygon/blob/master/index.js

  var length = polygon.length;

  for (var i = 0, j = length - 1; i < length; j = i++) {
    var xi = polygon[i].x,
        yi = polygon[i].y,
        xj = polygon[j].x,
        yj = polygon[j].y,
        intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) inside = !inside;
  }

  return inside;
}

Intersection.pointInPolygon = pointInPolygon;
/**
 * !#en Calculate the distance of point to line.
 * !#zh 计算点到直线的距离。如果这是一条线段并且垂足不在线段内，则会计算点到线段端点的距离。
 * @method pointLineDistance
 * @param {Vec2} point - The point
 * @param {Vec2} start - The start point of line
 * @param {Vec2} end - The end point of line
 * @param {boolean} isSegment - whether this line is a segment
 * @return {number}
 */

function pointLineDistance(point, start, end, isSegment) {
  var dx = end.x - start.x;
  var dy = end.y - start.y;
  var d = dx * dx + dy * dy;
  var t = ((point.x - start.x) * dx + (point.y - start.y) * dy) / d;
  var p;

  if (!isSegment) {
    p = cc.v2(start.x + t * dx, start.y + t * dy);
  } else {
    if (d) {
      if (t < 0) p = start;else if (t > 1) p = end;else p = cc.v2(start.x + t * dx, start.y + t * dy);
    } else {
      p = start;
    }
  }

  dx = point.x - p.x;
  dy = point.y - p.y;
  return Math.sqrt(dx * dx + dy * dy);
}

Intersection.pointLineDistance = pointLineDistance;
cc.Intersection = module.exports = Intersection;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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