
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/camera/CCCamera.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _valueTypes = require("../value-types");

var _geomUtils = require("../geom-utils");

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var AffineTrans = require('../utils/affine-transform');

var renderer = require('../renderer/index');

var RenderFlow = require('../renderer/render-flow');

var game = require('../CCGame');

var RendererCamera = null;

if (CC_JSB && CC_NATIVERENDERER) {
  RendererCamera = window.renderer.Camera;
} else {
  RendererCamera = require('../../renderer/scene/camera');
}

var _mat4_temp_1 = cc.mat4();

var _mat4_temp_2 = cc.mat4();

var _v3_temp_1 = cc.v3();

var _v3_temp_2 = cc.v3();

var _v3_temp_3 = cc.v3();

var _cameras = [];
var _debugCamera = null;

function repositionDebugCamera() {
  if (!_debugCamera) return;

  var node = _debugCamera.getNode();

  var canvas = cc.game.canvas;
  node.z = canvas.height / 1.1566;
  node.x = canvas.width / 2;
  node.y = canvas.height / 2;
}
/**
 * !#en Values for Camera.clearFlags, determining what to clear when rendering a Camera.
 * !#zh 摄像机清除标记位，决定摄像机渲染时会清除哪些状态
 * @enum Camera.ClearFlags
 */


var ClearFlags = cc.Enum({
  /**
   * !#en
   * Clear the background color.
   * !#zh
   * 清除背景颜色
   * @property COLOR
   */
  COLOR: 1,

  /**
   * !#en
   * Clear the depth buffer.
   * !#zh
   * 清除深度缓冲区
   * @property DEPTH
   */
  DEPTH: 2,

  /**
   * !#en
   * Clear the stencil.
   * !#zh
   * 清除模板缓冲区
   * @property STENCIL
   */
  STENCIL: 4
});
var StageFlags = cc.Enum({
  OPAQUE: 1,
  TRANSPARENT: 2
});
/**
 * !#en
 * Camera is usefull when making reel game or other games which need scroll screen.
 * Using camera will be more efficient than moving node to scroll screen.
 * Camera 
 * !#zh
 * 摄像机在制作卷轴或是其他需要移动屏幕的游戏时比较有用，使用摄像机将会比移动节点来移动屏幕更加高效。
 * @class Camera
 * @extends Component
 */

var Camera = cc.Class({
  name: 'cc.Camera',
  "extends": cc.Component,
  ctor: function ctor() {
    if (game.renderType !== game.RENDER_TYPE_CANVAS) {
      var camera = new RendererCamera();
      camera.setStages(['opaque']);
      camera.dirty = true;
      this._inited = false;
      this._camera = camera;
    } else {
      this._inited = true;
    }
  },
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.others/Camera',
    inspector: 'packages://inspector/inspectors/comps/camera.js',
    executeInEditMode: true
  },
  properties: {
    _cullingMask: 0xffffffff,
    _clearFlags: ClearFlags.DEPTH | ClearFlags.STENCIL,
    _backgroundColor: cc.color(0, 0, 0, 255),
    _depth: 0,
    _zoomRatio: 1,
    _targetTexture: null,
    _fov: 60,
    _orthoSize: 10,
    _nearClip: 1,
    _farClip: 4096,
    _ortho: true,
    _rect: cc.rect(0, 0, 1, 1),
    _renderStages: 1,
    _alignWithScreen: true,

    /**
     * !#en
     * The camera zoom ratio, only support 2D camera.
     * !#zh
     * 摄像机缩放比率, 只支持 2D camera。
     * @property {Number} zoomRatio
     */
    zoomRatio: {
      get: function get() {
        return this._zoomRatio;
      },
      set: function set(value) {
        this._zoomRatio = value;
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.zoomRatio'
    },

    /**
     * !#en
     * Field of view. The width of the Camera’s view angle, measured in degrees along the local Y axis.
     * !#zh
     * 决定摄像机视角的宽度，当摄像机处于透视投影模式下这个属性才会生效。
     * @property {Number} fov
     * @default 60
     */
    fov: {
      get: function get() {
        return this._fov;
      },
      set: function set(v) {
        this._fov = v;
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.fov'
    },

    /**
     * !#en
     * The viewport size of the Camera when set to orthographic projection.
     * !#zh
     * 摄像机在正交投影模式下的视窗大小。
     * @property {Number} orthoSize
     * @default 10
     */
    orthoSize: {
      get: function get() {
        return this._orthoSize;
      },
      set: function set(v) {
        this._orthoSize = v;
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.orthoSize'
    },

    /**
     * !#en
     * The near clipping plane.
     * !#zh
     * 摄像机的近剪裁面。
     * @property {Number} nearClip
     * @default 0.1
     */
    nearClip: {
      get: function get() {
        return this._nearClip;
      },
      set: function set(v) {
        this._nearClip = v;

        this._updateClippingpPlanes();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.nearClip'
    },

    /**
     * !#en
     * The far clipping plane.
     * !#zh
     * 摄像机的远剪裁面。
     * @property {Number} farClip
     * @default 4096
     */
    farClip: {
      get: function get() {
        return this._farClip;
      },
      set: function set(v) {
        this._farClip = v;

        this._updateClippingpPlanes();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.farClip'
    },

    /**
     * !#en
     * Is the camera orthographic (true) or perspective (false)?
     * !#zh
     * 设置摄像机的投影模式是正交还是透视模式。
     * @property {Boolean} ortho
     * @default false
     */
    ortho: {
      get: function get() {
        return this._ortho;
      },
      set: function set(v) {
        this._ortho = v;

        this._updateProjection();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.ortho'
    },

    /**
     * !#en
     * Four values (0 ~ 1) that indicate where on the screen this camera view will be drawn.
     * !#zh
     * 决定摄像机绘制在屏幕上哪个位置，值为（0 ~ 1）。
     * @property {Rect} rect
     * @default cc.rect(0,0,1,1)
     */
    rect: {
      get: function get() {
        return this._rect;
      },
      set: function set(v) {
        this._rect = v;

        this._updateRect();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.rect'
    },

    /**
     * !#en
     * This is used to render parts of the scene selectively.
     * !#zh
     * 决定摄像机会渲染场景的哪一部分。
     * @property {Number} cullingMask
     */
    cullingMask: {
      get: function get() {
        return this._cullingMask;
      },
      set: function set(value) {
        this._cullingMask = value;

        this._updateCameraMask();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.cullingMask'
    },

    /**
     * !#en
     * Determining what to clear when camera rendering.
     * !#zh
     * 决定摄像机渲染时会清除哪些状态。
     * @property {Camera.ClearFlags} clearFlags
     */
    clearFlags: {
      get: function get() {
        return this._clearFlags;
      },
      set: function set(value) {
        this._clearFlags = value;

        if (this._camera) {
          this._camera.setClearFlags(value);
        }
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.clearFlags'
    },

    /**
     * !#en
     * The color with which the screen will be cleared.
     * !#zh
     * 摄像机用于清除屏幕的背景色。
     * @property {Color} backgroundColor
     */
    backgroundColor: {
      get: function get() {
        return this._backgroundColor;
      },
      set: function set(value) {
        if (!this._backgroundColor.equals(value)) {
          this._backgroundColor.set(value);

          this._updateBackgroundColor();
        }
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.backgroundColor'
    },

    /**
     * !#en
     * Camera's depth in the camera rendering order.
     * !#zh
     * 摄像机深度，用于决定摄像机的渲染顺序。
     * @property {Number} depth
     */
    depth: {
      get: function get() {
        return this._depth;
      },
      set: function set(value) {
        this._depth = value;

        if (this._camera) {
          this._camera.setPriority(value);
        }
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.depth'
    },

    /**
     * !#en
     * Destination render texture.
     * Usually cameras render directly to screen, but for some effects it is useful to make a camera render into a texture.
     * !#zh
     * 摄像机渲染的目标 RenderTexture。
     * 一般摄像机会直接渲染到屏幕上，但是有一些效果可以使用摄像机渲染到 RenderTexture 上再对 RenderTexture 进行处理来实现。
     * @property {RenderTexture} targetTexture
     */
    targetTexture: {
      get: function get() {
        return this._targetTexture;
      },
      set: function set(value) {
        this._targetTexture = value;

        this._updateTargetTexture();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.targetTexture'
    },

    /**
     * !#en
     * Sets the camera's render stages.
     * !#zh
     * 设置摄像机渲染的阶段
     * @property {Number} renderStages
     */
    renderStages: {
      get: function get() {
        return this._renderStages;
      },
      set: function set(val) {
        this._renderStages = val;

        this._updateStages();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.camera.renderStages'
    },

    /**
     * !#en Whether auto align camera viewport to screen
     * !#zh 是否自动将摄像机的视口对准屏幕
     * @property {Boolean} alignWithScreen
     */
    alignWithScreen: {
      get: function get() {
        return this._alignWithScreen;
      },
      set: function set(v) {
        this._alignWithScreen = v;
      }
    },
    _is3D: {
      get: function get() {
        return this.node && this.node._is3DNode;
      }
    }
  },
  statics: {
    /**
     * !#en
     * The first enabled camera.
     * !#zh
     * 第一个被激活的摄像机。
     * @property {Camera} main
     * @static
     */
    main: null,

    /**
     * !#en
     * All enabled cameras.
     * !#zh
     * 激活的所有摄像机。
     * @property {[Camera]} cameras
     * @static
     */
    cameras: _cameras,
    ClearFlags: ClearFlags,

    /**
     * !#en
     * Get the first camera which the node belong to.
     * !#zh
     * 获取节点所在的第一个摄像机。
     * @method findCamera
     * @param {Node} node 
     * @return {Camera}
     * @static
     */
    findCamera: function findCamera(node) {
      for (var i = 0, l = _cameras.length; i < l; i++) {
        var camera = _cameras[i];

        if (camera.containsNode(node)) {
          return camera;
        }
      }

      return null;
    },
    _findRendererCamera: function _findRendererCamera(node) {
      var cameras = renderer.scene._cameras;

      for (var i = 0; i < cameras._count; i++) {
        if (cameras._data[i]._cullingMask & node._cullingMask) {
          return cameras._data[i];
        }
      }

      return null;
    },
    _setupDebugCamera: function _setupDebugCamera() {
      if (_debugCamera) return;
      if (game.renderType === game.RENDER_TYPE_CANVAS) return;
      var camera = new RendererCamera();
      _debugCamera = camera;
      camera.setStages(['opaque']);
      camera.setFov(Math.PI * 60 / 180);
      camera.setNear(0.1);
      camera.setFar(4096);
      camera.dirty = true;
      camera.cullingMask = 1 << cc.Node.BuiltinGroupIndex.DEBUG;
      camera.setPriority(cc.macro.MAX_ZINDEX);
      camera.setClearFlags(0);
      camera.setColor(0, 0, 0, 0);
      var node = new cc.Node();
      camera.setNode(node);
      repositionDebugCamera();
      cc.view.on('design-resolution-changed', repositionDebugCamera);
      renderer.scene.addCamera(camera);
    }
  },
  _updateCameraMask: function _updateCameraMask() {
    if (this._camera) {
      var mask = this._cullingMask & ~(1 << cc.Node.BuiltinGroupIndex.DEBUG);
      this._camera.cullingMask = mask;
    }
  },
  _updateBackgroundColor: function _updateBackgroundColor() {
    if (!this._camera) return;
    var color = this._backgroundColor;

    this._camera.setColor(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
  },
  _updateTargetTexture: function _updateTargetTexture() {
    if (!this._camera) return;
    var texture = this._targetTexture;

    this._camera.setFrameBuffer(texture ? texture._framebuffer : null);
  },
  _updateClippingpPlanes: function _updateClippingpPlanes() {
    if (!this._camera) return;

    this._camera.setNear(this._nearClip);

    this._camera.setFar(this._farClip);
  },
  _updateProjection: function _updateProjection() {
    if (!this._camera) return;
    var type = this._ortho ? 1 : 0;

    this._camera.setType(type);
  },
  _updateRect: function _updateRect() {
    if (!this._camera) return;
    var rect = this._rect;

    this._camera.setRect(rect.x, rect.y, rect.width, rect.height);
  },
  _updateStages: function _updateStages() {
    var flags = this._renderStages;
    var stages = [];

    if (flags & StageFlags.OPAQUE) {
      stages.push('opaque');
    }

    if (flags & StageFlags.TRANSPARENT) {
      stages.push('transparent');
    }

    this._camera.setStages(stages);
  },
  _init: function _init() {
    if (this._inited) return;
    this._inited = true;
    var camera = this._camera;
    if (!camera) return;
    camera.setNode(this.node);
    camera.setClearFlags(this._clearFlags);
    camera.setPriority(this._depth);

    this._updateBackgroundColor();

    this._updateCameraMask();

    this._updateTargetTexture();

    this._updateClippingpPlanes();

    this._updateProjection();

    this._updateStages();

    this._updateRect();

    this.beforeDraw();
  },
  onLoad: function onLoad() {
    this._init();
  },
  onEnable: function onEnable() {
    if (!CC_EDITOR && game.renderType !== game.RENDER_TYPE_CANVAS) {
      cc.director.on(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
      renderer.scene.addCamera(this._camera);
    }

    _cameras.push(this);
  },
  onDisable: function onDisable() {
    if (!CC_EDITOR && game.renderType !== game.RENDER_TYPE_CANVAS) {
      cc.director.off(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
      renderer.scene.removeCamera(this._camera);
    }

    cc.js.array.remove(_cameras, this);
  },

  /**
   * !#en
   * Get the screen to world matrix, only support 2D camera which alignWithScreen is true.
   * !#zh
   * 获取屏幕坐标系到世界坐标系的矩阵，只适用于 alignWithScreen 为 true 的 2D 摄像机。
   * @method getScreenToWorldMatrix2D
   * @param {Mat4} out - the matrix to receive the result
   * @return {Mat4} out
   */
  getScreenToWorldMatrix2D: function getScreenToWorldMatrix2D(out) {
    this.getWorldToScreenMatrix2D(out);

    _valueTypes.Mat4.invert(out, out);

    return out;
  },

  /**
   * !#en
   * Get the world to camera matrix, only support 2D camera which alignWithScreen is true.
   * !#zh
   * 获取世界坐标系到摄像机坐标系的矩阵，只适用于 alignWithScreen 为 true 的 2D 摄像机。
   * @method getWorldToScreenMatrix2D
   * @param {Mat4} out - the matrix to receive the result
   * @return {Mat4} out
   */
  getWorldToScreenMatrix2D: function getWorldToScreenMatrix2D(out) {
    this.node.getWorldRT(_mat4_temp_1);
    var zoomRatio = this.zoomRatio;
    var _mat4_temp_1m = _mat4_temp_1.m;
    _mat4_temp_1m[0] *= zoomRatio;
    _mat4_temp_1m[1] *= zoomRatio;
    _mat4_temp_1m[4] *= zoomRatio;
    _mat4_temp_1m[5] *= zoomRatio;
    var m12 = _mat4_temp_1m[12];
    var m13 = _mat4_temp_1m[13];
    var center = cc.visibleRect.center;
    _mat4_temp_1m[12] = center.x - (_mat4_temp_1m[0] * m12 + _mat4_temp_1m[4] * m13);
    _mat4_temp_1m[13] = center.y - (_mat4_temp_1m[1] * m12 + _mat4_temp_1m[5] * m13);

    if (out !== _mat4_temp_1) {
      _valueTypes.Mat4.copy(out, _mat4_temp_1);
    }

    return out;
  },

  /**
   * !#en
   * Convert point from screen to world.
   * !#zh
   * 将坐标从屏幕坐标系转换到世界坐标系。
   * @method getScreenToWorldPoint
   * @param {Vec3|Vec2} screenPosition 
   * @param {Vec3|Vec2} [out] 
   * @return {Vec3|Vec2} out
   */
  getScreenToWorldPoint: function getScreenToWorldPoint(screenPosition, out) {
    if (this.node.is3DNode) {
      out = out || new cc.Vec3();

      this._camera.screenToWorld(out, screenPosition, cc.visibleRect.width, cc.visibleRect.height);
    } else {
      out = out || new cc.Vec2();
      this.getScreenToWorldMatrix2D(_mat4_temp_1);

      _valueTypes.Vec2.transformMat4(out, screenPosition, _mat4_temp_1);
    }

    return out;
  },

  /**
   * !#en
   * Convert point from world to screen.
   * !#zh
   * 将坐标从世界坐标系转化到屏幕坐标系。
   * @method getWorldToScreenPoint
   * @param {Vec3|Vec2} worldPosition 
   * @param {Vec3|Vec2} [out] 
   * @return {Vec3|Vec2} out
   */
  getWorldToScreenPoint: function getWorldToScreenPoint(worldPosition, out) {
    if (this.node.is3DNode) {
      out = out || new cc.Vec3();

      this._camera.worldToScreen(out, worldPosition, cc.visibleRect.width, cc.visibleRect.height);
    } else {
      out = out || new cc.Vec2();
      this.getWorldToScreenMatrix2D(_mat4_temp_1);

      _valueTypes.Vec2.transformMat4(out, worldPosition, _mat4_temp_1);
    }

    return out;
  },

  /**
   * !#en
   * Get a ray from screen position
   * !#zh
   * 从屏幕坐标获取一条射线
   * @method getRay
   * @param {Vec2} screenPos
   * @return {Ray}
   */
  getRay: function getRay(screenPos) {
    if (!cc.geomUtils) return screenPos;

    _valueTypes.Vec3.set(_v3_temp_3, screenPos.x, screenPos.y, 1);

    this._camera.screenToWorld(_v3_temp_2, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);

    if (this.ortho) {
      _valueTypes.Vec3.set(_v3_temp_3, screenPos.x, screenPos.y, -1);

      this._camera.screenToWorld(_v3_temp_1, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
    } else {
      this.node.getWorldPosition(_v3_temp_1);
    }

    return _geomUtils.Ray.fromPoints(new _geomUtils.Ray(), _v3_temp_1, _v3_temp_2);
  },

  /**
   * !#en
   * Check whether the node is in the camera.
   * !#zh
   * 检测节点是否被此摄像机影响
   * @method containsNode
   * @param {Node} node - the node which need to check
   * @return {Boolean}
   */
  containsNode: function containsNode(node) {
    return node._cullingMask & this.cullingMask;
  },

  /**
   * !#en
   * Render the camera manually.
   * !#zh
   * 手动渲染摄像机。
   * @method render
   * @param {Node} root 
   */
  render: function render(root) {
    root = root || cc.director.getScene();
    if (!root) return null; // force update node world matrix

    this.node.getWorldMatrix(_mat4_temp_1);
    this.beforeDraw();
    RenderFlow.render(root);

    if (!CC_JSB) {
      renderer._forward.renderCamera(this._camera, renderer.scene);
    }
  },
  _onAlignWithScreen: function _onAlignWithScreen() {
    var height = cc.game.canvas.height / cc.view._scaleY;
    var targetTexture = this._targetTexture;

    if (targetTexture) {
      if (CC_EDITOR) {
        height = cc.engine.getDesignResolutionSize().height;
      } else {
        height = cc.visibleRect.height;
      }
    }

    var fov = this._fov * cc.macro.RAD;
    this.node.z = height / (Math.tan(fov / 2) * 2);
    fov = Math.atan(Math.tan(fov / 2) / this.zoomRatio) * 2;

    this._camera.setFov(fov);

    this._camera.setOrthoHeight(height / 2 / this.zoomRatio);

    this.node.setRotation(0, 0, 0, 1);
  },
  beforeDraw: function beforeDraw() {
    if (!this._camera) return;

    if (this._alignWithScreen) {
      this._onAlignWithScreen();
    } else {
      var fov = this._fov * cc.macro.RAD;
      fov = Math.atan(Math.tan(fov / 2) / this.zoomRatio) * 2;

      this._camera.setFov(fov);

      this._camera.setOrthoHeight(this._orthoSize / this.zoomRatio);
    }

    this._camera.dirty = true;
  }
}); // deprecated

cc.js.mixin(Camera.prototype, {
  /**
   * !#en
   * Returns the matrix that transform the node's (local) space coordinates into the camera's space coordinates.
   * !#zh
   * 返回一个将节点坐标系转换到摄像机坐标系下的矩阵
   * @method getNodeToCameraTransform
   * @deprecated since v2.0.0
   * @param {Node} node - the node which should transform
   * @return {AffineTransform}
   */
  getNodeToCameraTransform: function getNodeToCameraTransform(node) {
    var out = AffineTrans.identity();
    node.getWorldMatrix(_mat4_temp_2);

    if (this.containsNode(node)) {
      this.getWorldToCameraMatrix(_mat4_temp_1);

      _valueTypes.Mat4.mul(_mat4_temp_2, _mat4_temp_2, _mat4_temp_1);
    }

    AffineTrans.fromMat4(out, _mat4_temp_2);
    return out;
  },

  /**
   * !#en
   * Conver a camera coordinates point to world coordinates.
   * !#zh
   * 将一个摄像机坐标系下的点转换到世界坐标系下。
   * @method getCameraToWorldPoint
   * @deprecated since v2.1.3
   * @param {Vec2} point - the point which should transform
   * @param {Vec2} [out] - the point to receive the result
   * @return {Vec2} out
   */
  getCameraToWorldPoint: function getCameraToWorldPoint(point, out) {
    return this.getScreenToWorldPoint(point, out);
  },

  /**
   * !#en
   * Conver a world coordinates point to camera coordinates.
   * !#zh
   * 将一个世界坐标系下的点转换到摄像机坐标系下。
   * @method getWorldToCameraPoint
   * @deprecated since v2.1.3
   * @param {Vec2} point 
   * @param {Vec2} [out] - the point to receive the result
   * @return {Vec2} out
   */
  getWorldToCameraPoint: function getWorldToCameraPoint(point, out) {
    return this.getWorldToScreenPoint(point, out);
  },

  /**
   * !#en
   * Get the camera to world matrix
   * !#zh
   * 获取摄像机坐标系到世界坐标系的矩阵
   * @method getCameraToWorldMatrix
   * @deprecated since v2.1.3
   * @param {Mat4} out - the matrix to receive the result
   * @return {Mat4} out
   */
  getCameraToWorldMatrix: function getCameraToWorldMatrix(out) {
    return this.getScreenToWorldMatrix2D(out);
  },

  /**
   * !#en
   * Get the world to camera matrix
   * !#zh
   * 获取世界坐标系到摄像机坐标系的矩阵
   * @method getWorldToCameraMatrix
   * @deprecated since v2.1.3
   * @param {Mat4} out - the matrix to receive the result
   * @return {Mat4} out
   */
  getWorldToCameraMatrix: function getWorldToCameraMatrix(out) {
    return this.getWorldToScreenMatrix2D(out);
  }
});
module.exports = cc.Camera = Camera;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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