
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/material/material-variant.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _CCMaterial = _interopRequireDefault(require("./CCMaterial"));

var _effectVariant = _interopRequireDefault(require("./effect-variant"));

var _materialPool = _interopRequireDefault(require("./material-pool"));

var _dec, _class, _temp;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var ccclass = cc._decorator.ccclass;
/**
 * !#en
 * Material Variant is an extension of the Material Asset.
 * Changes to Material Variant do not affect other Material Variant or Material Asset, 
 * and changes to Material Asset are synchronized to the Material Variant.
 * However, when a Material Variant had already modifies a state, the Material Asset state is not synchronized to the Material Variant.
 * !#zh 
 * 材质变体是材质资源的一个延伸。
 * 材质变体的修改不会影响到其他的材质变体或者材质资源，而材质资源的修改会同步体现到材质变体上，
 * 但是当材质变体对一个状态修改后，材质资源再对这个状态修改是不会同步到材质变体上的。
 * @class MaterialVariant
 * @extends Material
 */

var MaterialVariant = (_dec = ccclass('cc.MaterialVariant'), _dec(_class = (_temp =
/*#__PURE__*/
function (_Material) {
  _inheritsLoose(MaterialVariant, _Material);

  /**
   * @method createWithBuiltin
   * @param {Material.BUILTIN_NAME} materialName 
   * @param {RenderComponent} [owner] 
   * @typescript
   * static createWithBuiltin (materialName, owner: cc.RenderComponent): MaterialVariant | null
   */
  MaterialVariant.createWithBuiltin = function createWithBuiltin(materialName, owner) {
    return MaterialVariant.create(_CCMaterial["default"].getBuiltinMaterial(materialName), owner);
  }
  /**
   * @method create
   * @param {Material} material 
   * @param {RenderComponent} [owner] 
   * @typescript
   * static create (material: Material, owner: cc.RenderComponent): MaterialVariant | null
   */
  ;

  MaterialVariant.create = function create(material, owner) {
    if (!material) return null;
    return _materialPool["default"].get(material, owner);
  };

  _createClass(MaterialVariant, [{
    key: "uuid",
    get: function get() {
      return this._material.uuid;
    }
  }, {
    key: "owner",
    get: function get() {
      return this._owner;
    }
  }, {
    key: "material",
    get: function get() {
      return this._material;
    }
  }]);

  function MaterialVariant(material) {
    var _this;

    _this = _Material.call(this) || this;
    _this._owner = null;
    _this._material = null;

    _this.init(material);

    return _this;
  }

  var _proto = MaterialVariant.prototype;

  _proto.init = function init(material) {
    this._effect = new _effectVariant["default"](material.effect);
    this._effectAsset = material._effectAsset;
    this._material = material;
  };

  return MaterialVariant;
}(_CCMaterial["default"]), _temp)) || _class);
exports["default"] = MaterialVariant;
cc.MaterialVariant = MaterialVariant;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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