
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/material/CCMaterial.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Asset = require('../CCAsset');

var Texture = require('../CCTexture2D');

var PixelFormat = Texture.PixelFormat;

var EffectAsset = require('./CCEffectAsset');

var textureUtil = require('../../utils/texture-util');

var gfx = cc.gfx;
/**
 * !#en Material builtin name
 * !#zh 内置材质名字
 * @enum Material.BUILTIN_NAME
 */

var BUILTIN_NAME = cc.Enum({
  /**
   * @property SPRITE
   * @readonly
   * @type {String}
   */
  SPRITE: '2d-sprite',

  /**
   * @property GRAY_SPRITE
   * @readonly
   * @type {String}
   */
  GRAY_SPRITE: '2d-gray-sprite',

  /**
   * @property UNLIT
   * @readonly
   * @type {String}
   */
  UNLIT: 'unlit'
});
/**
 * !#en Material Asset.
 * !#zh 材质资源类。
 * @class Material
 * @extends Asset
 */

var Material = cc.Class({
  name: 'cc.Material',
  "extends": Asset,
  ctor: function ctor() {
    this._manualHash = false;
    this._dirty = true;
    this._effect = null;
  },
  properties: {
    // deprecated
    _defines: {
      "default": undefined,
      type: Object
    },
    // deprecated
    _props: {
      "default": undefined,
      type: Object
    },
    _effectAsset: {
      type: EffectAsset,
      "default": null
    },
    _techniqueIndex: 0,
    _techniqueData: Object,
    effectName: CC_EDITOR ? {
      get: function get() {
        return this._effectAsset && this._effectAsset.name;
      },
      set: function set(val) {
        var effectAsset = cc.AssetLibrary.getBuiltin('effect', val);

        if (!effectAsset) {
          Editor.warn("no effect named '" + val + "' found");
          return;
        }

        this.effectAsset = effectAsset;
      }
    } : undefined,
    effectAsset: {
      get: function get() {
        return this._effectAsset;
      },
      set: function set(asset) {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
          return;
        }

        this._effectAsset = asset;

        if (!asset) {
          cc.error('Can not set an empty effect asset.');
          return;
        }

        this._effect = this._effectAsset.getInstantiatedEffect();
      }
    },
    effect: {
      get: function get() {
        return this._effect;
      }
    },
    techniqueIndex: {
      get: function get() {
        return this._techniqueIndex;
      },
      set: function set(v) {
        this._techniqueIndex = v;

        this._effect.switchTechnique(v);
      }
    }
  },
  statics: {
    getBuiltinMaterial: function getBuiltinMaterial(name) {
      if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
        return new cc.Material();
      }

      return cc.AssetLibrary.getBuiltin('material', 'builtin-' + name);
    },
    BUILTIN_NAME: BUILTIN_NAME,

    /**
     * !#en Creates a Material with builtin Effect.
     * !#zh 使用内建 Effect 创建一个材质。
     * @static
     * @method createWithBuiltin
     * @param {string} effectName 
     * @param {number} [techniqueIndex] 
     * @return {Material}
     */
    createWithBuiltin: function createWithBuiltin(effectName, techniqueIndex) {
      if (techniqueIndex === void 0) {
        techniqueIndex = 0;
      }

      var effectAsset = cc.AssetLibrary.getBuiltin('effect', 'builtin-' + effectName);
      return Material.create(effectAsset, techniqueIndex);
    },

    /**
     * !#en Creates a Material.
     * !#zh 创建一个材质。
     * @static
     * @method create
     * @param {EffectAsset} effectAsset 
     * @param {number} [techniqueIndex] 
     * @return {Material}
     */
    create: function create(effectAsset, techniqueIndex) {
      if (techniqueIndex === void 0) {
        techniqueIndex = 0;
      }

      if (!effectAsset) return null;
      var material = new Material();
      material.effectAsset = effectAsset;
      material.techniqueIndex = techniqueIndex;
      return material;
    }
  },

  /**
   * !#en Sets the Material property
   * !#zh 是指材质的属性
   * @method setProperty
   * @param {string} name
   * @param {Object} val
   * @param {number} [passIdx]
   * @param {boolean} [directly]
   */
  setProperty: function setProperty(name, val, passIdx, directly) {
    if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;

    if (typeof passIdx === 'string') {
      passIdx = parseInt(passIdx);
    }

    if (val instanceof Texture) {
      var loaded = function loaded() {
        this._effect.setProperty(name, val, passIdx);
      };

      var format = val.getPixelFormat();
      var value = format === PixelFormat.RGBA_ETC1 || format === PixelFormat.RGB_A_PVRTC_4BPPV1 || format === PixelFormat.RGB_A_PVRTC_2BPPV1;
      var key = 'CC_USE_ALPHA_ATLAS_' + name;
      var def = this.getDefine(key, passIdx);

      if (value || def) {
        this.define(key, value);
      }

      if (!val.loaded) {
        val.once('load', loaded, this);
        textureUtil.postLoadTexture(val);
        return;
      }
    }

    this._effect.setProperty(name, val, passIdx, directly);
  },

  /**
   * !#en Gets the Material property.
   * !#zh 获取材质的属性。
   * @method getProperty
   * @param {string} name 
   * @param {number} passIdx 
   */
  getProperty: function getProperty(name, passIdx) {
    if (typeof passIdx === 'string') {
      passIdx = parseInt(passIdx);
    }

    return this._effect.getProperty(name, passIdx);
  },

  /**
   * !#en Sets the Material define.
   * !#zh 设置材质的宏定义。
   * @method define
   * @param {string} name
   * @param {boolean|number} val
   * @param {number} [passIdx]
   * @param {boolean} [force]
   */
  define: function define(name, val, passIdx, force) {
    if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;

    if (typeof passIdx === 'string') {
      passIdx = parseInt(passIdx);
    }

    this._effect.define(name, val, passIdx, force);
  },

  /**
   * !#en Gets the Material define.
   * !#zh 获取材质的宏定义。
   * @method getDefine
   * @param {string} name 
   * @param {number} [passIdx] 
   * @return {boolean|number}
   */
  getDefine: function getDefine(name, passIdx) {
    if (typeof passIdx === 'string') {
      passIdx = parseInt(passIdx);
    }

    return this._effect.getDefine(name, passIdx);
  },

  /**
   * !#en Sets the Material cull mode.
   * !#zh 设置材质的裁减模式。
   * @method setCullMode
   * @param {number} cullMode 
   * @param {number} passIdx 
   */
  setCullMode: function setCullMode(cullMode, passIdx) {
    if (cullMode === void 0) {
      cullMode = gfx.CULL_BACK;
    }

    this._effect.setCullMode(cullMode, passIdx);
  },

  /**
   * !#en Sets the Material depth states.
   * !#zh 设置材质的深度渲染状态。
   * @method setDepth
   * @param {boolean} depthTest 
   * @param {boolean} depthWrite 
   * @param {number} depthFunc 
   * @param {number} passIdx 
   */
  setDepth: function setDepth(depthTest, depthWrite, depthFunc, passIdx) {
    if (depthTest === void 0) {
      depthTest = false;
    }

    if (depthWrite === void 0) {
      depthWrite = false;
    }

    if (depthFunc === void 0) {
      depthFunc = gfx.DS_FUNC_LESS;
    }

    this._effect.setDepth(depthTest, depthWrite, depthFunc, passIdx);
  },

  /**
   * !#en Sets the Material blend states.
   * !#zh 设置材质的混合渲染状态。
   * @method setBlend
   * @param {number} enabled 
   * @param {number} blendEq 
   * @param {number} blendSrc 
   * @param {number} blendDst 
   * @param {number} blendAlphaEq 
   * @param {number} blendSrcAlpha 
   * @param {number} blendDstAlpha 
   * @param {number} blendColor 
   * @param {number} passIdx 
   */
  setBlend: function setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor, passIdx) {
    if (enabled === void 0) {
      enabled = false;
    }

    if (blendEq === void 0) {
      blendEq = gfx.BLEND_FUNC_ADD;
    }

    if (blendSrc === void 0) {
      blendSrc = gfx.BLEND_SRC_ALPHA;
    }

    if (blendDst === void 0) {
      blendDst = gfx.BLEND_ONE_MINUS_SRC_ALPHA;
    }

    if (blendAlphaEq === void 0) {
      blendAlphaEq = gfx.BLEND_FUNC_ADD;
    }

    if (blendSrcAlpha === void 0) {
      blendSrcAlpha = gfx.BLEND_SRC_ALPHA;
    }

    if (blendDstAlpha === void 0) {
      blendDstAlpha = gfx.BLEND_ONE_MINUS_SRC_ALPHA;
    }

    if (blendColor === void 0) {
      blendColor = 0xffffffff;
    }

    this._effect.setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor, passIdx);
  },

  /**
   * !#en Sets whether enable the stencil test.
   * !#zh 设置是否开启模板测试。
   * @method setStencilEnabled
   * @param {number} stencilTest 
   * @param {number} passIdx 
   */
  setStencilEnabled: function setStencilEnabled(stencilTest, passIdx) {
    if (stencilTest === void 0) {
      stencilTest = gfx.STENCIL_INHERIT;
    }

    this._effect.setStencilEnabled(stencilTest, passIdx);
  },

  /**
   * !#en Sets the Material stencil render states.
   * !#zh 设置材质的模板测试渲染参数。
   * @method setStencil
   * @param {number} stencilTest 
   * @param {number} stencilFunc 
   * @param {number} stencilRef 
   * @param {number} stencilMask 
   * @param {number} stencilFailOp 
   * @param {number} stencilZFailOp 
   * @param {number} stencilZPassOp 
   * @param {number} stencilWriteMask 
   * @param {number} passIdx 
   */
  setStencil: function setStencil(stencilTest, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask, passIdx) {
    if (stencilTest === void 0) {
      stencilTest = gfx.STENCIL_INHERIT;
    }

    if (stencilFunc === void 0) {
      stencilFunc = gfx.DS_FUNC_ALWAYS;
    }

    if (stencilRef === void 0) {
      stencilRef = 0;
    }

    if (stencilMask === void 0) {
      stencilMask = 0xff;
    }

    if (stencilFailOp === void 0) {
      stencilFailOp = gfx.STENCIL_OP_KEEP;
    }

    if (stencilZFailOp === void 0) {
      stencilZFailOp = gfx.STENCIL_OP_KEEP;
    }

    if (stencilZPassOp === void 0) {
      stencilZPassOp = gfx.STENCIL_OP_KEEP;
    }

    if (stencilWriteMask === void 0) {
      stencilWriteMask = 0xff;
    }

    this._effect.setStencil(stencilTest, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask, passIdx);
  },
  updateHash: function updateHash(hash) {
    this._manualHash = hash;
    this._effect && this._effect.updateHash(hash);
  },
  getHash: function getHash() {
    return this._manualHash || this._effect && this._effect.getHash();
  },
  onLoad: function onLoad() {
    this.effectAsset = this._effectAsset;
    if (!this._effect) return;

    if (this._techniqueIndex) {
      this._effect.switchTechnique(this._techniqueIndex);
    }

    this._techniqueData = this._techniqueData || {};
    var passDatas = this._techniqueData;

    for (var index in passDatas) {
      index = parseInt(index);
      var passData = passDatas[index];
      if (!passData) continue;

      for (var def in passData.defines) {
        this.define(def, passData.defines[def], index);
      }

      for (var prop in passData.props) {
        this.setProperty(prop, passData.props[prop], index);
      }
    }
  }
});
var _default = Material;
exports["default"] = _default;
cc.Material = Material;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL2Fzc2V0cy9tYXRlcmlhbC9DQ01hdGVyaWFsLmpzIl0sIm5hbWVzIjpbIkFzc2V0IiwicmVxdWlyZSIsIlRleHR1cmUiLCJQaXhlbEZvcm1hdCIsIkVmZmVjdEFzc2V0IiwidGV4dHVyZVV0aWwiLCJnZngiLCJjYyIsIkJVSUxUSU5fTkFNRSIsIkVudW0iLCJTUFJJVEUiLCJHUkFZX1NQUklURSIsIlVOTElUIiwiTWF0ZXJpYWwiLCJDbGFzcyIsIm5hbWUiLCJjdG9yIiwiX21hbnVhbEhhc2giLCJfZGlydHkiLCJfZWZmZWN0IiwicHJvcGVydGllcyIsIl9kZWZpbmVzIiwidW5kZWZpbmVkIiwidHlwZSIsIk9iamVjdCIsIl9wcm9wcyIsIl9lZmZlY3RBc3NldCIsIl90ZWNobmlxdWVJbmRleCIsIl90ZWNobmlxdWVEYXRhIiwiZWZmZWN0TmFtZSIsIkNDX0VESVRPUiIsImdldCIsInNldCIsInZhbCIsImVmZmVjdEFzc2V0IiwiQXNzZXRMaWJyYXJ5IiwiZ2V0QnVpbHRpbiIsIkVkaXRvciIsIndhcm4iLCJhc3NldCIsImdhbWUiLCJyZW5kZXJUeXBlIiwiUkVOREVSX1RZUEVfQ0FOVkFTIiwiZXJyb3IiLCJnZXRJbnN0YW50aWF0ZWRFZmZlY3QiLCJlZmZlY3QiLCJ0ZWNobmlxdWVJbmRleCIsInYiLCJzd2l0Y2hUZWNobmlxdWUiLCJzdGF0aWNzIiwiZ2V0QnVpbHRpbk1hdGVyaWFsIiwiY3JlYXRlV2l0aEJ1aWx0aW4iLCJjcmVhdGUiLCJtYXRlcmlhbCIsInNldFByb3BlcnR5IiwicGFzc0lkeCIsImRpcmVjdGx5IiwicGFyc2VJbnQiLCJsb2FkZWQiLCJmb3JtYXQiLCJnZXRQaXhlbEZvcm1hdCIsInZhbHVlIiwiUkdCQV9FVEMxIiwiUkdCX0FfUFZSVENfNEJQUFYxIiwiUkdCX0FfUFZSVENfMkJQUFYxIiwia2V5IiwiZGVmIiwiZ2V0RGVmaW5lIiwiZGVmaW5lIiwib25jZSIsInBvc3RMb2FkVGV4dHVyZSIsImdldFByb3BlcnR5IiwiZm9yY2UiLCJzZXRDdWxsTW9kZSIsImN1bGxNb2RlIiwiQ1VMTF9CQUNLIiwic2V0RGVwdGgiLCJkZXB0aFRlc3QiLCJkZXB0aFdyaXRlIiwiZGVwdGhGdW5jIiwiRFNfRlVOQ19MRVNTIiwic2V0QmxlbmQiLCJlbmFibGVkIiwiYmxlbmRFcSIsImJsZW5kU3JjIiwiYmxlbmREc3QiLCJibGVuZEFscGhhRXEiLCJibGVuZFNyY0FscGhhIiwiYmxlbmREc3RBbHBoYSIsImJsZW5kQ29sb3IiLCJCTEVORF9GVU5DX0FERCIsIkJMRU5EX1NSQ19BTFBIQSIsIkJMRU5EX09ORV9NSU5VU19TUkNfQUxQSEEiLCJzZXRTdGVuY2lsRW5hYmxlZCIsInN0ZW5jaWxUZXN0IiwiU1RFTkNJTF9JTkhFUklUIiwic2V0U3RlbmNpbCIsInN0ZW5jaWxGdW5jIiwic3RlbmNpbFJlZiIsInN0ZW5jaWxNYXNrIiwic3RlbmNpbEZhaWxPcCIsInN0ZW5jaWxaRmFpbE9wIiwic3RlbmNpbFpQYXNzT3AiLCJzdGVuY2lsV3JpdGVNYXNrIiwiRFNfRlVOQ19BTFdBWVMiLCJTVEVOQ0lMX09QX0tFRVAiLCJ1cGRhdGVIYXNoIiwiaGFzaCIsImdldEhhc2giLCJvbkxvYWQiLCJwYXNzRGF0YXMiLCJpbmRleCIsInBhc3NEYXRhIiwiZGVmaW5lcyIsInByb3AiLCJwcm9wcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUF5QkEsSUFBTUEsS0FBSyxHQUFHQyxPQUFPLENBQUMsWUFBRCxDQUFyQjs7QUFDQSxJQUFNQyxPQUFPLEdBQUdELE9BQU8sQ0FBQyxnQkFBRCxDQUF2Qjs7QUFDQSxJQUFNRSxXQUFXLEdBQUdELE9BQU8sQ0FBQ0MsV0FBNUI7O0FBQ0EsSUFBTUMsV0FBVyxHQUFHSCxPQUFPLENBQUMsaUJBQUQsQ0FBM0I7O0FBQ0EsSUFBTUksV0FBVyxHQUFHSixPQUFPLENBQUMsMEJBQUQsQ0FBM0I7O0FBQ0EsSUFBTUssR0FBRyxHQUFHQyxFQUFFLENBQUNELEdBQWY7QUFFQTs7Ozs7O0FBS0EsSUFBTUUsWUFBWSxHQUFHRCxFQUFFLENBQUNFLElBQUgsQ0FBUTtBQUN6Qjs7Ozs7QUFLQUMsRUFBQUEsTUFBTSxFQUFFLFdBTmlCOztBQU96Qjs7Ozs7QUFLQUMsRUFBQUEsV0FBVyxFQUFFLGdCQVpZOztBQWF6Qjs7Ozs7QUFLQUMsRUFBQUEsS0FBSyxFQUFFO0FBbEJrQixDQUFSLENBQXJCO0FBc0JBOzs7Ozs7O0FBTUEsSUFBSUMsUUFBUSxHQUFHTixFQUFFLENBQUNPLEtBQUgsQ0FBUztBQUNwQkMsRUFBQUEsSUFBSSxFQUFFLGFBRGM7QUFFcEIsYUFBU2YsS0FGVztBQUlwQmdCLEVBQUFBLElBSm9CLGtCQUlaO0FBQ0osU0FBS0MsV0FBTCxHQUFtQixLQUFuQjtBQUNBLFNBQUtDLE1BQUwsR0FBYyxJQUFkO0FBQ0EsU0FBS0MsT0FBTCxHQUFlLElBQWY7QUFDSCxHQVJtQjtBQVVwQkMsRUFBQUEsVUFBVSxFQUFFO0FBQ1I7QUFDQUMsSUFBQUEsUUFBUSxFQUFFO0FBQ04saUJBQVNDLFNBREg7QUFFTkMsTUFBQUEsSUFBSSxFQUFFQztBQUZBLEtBRkY7QUFNUjtBQUNBQyxJQUFBQSxNQUFNLEVBQUU7QUFDSixpQkFBU0gsU0FETDtBQUVKQyxNQUFBQSxJQUFJLEVBQUVDO0FBRkYsS0FQQTtBQVlSRSxJQUFBQSxZQUFZLEVBQUU7QUFDVkgsTUFBQUEsSUFBSSxFQUFFbkIsV0FESTtBQUVWLGlCQUFTO0FBRkMsS0FaTjtBQWlCUnVCLElBQUFBLGVBQWUsRUFBRSxDQWpCVDtBQWtCUkMsSUFBQUEsY0FBYyxFQUFFSixNQWxCUjtBQW9CUkssSUFBQUEsVUFBVSxFQUFFQyxTQUFTLEdBQUc7QUFDcEJDLE1BQUFBLEdBRG9CLGlCQUNiO0FBQ0gsZUFBTyxLQUFLTCxZQUFMLElBQXFCLEtBQUtBLFlBQUwsQ0FBa0JYLElBQTlDO0FBQ0gsT0FIbUI7QUFJcEJpQixNQUFBQSxHQUpvQixlQUlmQyxHQUplLEVBSVY7QUFDTixZQUFJQyxXQUFXLEdBQUczQixFQUFFLENBQUM0QixZQUFILENBQWdCQyxVQUFoQixDQUEyQixRQUEzQixFQUFxQ0gsR0FBckMsQ0FBbEI7O0FBQ0EsWUFBSSxDQUFDQyxXQUFMLEVBQWtCO0FBQ2RHLFVBQUFBLE1BQU0sQ0FBQ0MsSUFBUCx1QkFBZ0NMLEdBQWhDO0FBQ0E7QUFDSDs7QUFDRCxhQUFLQyxXQUFMLEdBQW1CQSxXQUFuQjtBQUNIO0FBWG1CLEtBQUgsR0FZakJaLFNBaENJO0FBa0NSWSxJQUFBQSxXQUFXLEVBQUU7QUFDVEgsTUFBQUEsR0FEUyxpQkFDRjtBQUNILGVBQU8sS0FBS0wsWUFBWjtBQUNILE9BSFE7QUFJVE0sTUFBQUEsR0FKUyxlQUlKTyxLQUpJLEVBSUc7QUFDUixZQUFJaEMsRUFBRSxDQUFDaUMsSUFBSCxDQUFRQyxVQUFSLEtBQXVCbEMsRUFBRSxDQUFDaUMsSUFBSCxDQUFRRSxrQkFBbkMsRUFBdUQ7QUFDbkQ7QUFDSDs7QUFFRCxhQUFLaEIsWUFBTCxHQUFvQmEsS0FBcEI7O0FBQ0EsWUFBSSxDQUFDQSxLQUFMLEVBQVk7QUFDUmhDLFVBQUFBLEVBQUUsQ0FBQ29DLEtBQUgsQ0FBUyxvQ0FBVDtBQUNBO0FBQ0g7O0FBRUQsYUFBS3hCLE9BQUwsR0FBZSxLQUFLTyxZQUFMLENBQWtCa0IscUJBQWxCLEVBQWY7QUFDSDtBQWhCUSxLQWxDTDtBQXFEUkMsSUFBQUEsTUFBTSxFQUFFO0FBQ0pkLE1BQUFBLEdBREksaUJBQ0c7QUFDSCxlQUFPLEtBQUtaLE9BQVo7QUFDSDtBQUhHLEtBckRBO0FBMkRSMkIsSUFBQUEsY0FBYyxFQUFFO0FBQ1pmLE1BQUFBLEdBRFksaUJBQ0w7QUFDSCxlQUFPLEtBQUtKLGVBQVo7QUFDSCxPQUhXO0FBSVpLLE1BQUFBLEdBSlksZUFJUGUsQ0FKTyxFQUlKO0FBQ0osYUFBS3BCLGVBQUwsR0FBdUJvQixDQUF2Qjs7QUFDQSxhQUFLNUIsT0FBTCxDQUFhNkIsZUFBYixDQUE2QkQsQ0FBN0I7QUFDSDtBQVBXO0FBM0RSLEdBVlE7QUFnRnBCRSxFQUFBQSxPQUFPLEVBQUU7QUFDTEMsSUFBQUEsa0JBREssOEJBQ2VuQyxJQURmLEVBQ3FCO0FBQ3RCLFVBQUlSLEVBQUUsQ0FBQ2lDLElBQUgsQ0FBUUMsVUFBUixLQUF1QmxDLEVBQUUsQ0FBQ2lDLElBQUgsQ0FBUUUsa0JBQW5DLEVBQXVEO0FBQ25ELGVBQU8sSUFBSW5DLEVBQUUsQ0FBQ00sUUFBUCxFQUFQO0FBQ0g7O0FBQ0QsYUFBT04sRUFBRSxDQUFDNEIsWUFBSCxDQUFnQkMsVUFBaEIsQ0FBMkIsVUFBM0IsRUFBdUMsYUFBYXJCLElBQXBELENBQVA7QUFDSCxLQU5JO0FBUUxQLElBQUFBLFlBQVksRUFBWkEsWUFSSzs7QUFVTDs7Ozs7Ozs7O0FBU0EyQyxJQUFBQSxpQkFuQkssNkJBbUJjdEIsVUFuQmQsRUFtQjBCaUIsY0FuQjFCLEVBbUI4QztBQUFBLFVBQXBCQSxjQUFvQjtBQUFwQkEsUUFBQUEsY0FBb0IsR0FBSCxDQUFHO0FBQUE7O0FBQy9DLFVBQUlaLFdBQVcsR0FBRzNCLEVBQUUsQ0FBQzRCLFlBQUgsQ0FBZ0JDLFVBQWhCLENBQTJCLFFBQTNCLEVBQXFDLGFBQWFQLFVBQWxELENBQWxCO0FBQ0EsYUFBT2hCLFFBQVEsQ0FBQ3VDLE1BQVQsQ0FBZ0JsQixXQUFoQixFQUE2QlksY0FBN0IsQ0FBUDtBQUNILEtBdEJJOztBQXVCTDs7Ozs7Ozs7O0FBU0FNLElBQUFBLE1BaENLLGtCQWdDR2xCLFdBaENILEVBZ0NnQlksY0FoQ2hCLEVBZ0NvQztBQUFBLFVBQXBCQSxjQUFvQjtBQUFwQkEsUUFBQUEsY0FBb0IsR0FBSCxDQUFHO0FBQUE7O0FBQ3JDLFVBQUksQ0FBQ1osV0FBTCxFQUFrQixPQUFPLElBQVA7QUFDbEIsVUFBSW1CLFFBQVEsR0FBRyxJQUFJeEMsUUFBSixFQUFmO0FBQ0F3QyxNQUFBQSxRQUFRLENBQUNuQixXQUFULEdBQXVCQSxXQUF2QjtBQUNBbUIsTUFBQUEsUUFBUSxDQUFDUCxjQUFULEdBQTBCQSxjQUExQjtBQUNBLGFBQU9PLFFBQVA7QUFDSDtBQXRDSSxHQWhGVzs7QUF5SHBCOzs7Ozs7Ozs7QUFTQUMsRUFBQUEsV0FsSW9CLHVCQWtJUHZDLElBbElPLEVBa0lEa0IsR0FsSUMsRUFrSUlzQixPQWxJSixFQWtJYUMsUUFsSWIsRUFrSXVCO0FBQ3ZDLFFBQUlqRCxFQUFFLENBQUNpQyxJQUFILENBQVFDLFVBQVIsS0FBdUJsQyxFQUFFLENBQUNpQyxJQUFILENBQVFFLGtCQUFuQyxFQUF1RDs7QUFFdkQsUUFBSSxPQUFPYSxPQUFQLEtBQW1CLFFBQXZCLEVBQWlDO0FBQzdCQSxNQUFBQSxPQUFPLEdBQUdFLFFBQVEsQ0FBQ0YsT0FBRCxDQUFsQjtBQUNIOztBQUVELFFBQUl0QixHQUFHLFlBQVkvQixPQUFuQixFQUE0QjtBQUFBLFVBUWZ3RCxNQVJlLEdBUXhCLFNBQVNBLE1BQVQsR0FBbUI7QUFDZixhQUFLdkMsT0FBTCxDQUFhbUMsV0FBYixDQUF5QnZDLElBQXpCLEVBQStCa0IsR0FBL0IsRUFBb0NzQixPQUFwQztBQUNILE9BVnVCOztBQUN4QixVQUFJSSxNQUFNLEdBQUcxQixHQUFHLENBQUMyQixjQUFKLEVBQWI7QUFDQSxVQUFJQyxLQUFLLEdBQUlGLE1BQU0sS0FBS3hELFdBQVcsQ0FBQzJELFNBQXZCLElBQW9DSCxNQUFNLEtBQUt4RCxXQUFXLENBQUM0RCxrQkFBM0QsSUFBaUZKLE1BQU0sS0FBS3hELFdBQVcsQ0FBQzZELGtCQUFySDtBQUNBLFVBQUlDLEdBQUcsR0FBRyx3QkFBd0JsRCxJQUFsQztBQUNBLFVBQUltRCxHQUFHLEdBQUcsS0FBS0MsU0FBTCxDQUFlRixHQUFmLEVBQW9CVixPQUFwQixDQUFWOztBQUNBLFVBQUlNLEtBQUssSUFBSUssR0FBYixFQUFrQjtBQUNkLGFBQUtFLE1BQUwsQ0FBWUgsR0FBWixFQUFpQkosS0FBakI7QUFDSDs7QUFLRCxVQUFJLENBQUM1QixHQUFHLENBQUN5QixNQUFULEVBQWlCO0FBQ2J6QixRQUFBQSxHQUFHLENBQUNvQyxJQUFKLENBQVMsTUFBVCxFQUFpQlgsTUFBakIsRUFBeUIsSUFBekI7QUFDQXJELFFBQUFBLFdBQVcsQ0FBQ2lFLGVBQVosQ0FBNEJyQyxHQUE1QjtBQUNBO0FBQ0g7QUFDSjs7QUFFRCxTQUFLZCxPQUFMLENBQWFtQyxXQUFiLENBQXlCdkMsSUFBekIsRUFBK0JrQixHQUEvQixFQUFvQ3NCLE9BQXBDLEVBQTZDQyxRQUE3QztBQUNILEdBN0ptQjs7QUErSnBCOzs7Ozs7O0FBT0FlLEVBQUFBLFdBdEtvQix1QkFzS1B4RCxJQXRLTyxFQXNLRHdDLE9BdEtDLEVBc0tRO0FBQ3hCLFFBQUksT0FBT0EsT0FBUCxLQUFtQixRQUF2QixFQUFpQztBQUM3QkEsTUFBQUEsT0FBTyxHQUFHRSxRQUFRLENBQUNGLE9BQUQsQ0FBbEI7QUFDSDs7QUFDRCxXQUFPLEtBQUtwQyxPQUFMLENBQWFvRCxXQUFiLENBQXlCeEQsSUFBekIsRUFBK0J3QyxPQUEvQixDQUFQO0FBQ0gsR0EzS21COztBQTZLcEI7Ozs7Ozs7OztBQVNBYSxFQUFBQSxNQXRMb0Isa0JBc0xackQsSUF0TFksRUFzTE5rQixHQXRMTSxFQXNMRHNCLE9BdExDLEVBc0xRaUIsS0F0TFIsRUFzTGU7QUFDL0IsUUFBSWpFLEVBQUUsQ0FBQ2lDLElBQUgsQ0FBUUMsVUFBUixLQUF1QmxDLEVBQUUsQ0FBQ2lDLElBQUgsQ0FBUUUsa0JBQW5DLEVBQXVEOztBQUV2RCxRQUFJLE9BQU9hLE9BQVAsS0FBbUIsUUFBdkIsRUFBaUM7QUFDN0JBLE1BQUFBLE9BQU8sR0FBR0UsUUFBUSxDQUFDRixPQUFELENBQWxCO0FBQ0g7O0FBQ0QsU0FBS3BDLE9BQUwsQ0FBYWlELE1BQWIsQ0FBb0JyRCxJQUFwQixFQUEwQmtCLEdBQTFCLEVBQStCc0IsT0FBL0IsRUFBd0NpQixLQUF4QztBQUNILEdBN0xtQjs7QUErTHBCOzs7Ozs7OztBQVFBTCxFQUFBQSxTQXZNb0IscUJBdU1UcEQsSUF2TVMsRUF1TUh3QyxPQXZNRyxFQXVNTTtBQUN0QixRQUFJLE9BQU9BLE9BQVAsS0FBbUIsUUFBdkIsRUFBaUM7QUFDN0JBLE1BQUFBLE9BQU8sR0FBR0UsUUFBUSxDQUFDRixPQUFELENBQWxCO0FBQ0g7O0FBQ0QsV0FBTyxLQUFLcEMsT0FBTCxDQUFhZ0QsU0FBYixDQUF1QnBELElBQXZCLEVBQTZCd0MsT0FBN0IsQ0FBUDtBQUNILEdBNU1tQjs7QUE4TXBCOzs7Ozs7O0FBT0FrQixFQUFBQSxXQXJOb0IsdUJBcU5QQyxRQXJOTyxFQXFObUJuQixPQXJObkIsRUFxTjRCO0FBQUEsUUFBbkNtQixRQUFtQztBQUFuQ0EsTUFBQUEsUUFBbUMsR0FBeEJwRSxHQUFHLENBQUNxRSxTQUFvQjtBQUFBOztBQUM1QyxTQUFLeEQsT0FBTCxDQUFhc0QsV0FBYixDQUF5QkMsUUFBekIsRUFBbUNuQixPQUFuQztBQUNILEdBdk5tQjs7QUF5TnBCOzs7Ozs7Ozs7QUFTQXFCLEVBQUFBLFFBbE9vQixvQkFtT2hCQyxTQW5PZ0IsRUFvT2hCQyxVQXBPZ0IsRUFxT2hCQyxTQXJPZ0IsRUFzT2hCeEIsT0F0T2dCLEVBdU9sQjtBQUFBLFFBSkVzQixTQUlGO0FBSkVBLE1BQUFBLFNBSUYsR0FKYyxLQUlkO0FBQUE7O0FBQUEsUUFIRUMsVUFHRjtBQUhFQSxNQUFBQSxVQUdGLEdBSGUsS0FHZjtBQUFBOztBQUFBLFFBRkVDLFNBRUY7QUFGRUEsTUFBQUEsU0FFRixHQUZjekUsR0FBRyxDQUFDMEUsWUFFbEI7QUFBQTs7QUFDRSxTQUFLN0QsT0FBTCxDQUFheUQsUUFBYixDQUFzQkMsU0FBdEIsRUFBaUNDLFVBQWpDLEVBQTZDQyxTQUE3QyxFQUF3RHhCLE9BQXhEO0FBQ0gsR0F6T21COztBQTJPcEI7Ozs7Ozs7Ozs7Ozs7O0FBY0EwQixFQUFBQSxRQXpQb0Isb0JBMFBoQkMsT0ExUGdCLEVBMlBoQkMsT0EzUGdCLEVBNFBoQkMsUUE1UGdCLEVBNlBoQkMsUUE3UGdCLEVBOFBoQkMsWUE5UGdCLEVBK1BoQkMsYUEvUGdCLEVBZ1FoQkMsYUFoUWdCLEVBaVFoQkMsVUFqUWdCLEVBa1FoQmxDLE9BbFFnQixFQW1RbEI7QUFBQSxRQVRFMkIsT0FTRjtBQVRFQSxNQUFBQSxPQVNGLEdBVFksS0FTWjtBQUFBOztBQUFBLFFBUkVDLE9BUUY7QUFSRUEsTUFBQUEsT0FRRixHQVJZN0UsR0FBRyxDQUFDb0YsY0FRaEI7QUFBQTs7QUFBQSxRQVBFTixRQU9GO0FBUEVBLE1BQUFBLFFBT0YsR0FQYTlFLEdBQUcsQ0FBQ3FGLGVBT2pCO0FBQUE7O0FBQUEsUUFORU4sUUFNRjtBQU5FQSxNQUFBQSxRQU1GLEdBTmEvRSxHQUFHLENBQUNzRix5QkFNakI7QUFBQTs7QUFBQSxRQUxFTixZQUtGO0FBTEVBLE1BQUFBLFlBS0YsR0FMaUJoRixHQUFHLENBQUNvRixjQUtyQjtBQUFBOztBQUFBLFFBSkVILGFBSUY7QUFKRUEsTUFBQUEsYUFJRixHQUprQmpGLEdBQUcsQ0FBQ3FGLGVBSXRCO0FBQUE7O0FBQUEsUUFIRUgsYUFHRjtBQUhFQSxNQUFBQSxhQUdGLEdBSGtCbEYsR0FBRyxDQUFDc0YseUJBR3RCO0FBQUE7O0FBQUEsUUFGRUgsVUFFRjtBQUZFQSxNQUFBQSxVQUVGLEdBRmUsVUFFZjtBQUFBOztBQUNFLFNBQUt0RSxPQUFMLENBQWE4RCxRQUFiLENBQXNCQyxPQUF0QixFQUErQkMsT0FBL0IsRUFBd0NDLFFBQXhDLEVBQWtEQyxRQUFsRCxFQUE0REMsWUFBNUQsRUFBMEVDLGFBQTFFLEVBQXlGQyxhQUF6RixFQUF3R0MsVUFBeEcsRUFBb0hsQyxPQUFwSDtBQUNILEdBclFtQjs7QUF1UXBCOzs7Ozs7O0FBT0FzQyxFQUFBQSxpQkE5UW9CLDZCQThRREMsV0E5UUMsRUE4UWtDdkMsT0E5UWxDLEVBOFEyQztBQUFBLFFBQTVDdUMsV0FBNEM7QUFBNUNBLE1BQUFBLFdBQTRDLEdBQTlCeEYsR0FBRyxDQUFDeUYsZUFBMEI7QUFBQTs7QUFDM0QsU0FBSzVFLE9BQUwsQ0FBYTBFLGlCQUFiLENBQStCQyxXQUEvQixFQUE0Q3ZDLE9BQTVDO0FBQ0gsR0FoUm1COztBQWtScEI7Ozs7Ozs7Ozs7Ozs7O0FBY0F5QyxFQUFBQSxVQWhTb0Isc0JBaVNoQkYsV0FqU2dCLEVBa1NoQkcsV0FsU2dCLEVBbVNoQkMsVUFuU2dCLEVBb1NoQkMsV0FwU2dCLEVBcVNoQkMsYUFyU2dCLEVBc1NoQkMsY0F0U2dCLEVBdVNoQkMsY0F2U2dCLEVBd1NoQkMsZ0JBeFNnQixFQXlTaEJoRCxPQXpTZ0IsRUEwU2xCO0FBQUEsUUFURXVDLFdBU0Y7QUFURUEsTUFBQUEsV0FTRixHQVRnQnhGLEdBQUcsQ0FBQ3lGLGVBU3BCO0FBQUE7O0FBQUEsUUFSRUUsV0FRRjtBQVJFQSxNQUFBQSxXQVFGLEdBUmdCM0YsR0FBRyxDQUFDa0csY0FRcEI7QUFBQTs7QUFBQSxRQVBFTixVQU9GO0FBUEVBLE1BQUFBLFVBT0YsR0FQZSxDQU9mO0FBQUE7O0FBQUEsUUFORUMsV0FNRjtBQU5FQSxNQUFBQSxXQU1GLEdBTmdCLElBTWhCO0FBQUE7O0FBQUEsUUFMRUMsYUFLRjtBQUxFQSxNQUFBQSxhQUtGLEdBTGtCOUYsR0FBRyxDQUFDbUcsZUFLdEI7QUFBQTs7QUFBQSxRQUpFSixjQUlGO0FBSkVBLE1BQUFBLGNBSUYsR0FKbUIvRixHQUFHLENBQUNtRyxlQUl2QjtBQUFBOztBQUFBLFFBSEVILGNBR0Y7QUFIRUEsTUFBQUEsY0FHRixHQUhtQmhHLEdBQUcsQ0FBQ21HLGVBR3ZCO0FBQUE7O0FBQUEsUUFGRUYsZ0JBRUY7QUFGRUEsTUFBQUEsZ0JBRUYsR0FGcUIsSUFFckI7QUFBQTs7QUFDRSxTQUFLcEYsT0FBTCxDQUFhNkUsVUFBYixDQUF3QkYsV0FBeEIsRUFBcUNHLFdBQXJDLEVBQWtEQyxVQUFsRCxFQUE4REMsV0FBOUQsRUFBMkVDLGFBQTNFLEVBQTBGQyxjQUExRixFQUEwR0MsY0FBMUcsRUFBMEhDLGdCQUExSCxFQUE0SWhELE9BQTVJO0FBQ0gsR0E1U21CO0FBOFNwQm1ELEVBQUFBLFVBOVNvQixzQkE4U1JDLElBOVNRLEVBOFNGO0FBQ2QsU0FBSzFGLFdBQUwsR0FBbUIwRixJQUFuQjtBQUNBLFNBQUt4RixPQUFMLElBQWdCLEtBQUtBLE9BQUwsQ0FBYXVGLFVBQWIsQ0FBd0JDLElBQXhCLENBQWhCO0FBQ0gsR0FqVG1CO0FBbVRwQkMsRUFBQUEsT0FuVG9CLHFCQW1UVDtBQUNQLFdBQU8sS0FBSzNGLFdBQUwsSUFBcUIsS0FBS0UsT0FBTCxJQUFnQixLQUFLQSxPQUFMLENBQWF5RixPQUFiLEVBQTVDO0FBQ0gsR0FyVG1CO0FBdVRwQkMsRUFBQUEsTUF2VG9CLG9CQXVUVjtBQUNOLFNBQUszRSxXQUFMLEdBQW1CLEtBQUtSLFlBQXhCO0FBQ0EsUUFBSSxDQUFDLEtBQUtQLE9BQVYsRUFBbUI7O0FBRW5CLFFBQUksS0FBS1EsZUFBVCxFQUEwQjtBQUN0QixXQUFLUixPQUFMLENBQWE2QixlQUFiLENBQTZCLEtBQUtyQixlQUFsQztBQUNIOztBQUVELFNBQUtDLGNBQUwsR0FBc0IsS0FBS0EsY0FBTCxJQUF1QixFQUE3QztBQUVBLFFBQUlrRixTQUFTLEdBQUcsS0FBS2xGLGNBQXJCOztBQUNBLFNBQUssSUFBSW1GLEtBQVQsSUFBa0JELFNBQWxCLEVBQTZCO0FBQ3pCQyxNQUFBQSxLQUFLLEdBQUd0RCxRQUFRLENBQUNzRCxLQUFELENBQWhCO0FBQ0EsVUFBSUMsUUFBUSxHQUFHRixTQUFTLENBQUNDLEtBQUQsQ0FBeEI7QUFDQSxVQUFJLENBQUNDLFFBQUwsRUFBZTs7QUFFZixXQUFLLElBQUk5QyxHQUFULElBQWdCOEMsUUFBUSxDQUFDQyxPQUF6QixFQUFrQztBQUM5QixhQUFLN0MsTUFBTCxDQUFZRixHQUFaLEVBQWlCOEMsUUFBUSxDQUFDQyxPQUFULENBQWlCL0MsR0FBakIsQ0FBakIsRUFBd0M2QyxLQUF4QztBQUNIOztBQUNELFdBQUssSUFBSUcsSUFBVCxJQUFpQkYsUUFBUSxDQUFDRyxLQUExQixFQUFpQztBQUM3QixhQUFLN0QsV0FBTCxDQUFpQjRELElBQWpCLEVBQXVCRixRQUFRLENBQUNHLEtBQVQsQ0FBZUQsSUFBZixDQUF2QixFQUE2Q0gsS0FBN0M7QUFDSDtBQUNKO0FBRUo7QUEvVW1CLENBQVQsQ0FBZjtlQWtWZWxHOztBQUNmTixFQUFFLENBQUNNLFFBQUgsR0FBY0EsUUFBZCIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDE3LTIwMTggWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuXG5cbiBodHRwOi8vd3d3LmNvY29zLmNvbVxuXG4gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZW5naW5lIHNvdXJjZSBjb2RlICh0aGUgXCJTb2Z0d2FyZVwiKSwgYSBsaW1pdGVkLFxuICB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiAgbm90IHVzZSBDb2NvcyBDcmVhdG9yIHNvZnR3YXJlIGZvciBkZXZlbG9waW5nIG90aGVyIHNvZnR3YXJlIG9yIHRvb2xzIHRoYXQnc1xuICB1c2VkIGZvciBkZXZlbG9waW5nIGdhbWVzLiBZb3UgYXJlIG5vdCBncmFudGVkIHRvIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsXG4gIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuY29uc3QgQXNzZXQgPSByZXF1aXJlKCcuLi9DQ0Fzc2V0Jyk7XG5jb25zdCBUZXh0dXJlID0gcmVxdWlyZSgnLi4vQ0NUZXh0dXJlMkQnKTtcbmNvbnN0IFBpeGVsRm9ybWF0ID0gVGV4dHVyZS5QaXhlbEZvcm1hdDtcbmNvbnN0IEVmZmVjdEFzc2V0ID0gcmVxdWlyZSgnLi9DQ0VmZmVjdEFzc2V0Jyk7XG5jb25zdCB0ZXh0dXJlVXRpbCA9IHJlcXVpcmUoJy4uLy4uL3V0aWxzL3RleHR1cmUtdXRpbCcpO1xuY29uc3QgZ2Z4ID0gY2MuZ2Z4O1xuXG4vKipcbiAqICEjZW4gTWF0ZXJpYWwgYnVpbHRpbiBuYW1lXG4gKiAhI3poIOWGhee9ruadkOi0qOWQjeWtl1xuICogQGVudW0gTWF0ZXJpYWwuQlVJTFRJTl9OQU1FXG4gKi9cbmNvbnN0IEJVSUxUSU5fTkFNRSA9IGNjLkVudW0oe1xuICAgIC8qKlxuICAgICAqIEBwcm9wZXJ0eSBTUFJJVEVcbiAgICAgKiBAcmVhZG9ubHlcbiAgICAgKiBAdHlwZSB7U3RyaW5nfVxuICAgICAqL1xuICAgIFNQUklURTogJzJkLXNwcml0ZScsXG4gICAgLyoqXG4gICAgICogQHByb3BlcnR5IEdSQVlfU1BSSVRFXG4gICAgICogQHJlYWRvbmx5XG4gICAgICogQHR5cGUge1N0cmluZ31cbiAgICAgKi9cbiAgICBHUkFZX1NQUklURTogJzJkLWdyYXktc3ByaXRlJyxcbiAgICAvKipcbiAgICAgKiBAcHJvcGVydHkgVU5MSVRcbiAgICAgKiBAcmVhZG9ubHlcbiAgICAgKiBAdHlwZSB7U3RyaW5nfVxuICAgICAqL1xuICAgIFVOTElUOiAndW5saXQnLFxufSlcblxuXG4vKipcbiAqICEjZW4gTWF0ZXJpYWwgQXNzZXQuXG4gKiAhI3poIOadkOi0qOi1hOa6kOexu+OAglxuICogQGNsYXNzIE1hdGVyaWFsXG4gKiBAZXh0ZW5kcyBBc3NldFxuICovXG5sZXQgTWF0ZXJpYWwgPSBjYy5DbGFzcyh7XG4gICAgbmFtZTogJ2NjLk1hdGVyaWFsJyxcbiAgICBleHRlbmRzOiBBc3NldCxcblxuICAgIGN0b3IgKCkge1xuICAgICAgICB0aGlzLl9tYW51YWxIYXNoID0gZmFsc2U7XG4gICAgICAgIHRoaXMuX2RpcnR5ID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5fZWZmZWN0ID0gbnVsbDtcbiAgICB9LFxuXG4gICAgcHJvcGVydGllczoge1xuICAgICAgICAvLyBkZXByZWNhdGVkXG4gICAgICAgIF9kZWZpbmVzOiB7XG4gICAgICAgICAgICBkZWZhdWx0OiB1bmRlZmluZWQsXG4gICAgICAgICAgICB0eXBlOiBPYmplY3RcbiAgICAgICAgfSxcbiAgICAgICAgLy8gZGVwcmVjYXRlZFxuICAgICAgICBfcHJvcHM6IHtcbiAgICAgICAgICAgIGRlZmF1bHQ6IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHR5cGU6IE9iamVjdFxuICAgICAgICB9LFxuXG4gICAgICAgIF9lZmZlY3RBc3NldDoge1xuICAgICAgICAgICAgdHlwZTogRWZmZWN0QXNzZXQsXG4gICAgICAgICAgICBkZWZhdWx0OiBudWxsLFxuICAgICAgICB9LFxuXG4gICAgICAgIF90ZWNobmlxdWVJbmRleDogMCxcbiAgICAgICAgX3RlY2huaXF1ZURhdGE6IE9iamVjdCxcblxuICAgICAgICBlZmZlY3ROYW1lOiBDQ19FRElUT1IgPyB7XG4gICAgICAgICAgICBnZXQgKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLl9lZmZlY3RBc3NldCAmJiB0aGlzLl9lZmZlY3RBc3NldC5uYW1lO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNldCAodmFsKSB7XG4gICAgICAgICAgICAgICAgbGV0IGVmZmVjdEFzc2V0ID0gY2MuQXNzZXRMaWJyYXJ5LmdldEJ1aWx0aW4oJ2VmZmVjdCcsIHZhbCk7XG4gICAgICAgICAgICAgICAgaWYgKCFlZmZlY3RBc3NldCkge1xuICAgICAgICAgICAgICAgICAgICBFZGl0b3Iud2Fybihgbm8gZWZmZWN0IG5hbWVkICcke3ZhbH0nIGZvdW5kYCk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdGhpcy5lZmZlY3RBc3NldCA9IGVmZmVjdEFzc2V0O1xuICAgICAgICAgICAgfVxuICAgICAgICB9IDogdW5kZWZpbmVkLFxuXG4gICAgICAgIGVmZmVjdEFzc2V0OiB7XG4gICAgICAgICAgICBnZXQgKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLl9lZmZlY3RBc3NldDtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBzZXQgKGFzc2V0KSB7XG4gICAgICAgICAgICAgICAgaWYgKGNjLmdhbWUucmVuZGVyVHlwZSA9PT0gY2MuZ2FtZS5SRU5ERVJfVFlQRV9DQU5WQVMpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHRoaXMuX2VmZmVjdEFzc2V0ID0gYXNzZXQ7XG4gICAgICAgICAgICAgICAgaWYgKCFhc3NldCkge1xuICAgICAgICAgICAgICAgICAgICBjYy5lcnJvcignQ2FuIG5vdCBzZXQgYW4gZW1wdHkgZWZmZWN0IGFzc2V0LicpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgdGhpcy5fZWZmZWN0ID0gdGhpcy5fZWZmZWN0QXNzZXQuZ2V0SW5zdGFudGlhdGVkRWZmZWN0KCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG5cbiAgICAgICAgZWZmZWN0OiB7XG4gICAgICAgICAgICBnZXQgKCkge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLl9lZmZlY3Q7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG5cbiAgICAgICAgdGVjaG5pcXVlSW5kZXg6IHtcbiAgICAgICAgICAgIGdldCAoKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuX3RlY2huaXF1ZUluZGV4O1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNldCAodikge1xuICAgICAgICAgICAgICAgIHRoaXMuX3RlY2huaXF1ZUluZGV4ID0gdjtcbiAgICAgICAgICAgICAgICB0aGlzLl9lZmZlY3Quc3dpdGNoVGVjaG5pcXVlKHYpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfSxcblxuICAgIHN0YXRpY3M6IHtcbiAgICAgICAgZ2V0QnVpbHRpbk1hdGVyaWFsIChuYW1lKSB7XG4gICAgICAgICAgICBpZiAoY2MuZ2FtZS5yZW5kZXJUeXBlID09PSBjYy5nYW1lLlJFTkRFUl9UWVBFX0NBTlZBUykge1xuICAgICAgICAgICAgICAgIHJldHVybiBuZXcgY2MuTWF0ZXJpYWwoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBjYy5Bc3NldExpYnJhcnkuZ2V0QnVpbHRpbignbWF0ZXJpYWwnLCAnYnVpbHRpbi0nICsgbmFtZSk7XG4gICAgICAgIH0sXG5cbiAgICAgICAgQlVJTFRJTl9OQU1FLFxuICAgICAgICBcbiAgICAgICAgLyoqXG4gICAgICAgICAqICEjZW4gQ3JlYXRlcyBhIE1hdGVyaWFsIHdpdGggYnVpbHRpbiBFZmZlY3QuXG4gICAgICAgICAqICEjemgg5L2/55So5YaF5bu6IEVmZmVjdCDliJvlu7rkuIDkuKrmnZDotKjjgIJcbiAgICAgICAgICogQHN0YXRpY1xuICAgICAgICAgKiBAbWV0aG9kIGNyZWF0ZVdpdGhCdWlsdGluXG4gICAgICAgICAqIEBwYXJhbSB7c3RyaW5nfSBlZmZlY3ROYW1lIFxuICAgICAgICAgKiBAcGFyYW0ge251bWJlcn0gW3RlY2huaXF1ZUluZGV4XSBcbiAgICAgICAgICogQHJldHVybiB7TWF0ZXJpYWx9XG4gICAgICAgICAqL1xuICAgICAgICBjcmVhdGVXaXRoQnVpbHRpbiAoZWZmZWN0TmFtZSwgdGVjaG5pcXVlSW5kZXggPSAwKSB7XG4gICAgICAgICAgICBsZXQgZWZmZWN0QXNzZXQgPSBjYy5Bc3NldExpYnJhcnkuZ2V0QnVpbHRpbignZWZmZWN0JywgJ2J1aWx0aW4tJyArIGVmZmVjdE5hbWUpO1xuICAgICAgICAgICAgcmV0dXJuIE1hdGVyaWFsLmNyZWF0ZShlZmZlY3RBc3NldCwgdGVjaG5pcXVlSW5kZXgpO1xuICAgICAgICB9LFxuICAgICAgICAvKipcbiAgICAgICAgICogISNlbiBDcmVhdGVzIGEgTWF0ZXJpYWwuXG4gICAgICAgICAqICEjemgg5Yib5bu65LiA5Liq5p2Q6LSo44CCXG4gICAgICAgICAqIEBzdGF0aWNcbiAgICAgICAgICogQG1ldGhvZCBjcmVhdGVcbiAgICAgICAgICogQHBhcmFtIHtFZmZlY3RBc3NldH0gZWZmZWN0QXNzZXQgXG4gICAgICAgICAqIEBwYXJhbSB7bnVtYmVyfSBbdGVjaG5pcXVlSW5kZXhdIFxuICAgICAgICAgKiBAcmV0dXJuIHtNYXRlcmlhbH1cbiAgICAgICAgICovXG4gICAgICAgIGNyZWF0ZSAoZWZmZWN0QXNzZXQsIHRlY2huaXF1ZUluZGV4ID0gMCkge1xuICAgICAgICAgICAgaWYgKCFlZmZlY3RBc3NldCkgcmV0dXJuIG51bGw7XG4gICAgICAgICAgICBsZXQgbWF0ZXJpYWwgPSBuZXcgTWF0ZXJpYWwoKTtcbiAgICAgICAgICAgIG1hdGVyaWFsLmVmZmVjdEFzc2V0ID0gZWZmZWN0QXNzZXQ7XG4gICAgICAgICAgICBtYXRlcmlhbC50ZWNobmlxdWVJbmRleCA9IHRlY2huaXF1ZUluZGV4O1xuICAgICAgICAgICAgcmV0dXJuIG1hdGVyaWFsO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW4gU2V0cyB0aGUgTWF0ZXJpYWwgcHJvcGVydHlcbiAgICAgKiAhI3poIOaYr+aMh+adkOi0qOeahOWxnuaAp1xuICAgICAqIEBtZXRob2Qgc2V0UHJvcGVydHlcbiAgICAgKiBAcGFyYW0ge3N0cmluZ30gbmFtZVxuICAgICAqIEBwYXJhbSB7T2JqZWN0fSB2YWxcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gW3Bhc3NJZHhdXG4gICAgICogQHBhcmFtIHtib29sZWFufSBbZGlyZWN0bHldXG4gICAgICovXG4gICAgc2V0UHJvcGVydHkgKG5hbWUsIHZhbCwgcGFzc0lkeCwgZGlyZWN0bHkpIHtcbiAgICAgICAgaWYgKGNjLmdhbWUucmVuZGVyVHlwZSA9PT0gY2MuZ2FtZS5SRU5ERVJfVFlQRV9DQU5WQVMpIHJldHVybjtcblxuICAgICAgICBpZiAodHlwZW9mIHBhc3NJZHggPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICBwYXNzSWR4ID0gcGFyc2VJbnQocGFzc0lkeCk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodmFsIGluc3RhbmNlb2YgVGV4dHVyZSkge1xuICAgICAgICAgICAgbGV0IGZvcm1hdCA9IHZhbC5nZXRQaXhlbEZvcm1hdCgpO1xuICAgICAgICAgICAgbGV0IHZhbHVlID0gKGZvcm1hdCA9PT0gUGl4ZWxGb3JtYXQuUkdCQV9FVEMxIHx8IGZvcm1hdCA9PT0gUGl4ZWxGb3JtYXQuUkdCX0FfUFZSVENfNEJQUFYxIHx8IGZvcm1hdCA9PT0gUGl4ZWxGb3JtYXQuUkdCX0FfUFZSVENfMkJQUFYxKTtcbiAgICAgICAgICAgIGxldCBrZXkgPSAnQ0NfVVNFX0FMUEhBX0FUTEFTXycgKyBuYW1lO1xuICAgICAgICAgICAgbGV0IGRlZiA9IHRoaXMuZ2V0RGVmaW5lKGtleSwgcGFzc0lkeCk7XG4gICAgICAgICAgICBpZiAodmFsdWUgfHwgZGVmKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5kZWZpbmUoa2V5LCB2YWx1ZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBmdW5jdGlvbiBsb2FkZWQgKCkge1xuICAgICAgICAgICAgICAgIHRoaXMuX2VmZmVjdC5zZXRQcm9wZXJ0eShuYW1lLCB2YWwsIHBhc3NJZHgpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAoIXZhbC5sb2FkZWQpIHtcbiAgICAgICAgICAgICAgICB2YWwub25jZSgnbG9hZCcsIGxvYWRlZCwgdGhpcyk7XG4gICAgICAgICAgICAgICAgdGV4dHVyZVV0aWwucG9zdExvYWRUZXh0dXJlKHZhbCk7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5fZWZmZWN0LnNldFByb3BlcnR5KG5hbWUsIHZhbCwgcGFzc0lkeCwgZGlyZWN0bHkpO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIEdldHMgdGhlIE1hdGVyaWFsIHByb3BlcnR5LlxuICAgICAqICEjemgg6I635Y+W5p2Q6LSo55qE5bGe5oCn44CCXG4gICAgICogQG1ldGhvZCBnZXRQcm9wZXJ0eVxuICAgICAqIEBwYXJhbSB7c3RyaW5nfSBuYW1lIFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBwYXNzSWR4IFxuICAgICAqL1xuICAgIGdldFByb3BlcnR5IChuYW1lLCBwYXNzSWR4KSB7XG4gICAgICAgIGlmICh0eXBlb2YgcGFzc0lkeCA9PT0gJ3N0cmluZycpIHtcbiAgICAgICAgICAgIHBhc3NJZHggPSBwYXJzZUludChwYXNzSWR4KTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdGhpcy5fZWZmZWN0LmdldFByb3BlcnR5KG5hbWUsIHBhc3NJZHgpO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFNldHMgdGhlIE1hdGVyaWFsIGRlZmluZS5cbiAgICAgKiAhI3poIOiuvue9ruadkOi0qOeahOWuj+WumuS5ieOAglxuICAgICAqIEBtZXRob2QgZGVmaW5lXG4gICAgICogQHBhcmFtIHtzdHJpbmd9IG5hbWVcbiAgICAgKiBAcGFyYW0ge2Jvb2xlYW58bnVtYmVyfSB2YWxcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gW3Bhc3NJZHhdXG4gICAgICogQHBhcmFtIHtib29sZWFufSBbZm9yY2VdXG4gICAgICovXG4gICAgZGVmaW5lIChuYW1lLCB2YWwsIHBhc3NJZHgsIGZvcmNlKSB7XG4gICAgICAgIGlmIChjYy5nYW1lLnJlbmRlclR5cGUgPT09IGNjLmdhbWUuUkVOREVSX1RZUEVfQ0FOVkFTKSByZXR1cm47XG5cbiAgICAgICAgaWYgKHR5cGVvZiBwYXNzSWR4ID09PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgcGFzc0lkeCA9IHBhcnNlSW50KHBhc3NJZHgpO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMuX2VmZmVjdC5kZWZpbmUobmFtZSwgdmFsLCBwYXNzSWR4LCBmb3JjZSk7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW4gR2V0cyB0aGUgTWF0ZXJpYWwgZGVmaW5lLlxuICAgICAqICEjemgg6I635Y+W5p2Q6LSo55qE5a6P5a6a5LmJ44CCXG4gICAgICogQG1ldGhvZCBnZXREZWZpbmVcbiAgICAgKiBAcGFyYW0ge3N0cmluZ30gbmFtZSBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gW3Bhc3NJZHhdIFxuICAgICAqIEByZXR1cm4ge2Jvb2xlYW58bnVtYmVyfVxuICAgICAqL1xuICAgIGdldERlZmluZSAobmFtZSwgcGFzc0lkeCkge1xuICAgICAgICBpZiAodHlwZW9mIHBhc3NJZHggPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICBwYXNzSWR4ID0gcGFyc2VJbnQocGFzc0lkeCk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMuX2VmZmVjdC5nZXREZWZpbmUobmFtZSwgcGFzc0lkeCk7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW4gU2V0cyB0aGUgTWF0ZXJpYWwgY3VsbCBtb2RlLlxuICAgICAqICEjemgg6K6+572u5p2Q6LSo55qE6KOB5YeP5qih5byP44CCXG4gICAgICogQG1ldGhvZCBzZXRDdWxsTW9kZVxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBjdWxsTW9kZSBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gcGFzc0lkeCBcbiAgICAgKi9cbiAgICBzZXRDdWxsTW9kZSAoY3VsbE1vZGUgPSBnZnguQ1VMTF9CQUNLLCBwYXNzSWR4KSB7XG4gICAgICAgIHRoaXMuX2VmZmVjdC5zZXRDdWxsTW9kZShjdWxsTW9kZSwgcGFzc0lkeCk7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqICEjZW4gU2V0cyB0aGUgTWF0ZXJpYWwgZGVwdGggc3RhdGVzLlxuICAgICAqICEjemgg6K6+572u5p2Q6LSo55qE5rex5bqm5riy5p+T54q25oCB44CCXG4gICAgICogQG1ldGhvZCBzZXREZXB0aFxuICAgICAqIEBwYXJhbSB7Ym9vbGVhbn0gZGVwdGhUZXN0IFxuICAgICAqIEBwYXJhbSB7Ym9vbGVhbn0gZGVwdGhXcml0ZSBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gZGVwdGhGdW5jIFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBwYXNzSWR4IFxuICAgICAqL1xuICAgIHNldERlcHRoIChcbiAgICAgICAgZGVwdGhUZXN0ID0gZmFsc2UsXG4gICAgICAgIGRlcHRoV3JpdGUgPSBmYWxzZSxcbiAgICAgICAgZGVwdGhGdW5jID0gZ2Z4LkRTX0ZVTkNfTEVTUyxcbiAgICAgICAgcGFzc0lkeFxuICAgICkge1xuICAgICAgICB0aGlzLl9lZmZlY3Quc2V0RGVwdGgoZGVwdGhUZXN0LCBkZXB0aFdyaXRlLCBkZXB0aEZ1bmMsIHBhc3NJZHgpO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFNldHMgdGhlIE1hdGVyaWFsIGJsZW5kIHN0YXRlcy5cbiAgICAgKiAhI3poIOiuvue9ruadkOi0qOeahOa3t+WQiOa4suafk+eKtuaAgeOAglxuICAgICAqIEBtZXRob2Qgc2V0QmxlbmRcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gZW5hYmxlZCBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gYmxlbmRFcSBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gYmxlbmRTcmMgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IGJsZW5kRHN0IFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBibGVuZEFscGhhRXEgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IGJsZW5kU3JjQWxwaGEgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IGJsZW5kRHN0QWxwaGEgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IGJsZW5kQ29sb3IgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHBhc3NJZHggXG4gICAgICovXG4gICAgc2V0QmxlbmQgKFxuICAgICAgICBlbmFibGVkID0gZmFsc2UsXG4gICAgICAgIGJsZW5kRXEgPSBnZnguQkxFTkRfRlVOQ19BREQsXG4gICAgICAgIGJsZW5kU3JjID0gZ2Z4LkJMRU5EX1NSQ19BTFBIQSxcbiAgICAgICAgYmxlbmREc3QgPSBnZnguQkxFTkRfT05FX01JTlVTX1NSQ19BTFBIQSxcbiAgICAgICAgYmxlbmRBbHBoYUVxID0gZ2Z4LkJMRU5EX0ZVTkNfQURELFxuICAgICAgICBibGVuZFNyY0FscGhhID0gZ2Z4LkJMRU5EX1NSQ19BTFBIQSxcbiAgICAgICAgYmxlbmREc3RBbHBoYSA9IGdmeC5CTEVORF9PTkVfTUlOVVNfU1JDX0FMUEhBLFxuICAgICAgICBibGVuZENvbG9yID0gMHhmZmZmZmZmZixcbiAgICAgICAgcGFzc0lkeFxuICAgICkge1xuICAgICAgICB0aGlzLl9lZmZlY3Quc2V0QmxlbmQoZW5hYmxlZCwgYmxlbmRFcSwgYmxlbmRTcmMsIGJsZW5kRHN0LCBibGVuZEFscGhhRXEsIGJsZW5kU3JjQWxwaGEsIGJsZW5kRHN0QWxwaGEsIGJsZW5kQ29sb3IsIHBhc3NJZHgpO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFNldHMgd2hldGhlciBlbmFibGUgdGhlIHN0ZW5jaWwgdGVzdC5cbiAgICAgKiAhI3poIOiuvue9ruaYr+WQpuW8gOWQr+aooeadv+a1i+ivleOAglxuICAgICAqIEBtZXRob2Qgc2V0U3RlbmNpbEVuYWJsZWRcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gc3RlbmNpbFRlc3QgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHBhc3NJZHggXG4gICAgICovXG4gICAgc2V0U3RlbmNpbEVuYWJsZWQgKHN0ZW5jaWxUZXN0ID0gZ2Z4LlNURU5DSUxfSU5IRVJJVCwgcGFzc0lkeCkge1xuICAgICAgICB0aGlzLl9lZmZlY3Quc2V0U3RlbmNpbEVuYWJsZWQoc3RlbmNpbFRlc3QsIHBhc3NJZHgpO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiAhI2VuIFNldHMgdGhlIE1hdGVyaWFsIHN0ZW5jaWwgcmVuZGVyIHN0YXRlcy5cbiAgICAgKiAhI3poIOiuvue9ruadkOi0qOeahOaooeadv+a1i+ivlea4suafk+WPguaVsOOAglxuICAgICAqIEBtZXRob2Qgc2V0U3RlbmNpbFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBzdGVuY2lsVGVzdCBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gc3RlbmNpbEZ1bmMgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHN0ZW5jaWxSZWYgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHN0ZW5jaWxNYXNrIFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBzdGVuY2lsRmFpbE9wIFxuICAgICAqIEBwYXJhbSB7bnVtYmVyfSBzdGVuY2lsWkZhaWxPcCBcbiAgICAgKiBAcGFyYW0ge251bWJlcn0gc3RlbmNpbFpQYXNzT3AgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHN0ZW5jaWxXcml0ZU1hc2sgXG4gICAgICogQHBhcmFtIHtudW1iZXJ9IHBhc3NJZHggXG4gICAgICovXG4gICAgc2V0U3RlbmNpbCAoXG4gICAgICAgIHN0ZW5jaWxUZXN0ID0gZ2Z4LlNURU5DSUxfSU5IRVJJVCxcbiAgICAgICAgc3RlbmNpbEZ1bmMgPSBnZnguRFNfRlVOQ19BTFdBWVMsXG4gICAgICAgIHN0ZW5jaWxSZWYgPSAwLFxuICAgICAgICBzdGVuY2lsTWFzayA9IDB4ZmYsXG4gICAgICAgIHN0ZW5jaWxGYWlsT3AgPSBnZnguU1RFTkNJTF9PUF9LRUVQLFxuICAgICAgICBzdGVuY2lsWkZhaWxPcCA9IGdmeC5TVEVOQ0lMX09QX0tFRVAsXG4gICAgICAgIHN0ZW5jaWxaUGFzc09wID0gZ2Z4LlNURU5DSUxfT1BfS0VFUCxcbiAgICAgICAgc3RlbmNpbFdyaXRlTWFzayA9IDB4ZmYsXG4gICAgICAgIHBhc3NJZHhcbiAgICApIHtcbiAgICAgICAgdGhpcy5fZWZmZWN0LnNldFN0ZW5jaWwoc3RlbmNpbFRlc3QsIHN0ZW5jaWxGdW5jLCBzdGVuY2lsUmVmLCBzdGVuY2lsTWFzaywgc3RlbmNpbEZhaWxPcCwgc3RlbmNpbFpGYWlsT3AsIHN0ZW5jaWxaUGFzc09wLCBzdGVuY2lsV3JpdGVNYXNrLCBwYXNzSWR4KTtcbiAgICB9LFxuXG4gICAgdXBkYXRlSGFzaCAoaGFzaCkge1xuICAgICAgICB0aGlzLl9tYW51YWxIYXNoID0gaGFzaDtcbiAgICAgICAgdGhpcy5fZWZmZWN0ICYmIHRoaXMuX2VmZmVjdC51cGRhdGVIYXNoKGhhc2gpO1xuICAgIH0sXG5cbiAgICBnZXRIYXNoICgpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX21hbnVhbEhhc2ggfHwgKHRoaXMuX2VmZmVjdCAmJiB0aGlzLl9lZmZlY3QuZ2V0SGFzaCgpKTtcbiAgICB9LFxuXG4gICAgb25Mb2FkICgpIHtcbiAgICAgICAgdGhpcy5lZmZlY3RBc3NldCA9IHRoaXMuX2VmZmVjdEFzc2V0O1xuICAgICAgICBpZiAoIXRoaXMuX2VmZmVjdCkgcmV0dXJuO1xuXG4gICAgICAgIGlmICh0aGlzLl90ZWNobmlxdWVJbmRleCkge1xuICAgICAgICAgICAgdGhpcy5fZWZmZWN0LnN3aXRjaFRlY2huaXF1ZSh0aGlzLl90ZWNobmlxdWVJbmRleCk7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl90ZWNobmlxdWVEYXRhID0gdGhpcy5fdGVjaG5pcXVlRGF0YSB8fCB7fTtcblxuICAgICAgICBsZXQgcGFzc0RhdGFzID0gdGhpcy5fdGVjaG5pcXVlRGF0YTtcbiAgICAgICAgZm9yIChsZXQgaW5kZXggaW4gcGFzc0RhdGFzKSB7XG4gICAgICAgICAgICBpbmRleCA9IHBhcnNlSW50KGluZGV4KTtcbiAgICAgICAgICAgIGxldCBwYXNzRGF0YSA9IHBhc3NEYXRhc1tpbmRleF07XG4gICAgICAgICAgICBpZiAoIXBhc3NEYXRhKSBjb250aW51ZTtcblxuICAgICAgICAgICAgZm9yIChsZXQgZGVmIGluIHBhc3NEYXRhLmRlZmluZXMpIHtcbiAgICAgICAgICAgICAgICB0aGlzLmRlZmluZShkZWYsIHBhc3NEYXRhLmRlZmluZXNbZGVmXSwgaW5kZXgpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgZm9yIChsZXQgcHJvcCBpbiBwYXNzRGF0YS5wcm9wcykge1xuICAgICAgICAgICAgICAgIHRoaXMuc2V0UHJvcGVydHkocHJvcCwgcGFzc0RhdGEucHJvcHNbcHJvcF0sIGluZGV4KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgfSxcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCBNYXRlcmlhbDtcbmNjLk1hdGVyaWFsID0gTWF0ZXJpYWw7XG4iXSwic291cmNlUm9vdCI6Ii8ifQ==