
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/CCTexture2D.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _gfx = _interopRequireDefault(require("../../renderer/gfx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var EventTarget = require('../event/event-target');

var renderer = require('../renderer');

require('../platform/CCClass');

var GL_NEAREST = 9728; // gl.NEAREST

var GL_LINEAR = 9729; // gl.LINEAR

var GL_REPEAT = 10497; // gl.REPEAT

var GL_CLAMP_TO_EDGE = 33071; // gl.CLAMP_TO_EDGE

var GL_MIRRORED_REPEAT = 33648; // gl.MIRRORED_REPEAT

var GL_RGBA = 6408; // gl.RGBA

var CHAR_CODE_0 = 48; // '0'

var CHAR_CODE_1 = 49; // '1'

var idGenerater = new (require('../platform/id-generater'))('Tex');
/**
 * <p>
 * This class allows to easily create OpenGL or Canvas 2D textures from images, text or raw data.                                    <br/>
 * The created cc.Texture2D object will always have power-of-two dimensions.                                                <br/>
 * Depending on how you create the cc.Texture2D object, the actual image area of the texture might be smaller than the texture dimensions <br/>
 *  i.e. "contentSize" != (pixelsWide, pixelsHigh) and (maxS, maxT) != (1.0, 1.0).                                           <br/>
 * Be aware that the content of the generated textures will be upside-down! </p>

 * @class Texture2D
 * @uses EventTarget
 * @extends Asset
 */
// define a specified number for the pixel format which gfx do not have a standard definition.

var CUSTOM_PIXEL_FORMAT = 1024;
/**
 * The texture pixel format, default value is RGBA8888, 
 * you should note that textures loaded by normal image files (png, jpg) can only support RGBA8888 format,
 * other formats are supported by compressed file types or raw data.
 * @enum Texture2D.PixelFormat
 */

var PixelFormat = cc.Enum({
  /**
   * 16-bit texture without Alpha channel
   * @property RGB565
   * @readonly
   * @type {Number}
   */
  RGB565: _gfx["default"].TEXTURE_FMT_R5_G6_B5,

  /**
   * 16-bit textures: RGB5A1
   * @property RGB5A1
   * @readonly
   * @type {Number}
   */
  RGB5A1: _gfx["default"].TEXTURE_FMT_R5_G5_B5_A1,

  /**
   * 16-bit textures: RGBA4444
   * @property RGBA4444
   * @readonly
   * @type {Number}
   */
  RGBA4444: _gfx["default"].TEXTURE_FMT_R4_G4_B4_A4,

  /**
   * 24-bit texture: RGB888
   * @property RGB888
   * @readonly
   * @type {Number}
   */
  RGB888: _gfx["default"].TEXTURE_FMT_RGB8,

  /**
   * 32-bit texture: RGBA8888
   * @property RGBA8888
   * @readonly
   * @type {Number}
   */
  RGBA8888: _gfx["default"].TEXTURE_FMT_RGBA8,

  /**
   * 32-bit float texture: RGBA32F
   * @property RGBA32F
   * @readonly
   * @type {Number}
   */
  RGBA32F: _gfx["default"].TEXTURE_FMT_RGBA32F,

  /**
   * 8-bit textures used as masks
   * @property A8
   * @readonly
   * @type {Number}
   */
  A8: _gfx["default"].TEXTURE_FMT_A8,

  /**
   * 8-bit intensity texture
   * @property I8
   * @readonly
   * @type {Number}
   */
  I8: _gfx["default"].TEXTURE_FMT_L8,

  /**
   * 16-bit textures used as masks
   * @property AI88
   * @readonly
   * @type {Number}
   */
  AI8: _gfx["default"].TEXTURE_FMT_L8_A8,

  /**
   * rgb 2 bpp pvrtc
   * @property RGB_PVRTC_2BPPV1
   * @readonly
   * @type {Number}
   */
  RGB_PVRTC_2BPPV1: _gfx["default"].TEXTURE_FMT_RGB_PVRTC_2BPPV1,

  /**
   * rgba 2 bpp pvrtc
   * @property RGBA_PVRTC_2BPPV1
   * @readonly
   * @type {Number}
   */
  RGBA_PVRTC_2BPPV1: _gfx["default"].TEXTURE_FMT_RGBA_PVRTC_2BPPV1,

  /**
   * rgb separate a 2 bpp pvrtc
   * RGB_A_PVRTC_2BPPV1 texture is a 2x height RGB_PVRTC_2BPPV1 format texture.
   * It separate the origin alpha channel to the bottom half atlas, the origin rgb channel to the top half atlas
   * @property RGB_A_PVRTC_2BPPV1
   * @readonly
   * @type {Number}
   */
  RGB_A_PVRTC_2BPPV1: CUSTOM_PIXEL_FORMAT++,

  /**
   * rgb 4 bpp pvrtc
   * @property RGB_PVRTC_4BPPV1
   * @readonly
   * @type {Number}
   */
  RGB_PVRTC_4BPPV1: _gfx["default"].TEXTURE_FMT_RGB_PVRTC_4BPPV1,

  /**
   * rgba 4 bpp pvrtc
   * @property RGBA_PVRTC_4BPPV1
   * @readonly
   * @type {Number}
   */
  RGBA_PVRTC_4BPPV1: _gfx["default"].TEXTURE_FMT_RGBA_PVRTC_4BPPV1,

  /**
   * rgb a 4 bpp pvrtc
   * RGB_A_PVRTC_4BPPV1 texture is a 2x height RGB_PVRTC_4BPPV1 format texture.
   * It separate the origin alpha channel to the bottom half atlas, the origin rgb channel to the top half atlas
   * @property RGB_A_PVRTC_4BPPV1
   * @readonly
   * @type {Number}
   */
  RGB_A_PVRTC_4BPPV1: CUSTOM_PIXEL_FORMAT++,

  /**
   * rgb etc1
   * @property RGB_ETC1
   * @readonly
   * @type {Number}
   */
  RGB_ETC1: _gfx["default"].TEXTURE_FMT_RGB_ETC1,

  /**
   * rgba etc1
   * @property RGBA_ETC1
   * @readonly
   * @type {Number}
   */
  RGBA_ETC1: CUSTOM_PIXEL_FORMAT++,

  /**
   * rgb etc2
   * @property RGB_ETC2
   * @readonly
   * @type {Number}
   */
  RGB_ETC2: _gfx["default"].TEXTURE_FMT_RGB_ETC2,

  /**
   * rgba etc2
   * @property RGBA_ETC2
   * @readonly
   * @type {Number}
   */
  RGBA_ETC2: _gfx["default"].TEXTURE_FMT_RGBA_ETC2
});
/**
 * The texture wrap mode
 * @enum Texture2D.WrapMode
 */

var WrapMode = cc.Enum({
  /**
   * The constant variable equals gl.REPEAT for texture
   * @property REPEAT
   * @type {Number}
   * @readonly
   */
  REPEAT: GL_REPEAT,

  /**
   * The constant variable equals gl.CLAMP_TO_EDGE for texture
   * @property CLAMP_TO_EDGE
   * @type {Number}
   * @readonly
   */
  CLAMP_TO_EDGE: GL_CLAMP_TO_EDGE,

  /**
   * The constant variable equals gl.MIRRORED_REPEAT for texture
   * @property MIRRORED_REPEAT
   * @type {Number}
   * @readonly
   */
  MIRRORED_REPEAT: GL_MIRRORED_REPEAT
});
/**
 * The texture filter mode
 * @enum Texture2D.Filter
 */

var Filter = cc.Enum({
  /**
   * The constant variable equals gl.LINEAR for texture
   * @property LINEAR
   * @type {Number}
   * @readonly
   */
  LINEAR: GL_LINEAR,

  /**
   * The constant variable equals gl.NEAREST for texture
   * @property NEAREST
   * @type {Number}
   * @readonly
   */
  NEAREST: GL_NEAREST
});
var FilterIndex = {
  9728: 0,
  // GL_NEAREST
  9729: 1 // GL_LINEAR

};
var _images = [];
var _sharedOpts = {
  width: undefined,
  height: undefined,
  minFilter: undefined,
  magFilter: undefined,
  wrapS: undefined,
  wrapT: undefined,
  format: undefined,
  genMipmaps: undefined,
  images: undefined,
  image: undefined,
  flipY: undefined,
  premultiplyAlpha: undefined
};

function _getSharedOptions() {
  for (var key in _sharedOpts) {
    _sharedOpts[key] = undefined;
  }

  _images.length = 0;
  _sharedOpts.images = _images;
  return _sharedOpts;
}
/**
 * This class allows to easily create OpenGL or Canvas 2D textures from images or raw data.
 *
 * @class Texture2D
 * @uses EventTarget
 * @extends Asset
 */


var Texture2D = cc.Class({
  name: 'cc.Texture2D',
  "extends": require('../assets/CCAsset'),
  mixins: [EventTarget],
  properties: {
    _nativeAsset: {
      get: function get() {
        // maybe returned to pool in webgl
        return this._image;
      },
      set: function set(data) {
        if (data._compressed && data._data) {
          this.initWithData(data._data, this._format, data.width, data.height);
        } else {
          this.initWithElement(data);
        }
      },
      override: true
    },
    _format: PixelFormat.RGBA8888,
    _premultiplyAlpha: false,
    _flipY: false,
    _minFilter: Filter.LINEAR,
    _magFilter: Filter.LINEAR,
    _mipFilter: Filter.LINEAR,
    _wrapS: WrapMode.CLAMP_TO_EDGE,
    _wrapT: WrapMode.CLAMP_TO_EDGE,
    _genMipmaps: false,

    /**
     * !#en Sets whether generate mipmaps for the texture
     * !#zh 是否为纹理设置生成 mipmaps。
     * @property {Boolean} genMipmaps
     * @default false
     */
    genMipmaps: {
      get: function get() {
        return this._genMipmaps;
      },
      set: function set(genMipmaps) {
        if (this._genMipmaps !== genMipmaps) {
          var opts = _getSharedOptions();

          opts.genMipmaps = genMipmaps;
          this.update(opts);
        }
      }
    },
    _packable: true,

    /**
     * !#en 
     * Sets whether texture can be packed into texture atlas.
     * If need use texture uv in custom Effect, please sets packable to false.
     * !#zh 
     * 设置纹理是否允许参与合图。
     * 如果需要在自定义 Effect 中使用纹理 UV，需要禁止该选项。
     * @property {Boolean} packable
     * @default true
     */
    packable: {
      get: function get() {
        return this._packable;
      },
      set: function set(val) {
        this._packable = val;
      }
    }
  },
  statics: {
    PixelFormat: PixelFormat,
    WrapMode: WrapMode,
    Filter: Filter,
    _FilterIndex: FilterIndex,
    // predefined most common extnames
    extnames: ['.png', '.jpg', '.jpeg', '.bmp', '.webp', '.pvr', '.pkm']
  },
  ctor: function ctor() {
    // Id for generate hash in material
    this._id = idGenerater.getNewId();
    /**
     * !#en
     * Whether the texture is loaded or not
     * !#zh
     * 贴图是否已经成功加载
     * @property loaded
     * @type {Boolean}
     */

    this.loaded = false;
    /**
     * !#en
     * Texture width in pixel
     * !#zh
     * 贴图像素宽度
     * @property width
     * @type {Number}
     */

    this.width = 0;
    /**
     * !#en
     * Texture height in pixel
     * !#zh
     * 贴图像素高度
     * @property height
     * @type {Number}
     */

    this.height = 0;
    this._hashDirty = true;
    this._hash = 0;
    this._texture = null;

    if (CC_EDITOR) {
      this._exportedExts = null;
    }
  },

  /**
   * !#en
   * Get renderer texture implementation object
   * extended from render.Texture2D
   * !#zh  返回渲染器内部贴图对象
   * @method getImpl
   */
  getImpl: function getImpl() {
    return this._texture;
  },
  getId: function getId() {
    return this._id;
  },
  toString: function toString() {
    return this.url || '';
  },

  /**
   * Update texture options, not available in Canvas render mode.
   * image, format, premultiplyAlpha can not be updated in native.
   * @method update
   * @param {Object} options
   * @param {DOMImageElement} options.image
   * @param {Boolean} options.genMipmaps
   * @param {PixelFormat} options.format
   * @param {Filter} options.minFilter
   * @param {Filter} options.magFilter
   * @param {WrapMode} options.wrapS
   * @param {WrapMode} options.wrapT
   * @param {Boolean} options.premultiplyAlpha
   */
  update: function update(options) {
    if (options) {
      var updateImg = false;

      if (options.width !== undefined) {
        this.width = options.width;
      }

      if (options.height !== undefined) {
        this.height = options.height;
      }

      if (options.minFilter !== undefined) {
        this._minFilter = options.minFilter;
        options.minFilter = FilterIndex[options.minFilter];
      }

      if (options.magFilter !== undefined) {
        this._magFilter = options.magFilter;
        options.magFilter = FilterIndex[options.magFilter];
      }

      if (options.mipFilter !== undefined) {
        this._mipFilter = options.mipFilter;
        options.mipFilter = FilterIndex[options.mipFilter];
      }

      if (options.wrapS !== undefined) {
        this._wrapS = options.wrapS;
      }

      if (options.wrapT !== undefined) {
        this._wrapT = options.wrapT;
      }

      if (options.format !== undefined) {
        this._format = options.format;
      }

      if (options.flipY !== undefined) {
        this._flipY = options.flipY;
        updateImg = true;
      }

      if (options.premultiplyAlpha !== undefined) {
        this._premultiplyAlpha = options.premultiplyAlpha;
        updateImg = true;
      }

      if (options.genMipmaps !== undefined) {
        this._genMipmaps = options.genMipmaps;
      }

      if (updateImg && this._image) {
        options.image = this._image;
      }

      if (options.images && options.images.length > 0) {
        this._image = options.images[0];
      } else if (options.image !== undefined) {
        this._image = options.image;

        if (!options.images) {
          _images.length = 0;
          options.images = _images;
        } // webgl texture 2d uses images


        options.images.push(options.image);
      }

      this._texture && this._texture.update(options);
      this._hashDirty = true;
    }
  },

  /**
   * !#en
   * Init with HTML element.
   * !#zh 用 HTML Image 或 Canvas 对象初始化贴图。
   * @method initWithElement
   * @param {HTMLImageElement|HTMLCanvasElement} element
   * @example
   * var img = new Image();
   * img.src = dataURL;
   * texture.initWithElement(img);
   */
  initWithElement: function initWithElement(element) {
    if (!element) return;
    this._image = element;

    if (element.complete || element instanceof HTMLCanvasElement) {
      this.handleLoadedTexture();
    } else {
      var self = this;
      element.addEventListener('load', function () {
        self.handleLoadedTexture();
      });
      element.addEventListener('error', function (err) {
        cc.warnID(3119, err.message);
      });
    }
  },

  /**
   * !#en
   * Intializes with a texture2d with data in Uint8Array.
   * !#zh 使用一个存储在 Unit8Array 中的图像数据（raw data）初始化数据。
   * @method initWithData
   * @param {TypedArray} data
   * @param {Number} pixelFormat
   * @param {Number} pixelsWidth
   * @param {Number} pixelsHeight
   * @return {Boolean}
   */
  initWithData: function initWithData(data, pixelFormat, pixelsWidth, pixelsHeight) {
    var opts = _getSharedOptions();

    opts.image = data; // webgl texture 2d uses images

    opts.images = [opts.image];
    opts.genMipmaps = this._genMipmaps;
    opts.premultiplyAlpha = this._premultiplyAlpha;
    opts.flipY = this._flipY;
    opts.minFilter = FilterIndex[this._minFilter];
    opts.magFilter = FilterIndex[this._magFilter];
    opts.wrapS = this._wrapS;
    opts.wrapT = this._wrapT;
    opts.format = this._getGFXPixelFormat(pixelFormat);
    opts.width = pixelsWidth;
    opts.height = pixelsHeight;

    if (!this._texture) {
      this._texture = new renderer.Texture2D(renderer.device, opts);
    } else {
      this._texture.update(opts);
    }

    this.width = pixelsWidth;
    this.height = pixelsHeight;

    this._checkPackable();

    this.loaded = true;
    this.emit("load");
    return true;
  },

  /**
   * !#en
   * HTMLElement Object getter, available only on web.<br/>
   * Note: texture is packed into texture atlas by default<br/>
   * you should set texture.packable as false before getting Html element object.
   * !#zh 获取当前贴图对应的 HTML Image 或 Canvas 对象，只在 Web 平台下有效。<br/>
   * 注意：<br/>
   * texture 默认参与动态合图，如果需要获取到正确的 Html 元素对象，需要先设置 texture.packable 为 false
   * @method getHtmlElementObj
   * @return {HTMLImageElement|HTMLCanvasElement}
   */
  getHtmlElementObj: function getHtmlElementObj() {
    return this._image;
  },

  /**
   * !#en
   * Destory this texture and immediately release its video memory. (Inherit from cc.Object.destroy)<br>
   * After destroy, this object is not usable any more.
   * You can use cc.isValid(obj) to check whether the object is destroyed before accessing it.
   * !#zh
   * 销毁该贴图，并立即释放它对应的显存。（继承自 cc.Object.destroy）<br/>
   * 销毁后，该对象不再可用。您可以在访问对象之前使用 cc.isValid(obj) 来检查对象是否已被销毁。
   * @method destroy
   * @return {Boolean} inherit from the CCObject
   */
  destroy: function destroy() {
    this._packable && cc.dynamicAtlasManager && cc.dynamicAtlasManager.deleteAtlasTexture(this);
    this._image = null;
    this._texture && this._texture.destroy(); // TODO cc.textureUtil ?
    // cc.textureCache.removeTextureForKey(this.url);  // item.rawUrl || item.url

    this._super();
  },

  /**
   * !#en
   * Pixel format of the texture.
   * !#zh 获取纹理的像素格式。
   * @method getPixelFormat
   * @return {Number}
   */
  getPixelFormat: function getPixelFormat() {
    //support only in WebGl rendering mode
    return this._format;
  },

  /**
   * !#en
   * Whether or not the texture has their Alpha premultiplied.
   * !#zh 检查纹理在上传 GPU 时预乘选项是否开启。
   * @method hasPremultipliedAlpha
   * @return {Boolean}
   */
  hasPremultipliedAlpha: function hasPremultipliedAlpha() {
    return this._premultiplyAlpha || false;
  },

  /**
   * !#en
   * Handler of texture loaded event.
   * Since v2.0, you don't need to invoke this function, it will be invoked automatically after texture loaded.
   * !#zh 贴图加载事件处理器。v2.0 之后你将不在需要手动执行这个函数，它会在贴图加载成功之后自动执行。
   * @method handleLoadedTexture
   * @param {Boolean} [premultiplied]
   */
  handleLoadedTexture: function handleLoadedTexture() {
    if (!this._image || !this._image.width || !this._image.height) return;
    this.width = this._image.width;
    this.height = this._image.height;

    var opts = _getSharedOptions();

    opts.image = this._image; // webgl texture 2d uses images

    opts.images = [opts.image];
    opts.width = this.width;
    opts.height = this.height;
    opts.genMipmaps = this._genMipmaps;
    opts.format = this._getGFXPixelFormat(this._format);
    opts.premultiplyAlpha = this._premultiplyAlpha;
    opts.flipY = this._flipY;
    opts.minFilter = FilterIndex[this._minFilter];
    opts.magFilter = FilterIndex[this._magFilter];
    opts.wrapS = this._wrapS;
    opts.wrapT = this._wrapT;

    if (!this._texture) {
      this._texture = new renderer.Texture2D(renderer.device, opts);
    } else {
      this._texture.update(opts);
    }

    this._checkPackable(); //dispatch load event to listener.


    this.loaded = true;
    this.emit("load");

    if (cc.macro.CLEANUP_IMAGE_CACHE && this._image instanceof HTMLImageElement) {
      this._clearImage();
    }
  },

  /**
   * !#en
   * Description of cc.Texture2D.
   * !#zh cc.Texture2D 描述。
   * @method description
   * @returns {String}
   */
  description: function description() {
    return "<cc.Texture2D | Name = " + this.url + " | Dimensions = " + this.width + " x " + this.height + ">";
  },

  /**
   * !#en
   * Release texture, please use destroy instead.
   * !#zh 释放纹理，请使用 destroy 替代。
   * @method releaseTexture
   * @deprecated since v2.0
   */
  releaseTexture: function releaseTexture() {
    this._image = null;
    this._texture && this._texture.destroy();
  },

  /**
   * !#en Sets the wrap s and wrap t options. <br/>
   * If the texture size is NPOT (non power of 2), then in can only use gl.CLAMP_TO_EDGE in gl.TEXTURE_WRAP_{S,T}.
   * !#zh 设置纹理包装模式。
   * 若纹理贴图尺寸是 NPOT（non power of 2），则只能使用 Texture2D.WrapMode.CLAMP_TO_EDGE。
   * @method setTexParameters
   * @param {Texture2D.WrapMode} wrapS
   * @param {Texture2D.WrapMode} wrapT
   */
  setWrapMode: function setWrapMode(wrapS, wrapT) {
    if (this._wrapS !== wrapS || this._wrapT !== wrapT) {
      var opts = _getSharedOptions();

      opts.wrapS = wrapS;
      opts.wrapT = wrapT;
      this.update(opts);
    }
  },

  /**
   * !#en Sets the minFilter and magFilter options
   * !#zh 设置纹理贴图缩小和放大过滤器算法选项。
   * @method setFilters
   * @param {Texture2D.Filter} minFilter
   * @param {Texture2D.Filter} magFilter
   */
  setFilters: function setFilters(minFilter, magFilter) {
    if (this._minFilter !== minFilter || this._magFilter !== magFilter) {
      var opts = _getSharedOptions();

      opts.minFilter = minFilter;
      opts.magFilter = magFilter;
      this.update(opts);
    }
  },

  /**
   * !#en
   * Sets the flipY options
   * !#zh 设置贴图的纵向翻转选项。
   * @method setFlipY
   * @param {Boolean} flipY
   */
  setFlipY: function setFlipY(flipY) {
    if (this._flipY !== flipY) {
      var opts = _getSharedOptions();

      opts.flipY = flipY;
      this.update(opts);
    }
  },

  /**
   * !#en
   * Sets the premultiply alpha options
   * !#zh 设置贴图的预乘选项。
   * @method setPremultiplyAlpha
   * @param {Boolean} premultiply
   */
  setPremultiplyAlpha: function setPremultiplyAlpha(premultiply) {
    if (this._premultiplyAlpha !== premultiply) {
      var opts = _getSharedOptions();

      opts.premultiplyAlpha = premultiply;
      this.update(opts);
    }
  },
  _checkPackable: function _checkPackable() {
    var dynamicAtlas = cc.dynamicAtlasManager;
    if (!dynamicAtlas) return;

    if (this._isCompressed()) {
      this._packable = false;
      return;
    }

    var w = this.width,
        h = this.height;

    if (!this._image || w > dynamicAtlas.maxFrameSize || h > dynamicAtlas.maxFrameSize || this._getHash() !== dynamicAtlas.Atlas.DEFAULT_HASH) {
      this._packable = false;
      return;
    }

    if (this._image && this._image instanceof HTMLCanvasElement) {
      this._packable = true;
    }
  },
  _getOpts: function _getOpts() {
    var opts = _getSharedOptions();

    opts.width = this.width;
    opts.height = this.height;
    opts.genMipmaps = this._genMipmaps;
    opts.format = this._format;
    opts.premultiplyAlpha = this._premultiplyAlpha;
    opts.anisotropy = this._anisotropy;
    opts.flipY = this._flipY;
    opts.minFilter = FilterIndex[this._minFilter];
    opts.magFilter = FilterIndex[this._magFilter];
    opts.mipFilter = FilterIndex[this._mipFilter];
    opts.wrapS = this._wrapS;
    opts.wrapT = this._wrapT;
    return opts;
  },
  _getGFXPixelFormat: function _getGFXPixelFormat(format) {
    if (format === PixelFormat.RGBA_ETC1) {
      format = PixelFormat.RGB_ETC1;
    } else if (format === PixelFormat.RGB_A_PVRTC_4BPPV1) {
      format = PixelFormat.RGB_PVRTC_4BPPV1;
    } else if (format === PixelFormat.RGB_A_PVRTC_2BPPV1) {
      format = PixelFormat.RGB_PVRTC_2BPPV1;
    }

    return format;
  },
  _resetUnderlyingMipmaps: function _resetUnderlyingMipmaps(mipmapSources) {
    var opts = this._getOpts();

    opts.images = mipmapSources || [null];

    if (!this._texture) {
      this._texture = new renderer.Texture2D(renderer.device, opts);
    } else {
      this._texture.update(opts);
    }
  },
  // SERIALIZATION
  _serialize: (CC_EDITOR || CC_TEST) && function () {
    var extId = "";
    var exportedExts = this._exportedExts;

    if (!exportedExts && this._native) {
      exportedExts = [this._native];
    }

    if (exportedExts) {
      var exts = [];

      for (var i = 0; i < exportedExts.length; i++) {
        var _extId = "";
        var ext = exportedExts[i];

        if (ext) {
          // ext@format
          var extFormat = ext.split('@');
          _extId = Texture2D.extnames.indexOf(extFormat[0]);

          if (_extId < 0) {
            _extId = ext;
          }

          if (extFormat[1]) {
            _extId += '@' + extFormat[1];
          }
        }

        exts.push(_extId);
      }

      extId = exts.join('_');
    }

    var asset = extId + "," + this._minFilter + "," + this._magFilter + "," + this._wrapS + "," + this._wrapT + "," + ((this._premultiplyAlpha ? 1 : 0) + "," + (this._genMipmaps ? 1 : 0) + "," + (this._packable ? 1 : 0));
    return asset;
  },
  _deserialize: function _deserialize(data, handle) {
    var device = cc.renderer.device;
    var fields = data.split(','); // decode extname

    var extIdStr = fields[0];

    if (extIdStr) {
      var extIds = extIdStr.split('_');
      var defaultExt = '';
      var bestExt = '';
      var bestIndex = 999;
      var bestFormat = this._format;
      var SupportTextureFormats = cc.macro.SUPPORT_TEXTURE_FORMATS;

      for (var i = 0; i < extIds.length; i++) {
        var extFormat = extIds[i].split('@');
        var tmpExt = extFormat[0];
        tmpExt = Texture2D.extnames[tmpExt.charCodeAt(0) - CHAR_CODE_0] || tmpExt;
        var index = SupportTextureFormats.indexOf(tmpExt);

        if (index !== -1 && index < bestIndex) {
          var tmpFormat = extFormat[1] ? parseInt(extFormat[1]) : this._format; // check whether or not support compressed texture

          if (tmpExt === '.pvr' && !device.ext('WEBGL_compressed_texture_pvrtc')) {
            continue;
          } else if ((tmpFormat === PixelFormat.RGB_ETC1 || tmpFormat === PixelFormat.RGBA_ETC1) && !device.ext('WEBGL_compressed_texture_etc1')) {
            continue;
          } else if ((tmpFormat === PixelFormat.RGB_ETC2 || tmpFormat === PixelFormat.RGBA_ETC2) && !device.ext('WEBGL_compressed_texture_etc')) {
            continue;
          } else if (tmpExt === '.webp' && !cc.sys.capabilities.webp) {
            continue;
          }

          bestIndex = index;
          bestExt = tmpExt;
          bestFormat = tmpFormat;
        } else if (!defaultExt) {
          defaultExt = tmpExt;
        }
      }

      if (bestExt) {
        this._setRawAsset(bestExt);

        this._format = bestFormat;
      } else {
        this._setRawAsset(defaultExt);

        cc.warnID(3120, handle.customEnv.url, defaultExt, defaultExt);
      }
    }

    if (fields.length === 8) {
      // decode filters
      this._minFilter = parseInt(fields[1]);
      this._magFilter = parseInt(fields[2]); // decode wraps

      this._wrapS = parseInt(fields[3]);
      this._wrapT = parseInt(fields[4]); // decode premultiply alpha

      this._premultiplyAlpha = fields[5].charCodeAt(0) === CHAR_CODE_1;
      this._genMipmaps = fields[6].charCodeAt(0) === CHAR_CODE_1;
      this._packable = fields[7].charCodeAt(0) === CHAR_CODE_1;
    }
  },
  _getHash: function _getHash() {
    if (!this._hashDirty) {
      return this._hash;
    }

    var genMipmaps = this._genMipmaps ? 1 : 0;
    var premultiplyAlpha = this._premultiplyAlpha ? 1 : 0;
    var flipY = this._flipY ? 1 : 0;
    var minFilter = this._minFilter === Filter.LINEAR ? 1 : 2;
    var magFilter = this._magFilter === Filter.LINEAR ? 1 : 2;
    var wrapS = this._wrapS === WrapMode.REPEAT ? 1 : this._wrapS === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
    var wrapT = this._wrapT === WrapMode.REPEAT ? 1 : this._wrapT === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
    var pixelFormat = this._format;
    var image = this._image;

    if (CC_JSB && image) {
      if (image._glFormat && image._glFormat !== GL_RGBA) pixelFormat = 0;
      premultiplyAlpha = image._premultiplyAlpha ? 1 : 0;
    }

    this._hash = Number("" + minFilter + magFilter + pixelFormat + wrapS + wrapT + genMipmaps + premultiplyAlpha + flipY);
    this._hashDirty = false;
    return this._hash;
  },
  _isCompressed: function _isCompressed() {
    return this._format < PixelFormat.A8 || this._format > PixelFormat.RGBA32F;
  },
  _clearImage: function _clearImage() {
    // wechat game platform will cache image parsed data, 
    // so image will consume much more memory than web, releasing it
    // Release image in loader cache
    // native image element has not image.id, release by image.src.
    cc.loader.removeItem(this._image.id || this._image.src);
    this._image.src = "";
  }
});
/**
 * !#zh
 * 当该资源加载成功后触发该事件
 * !#en
 * This event is emitted when the asset is loaded
 *
 * @event load
 */

cc.Texture2D = module.exports = Texture2D;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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