
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/assets/CCSpriteFrame.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var EventTarget = require("../event/event-target");

var textureUtil = require('../utils/texture-util');

var INSET_LEFT = 0;
var INSET_TOP = 1;
var INSET_RIGHT = 2;
var INSET_BOTTOM = 3;
var temp_uvs = [{
  u: 0,
  v: 0
}, {
  u: 0,
  v: 0
}, {
  u: 0,
  v: 0
}, {
  u: 0,
  v: 0
}];
/**
 * !#en
 * A cc.SpriteFrame has:<br/>
 *  - texture: A cc.Texture2D that will be used by render components<br/>
 *  - rectangle: A rectangle of the texture
 *
 * !#zh
 * 一个 SpriteFrame 包含：<br/>
 *  - 纹理：会被渲染组件使用的 Texture2D 对象。<br/>
 *  - 矩形：在纹理中的矩形区域。
 *
 * @class SpriteFrame
 * @extends Asset
 * @uses EventTarget
 * @example
 * // load a cc.SpriteFrame with image path (Recommend)
 * var self = this;
 * var url = "test assets/PurpleMonster";
 * cc.loader.loadRes(url, cc.SpriteFrame, function (err, spriteFrame) {
 *  var node = new cc.Node("New Sprite");
 *  var sprite = node.addComponent(cc.Sprite);
 *  sprite.spriteFrame = spriteFrame;
 *  node.parent = self.node
 * });
 */

var SpriteFrame = cc.Class(
/** @lends cc.SpriteFrame# */
{
  name: 'cc.SpriteFrame',
  "extends": require('../assets/CCAsset'),
  mixins: [EventTarget],
  properties: {
    // Use this property to set texture when loading dependency
    _textureSetter: {
      set: function set(texture) {
        if (texture) {
          if (CC_EDITOR && Editor.isBuilder) {
            // just building
            this._texture = texture;
            return;
          }

          if (this._texture !== texture) {
            this._refreshTexture(texture);
          }

          this._textureFilename = texture.url;
        }
      }
    },
    // _textureFilename: {
    //     get () {
    //         return (this._texture && this._texture.url) || "";
    //     },
    //     set (url) {
    //         let texture = cc.textureCache.addImage(url);
    //         this._refreshTexture(texture);
    //     }
    // },

    /**
     * !#en Top border of the sprite
     * !#zh sprite 的顶部边框
     * @property insetTop
     * @type {Number}
     * @default 0
     */
    insetTop: {
      get: function get() {
        return this._capInsets[INSET_TOP];
      },
      set: function set(value) {
        this._capInsets[INSET_TOP] = value;

        if (this._texture) {
          this._calculateSlicedUV();
        }
      }
    },

    /**
     * !#en Bottom border of the sprite
     * !#zh sprite 的底部边框
     * @property insetBottom
     * @type {Number}
     * @default 0
     */
    insetBottom: {
      get: function get() {
        return this._capInsets[INSET_BOTTOM];
      },
      set: function set(value) {
        this._capInsets[INSET_BOTTOM] = value;

        if (this._texture) {
          this._calculateSlicedUV();
        }
      }
    },

    /**
     * !#en Left border of the sprite
     * !#zh sprite 的左边边框
     * @property insetLeft
     * @type {Number}
     * @default 0
     */
    insetLeft: {
      get: function get() {
        return this._capInsets[INSET_LEFT];
      },
      set: function set(value) {
        this._capInsets[INSET_LEFT] = value;

        if (this._texture) {
          this._calculateSlicedUV();
        }
      }
    },

    /**
     * !#en Right border of the sprite
     * !#zh sprite 的左边边框
     * @property insetRight
     * @type {Number}
     * @default 0
     */
    insetRight: {
      get: function get() {
        return this._capInsets[INSET_RIGHT];
      },
      set: function set(value) {
        this._capInsets[INSET_RIGHT] = value;

        if (this._texture) {
          this._calculateSlicedUV();
        }
      }
    }
  },

  /**
   * !#en
   * Constructor of SpriteFrame class.
   * !#zh
   * SpriteFrame 类的构造函数。
   * @method constructor
   * @param {String|Texture2D} [filename]
   * @param {Rect} [rect]
   * @param {Boolean} [rotated] - Whether the frame is rotated in the texture
   * @param {Vec2} [offset] - The offset of the frame in the texture
   * @param {Size} [originalSize] - The size of the frame in the texture
   */
  ctor: function ctor() {
    // Init EventTarget data
    EventTarget.call(this);
    var filename = arguments[0];
    var rect = arguments[1];
    var rotated = arguments[2];
    var offset = arguments[3];
    var originalSize = arguments[4]; // the location of the sprite on rendering texture

    this._rect = null; // uv data of frame

    this.uv = []; // texture of frame

    this._texture = null; // store original info before packed to dynamic atlas

    this._original = null; // for trimming

    this._offset = null; // for trimming

    this._originalSize = null;
    this._rotated = false;
    this._flipX = false;
    this._flipY = false;
    this.vertices = null;
    this._capInsets = [0, 0, 0, 0];
    this.uvSliced = [];
    this._textureFilename = '';

    if (CC_EDITOR) {
      // Atlas asset uuid
      this._atlasUuid = '';
    }

    if (filename !== undefined) {
      this.setTexture(filename, rect, rotated, offset, originalSize);
    } else {//todo log Error
    }
  },

  /**
   * !#en Returns whether the texture have been loaded
   * !#zh 返回是否已加载纹理
   * @method textureLoaded
   * @returns {boolean}
   */
  textureLoaded: function textureLoaded() {
    return this._texture && this._texture.loaded;
  },
  onTextureLoaded: function onTextureLoaded(callback, target) {
    if (this.textureLoaded()) {
      callback.call(target);
    } else {
      this.once('load', callback, target);
      this.ensureLoadTexture();
      return false;
    }

    return true;
  },

  /**
   * !#en Returns whether the sprite frame is rotated in the texture.
   * !#zh 获取 SpriteFrame 是否旋转
   * @method isRotated
   * @return {Boolean}
   */
  isRotated: function isRotated() {
    return this._rotated;
  },

  /**
   * !#en Set whether the sprite frame is rotated in the texture.
   * !#zh 设置 SpriteFrame 是否旋转
   * @method setRotated
   * @param {Boolean} bRotated
   */
  setRotated: function setRotated(bRotated) {
    this._rotated = bRotated;
    if (this._texture) this._calculateUV();
  },

  /**
   * !#en Returns whether the sprite frame is flip x axis in the texture.
   * !#zh 获取 SpriteFrame 是否反转 x 轴
   * @method isFlipX
   * @return {Boolean}
   */
  isFlipX: function isFlipX() {
    return this._flipX;
  },

  /**
   * !#en Returns whether the sprite frame is flip y axis in the texture.
   * !#zh 获取 SpriteFrame 是否反转 y 轴
   * @method isFlipY
   * @return {Boolean}
   */
  isFlipY: function isFlipY() {
    return this._flipY;
  },

  /**
   * !#en Set whether the sprite frame is flip x axis in the texture.
   * !#zh 设置 SpriteFrame 是否翻转 x 轴
   * @method setFlipX
   * @param {Boolean} flipX
   */
  setFlipX: function setFlipX(flipX) {
    this._flipX = flipX;

    if (this._texture) {
      this._calculateUV();
    }
  },

  /**
   * !#en Set whether the sprite frame is flip y axis in the texture.
   * !#zh 设置 SpriteFrame 是否翻转 y 轴
   * @method setFlipY
   * @param {Boolean} flipY
   */
  setFlipY: function setFlipY(flipY) {
    this._flipY = flipY;

    if (this._texture) {
      this._calculateUV();
    }
  },

  /**
   * !#en Returns the rect of the sprite frame in the texture.
   * !#zh 获取 SpriteFrame 的纹理矩形区域
   * @method getRect
   * @return {Rect}
   */
  getRect: function getRect() {
    return cc.rect(this._rect);
  },

  /**
   * !#en Sets the rect of the sprite frame in the texture.
   * !#zh 设置 SpriteFrame 的纹理矩形区域
   * @method setRect
   * @param {Rect} rect
   */
  setRect: function setRect(rect) {
    this._rect = rect;
    if (this._texture) this._calculateUV();
  },

  /**
   * !#en Returns the original size of the trimmed image.
   * !#zh 获取修剪前的原始大小
   * @method getOriginalSize
   * @return {Size}
   */
  getOriginalSize: function getOriginalSize() {
    return cc.size(this._originalSize);
  },

  /**
   * !#en Sets the original size of the trimmed image.
   * !#zh 设置修剪前的原始大小
   * @method setOriginalSize
   * @param {Size} size
   */
  setOriginalSize: function setOriginalSize(size) {
    if (!this._originalSize) {
      this._originalSize = cc.size(size);
    } else {
      this._originalSize.width = size.width;
      this._originalSize.height = size.height;
    }
  },

  /**
   * !#en Returns the texture of the frame.
   * !#zh 获取使用的纹理实例
   * @method getTexture
   * @return {Texture2D}
   */
  getTexture: function getTexture() {
    return this._texture;
  },
  _textureLoadedCallback: function _textureLoadedCallback() {
    var self = this;
    var texture = this._texture;

    if (!texture) {
      // clearTexture called while loading texture...
      return;
    }

    var w = texture.width,
        h = texture.height;

    if (self._rect) {
      self._checkRect(self._texture);
    } else {
      self._rect = cc.rect(0, 0, w, h);
    }

    if (!self._originalSize) {
      self.setOriginalSize(cc.size(w, h));
    }

    if (!self._offset) {
      self.setOffset(cc.v2(0, 0));
    }

    self._calculateUV(); // dispatch 'load' event of cc.SpriteFrame


    self.emit("load");
  },

  /*
   * !#en Sets the texture of the frame.
   * !#zh 设置使用的纹理实例。
   * @method _refreshTexture
   * @param {Texture2D} texture
   */
  _refreshTexture: function _refreshTexture(texture) {
    this._texture = texture;

    if (texture.loaded) {
      this._textureLoadedCallback();
    } else {
      texture.once('load', this._textureLoadedCallback, this);
    }
  },

  /**
   * !#en Returns the offset of the frame in the texture.
   * !#zh 获取偏移量
   * @method getOffset
   * @return {Vec2}
   */
  getOffset: function getOffset() {
    return cc.v2(this._offset);
  },

  /**
   * !#en Sets the offset of the frame in the texture.
   * !#zh 设置偏移量
   * @method setOffset
   * @param {Vec2} offsets
   */
  setOffset: function setOffset(offsets) {
    this._offset = cc.v2(offsets);
  },

  /**
   * !#en Clone the sprite frame.
   * !#zh 克隆 SpriteFrame
   * @method clone
   * @return {SpriteFrame}
   */
  clone: function clone() {
    return new SpriteFrame(this._texture || this._textureFilename, this._rect, this._rotated, this._offset, this._originalSize);
  },

  /**
   * !#en Set SpriteFrame with Texture, rect, rotated, offset and originalSize.<br/>
   * !#zh 通过 Texture，rect，rotated，offset 和 originalSize 设置 SpriteFrame。
   * @method setTexture
   * @param {String|Texture2D} textureOrTextureFile
   * @param {Rect} [rect=null]
   * @param {Boolean} [rotated=false]
   * @param {Vec2} [offset=cc.v2(0,0)]
   * @param {Size} [originalSize=rect.size]
   * @return {Boolean}
   */
  setTexture: function setTexture(textureOrTextureFile, rect, rotated, offset, originalSize) {
    if (rect) {
      this._rect = rect;
    } else {
      this._rect = null;
    }

    if (offset) {
      this.setOffset(offset);
    } else {
      this._offset = null;
    }

    if (originalSize) {
      this.setOriginalSize(originalSize);
    } else {
      this._originalSize = null;
    }

    this._rotated = rotated || false; // loading texture

    var texture = textureOrTextureFile;

    if (typeof texture === 'string' && texture) {
      this._textureFilename = texture;

      this._loadTexture();
    }

    if (texture instanceof cc.Texture2D && this._texture !== texture) {
      this._refreshTexture(texture);
    }

    return true;
  },
  _loadTexture: function _loadTexture() {
    if (this._textureFilename) {
      var texture = textureUtil.loadImage(this._textureFilename);

      this._refreshTexture(texture);
    }
  },

  /**
   * !#en If a loading scene (or prefab) is marked as `asyncLoadAssets`, all the textures of the SpriteFrame which
   * associated by user's custom Components in the scene, will not preload automatically.
   * These textures will be load when Sprite component is going to render the SpriteFrames.
   * You can call this method if you want to load the texture early.
   * !#zh 当加载中的场景或 Prefab 被标记为 `asyncLoadAssets` 时，用户在场景中由自定义组件关联到的所有 SpriteFrame 的贴图都不会被提前加载。
   * 只有当 Sprite 组件要渲染这些 SpriteFrame 时，才会检查贴图是否加载。如果你希望加载过程提前，你可以手工调用这个方法。
   *
   * @method ensureLoadTexture
   * @example
   * if (spriteFrame.textureLoaded()) {
   *     this._onSpriteFrameLoaded();
   * }
   * else {
   *     spriteFrame.once('load', this._onSpriteFrameLoaded, this);
   *     spriteFrame.ensureLoadTexture();
   * }
   */
  ensureLoadTexture: function ensureLoadTexture() {
    if (this._texture) {
      if (!this._texture.loaded) {
        // load exists texture
        this._refreshTexture(this._texture);

        textureUtil.postLoadTexture(this._texture);
      }
    } else if (this._textureFilename) {
      // load new texture
      this._loadTexture();
    }
  },

  /**
   * !#en
   * If you do not need to use the SpriteFrame temporarily, you can call this method so that its texture could be garbage collected. Then when you need to render the SpriteFrame, you should call `ensureLoadTexture` manually to reload texture.
   * !#zh
   * 当你暂时不再使用这个 SpriteFrame 时，可以调用这个方法来保证引用的贴图对象能被 GC。然后当你要渲染 SpriteFrame 时，你需要手动调用 `ensureLoadTexture` 来重新加载贴图。
   * @method clearTexture
   * @deprecated since 2.1
   */
  _checkRect: function _checkRect(texture) {
    var rect = this._rect;
    var maxX = rect.x,
        maxY = rect.y;

    if (this._rotated) {
      maxX += rect.height;
      maxY += rect.width;
    } else {
      maxX += rect.width;
      maxY += rect.height;
    }

    if (maxX > texture.width) {
      cc.errorID(3300, texture.url + '/' + this.name, maxX, texture.width);
    }

    if (maxY > texture.height) {
      cc.errorID(3400, texture.url + '/' + this.name, maxY, texture.height);
    }
  },
  _flipXY: function _flipXY(uvs) {
    if (this._flipX) {
      var tempVal = uvs[0];
      uvs[0] = uvs[1];
      uvs[1] = tempVal;
      tempVal = uvs[2];
      uvs[2] = uvs[3];
      uvs[3] = tempVal;
    }

    if (this._flipY) {
      var _tempVal = uvs[0];
      uvs[0] = uvs[2];
      uvs[2] = _tempVal;
      _tempVal = uvs[1];
      uvs[1] = uvs[3];
      uvs[3] = _tempVal;
    }
  },
  _calculateSlicedUV: function _calculateSlicedUV() {
    var rect = this._rect;
    var atlasWidth = this._texture.width;
    var atlasHeight = this._texture.height;
    var leftWidth = this._capInsets[INSET_LEFT];
    var rightWidth = this._capInsets[INSET_RIGHT];
    var centerWidth = rect.width - leftWidth - rightWidth;
    var topHeight = this._capInsets[INSET_TOP];
    var bottomHeight = this._capInsets[INSET_BOTTOM];
    var centerHeight = rect.height - topHeight - bottomHeight;
    var uvSliced = this.uvSliced;
    uvSliced.length = 0;

    if (this._rotated) {
      temp_uvs[0].u = rect.x / atlasWidth;
      temp_uvs[1].u = (rect.x + bottomHeight) / atlasWidth;
      temp_uvs[2].u = (rect.x + bottomHeight + centerHeight) / atlasWidth;
      temp_uvs[3].u = (rect.x + rect.height) / atlasWidth;
      temp_uvs[3].v = rect.y / atlasHeight;
      temp_uvs[2].v = (rect.y + leftWidth) / atlasHeight;
      temp_uvs[1].v = (rect.y + leftWidth + centerWidth) / atlasHeight;
      temp_uvs[0].v = (rect.y + rect.width) / atlasHeight;

      this._flipXY(temp_uvs);

      for (var row = 0; row < 4; ++row) {
        var rowD = temp_uvs[row];

        for (var col = 0; col < 4; ++col) {
          var colD = temp_uvs[3 - col];
          uvSliced.push({
            u: rowD.u,
            v: colD.v
          });
        }
      }
    } else {
      temp_uvs[0].u = rect.x / atlasWidth;
      temp_uvs[1].u = (rect.x + leftWidth) / atlasWidth;
      temp_uvs[2].u = (rect.x + leftWidth + centerWidth) / atlasWidth;
      temp_uvs[3].u = (rect.x + rect.width) / atlasWidth;
      temp_uvs[3].v = rect.y / atlasHeight;
      temp_uvs[2].v = (rect.y + topHeight) / atlasHeight;
      temp_uvs[1].v = (rect.y + topHeight + centerHeight) / atlasHeight;
      temp_uvs[0].v = (rect.y + rect.height) / atlasHeight;

      this._flipXY(temp_uvs);

      for (var _row = 0; _row < 4; ++_row) {
        var _rowD = temp_uvs[_row];

        for (var _col = 0; _col < 4; ++_col) {
          var _colD = temp_uvs[_col];
          uvSliced.push({
            u: _colD.u,
            v: _rowD.v
          });
        }
      }
    }
  },
  _setDynamicAtlasFrame: function _setDynamicAtlasFrame(frame) {
    if (!frame) return;
    this._original = {
      _texture: this._texture,
      _x: this._rect.x,
      _y: this._rect.y
    };
    this._texture = frame.texture;
    this._rect.x = frame.x;
    this._rect.y = frame.y;

    this._calculateUV();
  },
  _resetDynamicAtlasFrame: function _resetDynamicAtlasFrame() {
    if (!this._original) return;
    this._rect.x = this._original._x;
    this._rect.y = this._original._y;
    this._texture = this._original._texture;
    this._original = null;

    this._calculateUV();
  },
  _calculateUV: function _calculateUV() {
    var rect = this._rect,
        texture = this._texture,
        uv = this.uv,
        texw = texture.width,
        texh = texture.height;

    if (this._rotated) {
      var l = texw === 0 ? 0 : rect.x / texw;
      var r = texw === 0 ? 0 : (rect.x + rect.height) / texw;
      var b = texh === 0 ? 0 : (rect.y + rect.width) / texh;
      var t = texh === 0 ? 0 : rect.y / texh;
      uv[0] = l;
      uv[1] = t;
      uv[2] = l;
      uv[3] = b;
      uv[4] = r;
      uv[5] = t;
      uv[6] = r;
      uv[7] = b;
    } else {
      var _l = texw === 0 ? 0 : rect.x / texw;

      var _r = texw === 0 ? 0 : (rect.x + rect.width) / texw;

      var _b = texh === 0 ? 0 : (rect.y + rect.height) / texh;

      var _t = texh === 0 ? 0 : rect.y / texh;

      uv[0] = _l;
      uv[1] = _b;
      uv[2] = _r;
      uv[3] = _b;
      uv[4] = _l;
      uv[5] = _t;
      uv[6] = _r;
      uv[7] = _t;
    }

    if (this._flipX) {
      var tempVal = uv[0];
      uv[0] = uv[2];
      uv[2] = tempVal;
      tempVal = uv[1];
      uv[1] = uv[3];
      uv[3] = tempVal;
      tempVal = uv[4];
      uv[4] = uv[6];
      uv[6] = tempVal;
      tempVal = uv[5];
      uv[5] = uv[7];
      uv[7] = tempVal;
    }

    if (this._flipY) {
      var _tempVal2 = uv[0];
      uv[0] = uv[4];
      uv[4] = _tempVal2;
      _tempVal2 = uv[1];
      uv[1] = uv[5];
      uv[5] = _tempVal2;
      _tempVal2 = uv[2];
      uv[2] = uv[6];
      uv[6] = _tempVal2;
      _tempVal2 = uv[3];
      uv[3] = uv[7];
      uv[7] = _tempVal2;
    }

    var vertices = this.vertices;

    if (vertices) {
      vertices.nu.length = 0;
      vertices.nv.length = 0;

      for (var i = 0; i < vertices.u.length; i++) {
        vertices.nu[i] = vertices.u[i] / texw;
        vertices.nv[i] = vertices.v[i] / texh;
      }
    }

    this._calculateSlicedUV();
  },
  // SERIALIZATION
  _serialize: CC_EDITOR && function (exporting) {
    var rect = this._rect;
    var offset = this._offset;
    var size = this._originalSize;
    var uuid;
    var texture = this._texture;

    if (texture) {
      uuid = texture._uuid;
    }

    if (!uuid) {
      var url = this._textureFilename;

      if (url) {
        uuid = Editor.Utils.UuidCache.urlToUuid(url);
      }
    }

    if (uuid && exporting) {
      uuid = Editor.Utils.UuidUtils.compressUuid(uuid, true);
    }

    var vertices;

    if (this.vertices) {
      vertices = {
        triangles: this.vertices.triangles,
        x: this.vertices.x,
        y: this.vertices.y,
        u: this.vertices.u,
        v: this.vertices.v
      };
    }

    return {
      name: this._name,
      texture: uuid || undefined,
      atlas: exporting ? undefined : this._atlasUuid,
      // strip from json if exporting
      rect: rect ? [rect.x, rect.y, rect.width, rect.height] : undefined,
      offset: offset ? [offset.x, offset.y] : undefined,
      originalSize: size ? [size.width, size.height] : undefined,
      rotated: this._rotated ? 1 : undefined,
      capInsets: this._capInsets,
      vertices: vertices
    };
  },
  _deserialize: function _deserialize(data, handle) {
    var rect = data.rect;

    if (rect) {
      this._rect = new cc.Rect(rect[0], rect[1], rect[2], rect[3]);
    }

    if (data.offset) {
      this.setOffset(new cc.Vec2(data.offset[0], data.offset[1]));
    }

    if (data.originalSize) {
      this.setOriginalSize(new cc.Size(data.originalSize[0], data.originalSize[1]));
    }

    this._rotated = data.rotated === 1;
    this._name = data.name;
    var capInsets = data.capInsets;

    if (capInsets) {
      this._capInsets[INSET_LEFT] = capInsets[INSET_LEFT];
      this._capInsets[INSET_TOP] = capInsets[INSET_TOP];
      this._capInsets[INSET_RIGHT] = capInsets[INSET_RIGHT];
      this._capInsets[INSET_BOTTOM] = capInsets[INSET_BOTTOM];
    }

    if (CC_EDITOR) {
      this._atlasUuid = data.atlas;
    }

    this.vertices = data.vertices;

    if (this.vertices) {
      // initialize normal uv arrays
      this.vertices.nu = [];
      this.vertices.nv = [];
    } // load texture via _textureSetter


    var textureUuid = data.texture;

    if (textureUuid) {
      handle.result.push(this, '_textureSetter', textureUuid);
    }
  }
});
var proto = SpriteFrame.prototype;
proto.copyWithZone = proto.clone;
proto.copy = proto.clone;
proto.initWithTexture = proto.setTexture;
cc.SpriteFrame = SpriteFrame;
module.exports = SpriteFrame;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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